/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import org.springframework.test.json.JsonCompareMode;
import org.springframework.test.web.reactive.server.WebTestClient;

final class SpringTestRules {
    private SpringTestRules() {
    }

    static final class BodyContentSpecJsonStrict {
        BodyContentSpecJsonStrict() {
        }

        WebTestClient.BodyContentSpec before(WebTestClient.BodyContentSpec spec, String expectedJson) {
            return spec.json(expectedJson, true);
        }

        WebTestClient.BodyContentSpec after(WebTestClient.BodyContentSpec spec, String expectedJson) {
            return spec.json(expectedJson, JsonCompareMode.STRICT);
        }
    }

    static final class BodyContentSpecJsonLenient {
        BodyContentSpecJsonLenient() {
        }

        WebTestClient.BodyContentSpec before(WebTestClient.BodyContentSpec spec, String expectedJson) {
            return (WebTestClient.BodyContentSpec)Refaster.anyOf((Object[])new WebTestClient.BodyContentSpec[]{spec.json(expectedJson), spec.json(expectedJson, false)});
        }

        WebTestClient.BodyContentSpec after(WebTestClient.BodyContentSpec spec, String expectedJson) {
            return spec.json(expectedJson, JsonCompareMode.LENIENT);
        }
    }
}

