/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class RxJava2AdapterRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`RxJava2AdapterRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `RxJava2Adapter`.\n[Source](https://error-prone.picnic.tech/refasterrules/RxJava2AdapterRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new CompletableToMonoRecipe(), new FlowableToFluxRecipe(), new FluxToFlowableRecipe(), new FluxToObservableRecipe(), new MaybeToMonoRecipe(), new MonoToCompletableRecipe(), new MonoToFlowableRecipe(), new MonoToMaybeRecipe(), new MonoToSingleRecipe(), new ObservableToFluxRecipe(), new SingleToMonoRecipe()});
    }

    @NullMarked
    public static class CompletableToMonoRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `RxJava2AdapterRules.CompletableToMono`";
        }

        public String getDescription() {
            return "Use the fluent API style when using `RxJava2Adapter#completableToMono`.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4968");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"reactor.adapter.rxjava.RxJava2Adapter.completableToMono(#{completable:any(io.reactivex.Completable)})").bindType("reactor.core.publisher.Mono<? extends java.lang.Void>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{completable:any(io.reactivex.Completable)}.as(reactor.adapter.rxjava.RxJava2Adapter::completableToMono)").bindType("reactor.core.publisher.Mono<? extends java.lang.Void>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-adapter-3", "rxjava-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{completable:any(io.reactivex.Completable)}.to(reactor.adapter.rxjava.RxJava2Adapter::completableToMono)").bindType("reactor.core.publisher.Mono<? extends java.lang.Void>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{completable:any(io.reactivex.Completable)}.as(reactor.adapter.rxjava.RxJava2Adapter::completableToMono)").bindType("reactor.core.publisher.Mono<? extends java.lang.Void>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-adapter-3", "rxjava-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("io.reactivex.Completable", Boolean.valueOf(true)), new UsesType("reactor.adapter.rxjava.RxJava2Adapter", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("io.reactivex.Completable to(..)", true), new UsesMethod("reactor.adapter.rxjava.RxJava2Adapter completableToMono(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FlowableToFluxRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `RxJava2AdapterRules.FlowableToFlux`";
        }

        public String getDescription() {
            return "Use `RxJava2Adapter#flowableToFlux` to convert a `Flowable` to a `Flux`, and do so using the fluent API style.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.from(#{flowable:any(io.reactivex.Flowable<T>)})").bindType("reactor.core.publisher.Flux<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{flowable:any(io.reactivex.Flowable<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)").bindType("reactor.core.publisher.Flux<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "rxjava-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{flowable:any(io.reactivex.Flowable<T>)}.to(reactor.core.publisher.Flux::from)").bindType("reactor.core.publisher.Flux<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{flowable:any(io.reactivex.Flowable<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)").bindType("reactor.core.publisher.Flux<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "rxjava-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"#{flowable:any(io.reactivex.Flowable<T>)}.as(reactor.core.publisher.Flux::from)").bindType("reactor.core.publisher.Flux<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{flowable:any(io.reactivex.Flowable<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)").bindType("reactor.core.publisher.Flux<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "rxjava-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"reactor.adapter.rxjava.RxJava2Adapter.flowableToFlux(#{flowable:any(io.reactivex.Flowable<T>)})").bindType("reactor.core.publisher.Flux<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{flowable:any(io.reactivex.Flowable<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)").bindType("reactor.core.publisher.Flux<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "rxjava-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$4 == null) {
                        this.before$4 = JavaTemplate.builder((String)"#{flowable:any(io.reactivex.Flowable<T>)}.to(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)").bindType("reactor.core.publisher.Flux<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$4.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{flowable:any(io.reactivex.Flowable<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)").bindType("reactor.core.publisher.Flux<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "rxjava-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("io.reactivex.Flowable", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("io.reactivex.Flowable as(..)", true), new UsesMethod("io.reactivex.Flowable to(..)", true), new UsesMethod("reactor.core.publisher.Flux from(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.adapter.rxjava.RxJava2Adapter", Boolean.valueOf(true)), new UsesMethod("io.reactivex.Flowable to(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.adapter.rxjava.RxJava2Adapter", Boolean.valueOf(true)), new UsesMethod("reactor.adapter.rxjava.RxJava2Adapter flowableToFlux(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxToFlowableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `RxJava2AdapterRules.FluxToFlowable`";
        }

        public String getDescription() {
            return "Use `RxJava2Adapter#fluxToFlowable` to convert a `Flux` to a `Flowable`, and do so using the fluent API style.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"io.reactivex.Flowable.fromPublisher(#{flux:any(reactor.core.publisher.Flux<T>)})").bindType("io.reactivex.Flowable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::fluxToFlowable)").bindType("io.reactivex.Flowable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.as(io.reactivex.Flowable::fromPublisher)").bindType("io.reactivex.Flowable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::fluxToFlowable)").bindType("io.reactivex.Flowable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"reactor.adapter.rxjava.RxJava2Adapter.fluxToFlowable(#{flux:any(reactor.core.publisher.Flux<T>)})").bindType("io.reactivex.Flowable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::fluxToFlowable)").bindType("io.reactivex.Flowable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("io.reactivex.Flowable", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("io.reactivex.Flowable fromPublisher(..)", true), new UsesMethod("reactor.core.publisher.Flux as(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.adapter.rxjava.RxJava2Adapter", Boolean.valueOf(true)), new UsesMethod("reactor.adapter.rxjava.RxJava2Adapter fluxToFlowable(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxToObservableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `RxJava2AdapterRules.FluxToObservable`";
        }

        public String getDescription() {
            return "Use `RxJava2Adapter#fluxToObservable` to convert a `Flux` to a `Observable`, and do so using the fluent API style.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"io.reactivex.Observable.fromPublisher(#{flux:any(reactor.core.publisher.Flux<T>)})").bindType("io.reactivex.Observable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::fluxToObservable)").bindType("io.reactivex.Observable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.as(io.reactivex.Observable::fromPublisher)").bindType("io.reactivex.Observable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::fluxToObservable)").bindType("io.reactivex.Observable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"reactor.adapter.rxjava.RxJava2Adapter.fluxToObservable(#{flux:any(reactor.core.publisher.Flux<T>)})").bindType("io.reactivex.Observable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::fluxToObservable)").bindType("io.reactivex.Observable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("io.reactivex.Observable", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("io.reactivex.Observable fromPublisher(..)", true), new UsesMethod("reactor.core.publisher.Flux as(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.adapter.rxjava.RxJava2Adapter", Boolean.valueOf(true)), new UsesMethod("reactor.adapter.rxjava.RxJava2Adapter fluxToObservable(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MaybeToMonoRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `RxJava2AdapterRules.MaybeToMono`";
        }

        public String getDescription() {
            return "Use the fluent API style when using `RxJava2Adapter#maybeToMono`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"reactor.adapter.rxjava.RxJava2Adapter.maybeToMono(#{maybe:any(io.reactivex.Maybe<T>)})").bindType("reactor.core.publisher.Mono<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{maybe:any(io.reactivex.Maybe<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::maybeToMono)").bindType("reactor.core.publisher.Mono<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-adapter-3", "rxjava-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{maybe:any(io.reactivex.Maybe<T>)}.to(reactor.adapter.rxjava.RxJava2Adapter::maybeToMono)").bindType("reactor.core.publisher.Mono<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{maybe:any(io.reactivex.Maybe<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::maybeToMono)").bindType("reactor.core.publisher.Mono<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-adapter-3", "rxjava-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("io.reactivex.Maybe", Boolean.valueOf(true)), new UsesType("reactor.adapter.rxjava.RxJava2Adapter", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("io.reactivex.Maybe to(..)", true), new UsesMethod("reactor.adapter.rxjava.RxJava2Adapter maybeToMono(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoToCompletableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `RxJava2AdapterRules.MonoToCompletable`";
        }

        public String getDescription() {
            return "Use `RxJava2Adapter#monoToCompletable` to convert a `Mono` to a `Completable`, and do so using the fluent API style.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"io.reactivex.Completable.fromPublisher(#{mono:any(reactor.core.publisher.Mono<T>)})").bindType("io.reactivex.Completable").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToCompletable)").bindType("io.reactivex.Completable").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.as(io.reactivex.Completable::fromPublisher)").bindType("io.reactivex.Completable").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToCompletable)").bindType("io.reactivex.Completable").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"reactor.adapter.rxjava.RxJava2Adapter.monoToCompletable(#{mono:any(reactor.core.publisher.Mono<T>)})").bindType("io.reactivex.Completable").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToCompletable)").bindType("io.reactivex.Completable").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("io.reactivex.Completable", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("io.reactivex.Completable fromPublisher(..)", true), new UsesMethod("reactor.core.publisher.Mono as(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.adapter.rxjava.RxJava2Adapter", Boolean.valueOf(true)), new UsesMethod("reactor.adapter.rxjava.RxJava2Adapter monoToCompletable(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoToFlowableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `RxJava2AdapterRules.MonoToFlowable`";
        }

        public String getDescription() {
            return "Use `RxJava2Adapter#monoToFlowable` to convert a `Mono` to a `Flowable`, and do so using the fluent API style.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"io.reactivex.Flowable.fromPublisher(#{mono:any(reactor.core.publisher.Mono<T>)})").bindType("io.reactivex.Flowable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToFlowable)").bindType("io.reactivex.Flowable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.as(io.reactivex.Flowable::fromPublisher)").bindType("io.reactivex.Flowable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToFlowable)").bindType("io.reactivex.Flowable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"reactor.adapter.rxjava.RxJava2Adapter.monoToFlowable(#{mono:any(reactor.core.publisher.Mono<T>)})").bindType("io.reactivex.Flowable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToFlowable)").bindType("io.reactivex.Flowable<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("io.reactivex.Flowable", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("io.reactivex.Flowable fromPublisher(..)", true), new UsesMethod("reactor.core.publisher.Mono as(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.adapter.rxjava.RxJava2Adapter", Boolean.valueOf(true)), new UsesMethod("reactor.adapter.rxjava.RxJava2Adapter monoToFlowable(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoToMaybeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `RxJava2AdapterRules.MonoToMaybe`";
        }

        public String getDescription() {
            return "Use the fluent API style when using `RxJava2Adapter#monoToMaybe`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"reactor.adapter.rxjava.RxJava2Adapter.monoToMaybe(#{mono:any(reactor.core.publisher.Mono<T>)})").bindType("io.reactivex.Maybe<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToMaybe)").bindType("io.reactivex.Maybe<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("io.reactivex.Maybe", Boolean.valueOf(true)), new UsesType("reactor.adapter.rxjava.RxJava2Adapter", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.adapter.rxjava.RxJava2Adapter monoToMaybe(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoToSingleRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `RxJava2AdapterRules.MonoToSingle`";
        }

        public String getDescription() {
            return "Use `RxJava2Adapter#monoToSingle` to convert a `Mono` to a `Single`, and do so using the fluent API style.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"io.reactivex.Single.fromPublisher(#{mono:any(reactor.core.publisher.Mono<T>)})").bindType("io.reactivex.Single<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToSingle)").bindType("io.reactivex.Single<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.as(io.reactivex.Single::fromPublisher)").bindType("io.reactivex.Single<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToSingle)").bindType("io.reactivex.Single<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"reactor.adapter.rxjava.RxJava2Adapter.monoToSingle(#{mono:any(reactor.core.publisher.Mono<T>)})").bindType("io.reactivex.Single<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::monoToSingle)").bindType("io.reactivex.Single<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("io.reactivex.Single", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("io.reactivex.Single fromPublisher(..)", true), new UsesMethod("reactor.core.publisher.Mono as(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.adapter.rxjava.RxJava2Adapter", Boolean.valueOf(true)), new UsesMethod("reactor.adapter.rxjava.RxJava2Adapter monoToSingle(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ObservableToFluxRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `RxJava2AdapterRules.ObservableToFlux`";
        }

        public String getDescription() {
            return "Use the fluent API style when using `RxJava2Adapter#observableToFlux`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"reactor.adapter.rxjava.RxJava2Adapter.observableToFlux(#{observable:any(io.reactivex.Observable<T>)}, #{strategy:any(io.reactivex.BackpressureStrategy)})").bindType("reactor.core.publisher.Flux<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{observable:any(io.reactivex.Observable<T>)}.toFlowable(#{strategy:any(io.reactivex.BackpressureStrategy)}).as(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)").bindType("reactor.core.publisher.Flux<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "rxjava-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{observable:any(io.reactivex.Observable<T>)}.as((obs)->reactor.adapter.rxjava.RxJava2Adapter.observableToFlux(obs, #{strategy:any(io.reactivex.BackpressureStrategy)}))").bindType("reactor.core.publisher.Flux<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{observable:any(io.reactivex.Observable<T>)}.toFlowable(#{strategy:any(io.reactivex.BackpressureStrategy)}).as(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)").bindType("reactor.core.publisher.Flux<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "rxjava-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"#{observable:any(io.reactivex.Observable<T>)}.to((obs)->reactor.adapter.rxjava.RxJava2Adapter.observableToFlux(obs, #{strategy:any(io.reactivex.BackpressureStrategy)}))").bindType("reactor.core.publisher.Flux<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{observable:any(io.reactivex.Observable<T>)}.toFlowable(#{strategy:any(io.reactivex.BackpressureStrategy)}).as(reactor.adapter.rxjava.RxJava2Adapter::flowableToFlux)").bindType("reactor.core.publisher.Flux<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "rxjava-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("io.reactivex.Observable", Boolean.valueOf(true)), new UsesType("reactor.adapter.rxjava.RxJava2Adapter", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.adapter.rxjava.RxJava2Adapter observableToFlux(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SingleToMonoRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `RxJava2AdapterRules.SingleToMono`";
        }

        public String getDescription() {
            return "Use the fluent API style when using `RxJava2Adapter#singleToMono`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"reactor.adapter.rxjava.RxJava2Adapter.singleToMono(#{single:any(io.reactivex.Single<T>)})").bindType("reactor.core.publisher.Mono<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{single:any(io.reactivex.Single<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::singleToMono)").bindType("reactor.core.publisher.Mono<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-adapter-3", "rxjava-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{single:any(io.reactivex.Single<T>)}.to(reactor.adapter.rxjava.RxJava2Adapter::singleToMono)").bindType("reactor.core.publisher.Mono<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-adapter-3", "reactor-core-3", "rxjava-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{single:any(io.reactivex.Single<T>)}.as(reactor.adapter.rxjava.RxJava2Adapter::singleToMono)").bindType("reactor.core.publisher.Mono<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-adapter-3", "rxjava-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("io.reactivex.Single", Boolean.valueOf(true)), new UsesType("reactor.adapter.rxjava.RxJava2Adapter", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("io.reactivex.Single to(..)", true), new UsesMethod("reactor.adapter.rxjava.RxJava2Adapter singleToMono(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }
}

