/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class BugCheckerRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`BugCheckerRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to `com.google.errorprone.bugpatterns.BugChecker` classes.\n[Source](https://error-prone.picnic.tech/refasterrules/BugCheckerRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new BugCheckerRefactoringTestHelperIdentityRecipe(), new BugCheckerRefactoringTestHelperAddInputLinesExpectUnchangedRecipe(), new NameContentEqualsRecipe(), new ASTHelpersGetStartPositionRecipe()});
    }

    @NullMarked
    public static class BugCheckerRefactoringTestHelperIdentityRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `BugCheckerRules.BugCheckerRefactoringTestHelperIdentity`";
        }

        public String getDescription() {
            return "Avoid calling `BugCheckerRefactoringTestHelper#setFixChooser(FixChooser)` or `BugCheckerRefactoringTestHelper#setImportOrder(String)` with their respective default values.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.setFixChooser(com.google.errorprone.BugCheckerRefactoringTestHelper.FixChoosers.FIRST)").bindType("com.google.errorprone.BugCheckerRefactoringTestHelper").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_test_helpers-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.errorprone.BugCheckerRefactoringTestHelper.FixChoosers");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}").bindType("com.google.errorprone.BugCheckerRefactoringTestHelper").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_test_helpers-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.setImportOrder(\"static-first\")").bindType("com.google.errorprone.BugCheckerRefactoringTestHelper").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_test_helpers-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}").bindType("com.google.errorprone.BugCheckerRefactoringTestHelper").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_test_helpers-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.BugCheckerRefactoringTestHelper", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.errorprone.BugCheckerRefactoringTestHelper setImportOrder(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.BugCheckerRefactoringTestHelper.FixChoosers", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.BugCheckerRefactoringTestHelper setFixChooser(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class BugCheckerRefactoringTestHelperAddInputLinesExpectUnchangedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `BugCheckerRules.BugCheckerRefactoringTestHelperAddInputLinesExpectUnchanged`";
        }

        public String getDescription() {
            return "Prefer `BugCheckerRefactoringTestHelper.ExpectOutput#expectUnchanged()` over repeating the input.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.addInputLines(#{path:any(java.lang.String)}, #{source:any(java.lang.String)}).addOutputLines(#{path}, #{source})").bindType("com.google.errorprone.BugCheckerRefactoringTestHelper").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_test_helpers-2"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.addInputLines(#{path:any(java.lang.String)}, #{source:any(java.lang.String)}).expectUnchanged()").bindType("com.google.errorprone.BugCheckerRefactoringTestHelper").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_test_helpers-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.BugCheckerRefactoringTestHelper", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.BugCheckerRefactoringTestHelper addInputLines(..)", true), new UsesMethod("com.google.errorprone.BugCheckerRefactoringTestHelper.ExpectOutput addOutputLines(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class NameContentEqualsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `BugCheckerRules.NameContentEquals`";
        }

        public String getDescription() {
            return "Prefer `Name#contentEquals(CharSequence)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{name:any(javax.lang.model.element.Name)}.toString().equals(#{string:any(java.lang.CharSequence)}.toString())").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{name:any(javax.lang.model.element.Name)}.contentEquals(#{string:any(java.lang.CharSequence)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{name:any(javax.lang.model.element.Name)}.toString().equals(#{string:any(java.lang.String)})").build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{name:any(javax.lang.model.element.Name)}.contentEquals(#{string:any(java.lang.CharSequence)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("javax.lang.model.element.Name", Boolean.valueOf(true)), new UsesMethod("java.lang.CharSequence toString(..)", true), new UsesMethod("java.lang.String equals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ASTHelpersGetStartPositionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `BugCheckerRules.ASTHelpersGetStartPosition`";
        }

        public String getDescription() {
            return "Prefer `ASTHelpers#getStartPosition(Tree)` over alternatives that require casting.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"((T)#{tree:any(com.sun.source.tree.Tree)}).getStartPosition()").genericTypes(new String[]{"T extends com.sun.tools.javac.util.JCDiagnostic.DiagnosticPosition"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.errorprone.util.ASTHelpers.getStartPosition(#{tree:any(com.sun.source.tree.Tree)})").genericTypes(new String[]{"T extends com.sun.tools.javac.util.JCDiagnostic.DiagnosticPosition"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"error_prone_check_api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.sun.source.tree.Tree", Boolean.valueOf(true)), new UsesMethod("com.sun.tools.javac.util.JCDiagnostic.DiagnosticPosition getStartPosition(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

