/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

final class AssertJStreamRules {
    private AssertJStreamRules() {
    }

    static final class AssertThatCollection<T> {
        AssertThatCollection() {
        }

        ListAssert<T> before(Collection<T> collection) {
            return Assertions.assertThat(collection.stream());
        }

        AbstractCollectionAssert<?, ?, T, ?> after(Collection<T> collection) {
            return Assertions.assertThat(collection);
        }
    }

    static final class AssertThatAnyMatch<T> {
        AssertThatAnyMatch() {
        }

        ListAssert<T> before(Stream<T> stream, Predicate<? super T> predicate) {
            return (ListAssert)((ListAssert)Assertions.assertThat(stream).filteredOn(predicate)).isNotEmpty();
        }

        AbstractBooleanAssert<?> before2(Stream<T> stream, Predicate<? super T> predicate) {
            return (AbstractBooleanAssert)Refaster.anyOf((Object[])new AbstractBooleanAssert[]{Assertions.assertThat((boolean)stream.anyMatch(predicate)).isTrue(), Assertions.assertThat((boolean)stream.noneMatch(predicate)).isFalse()});
        }

        ListAssert<T> after(Stream<T> stream, Predicate<? super T> predicate) {
            return (ListAssert)Assertions.assertThat(stream).anyMatch(predicate);
        }
    }

    static final class AssertThatNoneMatch<T> {
        AssertThatNoneMatch() {
        }

        void before(Stream<T> stream, Predicate<? super T> predicate) {
            ((ListAssert)Assertions.assertThat(stream).filteredOn(predicate)).isEmpty();
        }

        void before2(Stream<T> stream, Predicate<? super T> predicate) {
            Refaster.anyOf((Object[])new AbstractBooleanAssert[]{Assertions.assertThat((boolean)stream.anyMatch(predicate)).isFalse(), Assertions.assertThat((boolean)stream.noneMatch(predicate)).isTrue()});
        }

        void after(Stream<T> stream, Predicate<? super T> predicate) {
            Assertions.assertThat(stream).noneMatch(predicate);
        }
    }

    static final class AssertThatFilteredOn<T> {
        AssertThatFilteredOn() {
        }

        ListAssert<T> before(Stream<T> stream, Predicate<? super T> predicate) {
            return Assertions.assertThat(stream.filter(predicate));
        }

        ListAssert<T> after(Stream<T> stream, Predicate<? super T> predicate) {
            return (ListAssert)Assertions.assertThat(stream).filteredOn(predicate);
        }
    }
}

