/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.math.BigInteger;
import org.assertj.core.api.AbstractBigIntegerAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;

final class AssertJBigIntegerRules {
    private AssertJBigIntegerRules() {
    }

    static final class AbstractBigIntegerAssertIsOne {
        AbstractBigIntegerAssertIsOne() {
        }

        AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> bigIntegerAssert) {
            return (AbstractBigIntegerAssert)Refaster.anyOf((Object[])new AbstractBigIntegerAssert[]{bigIntegerAssert.isOne(), bigIntegerAssert.isEqualTo(1L), (AbstractBigIntegerAssert)bigIntegerAssert.isEqualTo((Object)BigInteger.ONE)});
        }

        AbstractBigIntegerAssert<?> after(AbstractBigIntegerAssert<?> bigIntegerAssert) {
            return bigIntegerAssert.isEqualTo(1);
        }
    }

    static final class AbstractBigIntegerAssertIsNotZero {
        AbstractBigIntegerAssertIsNotZero() {
        }

        AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> bigIntegerAssert) {
            return (AbstractBigIntegerAssert)Refaster.anyOf((Object[])new AbstractBigIntegerAssert[]{bigIntegerAssert.isNotZero(), (AbstractBigIntegerAssert)bigIntegerAssert.isNotEqualTo((Object)0L), (AbstractBigIntegerAssert)bigIntegerAssert.isNotEqualTo((Object)BigInteger.ZERO)});
        }

        AbstractBigIntegerAssert<?> after(AbstractBigIntegerAssert<?> bigIntegerAssert) {
            return (AbstractBigIntegerAssert)bigIntegerAssert.isNotEqualTo((Object)0);
        }
    }

    static final class AbstractBigIntegerAssertIsZero {
        AbstractBigIntegerAssertIsZero() {
        }

        AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> bigIntegerAssert) {
            return (AbstractBigIntegerAssert)Refaster.anyOf((Object[])new AbstractBigIntegerAssert[]{bigIntegerAssert.isZero(), bigIntegerAssert.isEqualTo(0L), (AbstractBigIntegerAssert)bigIntegerAssert.isEqualTo((Object)BigInteger.ZERO)});
        }

        AbstractBigIntegerAssert<?> after(AbstractBigIntegerAssert<?> bigIntegerAssert) {
            return bigIntegerAssert.isEqualTo(0);
        }
    }

    static final class AbstractBigIntegerAssertIsNotEqualTo {
        AbstractBigIntegerAssertIsNotEqualTo() {
        }

        AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> bigIntegerAssert, BigInteger n) {
            return (AbstractBigIntegerAssert)Refaster.anyOf((Object[])new AbstractBigIntegerAssert[]{bigIntegerAssert.isNotCloseTo(n, Offset.offset((Number)BigInteger.ZERO)), bigIntegerAssert.isNotCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractBigIntegerAssert<?> after(AbstractBigIntegerAssert<?> bigIntegerAssert, BigInteger n) {
            return (AbstractBigIntegerAssert)bigIntegerAssert.isNotEqualTo((Object)n);
        }
    }

    static final class AbstractBigIntegerAssertIsEqualTo {
        AbstractBigIntegerAssertIsEqualTo() {
        }

        AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> bigIntegerAssert, BigInteger n) {
            return (AbstractBigIntegerAssert)Refaster.anyOf((Object[])new AbstractBigIntegerAssert[]{bigIntegerAssert.isCloseTo(n, Offset.offset((Number)BigInteger.ZERO)), bigIntegerAssert.isCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractBigIntegerAssert<?> after(AbstractBigIntegerAssert<?> bigIntegerAssert, BigInteger n) {
            return (AbstractBigIntegerAssert)bigIntegerAssert.isEqualTo((Object)n);
        }
    }
}

