package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.TimeRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class TimeRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public TimeRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`TimeRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with time.\n[Source](https://error-prone.picnic.tech/refasterrules/TimeRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new ClockInstantRecipe(),
                new UtcConstantRecipe(),
                new LocalDateOfInstantRecipe(),
                new LocalDateTimeOfInstantRecipe(),
                new LocalTimeOfInstantRecipe(),
                new OffsetDateTimeOfInstantRecipe(),
                new InstantIdentityRecipe(),
                new InstantTruncatedToMillisecondsRecipe(),
                new InstantTruncatedToSecondsRecipe(),
                new InstantAtOffsetRecipe(),
                new OffsetTimeOfInstantRecipe(),
                new InstantAtZoneRecipe(),
                new UtcClockRecipe(),
                new EpochInstantRecipe(),
                new InstantIsBeforeRecipe(),
                new InstantIsAfterRecipe(),
                new LocalTimeMinRecipe(),
                new LocalDateAtStartOfDayRecipe(),
                new ChronoLocalDateIsBeforeRecipe(),
                new ChronoLocalDateIsAfterRecipe(),
                new ChronoLocalDateTimeIsBeforeRecipe(),
                new ChronoLocalDateTimeIsAfterRecipe(),
                new ChronoZonedDateTimeIsBeforeRecipe(),
                new ChronoZonedDateTimeIsAfterRecipe(),
                new OffsetDateTimeIsBeforeRecipe(),
                new OffsetDateTimeIsAfterRecipe(),
                new ZeroDurationRecipe(),
                new DurationOfDaysRecipe(),
                new DurationOfHoursRecipe(),
                new DurationOfMillisRecipe(),
                new DurationOfMinutesRecipe(),
                new DurationOfNanosRecipe(),
                new DurationOfSecondsRecipe(),
                new DurationBetweenInstantsRecipe(),
                new DurationBetweenOffsetDateTimesRecipe(),
                new DurationIsZeroRecipe(),
                new ZeroPeriodRecipe(),
                new LocalDatePlusDaysRecipe(),
                new LocalDatePlusWeeksRecipe(),
                new LocalDatePlusMonthsRecipe(),
                new LocalDatePlusYearsRecipe(),
                new LocalDateMinusDaysRecipe(),
                new LocalDateMinusWeeksRecipe(),
                new LocalDateMinusMonthsRecipe(),
                new LocalDateMinusYearsRecipe(),
                new LocalTimePlusNanosRecipe(),
                new LocalTimePlusSecondsRecipe(),
                new LocalTimePlusMinutesRecipe(),
                new LocalTimePlusHoursRecipe(),
                new LocalTimeMinusNanosRecipe(),
                new LocalTimeMinusSecondsRecipe(),
                new LocalTimeMinusMinutesRecipe(),
                new LocalTimeMinusHoursRecipe(),
                new OffsetTimePlusNanosRecipe(),
                new OffsetTimePlusSecondsRecipe(),
                new OffsetTimePlusMinutesRecipe(),
                new OffsetTimePlusHoursRecipe(),
                new OffsetTimeMinusNanosRecipe(),
                new OffsetTimeMinusSecondsRecipe(),
                new OffsetTimeMinusMinutesRecipe(),
                new OffsetTimeMinusHoursRecipe(),
                new LocalDateTimePlusNanosRecipe(),
                new LocalDateTimePlusSecondsRecipe(),
                new LocalDateTimePlusMinutesRecipe(),
                new LocalDateTimePlusHoursRecipe(),
                new LocalDateTimePlusDaysRecipe(),
                new LocalDateTimePlusWeeksRecipe(),
                new LocalDateTimePlusMonthsRecipe(),
                new LocalDateTimePlusYearsRecipe(),
                new LocalDateTimeMinusNanosRecipe(),
                new LocalDateTimeMinusSecondsRecipe(),
                new LocalDateTimeMinusMinutesRecipe(),
                new LocalDateTimeMinusHoursRecipe(),
                new LocalDateTimeMinusDaysRecipe(),
                new LocalDateTimeMinusWeeksRecipe(),
                new LocalDateTimeMinusMonthsRecipe(),
                new LocalDateTimeMinusYearsRecipe(),
                new OffsetDateTimePlusNanosRecipe(),
                new OffsetDateTimePlusSecondsRecipe(),
                new OffsetDateTimePlusMinutesRecipe(),
                new OffsetDateTimePlusHoursRecipe(),
                new OffsetDateTimePlusDaysRecipe(),
                new OffsetDateTimePlusWeeksRecipe(),
                new OffsetDateTimePlusMonthsRecipe(),
                new OffsetDateTimePlusYearsRecipe(),
                new OffsetDateTimeMinusNanosRecipe(),
                new OffsetDateTimeMinusSecondsRecipe(),
                new OffsetDateTimeMinusMinutesRecipe(),
                new OffsetDateTimeMinusHoursRecipe(),
                new OffsetDateTimeMinusDaysRecipe(),
                new OffsetDateTimeMinusWeeksRecipe(),
                new OffsetDateTimeMinusMonthsRecipe(),
                new OffsetDateTimeMinusYearsRecipe(),
                new ZonedDateTimePlusNanosRecipe(),
                new ZonedDateTimePlusSecondsRecipe(),
                new ZonedDateTimePlusMinutesRecipe(),
                new ZonedDateTimePlusHoursRecipe(),
                new ZonedDateTimePlusDaysRecipe(),
                new ZonedDateTimePlusWeeksRecipe(),
                new ZonedDateTimePlusMonthsRecipe(),
                new ZonedDateTimePlusYearsRecipe(),
                new ZonedDateTimeMinusNanosRecipe(),
                new ZonedDateTimeMinusSecondsRecipe(),
                new ZonedDateTimeMinusMinutesRecipe(),
                new ZonedDateTimeMinusHoursRecipe(),
                new ZonedDateTimeMinusDaysRecipe(),
                new ZonedDateTimeMinusWeeksRecipe(),
                new ZonedDateTimeMinusMonthsRecipe(),
                new ZonedDateTimeMinusYearsRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ClockInstant}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ClockInstantRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ClockInstantRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ClockInstant`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Clock#instant()` over `Instant#now(Clock)`, as it is more concise and more \"OOP-py\".";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.time.Instant.now(#{clock:any(java.time.Clock)})")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{clock:any(java.time.Clock)}.instant()")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Clock", true),
                            new UsesType<>("java.time.Instant", true),
                            new UsesMethod<>("java.time.Instant now(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.UtcConstant}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class UtcConstantRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public UtcConstantRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.UtcConstant`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Use `ZoneOffset#UTC` when possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate before$5;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.time.ZoneId.of(\"GMT\")")
                                .bindType("java.time.ZoneId").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.ZoneId");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.ZoneOffset.UTC")
                                    .bindType("java.time.ZoneOffset").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.time.ZoneId.of(\"UTC\")")
                                .bindType("java.time.ZoneId").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.ZoneId");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.ZoneOffset.UTC")
                                    .bindType("java.time.ZoneOffset").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.time.ZoneId.of(\"+0\")")
                                .bindType("java.time.ZoneId").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.ZoneId");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.ZoneOffset.UTC")
                                    .bindType("java.time.ZoneOffset").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("java.time.ZoneId.of(\"-0\")")
                                .bindType("java.time.ZoneId").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.ZoneId");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.ZoneOffset.UTC")
                                    .bindType("java.time.ZoneOffset").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$4 == null) {
                        before$4 = JavaTemplate.builder("java.time.ZoneOffset.UTC.normalized()")
                                .bindType("java.time.ZoneId").build();
                    }
                    if ((matcher = before$4.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.ZoneId");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.ZoneOffset.UTC")
                                    .bindType("java.time.ZoneOffset").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$5 == null) {
                        before$5 = JavaTemplate.builder("java.time.ZoneId.from(java.time.ZoneOffset.UTC)")
                                .bindType("java.time.ZoneId").build();
                    }
                    if ((matcher = before$5.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.ZoneId");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.ZoneOffset.UTC")
                                    .bindType("java.time.ZoneOffset").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZoneId", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.time.ZoneId from(..)", true),
                                    new UsesMethod<>("java.time.ZoneId of(..)", true),
                                    new UsesMethod<>("java.time.ZoneOffset normalized(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateOfInstant}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateOfInstantRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateOfInstantRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateOfInstant`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDate#ofInstant(Instant, ZoneId)` over more indirect alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.atZone(#{zoneId:any(java.time.ZoneId)}).toLocalDate()")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalDate.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.time.LocalDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)}).toLocalDate()")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.LocalDateTime");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalDate.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.time.OffsetDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)}).toLocalDate()")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.OffsetDateTime");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalDate.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.atOffset(#{zoneId:any(java.time.ZoneOffset)}).toLocalDate()")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.ZoneOffset");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalDate.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesType<>("java.time.LocalDate", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("java.time.LocalDateTime", true),
                                            new UsesType<>("java.time.ZoneId", true),
                                            new UsesMethod<>("java.time.LocalDateTime ofInstant(..)", true),
                                            new UsesMethod<>("java.time.LocalDateTime toLocalDate(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.time.OffsetDateTime", true),
                                            new UsesType<>("java.time.ZoneId", true),
                                            new UsesMethod<>("java.time.OffsetDateTime ofInstant(..)", true),
                                            new UsesMethod<>("java.time.OffsetDateTime toLocalDate(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.time.ZoneId", true),
                                            new UsesMethod<>("java.time.Instant atZone(..)", true),
                                            new UsesMethod<>("java.time.ZonedDateTime toLocalDate(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.time.ZoneOffset", true),
                                            new UsesMethod<>("java.time.Instant atOffset(..)", true),
                                            new UsesMethod<>("java.time.OffsetDateTime toLocalDate(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimeOfInstant}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimeOfInstantRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimeOfInstantRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimeOfInstant`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#ofInstant(Instant, ZoneId)` over more indirect alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.atZone(#{zoneId:any(java.time.ZoneId)}).toLocalDateTime()")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.time.OffsetDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)}).toLocalDateTime()")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.OffsetDateTime");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.atOffset(#{zoneId:any(java.time.ZoneOffset)}).toLocalDateTime()")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.ZoneOffset");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesType<>("java.time.LocalDateTime", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("java.time.OffsetDateTime", true),
                                            new UsesType<>("java.time.ZoneId", true),
                                            new UsesMethod<>("java.time.OffsetDateTime ofInstant(..)", true),
                                            new UsesMethod<>("java.time.OffsetDateTime toLocalDateTime(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.time.ZoneId", true),
                                            new UsesMethod<>("java.time.Instant atZone(..)", true),
                                            new UsesMethod<>("java.time.ZonedDateTime toLocalDateTime(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.time.ZoneOffset", true),
                                            new UsesMethod<>("java.time.Instant atOffset(..)", true),
                                            new UsesMethod<>("java.time.OffsetDateTime toLocalDateTime(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalTimeOfInstant}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalTimeOfInstantRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalTimeOfInstantRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalTimeOfInstant`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalTime#ofInstant(Instant, ZoneId)` over more indirect alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.atZone(#{zoneId:any(java.time.ZoneId)}).toLocalTime()")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.time.LocalDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)}).toLocalTime()")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.LocalDateTime");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.time.OffsetDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)}).toLocalTime()")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.OffsetDateTime");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("java.time.OffsetTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)}).toLocalTime()")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.OffsetTime");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.atOffset(#{zoneId:any(java.time.ZoneOffset)}).toLocalTime()")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.ZoneOffset");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesType<>("java.time.LocalTime", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("java.time.LocalDateTime", true),
                                            new UsesType<>("java.time.ZoneId", true),
                                            new UsesMethod<>("java.time.LocalDateTime ofInstant(..)", true),
                                            new UsesMethod<>("java.time.LocalDateTime toLocalTime(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.time.OffsetDateTime", true),
                                            new UsesType<>("java.time.ZoneId", true),
                                            new UsesMethod<>("java.time.OffsetDateTime ofInstant(..)", true),
                                            new UsesMethod<>("java.time.OffsetDateTime toLocalTime(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.time.OffsetTime", true),
                                            new UsesType<>("java.time.ZoneId", true),
                                            new UsesMethod<>("java.time.OffsetTime ofInstant(..)", true),
                                            new UsesMethod<>("java.time.OffsetTime toLocalTime(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.time.ZoneId", true),
                                            new UsesMethod<>("java.time.Instant atZone(..)", true),
                                            new UsesMethod<>("java.time.ZonedDateTime toLocalTime(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.time.ZoneOffset", true),
                                            new UsesMethod<>("java.time.Instant atOffset(..)", true),
                                            new UsesMethod<>("java.time.OffsetDateTime toLocalTime(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimeOfInstant}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimeOfInstantRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimeOfInstantRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimeOfInstant`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#ofInstant(Instant, ZoneId)` over more indirect alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{instant:any(java.time.Instant)}.atZone(#{zoneId:any(java.time.ZoneId)}).toOffsetDateTime()")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.OffsetDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesType<>("java.time.ZoneId", true),
                            new UsesMethod<>("java.time.Instant atZone(..)", true),
                            new UsesMethod<>("java.time.ZonedDateTime toOffsetDateTime(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.InstantIdentity}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class InstantIdentityRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public InstantIdentityRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.InstantIdentity`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily transform an `Instant` to an equivalent instance.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate before$5;
                JavaTemplate before$6;
                JavaTemplate before$7;
                JavaTemplate before$8;
                JavaTemplate before$9;
                JavaTemplate before$10;
                JavaTemplate before$11;
                JavaTemplate before$12;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.plus(java.time.Duration.ZERO)")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.plus(0, #{temporalUnit:any(java.time.temporal.TemporalUnit)})")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.plusNanos(0)")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.plusMillis(0)")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$4 == null) {
                        before$4 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.plusSeconds(0)")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before$4.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$5 == null) {
                        before$5 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.minus(java.time.Duration.ZERO)")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before$5.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$6 == null) {
                        before$6 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.minus(0, #{temporalUnit:any(java.time.temporal.TemporalUnit)})")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before$6.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$7 == null) {
                        before$7 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.minusNanos(0)")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before$7.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$8 == null) {
                        before$8 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.minusMillis(0)")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before$8.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$9 == null) {
                        before$9 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.minusSeconds(0)")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before$9.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$10 == null) {
                        before$10 = JavaTemplate.builder("java.time.Instant.parse(#{instant:any(java.time.Instant)}.toString())")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before$10.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$11 == null) {
                        before$11 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.truncatedTo(java.time.temporal.ChronoUnit.NANOS)")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before$11.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$12 == null) {
                        before$12 = JavaTemplate.builder("java.time.Instant.ofEpochSecond(#{instant:any(java.time.Instant)}.getEpochSecond(), #{instant}.getNano())")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before$12.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesType<>("java.time.temporal.TemporalUnit", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.time.Instant minus(..)", true),
                                    new UsesMethod<>("java.time.Instant minusMillis(..)", true),
                                    new UsesMethod<>("java.time.Instant minusNanos(..)", true),
                                    new UsesMethod<>("java.time.Instant minusSeconds(..)", true),
                                    new UsesMethod<>("java.time.Instant plus(..)", true),
                                    new UsesMethod<>("java.time.Instant plusMillis(..)", true),
                                    new UsesMethod<>("java.time.Instant plusNanos(..)", true),
                                    new UsesMethod<>("java.time.Instant plusSeconds(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("java.time.Instant getEpochSecond(..)", true),
                                            new UsesMethod<>("java.time.Instant getNano(..)", true),
                                            new UsesMethod<>("java.time.Instant ofEpochSecond(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.time.Instant parse(..)", true),
                                            new UsesMethod<>("java.time.Instant toString(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Instant minus(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Instant plus(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.time.temporal.ChronoUnit", true),
                                            new UsesMethod<>("java.time.Instant truncatedTo(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.InstantTruncatedToMilliseconds}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class InstantTruncatedToMillisecondsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public InstantTruncatedToMillisecondsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Prefer `Instant#truncatedTo(TemporalUnit)` over less obvious alternatives";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Note that `Instant#toEpochMilli()` throws an `ArithmeticException` for dates\n very far in the past or future, while the suggested alternative doesn't.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.time.Instant.ofEpochMilli(#{instant:any(java.time.Instant)}.toEpochMilli())")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}.truncatedTo(java.time.temporal.ChronoUnit.MILLIS)")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesMethod<>("java.time.Instant ofEpochMilli(..)", true),
                            new UsesMethod<>("java.time.Instant toEpochMilli(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.InstantTruncatedToSeconds}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class InstantTruncatedToSecondsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public InstantTruncatedToSecondsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.InstantTruncatedToSeconds`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Instant#truncatedTo(TemporalUnit)` over less obvious alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.time.Instant.ofEpochSecond(#{instant:any(java.time.Instant)}.getEpochSecond())")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}.truncatedTo(java.time.temporal.ChronoUnit.SECONDS)")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesMethod<>("java.time.Instant getEpochSecond(..)", true),
                            new UsesMethod<>("java.time.Instant ofEpochSecond(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.InstantAtOffset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class InstantAtOffsetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public InstantAtOffsetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.InstantAtOffset`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Instant#atOffset(ZoneOffset)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.time.OffsetDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneOffset:any(java.time.ZoneOffset)})")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}.atOffset(#{zoneOffset:any(java.time.ZoneOffset)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesType<>("java.time.ZoneOffset", true),
                            new UsesMethod<>("java.time.OffsetDateTime ofInstant(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetTimeOfInstant}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetTimeOfInstantRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetTimeOfInstantRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetTimeOfInstant`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetTime#ofInstant(Instant, ZoneId)` over more indirect alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.time.OffsetDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)}).toOffsetTime()")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.OffsetDateTime");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.OffsetTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{instant:any(java.time.Instant)}.atOffset(#{zoneId:any(java.time.ZoneOffset)}).toOffsetTime()")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.ZoneOffset");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.OffsetTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesType<>("java.time.OffsetTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime toOffsetTime(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("java.time.OffsetDateTime", true),
                                            new UsesType<>("java.time.ZoneId", true),
                                            new UsesMethod<>("java.time.OffsetDateTime ofInstant(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.time.ZoneOffset", true),
                                            new UsesMethod<>("java.time.Instant atOffset(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.InstantAtZone}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class InstantAtZoneRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public InstantAtZoneRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.InstantAtZone`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Instant#atZone(ZoneId)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.time.ZonedDateTime.ofInstant(#{instant:any(java.time.Instant)}, #{zoneId:any(java.time.ZoneId)})")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{instant:any(java.time.Instant)}.atZone(#{zoneId:any(java.time.ZoneId)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesType<>("java.time.ZoneId", true),
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime ofInstant(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.UtcClock}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class UtcClockRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public UtcClockRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.UtcClock`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Use `Clock#systemUTC()` when possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.time.Clock.system(java.time.ZoneOffset.UTC)")
                                .bindType("java.time.Clock").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.ZoneOffset");
                        maybeRemoveImport("java.time.ZoneOffset.UTC");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Clock.systemUTC()")
                                    .bindType("java.time.Clock").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Clock", true),
                            new UsesMethod<>("java.time.Clock system(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.EpochInstant}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EpochInstantRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EpochInstantRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.EpochInstant`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Instant#EPOCH` over alternative representations.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.time.Instant.ofEpochMilli(0)")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Instant.EPOCH")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.time.Instant.ofEpochSecond(0)")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Instant.EPOCH")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.time.Instant.ofEpochSecond(0, 0)")
                                .bindType("java.time.Instant").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Instant.EPOCH")
                                    .bindType("java.time.Instant").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.time.Instant ofEpochMilli(..)", true),
                                    new UsesMethod<>("java.time.Instant ofEpochSecond(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.InstantIsBefore}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class InstantIsBeforeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public InstantIsBeforeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.InstantIsBefore`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Instant#isBefore(Instant)` over explicit comparison, as it yields more readable code.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{a:any(java.time.Instant)}.compareTo(#{b:any(java.time.Instant)}) < 0").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(java.time.Instant)}.isBefore(#{b:any(java.time.Instant)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesMethod<>("java.time.Instant compareTo(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.InstantIsAfter}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class InstantIsAfterRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public InstantIsAfterRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.InstantIsAfter`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Instant#isBefore(Instant)` over explicit comparison, as it yields more readable code.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{a:any(java.time.Instant)}.compareTo(#{b:any(java.time.Instant)}) > 0").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(java.time.Instant)}.isAfter(#{b:any(java.time.Instant)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Instant", true),
                            new UsesMethod<>("java.time.Instant compareTo(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalTimeMin}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalTimeMinRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalTimeMinRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalTimeMin`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer the `LocalTime#MIN` over alternative representations.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate before$5;
                JavaTemplate after;

                @Override
                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.time.LocalTime.MIDNIGHT")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.time.LocalTime.of(0, 0)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.time.LocalTime.of(0, 0, 0)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("java.time.LocalTime.of(0, 0, 0, 0)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$4 == null) {
                        before$4 = JavaTemplate.builder("java.time.LocalTime.ofNanoOfDay(0)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$4.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$5 == null) {
                        before$5 = JavaTemplate.builder("java.time.LocalTime.ofSecondOfDay(0)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$5.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitFieldAccess(elem, ctx);
                }

                @Override
                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.time.LocalTime.MIDNIGHT")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.time.LocalTime.of(0, 0)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.time.LocalTime.of(0, 0, 0)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("java.time.LocalTime.of(0, 0, 0, 0)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$4 == null) {
                        before$4 = JavaTemplate.builder("java.time.LocalTime.ofNanoOfDay(0)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$4.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$5 == null) {
                        before$5 = JavaTemplate.builder("java.time.LocalTime.ofSecondOfDay(0)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$5.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitIdentifier(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.time.LocalTime.MIDNIGHT")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.time.LocalTime.of(0, 0)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.time.LocalTime.of(0, 0, 0)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("java.time.LocalTime.of(0, 0, 0, 0)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$4 == null) {
                        before$4 = JavaTemplate.builder("java.time.LocalTime.ofNanoOfDay(0)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$4.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$5 == null) {
                        before$5 = JavaTemplate.builder("java.time.LocalTime.ofSecondOfDay(0)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before$5.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.LocalTime.MIN")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesType<>("java.time.LocalTime", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateAtStartOfDay}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateAtStartOfDayRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateAtStartOfDayRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateAtStartOfDay`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDate#atStartOfDay()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.atTime(java.time.LocalTime.MIN)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.LocalTime");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.atStartOfDay()")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDate", true),
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesType<>("java.time.LocalTime", true),
                            new UsesMethod<>("java.time.LocalDate atTime(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ChronoLocalDateIsBefore}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ChronoLocalDateIsBeforeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ChronoLocalDateIsBeforeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ChronoLocalDateIsBefore`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ChronoLocalDate#isBefore(ChronoLocalDate)` over explicit comparison, as it yields more readable code.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{a:any(java.time.chrono.ChronoLocalDate)}.compareTo(#{b:any(java.time.chrono.ChronoLocalDate)}) < 0").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(java.time.chrono.ChronoLocalDate)}.isBefore(#{b:any(java.time.chrono.ChronoLocalDate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.chrono.ChronoLocalDate", true),
                            new UsesMethod<>("java.time.chrono.ChronoLocalDate compareTo(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ChronoLocalDateIsAfter}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ChronoLocalDateIsAfterRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ChronoLocalDateIsAfterRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ChronoLocalDateIsAfter`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ChronoLocalDate#isBefore(ChronoLocalDate)` over explicit comparison, as it yields more readable code.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{a:any(java.time.chrono.ChronoLocalDate)}.compareTo(#{b:any(java.time.chrono.ChronoLocalDate)}) > 0").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(java.time.chrono.ChronoLocalDate)}.isAfter(#{b:any(java.time.chrono.ChronoLocalDate)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.chrono.ChronoLocalDate", true),
                            new UsesMethod<>("java.time.chrono.ChronoLocalDate compareTo(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ChronoLocalDateTimeIsBefore}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ChronoLocalDateTimeIsBeforeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ChronoLocalDateTimeIsBeforeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ChronoLocalDateTimeIsBefore`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ChronoLocalDateTime#isBefore(ChronoLocalDateTime)` over explicit comparison, as it yields more readable code.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{a:any(java.time.chrono.ChronoLocalDateTime<?>)}.compareTo(#{b:any(java.time.chrono.ChronoLocalDateTime<?>)}) < 0").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(java.time.chrono.ChronoLocalDateTime<?>)}.isBefore(#{b:any(java.time.chrono.ChronoLocalDateTime<?>)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.chrono.ChronoLocalDateTime", true),
                            new UsesMethod<>("java.time.chrono.ChronoLocalDateTime compareTo(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ChronoLocalDateTimeIsAfter}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ChronoLocalDateTimeIsAfterRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ChronoLocalDateTimeIsAfterRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ChronoLocalDateTimeIsAfter`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ChronoLocalDateTime#isBefore(ChronoLocalDateTime)` over explicit comparison, as it yields more readable code.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{a:any(java.time.chrono.ChronoLocalDateTime<?>)}.compareTo(#{b:any(java.time.chrono.ChronoLocalDateTime<?>)}) > 0").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(java.time.chrono.ChronoLocalDateTime<?>)}.isAfter(#{b:any(java.time.chrono.ChronoLocalDateTime<?>)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.chrono.ChronoLocalDateTime", true),
                            new UsesMethod<>("java.time.chrono.ChronoLocalDateTime compareTo(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ChronoZonedDateTimeIsBefore}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ChronoZonedDateTimeIsBeforeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ChronoZonedDateTimeIsBeforeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ChronoZonedDateTimeIsBefore`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ChronoZonedDateTime#isBefore(ChronoZonedDateTime)` over explicit comparison, as it yields more readable code.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{a:any(java.time.chrono.ChronoZonedDateTime<?>)}.compareTo(#{b:any(java.time.chrono.ChronoZonedDateTime<?>)}) < 0").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(java.time.chrono.ChronoZonedDateTime<?>)}.isBefore(#{b:any(java.time.chrono.ChronoZonedDateTime<?>)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.chrono.ChronoZonedDateTime", true),
                            new UsesMethod<>("java.time.chrono.ChronoZonedDateTime compareTo(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ChronoZonedDateTimeIsAfter}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ChronoZonedDateTimeIsAfterRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ChronoZonedDateTimeIsAfterRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ChronoZonedDateTimeIsAfter`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ChronoZonedDateTime#isBefore(ChronoZonedDateTime)` over explicit comparison, as it yields more readable code.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{a:any(java.time.chrono.ChronoZonedDateTime<?>)}.compareTo(#{b:any(java.time.chrono.ChronoZonedDateTime<?>)}) > 0").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(java.time.chrono.ChronoZonedDateTime<?>)}.isAfter(#{b:any(java.time.chrono.ChronoZonedDateTime<?>)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.chrono.ChronoZonedDateTime", true),
                            new UsesMethod<>("java.time.chrono.ChronoZonedDateTime compareTo(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimeIsBefore}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimeIsBeforeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimeIsBeforeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimeIsBefore`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#isBefore(OffsetDateTime)` over explicit comparison, as it yields more readable code.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{a:any(java.time.OffsetDateTime)}.compareTo(#{b:any(java.time.OffsetDateTime)}) < 0").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(java.time.OffsetDateTime)}.isBefore(#{b:any(java.time.OffsetDateTime)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime compareTo(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimeIsAfter}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimeIsAfterRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimeIsAfterRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimeIsAfter`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#isBefore(OffsetDateTime)` over explicit comparison, as it yields more readable code.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{a:any(java.time.OffsetDateTime)}.compareTo(#{b:any(java.time.OffsetDateTime)}) > 0").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(java.time.OffsetDateTime)}.isAfter(#{b:any(java.time.OffsetDateTime)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime compareTo(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZeroDuration}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZeroDurationRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZeroDurationRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZeroDuration`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZeroDuration {\n    \n    @BeforeTemplate\n    Duration before(TemporalUnit temporalUnit) {\n        return Refaster.anyOf(Duration.ofNanos(0), Duration.ofMillis(0), Duration.ofSeconds(0), Duration.ofSeconds(0, 0), Duration.ofMinutes(0), Duration.ofHours(0), Duration.ofDays(0), Duration.of(0, temporalUnit));\n    }\n    \n    @AfterTemplate\n    Duration after() {\n        return Duration.ZERO;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate before$5;
                JavaTemplate before$6;
                JavaTemplate before$7;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.time.Duration.ofNanos(0)")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.ZERO")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.time.Duration.ofMillis(0)")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.ZERO")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.time.Duration.ofSeconds(0)")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.ZERO")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("java.time.Duration.ofSeconds(0, 0)")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.ZERO")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$4 == null) {
                        before$4 = JavaTemplate.builder("java.time.Duration.ofMinutes(0)")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before$4.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.ZERO")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$5 == null) {
                        before$5 = JavaTemplate.builder("java.time.Duration.ofHours(0)")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before$5.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.ZERO")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$6 == null) {
                        before$6 = JavaTemplate.builder("java.time.Duration.ofDays(0)")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before$6.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.ZERO")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$7 == null) {
                        before$7 = JavaTemplate.builder("java.time.Duration.of(0, #{temporalUnit:any(java.time.temporal.TemporalUnit)})")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before$7.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.TemporalUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.ZERO")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("java.time.temporal.TemporalUnit", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.time.Duration of(..)", true),
                                    new UsesMethod<>("java.time.Duration ofDays(..)", true),
                                    new UsesMethod<>("java.time.Duration ofHours(..)", true),
                                    new UsesMethod<>("java.time.Duration ofMillis(..)", true),
                                    new UsesMethod<>("java.time.Duration ofMinutes(..)", true),
                                    new UsesMethod<>("java.time.Duration ofNanos(..)", true),
                                    new UsesMethod<>("java.time.Duration ofSeconds(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.DurationOfDays}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class DurationOfDaysRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public DurationOfDaysRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.DurationOfDays`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Duration#ofDays(long)` over alternative representations.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.time.Duration.of(#{amount:any(long)}, java.time.temporal.ChronoUnit.DAYS)")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.ofDays(#{amount:any(long)})")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("java.time.temporal.ChronoUnit", true),
                            new UsesMethod<>("java.time.Duration of(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.DurationOfHours}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class DurationOfHoursRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public DurationOfHoursRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.DurationOfHours`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Duration#ofHours(long)` over alternative representations.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.time.Duration.of(#{amount:any(long)}, java.time.temporal.ChronoUnit.HOURS)")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.ofHours(#{amount:any(long)})")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("java.time.temporal.ChronoUnit", true),
                            new UsesMethod<>("java.time.Duration of(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.DurationOfMillis}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class DurationOfMillisRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public DurationOfMillisRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.DurationOfMillis`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Duration#ofMillis(long)` over alternative representations.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.time.Duration.of(#{amount:any(long)}, java.time.temporal.ChronoUnit.MILLIS)")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.ofMillis(#{amount:any(long)})")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("java.time.temporal.ChronoUnit", true),
                            new UsesMethod<>("java.time.Duration of(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.DurationOfMinutes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class DurationOfMinutesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public DurationOfMinutesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.DurationOfMinutes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Duration#ofMinutes(long)` over alternative representations.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.time.Duration.of(#{amount:any(long)}, java.time.temporal.ChronoUnit.MINUTES)")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.ofMinutes(#{amount:any(long)})")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("java.time.temporal.ChronoUnit", true),
                            new UsesMethod<>("java.time.Duration of(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.DurationOfNanos}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class DurationOfNanosRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public DurationOfNanosRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.DurationOfNanos`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Duration#ofNanos(long)` over alternative representations.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.time.Duration.of(#{amount:any(long)}, java.time.temporal.ChronoUnit.NANOS)")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.ofNanos(#{amount:any(long)})")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("java.time.temporal.ChronoUnit", true),
                            new UsesMethod<>("java.time.Duration of(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.DurationOfSeconds}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class DurationOfSecondsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public DurationOfSecondsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.DurationOfSeconds`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Duration#ofSeconds(long)` over alternative representations.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.time.Duration.of(#{amount:any(long)}, java.time.temporal.ChronoUnit.SECONDS)")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.ofSeconds(#{amount:any(long)})")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("java.time.temporal.ChronoUnit", true),
                            new UsesMethod<>("java.time.Duration of(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.DurationBetweenInstants}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class DurationBetweenInstantsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public DurationBetweenInstantsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.DurationBetweenInstants`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily convert to and from milliseconds. (This way nanosecond precision is retained.) <strong>Warning:</strong> this rewrite rule increases precision!.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.time.Duration.ofMillis(#{b:any(java.time.Instant)}.toEpochMilli() - #{a:any(java.time.Instant)}.toEpochMilli())")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.between(#{a:any(java.time.Instant)}, #{b:any(java.time.Instant)})")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("java.time.Instant", true),
                            new UsesMethod<>("java.time.Duration ofMillis(..)", true),
                            new UsesMethod<>("java.time.Instant toEpochMilli(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.DurationBetweenOffsetDateTimes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class DurationBetweenOffsetDateTimesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public DurationBetweenOffsetDateTimesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.DurationBetweenOffsetDateTimes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily convert to and from milliseconds. (This way nanosecond precision is retained.) <strong>Warning:</strong> this rewrite rule increases precision!.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.time.Duration.between(#{a:any(java.time.OffsetDateTime)}.toInstant(), #{b:any(java.time.OffsetDateTime)}.toInstant())")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.between(#{a:any(java.time.OffsetDateTime)}, #{b:any(java.time.OffsetDateTime)})")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.time.Duration.ofSeconds(#{b:any(java.time.OffsetDateTime)}.toEpochSecond() - #{a:any(java.time.OffsetDateTime)}.toEpochSecond())")
                                .bindType("java.time.Duration").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Duration.between(#{a:any(java.time.OffsetDateTime)}, #{b:any(java.time.OffsetDateTime)})")
                                    .bindType("java.time.Duration").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("java.time.OffsetDateTime", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.time.Duration between(..)", true),
                                            new UsesMethod<>("java.time.OffsetDateTime toInstant(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.time.Duration ofSeconds(..)", true),
                                            new UsesMethod<>("java.time.OffsetDateTime toEpochSecond(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.DurationIsZero}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class DurationIsZeroRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public DurationIsZeroRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.DurationIsZero`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Duration#isZero()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{duration:any(java.time.Duration)}.equals(java.time.Duration.ZERO)").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{duration:any(java.time.Duration)}.isZero()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.time.Duration.ZERO.equals(#{duration:any(java.time.Duration)})").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{duration:any(java.time.Duration)}.isZero()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesMethod<>("java.time.Duration equals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZeroPeriod}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZeroPeriodRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZeroPeriodRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZeroPeriod`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ZeroPeriod {\n    \n    @BeforeTemplate\n    Period before() {\n        return Refaster.anyOf(Period.ofDays(0), Period.ofWeeks(0), Period.ofMonths(0), Period.ofYears(0), Period.of(0, 0, 0));\n    }\n    \n    @AfterTemplate\n    Period after() {\n        return Period.ZERO;\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.time.Period.ofDays(0)")
                                .bindType("java.time.Period").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Period.ZERO")
                                    .bindType("java.time.Period").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.time.Period.ofWeeks(0)")
                                .bindType("java.time.Period").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Period.ZERO")
                                    .bindType("java.time.Period").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.time.Period.ofMonths(0)")
                                .bindType("java.time.Period").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Period.ZERO")
                                    .bindType("java.time.Period").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("java.time.Period.ofYears(0)")
                                .bindType("java.time.Period").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Period.ZERO")
                                    .bindType("java.time.Period").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$4 == null) {
                        before$4 = JavaTemplate.builder("java.time.Period.of(0, 0, 0)")
                                .bindType("java.time.Period").build();
                    }
                    if ((matcher = before$4.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.time.Period.ZERO")
                                    .bindType("java.time.Period").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Period", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.time.Period of(..)", true),
                                    new UsesMethod<>("java.time.Period ofDays(..)", true),
                                    new UsesMethod<>("java.time.Period ofMonths(..)", true),
                                    new UsesMethod<>("java.time.Period ofWeeks(..)", true),
                                    new UsesMethod<>("java.time.Period ofYears(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDatePlusDays}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDatePlusDaysRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDatePlusDaysRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDatePlusDays`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDate#plusDays(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.plus(java.time.Period.ofDays(#{days:any(int)}))")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.plusDays(#{days:any(int)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.plus(#{days:any(long)}, java.time.temporal.ChronoUnit.DAYS)")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.plusDays(#{days:any(int)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDate", true),
                            new UsesMethod<>("java.time.LocalDate plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofDays(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDatePlusWeeks}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDatePlusWeeksRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDatePlusWeeksRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDatePlusWeeks`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDate#plusWeeks(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.plus(java.time.Period.ofWeeks(#{weeks:any(int)}))")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.plusWeeks(#{weeks:any(int)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.plus(#{weeks:any(long)}, java.time.temporal.ChronoUnit.WEEKS)")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.plusWeeks(#{weeks:any(int)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDate", true),
                            new UsesMethod<>("java.time.LocalDate plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofWeeks(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDatePlusMonths}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDatePlusMonthsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDatePlusMonthsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDatePlusMonths`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDate#plusMonths(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.plus(java.time.Period.ofMonths(#{months:any(int)}))")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.plusMonths(#{months:any(int)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.plus(#{months:any(long)}, java.time.temporal.ChronoUnit.MONTHS)")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.plusMonths(#{months:any(int)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDate", true),
                            new UsesMethod<>("java.time.LocalDate plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofMonths(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDatePlusYears}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDatePlusYearsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDatePlusYearsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDatePlusYears`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDate#plusYears(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.plus(java.time.Period.ofYears(#{years:any(int)}))")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.plusYears(#{years:any(int)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.plus(#{years:any(long)}, java.time.temporal.ChronoUnit.YEARS)")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.plusYears(#{years:any(int)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDate", true),
                            new UsesMethod<>("java.time.LocalDate plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofYears(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateMinusDays}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateMinusDaysRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateMinusDaysRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateMinusDays`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDate#minusDays(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.minus(java.time.Period.ofDays(#{days:any(int)}))")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.minusDays(#{days:any(int)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.minus(#{days:any(long)}, java.time.temporal.ChronoUnit.DAYS)")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.minusDays(#{days:any(int)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDate", true),
                            new UsesMethod<>("java.time.LocalDate minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofDays(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateMinusWeeks}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateMinusWeeksRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateMinusWeeksRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateMinusWeeks`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDate#minusWeeks(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.minus(java.time.Period.ofWeeks(#{weeks:any(int)}))")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.minusWeeks(#{weeks:any(int)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.minus(#{weeks:any(long)}, java.time.temporal.ChronoUnit.WEEKS)")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.minusWeeks(#{weeks:any(int)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDate", true),
                            new UsesMethod<>("java.time.LocalDate minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofWeeks(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateMinusMonths}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateMinusMonthsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateMinusMonthsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateMinusMonths`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDate#minusMonths(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.minus(java.time.Period.ofMonths(#{months:any(int)}))")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.minusMonths(#{months:any(int)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.minus(#{months:any(long)}, java.time.temporal.ChronoUnit.MONTHS)")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.minusMonths(#{months:any(int)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDate", true),
                            new UsesMethod<>("java.time.LocalDate minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofMonths(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateMinusYears}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateMinusYearsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateMinusYearsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateMinusYears`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDate#minusYears(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.minus(java.time.Period.ofYears(#{years:any(int)}))")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.minusYears(#{years:any(int)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.minus(#{years:any(long)}, java.time.temporal.ChronoUnit.YEARS)")
                                .bindType("java.time.LocalDate").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDate:any(java.time.LocalDate)}.minusYears(#{years:any(int)})")
                                    .bindType("java.time.LocalDate").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDate", true),
                            new UsesMethod<>("java.time.LocalDate minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofYears(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalTimePlusNanos}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalTimePlusNanosRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalTimePlusNanosRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalTimePlusNanos`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalTime#plusNanos(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.plus(java.time.Duration.ofNanos(#{nanos:any(int)}))")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.plusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.plus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.plusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalTime", true),
                            new UsesMethod<>("java.time.LocalTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofNanos(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalTimePlusSeconds}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalTimePlusSecondsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalTimePlusSecondsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalTimePlusSeconds`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalTime#plusSeconds(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.plus(java.time.Duration.ofSeconds(#{seconds:any(int)}))")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.plusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.plus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.plusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalTime", true),
                            new UsesMethod<>("java.time.LocalTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofSeconds(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalTimePlusMinutes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalTimePlusMinutesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalTimePlusMinutesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalTimePlusMinutes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalTime#plusMinutes(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.plus(java.time.Duration.ofMinutes(#{minutes:any(int)}))")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.plusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.plus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.plusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalTime", true),
                            new UsesMethod<>("java.time.LocalTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofMinutes(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalTimePlusHours}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalTimePlusHoursRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalTimePlusHoursRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalTimePlusHours`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalTime#plusHours(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.plus(java.time.Duration.ofHours(#{hours:any(int)}))")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.plusHours(#{hours:any(int)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.plus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.plusHours(#{hours:any(int)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalTime", true),
                            new UsesMethod<>("java.time.LocalTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofHours(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalTimeMinusNanos}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalTimeMinusNanosRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalTimeMinusNanosRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalTimeMinusNanos`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalTime#minusNanos(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.minus(java.time.Duration.ofNanos(#{nanos:any(int)}))")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.minusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.minus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.minusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalTime", true),
                            new UsesMethod<>("java.time.LocalTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofNanos(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalTimeMinusSeconds}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalTimeMinusSecondsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalTimeMinusSecondsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalTimeMinusSeconds`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalTime#minusSeconds(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.minus(java.time.Duration.ofSeconds(#{seconds:any(int)}))")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.minusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.minus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.minusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalTime", true),
                            new UsesMethod<>("java.time.LocalTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofSeconds(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalTimeMinusMinutes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalTimeMinusMinutesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalTimeMinusMinutesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalTimeMinusMinutes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalTime#minusMinutes(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.minus(java.time.Duration.ofMinutes(#{minutes:any(int)}))")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.minusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.minus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.minusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalTime", true),
                            new UsesMethod<>("java.time.LocalTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofMinutes(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalTimeMinusHours}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalTimeMinusHoursRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalTimeMinusHoursRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalTimeMinusHours`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalTime#minusHours(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.minus(java.time.Duration.ofHours(#{hours:any(int)}))")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.minusHours(#{hours:any(int)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.minus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)")
                                .bindType("java.time.LocalTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localTime:any(java.time.LocalTime)}.minusHours(#{hours:any(int)})")
                                    .bindType("java.time.LocalTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalTime", true),
                            new UsesMethod<>("java.time.LocalTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofHours(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetTimePlusNanos}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetTimePlusNanosRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetTimePlusNanosRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetTimePlusNanos`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetTime#plusNanos(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.plus(java.time.Duration.ofNanos(#{nanos:any(int)}))")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.plusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.plus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.plusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetTime", true),
                            new UsesMethod<>("java.time.OffsetTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofNanos(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetTimePlusSeconds}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetTimePlusSecondsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetTimePlusSecondsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetTimePlusSeconds`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetTime#plusSeconds(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.plus(java.time.Duration.ofSeconds(#{seconds:any(int)}))")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.plusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.plus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.plusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetTime", true),
                            new UsesMethod<>("java.time.OffsetTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofSeconds(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetTimePlusMinutes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetTimePlusMinutesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetTimePlusMinutesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetTimePlusMinutes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetTime#plusMinutes(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.plus(java.time.Duration.ofMinutes(#{minutes:any(int)}))")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.plusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.plus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.plusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetTime", true),
                            new UsesMethod<>("java.time.OffsetTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofMinutes(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetTimePlusHours}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetTimePlusHoursRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetTimePlusHoursRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetTimePlusHours`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetTime#plusHours(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.plus(java.time.Duration.ofHours(#{hours:any(int)}))")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.plusHours(#{hours:any(int)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.plus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.plusHours(#{hours:any(int)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetTime", true),
                            new UsesMethod<>("java.time.OffsetTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofHours(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetTimeMinusNanos}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetTimeMinusNanosRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetTimeMinusNanosRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetTimeMinusNanos`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetTime#minusNanos(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.minus(java.time.Duration.ofNanos(#{nanos:any(int)}))")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.minusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.minus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.minusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetTime", true),
                            new UsesMethod<>("java.time.OffsetTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofNanos(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetTimeMinusSeconds}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetTimeMinusSecondsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetTimeMinusSecondsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetTimeMinusSeconds`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetTime#minusSeconds(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.minus(java.time.Duration.ofSeconds(#{seconds:any(int)}))")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.minusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.minus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.minusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetTime", true),
                            new UsesMethod<>("java.time.OffsetTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofSeconds(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetTimeMinusMinutes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetTimeMinusMinutesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetTimeMinusMinutesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetTimeMinusMinutes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetTime#minusMinutes(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.minus(java.time.Duration.ofMinutes(#{minutes:any(int)}))")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.minusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.minus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.minusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetTime", true),
                            new UsesMethod<>("java.time.OffsetTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofMinutes(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetTimeMinusHours}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetTimeMinusHoursRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetTimeMinusHoursRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetTimeMinusHours`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetTime#minusHours(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.minus(java.time.Duration.ofHours(#{hours:any(int)}))")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.minusHours(#{hours:any(int)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.minus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)")
                                .bindType("java.time.OffsetTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetTime:any(java.time.OffsetTime)}.minusHours(#{hours:any(int)})")
                                    .bindType("java.time.OffsetTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetTime", true),
                            new UsesMethod<>("java.time.OffsetTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofHours(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimePlusNanos}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimePlusNanosRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimePlusNanosRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimePlusNanos`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#plusNanos(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plus(java.time.Duration.ofNanos(#{nanos:any(int)}))")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesMethod<>("java.time.LocalDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofNanos(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimePlusSeconds}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimePlusSecondsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimePlusSecondsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimePlusSeconds`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#plusSeconds(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plus(java.time.Duration.ofSeconds(#{seconds:any(int)}))")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesMethod<>("java.time.LocalDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofSeconds(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimePlusMinutes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimePlusMinutesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimePlusMinutesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimePlusMinutes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#plusMinutes(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plus(java.time.Duration.ofMinutes(#{minutes:any(int)}))")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesMethod<>("java.time.LocalDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofMinutes(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimePlusHours}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimePlusHoursRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimePlusHoursRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimePlusHours`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#plusHours(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plus(java.time.Duration.ofHours(#{hours:any(int)}))")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plusHours(#{hours:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plusHours(#{hours:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesMethod<>("java.time.LocalDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofHours(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimePlusDays}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimePlusDaysRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimePlusDaysRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimePlusDays`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#plusDays(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plus(java.time.Period.ofDays(#{days:any(int)}))")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plusDays(#{days:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plus(#{days:any(long)}, java.time.temporal.ChronoUnit.DAYS)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plusDays(#{days:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesMethod<>("java.time.LocalDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofDays(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimePlusWeeks}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimePlusWeeksRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimePlusWeeksRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimePlusWeeks`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#plusWeeks(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plus(java.time.Period.ofWeeks(#{weeks:any(int)}))")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plusWeeks(#{weeks:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plus(#{weeks:any(long)}, java.time.temporal.ChronoUnit.WEEKS)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plusWeeks(#{weeks:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesMethod<>("java.time.LocalDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofWeeks(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimePlusMonths}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimePlusMonthsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimePlusMonthsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimePlusMonths`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#plusMonths(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plus(java.time.Period.ofMonths(#{months:any(int)}))")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plusMonths(#{months:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plus(#{months:any(long)}, java.time.temporal.ChronoUnit.MONTHS)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plusMonths(#{months:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesMethod<>("java.time.LocalDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofMonths(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimePlusYears}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimePlusYearsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimePlusYearsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimePlusYears`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#plusYears(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plus(java.time.Period.ofYears(#{years:any(int)}))")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plusYears(#{years:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plus(#{years:any(long)}, java.time.temporal.ChronoUnit.YEARS)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.plusYears(#{years:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesMethod<>("java.time.LocalDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofYears(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimeMinusNanos}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimeMinusNanosRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimeMinusNanosRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimeMinusNanos`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#minusNanos(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minus(java.time.Duration.ofNanos(#{nanos:any(int)}))")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesMethod<>("java.time.LocalDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofNanos(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimeMinusSeconds}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimeMinusSecondsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimeMinusSecondsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimeMinusSeconds`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#minusSeconds(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minus(java.time.Duration.ofSeconds(#{seconds:any(int)}))")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesMethod<>("java.time.LocalDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofSeconds(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimeMinusMinutes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimeMinusMinutesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimeMinusMinutesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimeMinusMinutes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#minusMinutes(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minus(java.time.Duration.ofMinutes(#{minutes:any(int)}))")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesMethod<>("java.time.LocalDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofMinutes(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimeMinusHours}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimeMinusHoursRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimeMinusHoursRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimeMinusHours`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#minusHours(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minus(java.time.Duration.ofHours(#{hours:any(int)}))")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minusHours(#{hours:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minusHours(#{hours:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesMethod<>("java.time.LocalDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofHours(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimeMinusDays}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimeMinusDaysRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimeMinusDaysRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimeMinusDays`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#minusDays(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minus(java.time.Period.ofDays(#{days:any(int)}))")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minusDays(#{days:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minus(#{days:any(long)}, java.time.temporal.ChronoUnit.DAYS)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minusDays(#{days:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesMethod<>("java.time.LocalDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofDays(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimeMinusWeeks}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimeMinusWeeksRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimeMinusWeeksRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimeMinusWeeks`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#minusWeeks(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minus(java.time.Period.ofWeeks(#{weeks:any(int)}))")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minusWeeks(#{weeks:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minus(#{weeks:any(long)}, java.time.temporal.ChronoUnit.WEEKS)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minusWeeks(#{weeks:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesMethod<>("java.time.LocalDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofWeeks(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimeMinusMonths}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimeMinusMonthsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimeMinusMonthsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimeMinusMonths`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#minusMonths(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minus(java.time.Period.ofMonths(#{months:any(int)}))")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minusMonths(#{months:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minus(#{months:any(long)}, java.time.temporal.ChronoUnit.MONTHS)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minusMonths(#{months:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesMethod<>("java.time.LocalDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofMonths(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.LocalDateTimeMinusYears}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LocalDateTimeMinusYearsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LocalDateTimeMinusYearsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.LocalDateTimeMinusYears`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `LocalDateTime#minusYears(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minus(java.time.Period.ofYears(#{years:any(int)}))")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minusYears(#{years:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minus(#{years:any(long)}, java.time.temporal.ChronoUnit.YEARS)")
                                .bindType("java.time.LocalDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{localDateTime:any(java.time.LocalDateTime)}.minusYears(#{years:any(int)})")
                                    .bindType("java.time.LocalDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.LocalDateTime", true),
                            new UsesMethod<>("java.time.LocalDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofYears(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimePlusNanos}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimePlusNanosRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimePlusNanosRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimePlusNanos`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#plusNanos(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(java.time.Duration.ofNanos(#{nanos:any(int)}))")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofNanos(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimePlusSeconds}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimePlusSecondsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimePlusSecondsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimePlusSeconds`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#plusSeconds(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(java.time.Duration.ofSeconds(#{seconds:any(int)}))")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofSeconds(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimePlusMinutes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimePlusMinutesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimePlusMinutesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimePlusMinutes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#plusMinutes(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(java.time.Duration.ofMinutes(#{minutes:any(int)}))")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofMinutes(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimePlusHours}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimePlusHoursRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimePlusHoursRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimePlusHours`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#plusHours(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(java.time.Duration.ofHours(#{hours:any(int)}))")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plusHours(#{hours:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plusHours(#{hours:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofHours(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimePlusDays}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimePlusDaysRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimePlusDaysRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimePlusDays`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#plusDays(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(java.time.Period.ofDays(#{days:any(int)}))")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plusDays(#{days:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(#{days:any(long)}, java.time.temporal.ChronoUnit.DAYS)")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plusDays(#{days:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofDays(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimePlusWeeks}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimePlusWeeksRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimePlusWeeksRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimePlusWeeks`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#plusWeeks(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(java.time.Period.ofWeeks(#{weeks:any(int)}))")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plusWeeks(#{weeks:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(#{weeks:any(long)}, java.time.temporal.ChronoUnit.WEEKS)")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plusWeeks(#{weeks:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofWeeks(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimePlusMonths}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimePlusMonthsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimePlusMonthsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimePlusMonths`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#plusMonths(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(java.time.Period.ofMonths(#{months:any(int)}))")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plusMonths(#{months:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(#{months:any(long)}, java.time.temporal.ChronoUnit.MONTHS)")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plusMonths(#{months:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofMonths(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimePlusYears}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimePlusYearsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimePlusYearsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimePlusYears`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#plusYears(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(java.time.Period.ofYears(#{years:any(int)}))")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plusYears(#{years:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plus(#{years:any(long)}, java.time.temporal.ChronoUnit.YEARS)")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.plusYears(#{years:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofYears(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimeMinusNanos}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimeMinusNanosRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimeMinusNanosRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimeMinusNanos`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#minusNanos(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(java.time.Duration.ofNanos(#{nanos:any(int)}))")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofNanos(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimeMinusSeconds}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimeMinusSecondsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimeMinusSecondsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimeMinusSeconds`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#minusSeconds(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(java.time.Duration.ofSeconds(#{seconds:any(int)}))")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofSeconds(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimeMinusMinutes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimeMinusMinutesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimeMinusMinutesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimeMinusMinutes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#minusMinutes(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(java.time.Duration.ofMinutes(#{minutes:any(int)}))")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofMinutes(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimeMinusHours}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimeMinusHoursRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimeMinusHoursRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimeMinusHours`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#minusHours(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(java.time.Duration.ofHours(#{hours:any(int)}))")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minusHours(#{hours:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minusHours(#{hours:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofHours(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimeMinusDays}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimeMinusDaysRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimeMinusDaysRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimeMinusDays`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#minusDays(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(java.time.Period.ofDays(#{days:any(int)}))")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minusDays(#{days:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(#{days:any(long)}, java.time.temporal.ChronoUnit.DAYS)")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minusDays(#{days:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofDays(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimeMinusWeeks}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimeMinusWeeksRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimeMinusWeeksRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimeMinusWeeks`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#minusWeeks(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(java.time.Period.ofWeeks(#{weeks:any(int)}))")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minusWeeks(#{weeks:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(#{weeks:any(long)}, java.time.temporal.ChronoUnit.WEEKS)")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minusWeeks(#{weeks:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofWeeks(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimeMinusMonths}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimeMinusMonthsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimeMinusMonthsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimeMinusMonths`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#minusMonths(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(java.time.Period.ofMonths(#{months:any(int)}))")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minusMonths(#{months:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(#{months:any(long)}, java.time.temporal.ChronoUnit.MONTHS)")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minusMonths(#{months:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofMonths(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.OffsetDateTimeMinusYears}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OffsetDateTimeMinusYearsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OffsetDateTimeMinusYearsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.OffsetDateTimeMinusYears`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `OffsetDateTime#minusYears(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(java.time.Period.ofYears(#{years:any(int)}))")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minusYears(#{years:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minus(#{years:any(long)}, java.time.temporal.ChronoUnit.YEARS)")
                                .bindType("java.time.OffsetDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{offsetDateTime:any(java.time.OffsetDateTime)}.minusYears(#{years:any(int)})")
                                    .bindType("java.time.OffsetDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.OffsetDateTime", true),
                            new UsesMethod<>("java.time.OffsetDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofYears(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZonedDateTimePlusNanos}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZonedDateTimePlusNanosRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZonedDateTimePlusNanosRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZonedDateTimePlusNanos`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ZonedDateTime#plusNanos(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(java.time.Duration.ofNanos(#{nanos:any(int)}))")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofNanos(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZonedDateTimePlusSeconds}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZonedDateTimePlusSecondsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZonedDateTimePlusSecondsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZonedDateTimePlusSeconds`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ZonedDateTime#plusSeconds(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(java.time.Duration.ofSeconds(#{seconds:any(int)}))")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofSeconds(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZonedDateTimePlusMinutes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZonedDateTimePlusMinutesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZonedDateTimePlusMinutesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZonedDateTimePlusMinutes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ZonedDateTime#plusMinutes(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(java.time.Duration.ofMinutes(#{minutes:any(int)}))")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofMinutes(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZonedDateTimePlusHours}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZonedDateTimePlusHoursRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZonedDateTimePlusHoursRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZonedDateTimePlusHours`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ZonedDateTime#plusHours(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(java.time.Duration.ofHours(#{hours:any(int)}))")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plusHours(#{hours:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plusHours(#{hours:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofHours(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZonedDateTimePlusDays}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZonedDateTimePlusDaysRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZonedDateTimePlusDaysRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZonedDateTimePlusDays`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ZonedDateTime#plusDays(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(java.time.Period.ofDays(#{days:any(int)}))")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plusDays(#{days:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(#{days:any(long)}, java.time.temporal.ChronoUnit.DAYS)")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plusDays(#{days:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofDays(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZonedDateTimePlusWeeks}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZonedDateTimePlusWeeksRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZonedDateTimePlusWeeksRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZonedDateTimePlusWeeks`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ZonedDateTime#plusWeeks(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(java.time.Period.ofWeeks(#{weeks:any(int)}))")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plusWeeks(#{weeks:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(#{weeks:any(long)}, java.time.temporal.ChronoUnit.WEEKS)")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plusWeeks(#{weeks:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofWeeks(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZonedDateTimePlusMonths}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZonedDateTimePlusMonthsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZonedDateTimePlusMonthsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZonedDateTimePlusMonths`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ZonedDateTime#plusMonths(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(java.time.Period.ofMonths(#{months:any(int)}))")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plusMonths(#{months:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(#{months:any(long)}, java.time.temporal.ChronoUnit.MONTHS)")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plusMonths(#{months:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofMonths(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZonedDateTimePlusYears}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZonedDateTimePlusYearsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZonedDateTimePlusYearsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZonedDateTimePlusYears`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ZonedDateTime#plusYears(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(java.time.Period.ofYears(#{years:any(int)}))")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plusYears(#{years:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plus(#{years:any(long)}, java.time.temporal.ChronoUnit.YEARS)")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.plusYears(#{years:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime plus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofYears(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZonedDateTimeMinusNanos}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZonedDateTimeMinusNanosRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZonedDateTimeMinusNanosRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZonedDateTimeMinusNanos`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ZonedDateTime#minusNanos(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(java.time.Duration.ofNanos(#{nanos:any(int)}))")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(#{nanos:any(long)}, java.time.temporal.ChronoUnit.NANOS)")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minusNanos(#{nanos:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofNanos(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZonedDateTimeMinusSeconds}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZonedDateTimeMinusSecondsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZonedDateTimeMinusSecondsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZonedDateTimeMinusSeconds`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ZonedDateTime#minusSeconds(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(java.time.Duration.ofSeconds(#{seconds:any(int)}))")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(#{seconds:any(long)}, java.time.temporal.ChronoUnit.SECONDS)")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minusSeconds(#{seconds:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofSeconds(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZonedDateTimeMinusMinutes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZonedDateTimeMinusMinutesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZonedDateTimeMinusMinutesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZonedDateTimeMinusMinutes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ZonedDateTime#minusMinutes(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(java.time.Duration.ofMinutes(#{minutes:any(int)}))")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(#{minutes:any(long)}, java.time.temporal.ChronoUnit.MINUTES)")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minusMinutes(#{minutes:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofMinutes(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZonedDateTimeMinusHours}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZonedDateTimeMinusHoursRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZonedDateTimeMinusHoursRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZonedDateTimeMinusHours`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ZonedDateTime#minusHours(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(java.time.Duration.ofHours(#{hours:any(int)}))")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Duration");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minusHours(#{hours:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(#{hours:any(long)}, java.time.temporal.ChronoUnit.HOURS)")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minusHours(#{hours:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("java.time.Duration ofHours(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZonedDateTimeMinusDays}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZonedDateTimeMinusDaysRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZonedDateTimeMinusDaysRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZonedDateTimeMinusDays`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ZonedDateTime#minusDays(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(java.time.Period.ofDays(#{days:any(int)}))")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minusDays(#{days:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(#{days:any(long)}, java.time.temporal.ChronoUnit.DAYS)")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minusDays(#{days:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofDays(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZonedDateTimeMinusWeeks}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZonedDateTimeMinusWeeksRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZonedDateTimeMinusWeeksRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZonedDateTimeMinusWeeks`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ZonedDateTime#minusWeeks(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(java.time.Period.ofWeeks(#{weeks:any(int)}))")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minusWeeks(#{weeks:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(#{weeks:any(long)}, java.time.temporal.ChronoUnit.WEEKS)")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minusWeeks(#{weeks:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofWeeks(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZonedDateTimeMinusMonths}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZonedDateTimeMinusMonthsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZonedDateTimeMinusMonthsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZonedDateTimeMinusMonths`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ZonedDateTime#minusMonths(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(java.time.Period.ofMonths(#{months:any(int)}))")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minusMonths(#{months:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(#{months:any(long)}, java.time.temporal.ChronoUnit.MONTHS)")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minusMonths(#{months:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofMonths(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code TimeRules.ZonedDateTimeMinusYears}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ZonedDateTimeMinusYearsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ZonedDateTimeMinusYearsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `TimeRules.ZonedDateTimeMinusYears`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ZonedDateTime#minusYears(long)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(java.time.Period.ofYears(#{years:any(int)}))")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.Period");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minusYears(#{years:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minus(#{years:any(long)}, java.time.temporal.ChronoUnit.YEARS)")
                                .bindType("java.time.ZonedDateTime").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.time.temporal.ChronoUnit");
                        if (after == null) {
                            after = JavaTemplate.builder("#{zonedDateTime:any(java.time.ZonedDateTime)}.minusYears(#{years:any(int)})")
                                    .bindType("java.time.ZonedDateTime").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.ZonedDateTime", true),
                            new UsesMethod<>("java.time.ZonedDateTime minus(..)", true),
                            Preconditions.or(
                                    new UsesType<>("java.time.temporal.ChronoUnit", true),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Period", true),
                                            new UsesMethod<>("java.time.Period ofYears(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

}
