package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.SuggestedFixRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class SuggestedFixRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public SuggestedFixRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`SuggestedFixRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `SuggestedFix`es.\n[Source](https://error-prone.picnic.tech/refasterrules/SuggestedFixRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new SuggestedFixToBuilderRecipe(),
                new SuggestedFixDeleteRecipe(),
                new SuggestedFixReplaceTreeRecipe(),
                new SuggestedFixReplaceStartEndRecipe(),
                new SuggestedFixReplaceTreeStartEndRecipe(),
                new SuggestedFixSwapRecipe(),
                new SuggestedFixPrefixWithRecipe(),
                new SuggestedFixPostfixWithRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code SuggestedFixRules.SuggestedFixToBuilder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SuggestedFixToBuilderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SuggestedFixToBuilderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `SuggestedFixRules.SuggestedFixToBuilder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `SuggestedFix#toBuilder()`} over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.errorprone.fixes.SuggestedFix.builder().merge(#{fix:any(com.google.errorprone.fixes.SuggestedFix)})")
                                .bindType("com.google.errorprone.fixes.SuggestedFix.Builder")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_check_api-2"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{fix:any(com.google.errorprone.fixes.SuggestedFix)}.toBuilder()")
                                    .bindType("com.google.errorprone.fixes.SuggestedFix.Builder")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_check_api-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.errorprone.fixes.SuggestedFix", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix builder(..)", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix.Builder merge(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code SuggestedFixRules.SuggestedFixDelete}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SuggestedFixDeleteRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SuggestedFixDeleteRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `SuggestedFixRules.SuggestedFixDelete`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `SuggestedFix#delete(Tree)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.errorprone.fixes.SuggestedFix.builder().delete(#{tree:any(com.sun.source.tree.Tree)}).build()")
                                .bindType("com.google.errorprone.fixes.SuggestedFix")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_check_api-2"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.errorprone.fixes.SuggestedFix.delete(#{tree:any(com.sun.source.tree.Tree)})")
                                    .bindType("com.google.errorprone.fixes.SuggestedFix")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_check_api-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.errorprone.fixes.SuggestedFix", true),
                            new UsesType<>("com.sun.source.tree.Tree", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix builder(..)", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix.Builder build(..)", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix.Builder delete(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code SuggestedFixRules.SuggestedFixReplaceTree}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SuggestedFixReplaceTreeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SuggestedFixReplaceTreeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `SuggestedFixRules.SuggestedFixReplaceTree`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `SuggestedFix#replace(Tree, String)`} over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.errorprone.fixes.SuggestedFix.builder().replace(#{tree:any(com.sun.source.tree.Tree)}, #{replaceWith:any(java.lang.String)}).build()")
                                .bindType("com.google.errorprone.fixes.SuggestedFix")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_check_api-2"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.errorprone.fixes.SuggestedFix.replace(#{tree:any(com.sun.source.tree.Tree)}, #{replaceWith:any(java.lang.String)})")
                                    .bindType("com.google.errorprone.fixes.SuggestedFix")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_check_api-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.errorprone.fixes.SuggestedFix", true),
                            new UsesType<>("com.sun.source.tree.Tree", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix builder(..)", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix.Builder build(..)", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix.Builder replace(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code SuggestedFixRules.SuggestedFixReplaceStartEnd}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SuggestedFixReplaceStartEndRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SuggestedFixReplaceStartEndRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `SuggestedFixRules.SuggestedFixReplaceStartEnd`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `SuggestedFix#replace(int, int, String)`} over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.errorprone.fixes.SuggestedFix.builder().replace(#{start:any(int)}, #{end:any(int)}, #{replaceWith:any(java.lang.String)}).build()")
                                .bindType("com.google.errorprone.fixes.SuggestedFix")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_check_api-2"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.errorprone.fixes.SuggestedFix.replace(#{start:any(int)}, #{end:any(int)}, #{replaceWith:any(java.lang.String)})")
                                    .bindType("com.google.errorprone.fixes.SuggestedFix")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_check_api-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.errorprone.fixes.SuggestedFix", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix builder(..)", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix.Builder build(..)", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix.Builder replace(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code SuggestedFixRules.SuggestedFixReplaceTreeStartEnd}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SuggestedFixReplaceTreeStartEndRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SuggestedFixReplaceTreeStartEndRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `SuggestedFixRules.SuggestedFixReplaceTreeStartEnd`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `SuggestedFix#replace(Tree, String, int, int)`} over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.errorprone.fixes.SuggestedFix.builder().replace(#{tree:any(com.sun.source.tree.Tree)}, #{replaceWith:any(java.lang.String)}, #{start:any(int)}, #{end:any(int)}).build()")
                                .bindType("com.google.errorprone.fixes.SuggestedFix")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_check_api-2"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.errorprone.fixes.SuggestedFix.replace(#{tree:any(com.sun.source.tree.Tree)}, #{replaceWith:any(java.lang.String)}, #{start:any(int)}, #{end:any(int)})")
                                    .bindType("com.google.errorprone.fixes.SuggestedFix")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_check_api-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.errorprone.fixes.SuggestedFix", true),
                            new UsesType<>("com.sun.source.tree.Tree", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix builder(..)", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix.Builder build(..)", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix.Builder replace(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code SuggestedFixRules.SuggestedFixSwap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SuggestedFixSwapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SuggestedFixSwapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `SuggestedFixRules.SuggestedFixSwap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `SuggestedFix#swap(Tree, Tree, VisitorState)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.errorprone.fixes.SuggestedFix.builder().swap(#{tree1:any(com.sun.source.tree.Tree)}, #{tree2:any(com.sun.source.tree.Tree)}, #{state:any(com.google.errorprone.VisitorState)}).build()")
                                .bindType("com.google.errorprone.fixes.SuggestedFix")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_check_api-2"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.errorprone.fixes.SuggestedFix.swap(#{tree1:any(com.sun.source.tree.Tree)}, #{tree2:any(com.sun.source.tree.Tree)}, #{state:any(com.google.errorprone.VisitorState)})")
                                    .bindType("com.google.errorprone.fixes.SuggestedFix")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_check_api-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.errorprone.VisitorState", true),
                            new UsesType<>("com.google.errorprone.fixes.SuggestedFix", true),
                            new UsesType<>("com.sun.source.tree.Tree", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix builder(..)", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix.Builder build(..)", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix.Builder swap(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code SuggestedFixRules.SuggestedFixPrefixWith}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SuggestedFixPrefixWithRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SuggestedFixPrefixWithRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `SuggestedFixRules.SuggestedFixPrefixWith`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `SuggestedFix#prefixWith(Tree, String)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.errorprone.fixes.SuggestedFix.builder().prefixWith(#{tree:any(com.sun.source.tree.Tree)}, #{prefix:any(java.lang.String)}).build()")
                                .bindType("com.google.errorprone.fixes.SuggestedFix")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_check_api-2"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.errorprone.fixes.SuggestedFix.prefixWith(#{tree:any(com.sun.source.tree.Tree)}, #{prefix:any(java.lang.String)})")
                                    .bindType("com.google.errorprone.fixes.SuggestedFix")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_check_api-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.errorprone.fixes.SuggestedFix", true),
                            new UsesType<>("com.sun.source.tree.Tree", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix builder(..)", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix.Builder build(..)", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix.Builder prefixWith(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code SuggestedFixRules.SuggestedFixPostfixWith}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SuggestedFixPostfixWithRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SuggestedFixPostfixWithRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `SuggestedFixRules.SuggestedFixPostfixWith`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `SuggestedFix#postfixWith(Tree, String)`} over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.errorprone.fixes.SuggestedFix.builder().postfixWith(#{tree:any(com.sun.source.tree.Tree)}, #{postfix:any(java.lang.String)}).build()")
                                .bindType("com.google.errorprone.fixes.SuggestedFix")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_check_api-2"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.errorprone.fixes.SuggestedFix.postfixWith(#{tree:any(com.sun.source.tree.Tree)}, #{postfix:any(java.lang.String)})")
                                    .bindType("com.google.errorprone.fixes.SuggestedFix")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_check_api-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.errorprone.fixes.SuggestedFix", true),
                            new UsesType<>("com.sun.source.tree.Tree", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix builder(..)", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix.Builder build(..)", true),
                            new UsesMethod<>("com.google.errorprone.fixes.SuggestedFix.Builder postfixWith(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
