package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.StreamRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class StreamRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public StreamRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`StreamRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `Stream`s.\n[Source](https://error-prone.picnic.tech/refasterrules/StreamRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new JoiningRecipe(),
                new StreamOfNullableRecipe(),
                new ConcatOneStreamRecipe(),
                new ConcatTwoStreamsRecipe(),
                new StreamFilterSortedRecipe(),
                new StreamFilterSortedWithComparatorRecipe(),
                new StreamMapFirstRecipe(),
                new StreamFindAnyIsEmptyRecipe(),
                new StreamFindAnyIsPresentRecipe(),
                new StreamMapFilterRecipe(),
                new StreamMinRecipe(),
                new StreamMinNaturalOrderRecipe(),
                new StreamMaxRecipe(),
                new StreamMaxNaturalOrderRecipe(),
                new StreamMapToIntSummaryStatisticsRecipe(),
                new StreamMapToDoubleSummaryStatisticsRecipe(),
                new StreamMapToLongSummaryStatisticsRecipe(),
                new StreamCountRecipe(),
                new StreamReduceRecipe(),
                new StreamReduceWithIdentityRecipe(),
                new StreamFilterCollectRecipe(),
                new StreamMapCollectRecipe(),
                new StreamFlatMapCollectRecipe(),
                new StreamTakeWhileRecipe(),
                new StreamIterateRecipe(),
                new StreamOf1Recipe(),
                new StreamOf2Recipe(),
                new StreamOf3Recipe(),
                new StreamOf4Recipe(),
                new StreamOf5Recipe(),
                new StreamsStreamRecipe(),
                new CollectionParallelStreamRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.Joining}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class JoiningRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public JoiningRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.Joining`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Collectors#joining()` over `Collectors#joining(CharSequence)` with an empty delimiter string.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.stream.Collectors.joining(\"\")")
                                .bindType("java.util.stream.Collector<java.lang.CharSequence, ?, java.lang.String>").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.Collectors.joining()")
                                    .bindType("java.util.stream.Collector<java.lang.CharSequence, ?, java.lang.String>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesMethod<>("java.util.stream.Collectors joining(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamOfNullable}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamOfNullableRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamOfNullableRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamOfNullable`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Stream#ofNullable(Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.util.stream.Stream.of(#{object:any(T)}).filter(java.util.Objects::nonNull)")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Objects");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.Stream.ofNullable(#{object:any(T)})")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Optional.ofNullable(#{object:any(T)}).stream()")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Optional");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.Stream.ofNullable(#{object:any(T)})")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Stream", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("java.util.Objects", true),
                                            new UsesMethod<>("java.util.stream.Stream filter(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream of(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Optional", true),
                                            new UsesMethod<>("java.util.Optional ofNullable(..)", true),
                                            new UsesMethod<>("java.util.Optional stream(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.ConcatOneStream}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ConcatOneStreamRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ConcatOneStreamRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.ConcatOneStream`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily call `Streams#concat(Stream...)`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.Streams.concat(#{stream:any(java.util.stream.Stream<T>)})")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Streams", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.Streams concat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.ConcatTwoStreams}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ConcatTwoStreamsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ConcatTwoStreamsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.ConcatTwoStreams`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Stream#concat(Stream, Stream)` over the Guava alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.Streams.concat(#{s1:any(java.util.stream.Stream<T>)}, #{s2:any(java.util.stream.Stream<T>)})")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.Stream.concat(#{s1:any(java.util.stream.Stream<T>)}, #{s2:any(java.util.stream.Stream<T>)})")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Streams", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.Streams concat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamFilterSorted}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamFilterSortedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamFilterSortedRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamFilterSorted`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Apply `Stream#filter(Predicate)` before `Stream#sorted()` to reduce the number of elements to sort.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.sorted().filter(#{predicate:any(java.util.function.Predicate<? super T>)})")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)}).sorted()")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream filter(..)", true),
                            new UsesMethod<>("java.util.stream.Stream sorted(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamFilterSortedWithComparator}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamFilterSortedWithComparatorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamFilterSortedWithComparatorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamFilterSortedWithComparator`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Apply `Stream#filter(Predicate)` before `Stream#sorted(Comparator)` to reduce the number of elements to sort.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.sorted(#{comparator:any(java.util.Comparator<? super T>)}).filter(#{predicate:any(java.util.function.Predicate<? super T>)})")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)}).sorted(#{comparator:any(java.util.Comparator<? super T>)})")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream filter(..)", true),
                            new UsesMethod<>("java.util.stream.Stream sorted(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamMapFirst}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamMapFirstRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamMapFirstRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamMapFirst`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Where possible, clarify that a mapping operation will be applied only to a single stream element.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.map(#{function:any(java.util.function.Function<? super T, S>)}).findFirst()")
                                .bindType("java.util.Optional<S>")
                                .genericTypes("T", "S").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findFirst().map(#{function:any(java.util.function.Function<? super T, S>)})")
                                    .bindType("java.util.Optional<S>")
                                    .genericTypes("T", "S").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("java.util.function.Function", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream findFirst(..)", true),
                            new UsesMethod<>("java.util.stream.Stream map(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamFindAnyIsEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamFindAnyIsEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamFindAnyIsEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamFindAnyIsEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "In order to test whether a stream has any element, simply try to find one.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate before$5;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.count() == 0")
                                .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findAny().isEmpty()")
                                    .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.count() <= 0")
                                .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findAny().isEmpty()")
                                    .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.count() < 1")
                                .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findAny().isEmpty()")
                                    .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findFirst().isEmpty()")
                                .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findAny().isEmpty()")
                                    .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$4 == null) {
                        before$4 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(#{collector:any(java.util.stream.Collector<? super T, ?, ? extends C>)}).isEmpty()")
                                .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                    }
                    if ((matcher = before$4.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findAny().isEmpty()")
                                    .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$5 == null) {
                        before$5 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.collectingAndThen(#{collector:any(java.util.stream.Collector<? super T, ?, ? extends C>)}, C::isEmpty))")
                                .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                    }
                    if ((matcher = before$5.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.stream.Collectors.collectingAndThen");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findAny().isEmpty()")
                                    .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.count() == 0")
                                .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findAny().isEmpty()")
                                    .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.count() <= 0")
                                .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findAny().isEmpty()")
                                    .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.count() < 1")
                                .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findAny().isEmpty()")
                                    .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findFirst().isEmpty()")
                                .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findAny().isEmpty()")
                                    .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$4 == null) {
                        before$4 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(#{collector:any(java.util.stream.Collector<? super T, ?, ? extends C>)}).isEmpty()")
                                .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                    }
                    if ((matcher = before$4.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findAny().isEmpty()")
                                    .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$5 == null) {
                        before$5 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.collectingAndThen(#{collector:any(java.util.stream.Collector<? super T, ?, ? extends C>)}, C::isEmpty))")
                                .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                    }
                    if ((matcher = before$5.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.stream.Collectors.collectingAndThen");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findAny().isEmpty()")
                                    .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.collectingAndThen(#{collector:any(java.util.stream.Collector<? super T, ?, ? extends M>)}, M::isEmpty))")
                                .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.stream.Collectors.collectingAndThen");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findAny().isEmpty()")
                                    .genericTypes("T", "K", "V", "C extends java.util.Collection<K>", "M extends java.util.Map<K, V>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.stream.Stream count(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Collection isEmpty(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Optional isEmpty(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream findFirst(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.stream.Collectors collectingAndThen(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamFindAnyIsPresent}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamFindAnyIsPresentRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamFindAnyIsPresentRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamFindAnyIsPresent`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Stream#findAny()` over `Stream#findFirst()` if one only cares whether the stream is nonempty.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findFirst().isPresent()")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.findAny().isPresent()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.Optional isPresent(..)", true),
                            new UsesMethod<>("java.util.stream.Stream findFirst(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamMapFilter}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamMapFilterRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamMapFilterRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamMapFilter`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer an unconditional `Map#get(Object)` call followed by a `null` check over a call to `Map#containsKey(Object)`, as the former avoids a second lookup operation.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.filter(#{map:any(java.util.Map<K, V>)}::containsKey).map(#{map}::get)")
                                .bindType("java.util.stream.Stream<V>")
                                .genericTypes("T", "K", "V").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.map(#{map:any(java.util.Map<K, V>)}::get).filter(java.util.Objects::nonNull)")
                                    .bindType("java.util.stream.Stream<V>")
                                    .genericTypes("T", "K", "V").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream filter(..)", true),
                            new UsesMethod<>("java.util.stream.Stream map(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamMin}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamMinRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamMinRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamMin`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamMin<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4266\")\n    Optional<T> before(Stream<T> stream, Comparator<? super T> comparator) {\n        return Refaster.anyOf(stream.max(comparator.reversed()), stream.sorted(comparator).findFirst(), stream.collect(minBy(comparator)));\n    }\n    \n    @AfterTemplate\n    Optional<T> after(Stream<T> stream, Comparator<? super T> comparator) {\n        return stream.min(comparator);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4266");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.max(#{comparator:any(java.util.Comparator<? super T>)}.reversed())")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.min(#{comparator:any(java.util.Comparator<? super T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.sorted(#{comparator:any(java.util.Comparator<? super T>)}).findFirst()")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.min(#{comparator:any(java.util.Comparator<? super T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.minBy(#{comparator:any(java.util.Comparator<? super T>)}))")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.stream.Collectors.minBy");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.min(#{comparator:any(java.util.Comparator<? super T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Comparator reversed(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream max(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.stream.Collectors minBy(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.stream.Stream findFirst(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream sorted(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamMinNaturalOrder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamMinNaturalOrderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamMinNaturalOrderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamMinNaturalOrder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamMinNaturalOrder<T extends Comparable<? super T>> {\n    \n    @BeforeTemplate\n    Optional<T> before(Stream<T> stream) {\n        return Refaster.anyOf(stream.max(reverseOrder()), stream.sorted().findFirst());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    Optional<T> after(Stream<T> stream) {\n        return stream.min(naturalOrder());\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.max(java.util.Comparator.reverseOrder())")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.reverseOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.min(java.util.Comparator.naturalOrder())")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.sorted().findFirst()")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.min(java.util.Comparator.naturalOrder())")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Comparator reverseOrder(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream max(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.stream.Stream findFirst(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream sorted(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamMax}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamMaxRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamMaxRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamMax`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamMax<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4266\")\n    Optional<T> before(Stream<T> stream, Comparator<? super T> comparator) {\n        return Refaster.anyOf(stream.min(comparator.reversed()), Streams.findLast(stream.sorted(comparator)), stream.collect(maxBy(comparator)));\n    }\n    \n    @AfterTemplate\n    Optional<T> after(Stream<T> stream, Comparator<? super T> comparator) {\n        return stream.max(comparator);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4266");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.min(#{comparator:any(java.util.Comparator<? super T>)}.reversed())")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.max(#{comparator:any(java.util.Comparator<? super T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.Streams.findLast(#{stream:any(java.util.stream.Stream<T>)}.sorted(#{comparator:any(java.util.Comparator<? super T>)}))")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.max(#{comparator:any(java.util.Comparator<? super T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.maxBy(#{comparator:any(java.util.Comparator<? super T>)}))")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.stream.Collectors.maxBy");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.max(#{comparator:any(java.util.Comparator<? super T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Comparator reversed(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream min(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.stream.Collectors maxBy(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Streams", true),
                                            new UsesMethod<>("com.google.common.collect.Streams findLast(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream sorted(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamMaxNaturalOrder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamMaxNaturalOrderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamMaxNaturalOrderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamMaxNaturalOrder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamMaxNaturalOrder<T extends Comparable<? super T>> {\n    \n    @BeforeTemplate\n    Optional<T> before(Stream<T> stream) {\n        return Refaster.anyOf(stream.min(reverseOrder()), Streams.findLast(stream.sorted()));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    Optional<T> after(Stream<T> stream) {\n        return stream.max(naturalOrder());\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.min(java.util.Comparator.reverseOrder())")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.reverseOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.max(java.util.Comparator.naturalOrder())")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.Streams.findLast(#{stream:any(java.util.stream.Stream<T>)}.sorted())")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.max(java.util.Comparator.naturalOrder())")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Comparator reverseOrder(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream min(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Streams", true),
                                            new UsesMethod<>("com.google.common.collect.Streams findLast(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream sorted(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamMapToIntSummaryStatistics}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamMapToIntSummaryStatisticsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamMapToIntSummaryStatisticsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamMapToIntSummaryStatistics`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamMapToIntSummaryStatistics<T> {\n    \n    @BeforeTemplate\n    IntSummaryStatistics before(Stream<T> stream, ToIntFunction<T> mapper) {\n        return stream.collect(summarizingInt(mapper));\n    }\n    \n    @AfterTemplate\n    IntSummaryStatistics after(Stream<T> stream, ToIntFunction<T> mapper) {\n        return stream.mapToInt(mapper).summaryStatistics();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.summarizingInt(#{mapper:any(java.util.function.ToIntFunction<T>)}))")
                                .bindType("java.util.IntSummaryStatistics")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.stream.Collectors.summarizingInt");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.mapToInt(#{mapper:any(java.util.function.ToIntFunction<T>)}).summaryStatistics()")
                                    .bindType("java.util.IntSummaryStatistics")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.IntSummaryStatistics", true),
                            new UsesType<>("java.util.function.ToIntFunction", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Collectors summarizingInt(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamMapToDoubleSummaryStatistics}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamMapToDoubleSummaryStatisticsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamMapToDoubleSummaryStatisticsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamMapToDoubleSummaryStatistics`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamMapToDoubleSummaryStatistics<T> {\n    \n    @BeforeTemplate\n    DoubleSummaryStatistics before(Stream<T> stream, ToDoubleFunction<T> mapper) {\n        return stream.collect(summarizingDouble(mapper));\n    }\n    \n    @AfterTemplate\n    DoubleSummaryStatistics after(Stream<T> stream, ToDoubleFunction<T> mapper) {\n        return stream.mapToDouble(mapper).summaryStatistics();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.summarizingDouble(#{mapper:any(java.util.function.ToDoubleFunction<T>)}))")
                                .bindType("java.util.DoubleSummaryStatistics")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.stream.Collectors.summarizingDouble");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.mapToDouble(#{mapper:any(java.util.function.ToDoubleFunction<T>)}).summaryStatistics()")
                                    .bindType("java.util.DoubleSummaryStatistics")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.DoubleSummaryStatistics", true),
                            new UsesType<>("java.util.function.ToDoubleFunction", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Collectors summarizingDouble(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamMapToLongSummaryStatistics}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamMapToLongSummaryStatisticsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamMapToLongSummaryStatisticsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamMapToLongSummaryStatistics`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamMapToLongSummaryStatistics<T> {\n    \n    @BeforeTemplate\n    LongSummaryStatistics before(Stream<T> stream, ToLongFunction<T> mapper) {\n        return stream.collect(summarizingLong(mapper));\n    }\n    \n    @AfterTemplate\n    LongSummaryStatistics after(Stream<T> stream, ToLongFunction<T> mapper) {\n        return stream.mapToLong(mapper).summaryStatistics();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.summarizingLong(#{mapper:any(java.util.function.ToLongFunction<T>)}))")
                                .bindType("java.util.LongSummaryStatistics")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.stream.Collectors.summarizingLong");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.mapToLong(#{mapper:any(java.util.function.ToLongFunction<T>)}).summaryStatistics()")
                                    .bindType("java.util.LongSummaryStatistics")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.LongSummaryStatistics", true),
                            new UsesType<>("java.util.function.ToLongFunction", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Collectors summarizingLong(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamCount}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamCountRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamCountRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamCount`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamCount<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4266\")\n    long before(Stream<T> stream) {\n        return stream.collect(counting());\n    }\n    \n    @AfterTemplate\n    long after(Stream<T> stream) {\n        return stream.count();\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4266");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.counting())")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.stream.Collectors.counting");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.count()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Collectors counting(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamReduce}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamReduceRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamReduceRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamReduce`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamReduce<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4266\")\n    Optional<T> before(Stream<T> stream, BinaryOperator<T> accumulator) {\n        return stream.collect(reducing(accumulator));\n    }\n    \n    @AfterTemplate\n    Optional<T> after(Stream<T> stream, BinaryOperator<T> accumulator) {\n        return stream.reduce(accumulator);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4266");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.reducing(#{accumulator:any(java.util.function.BinaryOperator<T>)}))")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.stream.Collectors.reducing");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.reduce(#{accumulator:any(java.util.function.BinaryOperator<T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("java.util.function.BinaryOperator", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Collectors reducing(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamReduceWithIdentity}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamReduceWithIdentityRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamReduceWithIdentityRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamReduceWithIdentity`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamReduceWithIdentity<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4266\")\n    T before(Stream<T> stream, T identity, BinaryOperator<T> accumulator) {\n        return stream.collect(reducing(identity, accumulator));\n    }\n    \n    @AfterTemplate\n    T after(Stream<T> stream, T identity, BinaryOperator<T> accumulator) {\n        return stream.reduce(identity, accumulator);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4266");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.reducing(#{identity:any(T)}, #{accumulator:any(java.util.function.BinaryOperator<T>)}))")
                                .bindType("T")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.stream.Collectors.reducing");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.reduce(#{identity:any(T)}, #{accumulator:any(java.util.function.BinaryOperator<T>)})")
                                    .bindType("T")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.BinaryOperator", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Collectors reducing(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamFilterCollect}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamFilterCollectRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamFilterCollectRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamFilterCollect`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamFilterCollect<T, R> {\n    \n    @BeforeTemplate\n    R before(Stream<T> stream, Predicate<? super T> predicate, Collector<? super T, ?, R> collector) {\n        return stream.collect(filtering(predicate, collector));\n    }\n    \n    @AfterTemplate\n    R after(Stream<T> stream, Predicate<? super T> predicate, Collector<? super T, ?, R> collector) {\n        return stream.filter(predicate).collect(collector);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.filtering(#{predicate:any(java.util.function.Predicate<? super T>)}, #{collector:any(java.util.stream.Collector<? super T, ?, R>)}))")
                                .bindType("R")
                                .genericTypes("T", "R").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.stream.Collectors.filtering");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)}).collect(#{collector:any(java.util.stream.Collector<? super T, ?, R>)})")
                                    .bindType("R")
                                    .genericTypes("T", "R").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Collectors filtering(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamMapCollect}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamMapCollectRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamMapCollectRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamMapCollect`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamMapCollect<T, U, R> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4266\")\n    R before(Stream<T> stream, Function<? super T, ? extends U> mapper, Collector<? super U, ?, R> collector) {\n        return stream.collect(mapping(mapper, collector));\n    }\n    \n    @AfterTemplate\n    R after(Stream<T> stream, Function<? super T, ? extends U> mapper, Collector<? super U, ?, R> collector) {\n        return stream.map(mapper).collect(collector);\n    }\n}\n```\n.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4266");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.mapping(#{mapper:any(java.util.function.Function<? super T, ? extends U>)}, #{collector:any(java.util.stream.Collector<? super U, ?, R>)}))")
                                .bindType("R")
                                .genericTypes("T", "U", "R").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.stream.Collectors.mapping");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.map(#{mapper:any(java.util.function.Function<? super T, ? extends U>)}).collect(#{collector:any(java.util.stream.Collector<? super U, ?, R>)})")
                                    .bindType("R")
                                    .genericTypes("T", "U", "R").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Function", true),
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Collectors mapping(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamFlatMapCollect}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamFlatMapCollectRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamFlatMapCollectRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamFlatMapCollect`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamFlatMapCollect<T, U, R> {\n    \n    @BeforeTemplate\n    R before(Stream<T> stream, Function<? super T, ? extends Stream<? extends U>> mapper, Collector<? super U, ?, R> collector) {\n        return stream.collect(flatMapping(mapper, collector));\n    }\n    \n    @AfterTemplate\n    R after(Stream<T> stream, Function<? super T, ? extends Stream<? extends U>> mapper, Collector<? super U, ?, R> collector) {\n        return stream.flatMap(mapper).collect(collector);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(java.util.stream.Collectors.flatMapping(#{mapper:any(java.util.function.Function<? super T, ? extends java.util.stream.Stream<? extends U>>)}, #{collector:any(java.util.stream.Collector<? super U, ?, R>)}))")
                                .bindType("R")
                                .genericTypes("T", "U", "R").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.stream.Collectors.flatMapping");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.flatMap(#{mapper:any(java.util.function.Function<? super T, ? extends java.util.stream.Stream<? extends U>>)}).collect(#{collector:any(java.util.stream.Collector<? super U, ?, R>)})")
                                    .bindType("R")
                                    .genericTypes("T", "U", "R").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Function", true),
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Collectors flatMapping(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamTakeWhile}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamTakeWhileRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamTakeWhileRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamTakeWhile`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StreamTakeWhile<T> {\n    \n    @BeforeTemplate\n    Stream<T> before(Stream<T> stream, Predicate<? super T> predicate) {\n        return stream.takeWhile(predicate).filter(predicate);\n    }\n    \n    @AfterTemplate\n    Stream<T> after(Stream<T> stream, Predicate<? super T> predicate) {\n        return stream.takeWhile(predicate);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.takeWhile(#{predicate:any(java.util.function.Predicate<? super T>)}).filter(#{predicate})")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.takeWhile(#{predicate:any(java.util.function.Predicate<? super T>)})")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream filter(..)", true),
                            new UsesMethod<>("java.util.stream.Stream takeWhile(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamIterate}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamIterateRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamIterateRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamIterate`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Stream#iterate(Object, Predicate, UnaryOperator)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.stream.Stream.iterate(#{seed:any(T)}, #{next:any(java.util.function.UnaryOperator<T>)}).takeWhile(#{hasNext:any(java.util.function.Predicate<? super T>)})")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.Stream.iterate(#{seed:any(T)}, #{hasNext:any(java.util.function.Predicate<? super T>)}, #{next:any(java.util.function.UnaryOperator<T>)})")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesType<>("java.util.function.UnaryOperator", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.stream.Stream iterate(..)", true),
                            new UsesMethod<>("java.util.stream.Stream takeWhile(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamOf1}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamOf1Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamOf1Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamOf1`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Stream#of(Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableList.of(#{e1:any(T)}).stream()")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.Stream.of(#{e1:any(T)})")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableList", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableList of(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamOf2}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamOf2Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamOf2Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamOf2`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Stream#of(Object[])` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableList.of(#{e1:any(T)}, #{e2:any(T)}).stream()")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.Stream.of(#{e1:any(T)}, #{e2:any(T)})")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableList", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableList of(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamOf3}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamOf3Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamOf3Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamOf3`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Stream#of(Object[])` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableList.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}).stream()")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.Stream.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)})")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableList", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableList of(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamOf4}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamOf4Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamOf4Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamOf4`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Stream#of(Object[])` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableList.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}).stream()")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.Stream.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)})")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableList", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableList of(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamOf5}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamOf5Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamOf5Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamOf5`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Stream#of(Object[])` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableList.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}, #{e5:any(T)}).stream()")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.Stream.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}, #{e5:any(T)})")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableList", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableList of(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.StreamsStream}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamsStreamRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamsStreamRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.StreamsStream`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Streams#stream(Iterable)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.stream.StreamSupport.stream(#{iterable:any(java.lang.Iterable<T>)}.spliterator(), false)")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.StreamSupport");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesType<>("java.util.stream.StreamSupport", true),
                            new UsesMethod<>("java.lang.Iterable spliterator(..)", true),
                            new UsesMethod<>("java.util.stream.StreamSupport stream(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code StreamRules.CollectionParallelStream}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CollectionParallelStreamRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CollectionParallelStreamRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `StreamRules.CollectionParallelStream`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Collection#parallelStream()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.stream.StreamSupport.stream(#{collection:any(java.util.Collection<T>)}.spliterator(), true)")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.StreamSupport");
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.parallelStream()")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Collection", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesType<>("java.util.stream.StreamSupport", true),
                            new UsesMethod<>("java.util.Collection spliterator(..)", true),
                            new UsesMethod<>("java.util.stream.StreamSupport stream(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
