package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.ReactorRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class ReactorRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public ReactorRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`ReactorRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to Reactor expressions and statements.\n[Source](https://error-prone.picnic.tech/refasterrules/ReactorRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new MonoEmptyRecipe(),
                new MonoTimeoutDurationMonoEmptyRecipe(),
                new MonoTimeoutDurationMonoJustRecipe(),
                new MonoTimeoutDurationRecipe(),
                new MonoTimeoutPublisherMonoEmptyRecipe(),
                new MonoTimeoutPublisherMonoJustRecipe(),
                new MonoTimeoutPublisherRecipe(),
                new MonoJustRecipe(),
                new MonoJustOrEmptyObjectRecipe(),
                new MonoJustOrEmptyOptionalRecipe(),
                new MonoDeferMonoJustOrEmptyRecipe(),
                new OptionalMapMonoJustRecipe(),
                new MonoFromOptionalSwitchIfEmptyRecipe(),
                new MonoZipRecipe(),
                new MonoZipWithCombinatorRecipe(),
                new FluxZipRecipe(),
                new FluxZipWithCombinatorRecipe(),
                new FluxZipWithIterableRecipe(),
                new FluxZipWithIterableBiFunctionRecipe(),
                new FluxZipWithIterableMapFunctionRecipe(),
                new MonoDeferredErrorRecipe(),
                new FluxDeferredErrorRecipe(),
                new MonoErrorSupplierRecipe(),
                new FluxErrorSupplierRecipe(),
                new MonoThenReturnRecipe(),
                new FluxTakeRecipe(),
                new MonoDefaultIfEmptyRecipe(),
                new FluxDefaultIfEmptyRecipe(),
                new FluxTimeoutFluxEmptyRecipe(),
                new FluxJustRecipe(),
                new MonoIdentityRecipe(),
                new MonoSingleRecipe(),
                new FluxSwitchIfEmptyOfEmptyPublisherRecipe(),
                new MonoFlatMapIterableIdentityRecipe(),
                new FluxMapNotNullOrElseRecipe(),
                new MonoFluxRecipe(),
                new MonoThenRecipe(),
                new FluxThenRecipe(),
                new MonoThenEmptyRecipe(),
                new FluxThenEmptyRecipe(),
                new MonoThenManyRecipe(),
                new MonoThenMonoFluxRecipe(),
                new FluxThenManyRecipe(),
                new MonoThenMonoRecipe(),
                new FluxThenMonoRecipe(),
                new MonoSingleOptionalRecipe(),
                new MonoOfTypeRecipe(),
                new FluxOfTypeRecipe(),
                new ConcatMapIterableIdentityRecipe(),
                new ConcatMapIterableIdentityWithPrefetchRecipe(),
                new FluxFromIterableRecipe(),
                new MonoDoOnErrorRecipe(),
                new FluxDoOnErrorRecipe(),
                new MonoOnErrorCompleteRecipe(),
                new FluxOnErrorCompleteRecipe(),
                new MonoOnErrorCompleteClassRecipe(),
                new MonoOnErrorCompletePredicateRecipe(),
                new FluxOnErrorCompletePredicateRecipe(),
                new MonoOnErrorContinueRecipe(),
                new FluxOnErrorContinueRecipe(),
                new MonoOnErrorMapRecipe(),
                new FluxOnErrorMapRecipe(),
                new MonoOnErrorResumeRecipe(),
                new FluxOnErrorResumeRecipe(),
                new MonoOnErrorReturnRecipe(),
                new FluxOnErrorReturnRecipe(),
                new FluxFilterSortRecipe(),
                new FluxFilterSortWithComparatorRecipe(),
                new FluxTakeWhileRecipe(),
                new FluxCollectToImmutableListRecipe(),
                new FluxCollectToImmutableSetRecipe(),
                new FluxSortRecipe(),
                new FluxTransformMinRecipe(),
                new FluxTransformMinWithComparatorRecipe(),
                new FluxTransformMaxRecipe(),
                new FluxTransformMaxWithComparatorRecipe(),
                new MathFluxMinRecipe(),
                new MathFluxMaxRecipe(),
                new PublisherProbeEmptyRecipe(),
                new PublisherProbeAssertWasSubscribedRecipe(),
                new PublisherProbeAssertWasNotSubscribedRecipe(),
                new PublisherProbeAssertWasCancelledRecipe(),
                new PublisherProbeAssertWasNotCancelledRecipe(),
                new PublisherProbeAssertWasRequestedRecipe(),
                new PublisherProbeAssertWasNotRequestedRecipe(),
                new StepVerifierFromMonoRecipe(),
                new StepVerifierFromFluxRecipe(),
                new StepVerifierVerifyRecipe(),
                new StepVerifierVerifyDurationRecipe(),
                new StepVerifierVerifyLaterRecipe(),
                new StepVerifierStepExpectNextRecipe(),
                new FluxAsStepVerifierExpectNextRecipe(),
                new StepVerifierLastStepVerifyCompleteRecipe(),
                new StepVerifierLastStepVerifyErrorRecipe(),
                new StepVerifierLastStepVerifyErrorClassRecipe(),
                new StepVerifierLastStepVerifyErrorMatchesRecipe(),
                new StepVerifierLastStepVerifyErrorSatisfiesRecipe(),
                new StepVerifierLastStepVerifyErrorSatisfiesAssertJRecipe(),
                new StepVerifierLastStepVerifyErrorMessageRecipe(),
                new StepVerifierLastStepVerifyTimeoutRecipe(),
                new MonoFromFutureSupplierRecipe(),
                new MonoFromFutureSupplierBooleanRecipe(),
                new MonoFromFutureAsyncLoadingCacheGetRecipe(),
                new MonoFromFutureAsyncLoadingCacheGetAllRecipe(),
                new FluxFromStreamSupplierRecipe(),
                new FluxNextRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#empty()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("reactor.core.publisher.Mono.justOrEmpty(null)")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.empty()")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("reactor.core.publisher.Mono.justOrEmpty(java.util.Optional.empty())")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Optional");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.empty()")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono justOrEmpty(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoTimeoutDurationMonoEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoTimeoutDurationMonoEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoTimeoutDurationMonoEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoTimeoutDurationMonoEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#timeout(Duration, Mono)` over more contrived or less performant alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.timeout(#{duration:any(java.time.Duration)}).onErrorComplete(java.util.concurrent.TimeoutException.class)")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.concurrent.TimeoutException");
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.timeout(#{duration:any(java.time.Duration)}, reactor.core.publisher.Mono.empty())")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("java.util.concurrent.TimeoutException", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono onErrorComplete(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono timeout(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoTimeoutDurationMonoJust}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoTimeoutDurationMonoJustRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoTimeoutDurationMonoJustRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoTimeoutDurationMonoJust`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#timeout(Duration, Mono)` over more contrived or less performant alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.timeout(#{duration:any(java.time.Duration)}).onErrorReturn(java.util.concurrent.TimeoutException.class, #{fallbackValue:any(T)})")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.concurrent.TimeoutException");
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.timeout(#{duration:any(java.time.Duration)}, reactor.core.publisher.Mono.just(#{fallbackValue:any(T)}))")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("java.util.concurrent.TimeoutException", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono onErrorReturn(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono timeout(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoTimeoutDuration}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoTimeoutDurationRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoTimeoutDurationRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoTimeoutDuration`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#timeout(Duration, Mono)` over more contrived or less performant alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.timeout(#{duration:any(java.time.Duration)}).onErrorResume(java.util.concurrent.TimeoutException.class, (e)->#{fallback:any(reactor.core.publisher.Mono<T>)})")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.concurrent.TimeoutException");
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.timeout(#{duration:any(java.time.Duration)}, #{fallback:any(reactor.core.publisher.Mono<T>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("java.util.concurrent.TimeoutException", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono onErrorResume(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono timeout(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoTimeoutPublisherMonoEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoTimeoutPublisherMonoEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoTimeoutPublisherMonoEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoTimeoutPublisherMonoEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#timeout(Publisher, Mono)` over more contrived or less performant alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.timeout(#{other:any(org.reactivestreams.Publisher<S>)}).onErrorComplete(java.util.concurrent.TimeoutException.class)")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.concurrent.TimeoutException");
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.timeout(#{other:any(org.reactivestreams.Publisher<S>)}, reactor.core.publisher.Mono.empty())")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.concurrent.TimeoutException", true),
                            new UsesType<>("org.reactivestreams.Publisher", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono onErrorComplete(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono timeout(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoTimeoutPublisherMonoJust}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoTimeoutPublisherMonoJustRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoTimeoutPublisherMonoJustRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoTimeoutPublisherMonoJust`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#timeout(Publisher, Mono)` over more contrived or less performant alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.timeout(#{other:any(org.reactivestreams.Publisher<S>)}).onErrorReturn(java.util.concurrent.TimeoutException.class, #{fallbackValue:any(T)})")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.concurrent.TimeoutException");
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.timeout(#{other:any(org.reactivestreams.Publisher<S>)}, reactor.core.publisher.Mono.just(#{fallbackValue:any(T)}))")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.concurrent.TimeoutException", true),
                            new UsesType<>("org.reactivestreams.Publisher", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono onErrorReturn(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono timeout(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoTimeoutPublisher}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoTimeoutPublisherRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoTimeoutPublisherRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoTimeoutPublisher`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#timeout(Publisher, Mono)` over more contrived or less performant alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.timeout(#{other:any(org.reactivestreams.Publisher<S>)}).onErrorResume(java.util.concurrent.TimeoutException.class, (e)->#{fallback:any(reactor.core.publisher.Mono<T>)})")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.concurrent.TimeoutException");
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.timeout(#{other:any(org.reactivestreams.Publisher<S>)}, #{fallback:any(reactor.core.publisher.Mono<T>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.concurrent.TimeoutException", true),
                            new UsesType<>("org.reactivestreams.Publisher", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono onErrorResume(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono timeout(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoJust}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoJustRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoJustRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoJust`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#just(Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("reactor.core.publisher.Mono.justOrEmpty(java.util.Optional.of(#{value:any(T)}))")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Optional");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.just(#{value:any(T)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("reactor.core.publisher.Flux.just(#{value:any(T)}).next()")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("reactor.core.publisher.Flux");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.just(#{value:any(T)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("java.util.Optional", true),
                                            new UsesMethod<>("java.util.Optional of(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono justOrEmpty(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("reactor.core.publisher.Flux", true),
                                            new UsesMethod<>("reactor.core.publisher.Flux just(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Flux next(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoJustOrEmptyObject}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoJustOrEmptyObjectRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoJustOrEmptyObjectRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoJustOrEmptyObject`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#justOrEmpty(Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("reactor.core.publisher.Mono.justOrEmpty(java.util.Optional.ofNullable(#{value:any(T)}))")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T extends java.lang.Object")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Optional");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.justOrEmpty(#{value:any(T)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T extends java.lang.Object")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("java.util.Optional ofNullable(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono justOrEmpty(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoJustOrEmptyOptional}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoJustOrEmptyOptionalRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoJustOrEmptyOptionalRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoJustOrEmptyOptional`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#justOrEmpty(Optional)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("reactor.core.publisher.Mono.just(#{optional:any(java.util.Optional<T>)}).filter(java.util.Optional::isPresent).map(java.util.Optional::orElseThrow)")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.justOrEmpty(#{optional:any(java.util.Optional<T>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono filter(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono just(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono map(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoDeferMonoJustOrEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoDeferMonoJustOrEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoDeferMonoJustOrEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoDeferMonoJustOrEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#defer(Supplier) deferring` `Mono#justOrEmpty(Optional)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("reactor.core.publisher.Mono.fromCallable(()->#{optional:any(java.util.Optional<T>)}.orElse(null))")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.defer(()->reactor.core.publisher.Mono.justOrEmpty(#{optional:any(java.util.Optional<T>)}))")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("reactor.core.publisher.Mono.fromSupplier(()->#{optional:any(java.util.Optional<T>)}.orElse(null))")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.defer(()->reactor.core.publisher.Mono.justOrEmpty(#{optional:any(java.util.Optional<T>)}))")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("java.util.Optional orElse(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("reactor.core.publisher.Mono fromCallable(..)", true),
                                    new UsesMethod<>("reactor.core.publisher.Mono fromSupplier(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.OptionalMapMonoJust}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OptionalMapMonoJustRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OptionalMapMonoJustRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.OptionalMapMonoJust`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Try to avoid expressions of type `Optional<Mono<T>>`, but if you must map an `Optional` to this type, prefer using `Mono#just(Object)`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.map(reactor.core.publisher.Mono::justOrEmpty)")
                                .bindType("java.util.Optional<reactor.core.publisher.Mono<T>>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.map(reactor.core.publisher.Mono::just)")
                                    .bindType("java.util.Optional<reactor.core.publisher.Mono<T>>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("java.util.Optional map(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoFromOptionalSwitchIfEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoFromOptionalSwitchIfEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoFromOptionalSwitchIfEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Prefer a `Mono#justOrEmpty(Optional)` and `Mono#switchIfEmpty(Mono)` chain over more contrived alternatives";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "In particular, avoid mixing of the `Optional` and `Mono` APIs.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.map(reactor.core.publisher.Mono::just).orElse(#{mono:any(reactor.core.publisher.Mono<T>)})")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.justOrEmpty(#{optional:any(java.util.Optional<T>)}).switchIfEmpty(#{mono:any(reactor.core.publisher.Mono<T>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("java.util.Optional map(..)", true),
                            new UsesMethod<>("java.util.Optional orElse(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoZip}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoZipRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoZipRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoZip`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#zip(Mono, Mono)` over a chained `Mono#zipWith(Mono)`, as the former better conveys that the `Mono`s may be subscribed to concurrently, and generalizes to combining three or more reactive streams.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.zipWith(#{other:any(reactor.core.publisher.Mono<S>)})")
                                .bindType("reactor.core.publisher.Mono<reactor.util.function.Tuple2<T, S>>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.zip(#{mono:any(reactor.core.publisher.Mono<T>)}, #{other:any(reactor.core.publisher.Mono<S>)})")
                                    .bindType("reactor.core.publisher.Mono<reactor.util.function.Tuple2<T, S>>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesType<>("reactor.util.function.Tuple2", true),
                            new UsesMethod<>("reactor.core.publisher.Mono zipWith(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoZipWithCombinator}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoZipWithCombinatorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoZipWithCombinatorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoZipWithCombinator`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#zip(Mono, Mono)` with a chained combinator over a chained `Mono#zipWith(Mono, BiFunction)`, as the former better conveys that the `Mono`s may be subscribed to concurrently, and generalizes to combining three or more reactive streams.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.zipWith(#{other:any(reactor.core.publisher.Mono<S>)}, #{combinator:any(java.util.function.BiFunction<T, S, R>)})")
                                .bindType("reactor.core.publisher.Mono<R>")
                                .genericTypes("T", "S", "R")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.zip(#{mono:any(reactor.core.publisher.Mono<T>)}, #{other:any(reactor.core.publisher.Mono<S>)}).map(reactor.function.TupleUtils.function(#{combinator:any(java.util.function.BiFunction<T, S, R>)}))")
                                    .bindType("reactor.core.publisher.Mono<R>")
                                    .genericTypes("T", "S", "R")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-extra-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.BiFunction", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono zipWith(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxZip}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxZipRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxZipRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxZip`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#zip(Publisher, Publisher)` over a chained `Flux#zipWith(Publisher)`, as the former better conveys that the `Publisher`s may be subscribed to concurrently, and generalizes to combining three or more reactive streams.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.zipWith(#{other:any(org.reactivestreams.Publisher<S>)})")
                                .bindType("reactor.core.publisher.Flux<reactor.util.function.Tuple2<T, S>>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Flux.zip(#{flux:any(reactor.core.publisher.Flux<T>)}, #{other:any(org.reactivestreams.Publisher<S>)})")
                                    .bindType("reactor.core.publisher.Flux<reactor.util.function.Tuple2<T, S>>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.reactivestreams.Publisher", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.util.function.Tuple2", true),
                            new UsesMethod<>("reactor.core.publisher.Flux zipWith(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxZipWithCombinator}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxZipWithCombinatorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxZipWithCombinatorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxZipWithCombinator`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#zip(Publisher, Publisher)` with a chained combinator over a chained `Flux#zipWith(Publisher, BiFunction)`, as the former better conveys that the `Publisher`s may be subscribed to concurrently, and generalizes to combining three or more reactive streams.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.zipWith(#{other:any(org.reactivestreams.Publisher<S>)}, #{combinator:any(java.util.function.BiFunction<T, S, R>)})")
                                .bindType("reactor.core.publisher.Flux<R>")
                                .genericTypes("T", "S", "R")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Flux.zip(#{flux:any(reactor.core.publisher.Flux<T>)}, #{other:any(org.reactivestreams.Publisher<S>)}).map(reactor.function.TupleUtils.function(#{combinator:any(java.util.function.BiFunction<T, S, R>)}))")
                                    .bindType("reactor.core.publisher.Flux<R>")
                                    .genericTypes("T", "S", "R")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-extra-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.BiFunction", true),
                            new UsesType<>("org.reactivestreams.Publisher", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux zipWith(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxZipWithIterable}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxZipWithIterableRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxZipWithIterableRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxZipWithIterable`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#zipWithIterable(Iterable)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("reactor.core.publisher.Flux.zip(#{flux:any(reactor.core.publisher.Flux<T>)}, reactor.core.publisher.Flux.fromIterable(#{iterable:any(java.lang.Iterable<S>)}))")
                                .bindType("reactor.core.publisher.Flux<reactor.util.function.Tuple2<T, S>>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.zipWithIterable(#{iterable:any(java.lang.Iterable<S>)})")
                                    .bindType("reactor.core.publisher.Flux<reactor.util.function.Tuple2<T, S>>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.util.function.Tuple2", true),
                            new UsesMethod<>("reactor.core.publisher.Flux fromIterable(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Flux zip(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxZipWithIterableBiFunction}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxZipWithIterableBiFunctionRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxZipWithIterableBiFunctionRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxZipWithIterableBiFunction`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#zipWithIterable(Iterable, BiFunction)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.zipWith(reactor.core.publisher.Flux.fromIterable(#{iterable:any(java.lang.Iterable<S>)}), #{function:any(java.util.function.BiFunction<? super T, ? super S, ? extends R>)})")
                                .bindType("reactor.core.publisher.Flux<R>")
                                .genericTypes("T", "S", "R")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.zipWithIterable(#{iterable:any(java.lang.Iterable<S>)}, #{function:any(java.util.function.BiFunction<? super T, ? super S, ? extends R>)})")
                                    .bindType("reactor.core.publisher.Flux<R>")
                                    .genericTypes("T", "S", "R")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.BiFunction", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux fromIterable(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Flux zipWith(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxZipWithIterableMapFunction}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxZipWithIterableMapFunctionRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxZipWithIterableMapFunctionRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxZipWithIterableMapFunction`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#zipWithIterable(Iterable)` with a chained combinator over `Flux#zipWithIterable(Iterable, BiFunction)`, as the former generally yields more readable code.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.zipWithIterable(#{iterable:any(java.lang.Iterable<S>)}, #{combinator:any(java.util.function.BiFunction<T, S, R>)})")
                                .bindType("reactor.core.publisher.Flux<R>")
                                .genericTypes("T", "S", "R")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.zipWithIterable(#{iterable:any(java.lang.Iterable<S>)}).map(reactor.function.TupleUtils.function(#{combinator:any(java.util.function.BiFunction<T, S, R>)}))")
                                    .bindType("reactor.core.publisher.Flux<R>")
                                    .genericTypes("T", "S", "R")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-extra-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.BiFunction", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux zipWithIterable(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoDeferredError}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoDeferredErrorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoDeferredErrorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoDeferredError`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily defer `Mono#error(Throwable)`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("reactor.core.publisher.Mono.defer(()->reactor.core.publisher.Mono.error(#{throwable:any(java.lang.Throwable)}))")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.error(()->#{throwable:any(java.lang.Throwable)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono defer(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono error(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxDeferredError}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxDeferredErrorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxDeferredErrorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxDeferredError`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily defer `Flux#error(Throwable)`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("reactor.core.publisher.Flux.defer(()->reactor.core.publisher.Flux.error(#{throwable:any(java.lang.Throwable)}))")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Flux.error(()->#{throwable:any(java.lang.Throwable)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux defer(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Flux error(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoErrorSupplier}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoErrorSupplierRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoErrorSupplierRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoErrorSupplier`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily pass `Mono#error(Supplier)` a method reference or lambda expression.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("reactor.core.publisher.Mono.error(()->#{supplier:any(java.util.function.Supplier<E>)}.get())")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T", "E extends java.lang.Throwable")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.error(#{supplier:any(java.util.function.Supplier<E>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T", "E extends java.lang.Throwable")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("java.util.function.Supplier get(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono error(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxErrorSupplier}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxErrorSupplierRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxErrorSupplierRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxErrorSupplier`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily pass `Flux#error(Supplier)` a method reference or lambda expression.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("reactor.core.publisher.Flux.error(()->#{supplier:any(java.util.function.Supplier<E>)}.get())")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T", "E extends java.lang.Throwable")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Flux.error(#{supplier:any(java.util.function.Supplier<E>)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T", "E extends java.lang.Throwable")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("java.util.function.Supplier get(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Flux error(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoThenReturn}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoThenReturnRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoThenReturnRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoThenReturn`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#thenReturn(Object)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.ignoreElement().thenReturn(#{object:any(S)})")
                                .bindType("reactor.core.publisher.Mono<S>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.thenReturn(#{object:any(S)})")
                                    .bindType("reactor.core.publisher.Mono<S>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.then().thenReturn(#{object:any(S)})")
                                .bindType("reactor.core.publisher.Mono<S>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.thenReturn(#{object:any(S)})")
                                    .bindType("reactor.core.publisher.Mono<S>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.then(reactor.core.publisher.Mono.just(#{object:any(S)}))")
                                .bindType("reactor.core.publisher.Mono<S>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.thenReturn(#{object:any(S)})")
                                    .bindType("reactor.core.publisher.Mono<S>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Mono ignoreElement(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono thenReturn(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Mono just(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono then(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Mono then(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono thenReturn(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxTake}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxTakeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxTakeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Prefer `Flux#take(long)` over `Flux#take(long, boolean)` where relevant";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "In Reactor versions prior to 3.5.0, `Flux#take(long)` makes an unbounded request\n upstream, and is equivalent to `Flux#take(long, false)`. From version 3.5.0 onwards, the\n behavior of `Flux#take(long)` instead matches `Flux#take(long, true)`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.take(#{n:any(long)}, true)")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.take(#{n:any(long)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux take(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoDefaultIfEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoDefaultIfEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoDefaultIfEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoDefaultIfEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#defaultIfEmpty(Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.switchIfEmpty(reactor.core.publisher.Mono.just(#{object:any(T)}))")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.defaultIfEmpty(#{object:any(T)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono just(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono switchIfEmpty(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxDefaultIfEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxDefaultIfEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxDefaultIfEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxDefaultIfEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#defaultIfEmpty(Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.switchIfEmpty(reactor.core.publisher.Mono.just(#{object:any(T)}))")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("reactor.core.publisher.Mono");
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.defaultIfEmpty(#{object:any(T)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.switchIfEmpty(reactor.core.publisher.Flux.just(#{object:any(T)}))")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.defaultIfEmpty(#{object:any(T)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux switchIfEmpty(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("reactor.core.publisher.Flux just(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("reactor.core.publisher.Mono", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono just(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxTimeoutFluxEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxTimeoutFluxEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxTimeoutFluxEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxTimeoutFluxEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#timeout(Duration, Publisher)` over more contrived or less performant alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.timeout(#{duration:any(java.time.Duration)}).onErrorComplete(java.util.concurrent.TimeoutException.class)")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.concurrent.TimeoutException");
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.timeout(#{duration:any(java.time.Duration)}, reactor.core.publisher.Flux.empty())")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("java.util.concurrent.TimeoutException", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux onErrorComplete(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Flux timeout(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxJust}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxJustRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxJustRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxJust`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#just(Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before0$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("reactor.core.publisher.Flux.range(#{value:any(int)}, 1)")
                                .bindType("reactor.core.publisher.Flux<java.lang.Integer>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Flux.just(#{value:any(T)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$0 == null) {
                        before0$0 = JavaTemplate.builder("reactor.core.publisher.Mono.just(#{value:any(T)}).flux()")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("reactor.core.publisher.Mono");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Flux.just(#{value:any(T)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$1 == null) {
                        before0$1 = JavaTemplate.builder("reactor.core.publisher.Flux.fromStream(()->java.util.stream.Stream.of(#{value:any(T)}))")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Stream");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Flux.just(#{value:any(T)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$2 == null) {
                        before0$2 = JavaTemplate.builder("reactor.core.publisher.Mono.just(#{value:any(T)}).repeat().take(1)")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before0$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("reactor.core.publisher.Mono");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Flux.just(#{value:any(T)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            Preconditions.or(
                                    new UsesMethod<>("reactor.core.publisher.Flux range(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.stream.Stream", true),
                                            new UsesMethod<>("java.util.stream.Stream of(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Flux fromStream(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("reactor.core.publisher.Mono", true),
                                            new UsesMethod<>("reactor.core.publisher.Flux take(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono just(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono repeat(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("reactor.core.publisher.Mono", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono flux(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono just(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoIdentity}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoIdentityRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoIdentityRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoIdentity`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily transform a `Mono` to an equivalent instance.";
        }

        @Override
        public Set<String> getTags() {
            return new HashSet<>(Arrays.asList("RSPEC-S2637", "RSPEC-S4968"));
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before2$0;
                JavaTemplate before2$1;
                JavaTemplate before3;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.switchIfEmpty(reactor.core.publisher.Mono.empty())")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.flux().next()")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.flux().singleOrEmpty()")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2$0 == null) {
                        before2$0 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<java.lang.Void>)}.ignoreElement()")
                                .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before2$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2$1 == null) {
                        before2$1 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<java.lang.Void>)}.then()")
                                .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before2$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before3 == null) {
                        before3 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<com.google.common.collect.ImmutableList<T>>)}.map(com.google.common.collect.ImmutableList::copyOf)")
                                .bindType("reactor.core.publisher.Mono<com.google.common.collect.ImmutableList<T>>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before3.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    new UsesMethod<>("reactor.core.publisher.Mono ignoreElement(..)", true),
                                    new UsesMethod<>("reactor.core.publisher.Mono then(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Flux next(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono flux(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Flux singleOrEmpty(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono flux(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Mono empty(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono switchIfEmpty(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableList", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono map(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoSingle}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoSingleRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoSingleRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoSingle`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily transform a `Mono` to a `Flux` to expect exactly one item.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.flux().single()")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.single()")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Flux single(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono flux(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxSwitchIfEmptyOfEmptyPublisher}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxSwitchIfEmptyOfEmptyPublisherRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxSwitchIfEmptyOfEmptyPublisherRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxSwitchIfEmptyOfEmptyPublisher`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily pass an empty publisher to `Flux#switchIfEmpty(Publisher)`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.switchIfEmpty(reactor.core.publisher.Mono.empty())")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("reactor.core.publisher.Mono");
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.switchIfEmpty(reactor.core.publisher.Flux.empty())")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux switchIfEmpty(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("reactor.core.publisher.Flux empty(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("reactor.core.publisher.Mono", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono empty(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoFlatMapIterableIdentity}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoFlatMapIterableIdentityRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoFlatMapIterableIdentityRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoFlatMapIterableIdentity`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#flatMapIterable(Function)` to flatten a `Mono` of some `Iterable` over less efficient alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<S>)}.flatMapMany(reactor.core.publisher.Flux::fromIterable)")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T", "S extends java.lang.Iterable<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<S>)}.flatMapIterable(java.util.function.Function.identity())")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T", "S extends java.lang.Iterable<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono flatMapMany(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxMapNotNullOrElse}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxMapNotNullOrElseRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxMapNotNullOrElseRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxMapNotNullOrElse`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#mapNotNull(Function)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<java.util.Optional<T>>)}.filter(java.util.Optional::isPresent).map(java.util.Optional::orElseThrow)")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<java.util.Optional<T>>)}.mapNotNull((x)->x.orElse(null))")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux filter(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Flux map(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoFlux}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoFluxRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoFluxRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoFlux`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#flux()`} over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.flatMapMany(reactor.core.publisher.Mono::just)")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.flux()")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.flatMapMany(reactor.core.publisher.Flux::just)")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.flux()")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("reactor.core.publisher.Flux.concat(#{mono:any(reactor.core.publisher.Mono<T>)})")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.flux()")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    new UsesMethod<>("reactor.core.publisher.Flux concat(..)", true),
                                    new UsesMethod<>("reactor.core.publisher.Mono flatMapMany(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoThen}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoThenRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoThenRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoThen`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer direct invocation of `Mono#then()`} over more contrived alternatives.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4968");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.ignoreElement().then()")
                                .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.then()")
                                    .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.flux().then()")
                                .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.then()")
                                    .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("reactor.core.publisher.Mono.when(#{mono:any(reactor.core.publisher.Mono<T>)})")
                                .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.then()")
                                    .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("reactor.core.publisher.Mono.whenDelayError(#{mono:any(reactor.core.publisher.Mono<T>)})")
                                .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.then()")
                                    .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    new UsesMethod<>("reactor.core.publisher.Mono when(..)", true),
                                    new UsesMethod<>("reactor.core.publisher.Mono whenDelayError(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Flux then(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono flux(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Mono ignoreElement(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono then(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxThen}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxThenRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxThenRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxThen`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid vacuous invocations of `Flux#ignoreElements()`.";
        }

        @Override
        public Set<String> getTags() {
            return new HashSet<>(Arrays.asList("RSPEC-S4968", "RSPEC-S2637"));
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.ignoreElements().then()")
                                .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.then()")
                                    .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<java.lang.Void>)}.ignoreElements()")
                                .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.then()")
                                    .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Flux ignoreElements(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoThenEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoThenEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoThenEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoThenEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid vacuous invocations of `Mono#ignoreElement()`.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4968");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.ignoreElement().thenEmpty(#{publisher:any(org.reactivestreams.Publisher<java.lang.Void>)})")
                                .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.thenEmpty(#{publisher:any(org.reactivestreams.Publisher<java.lang.Void>)})")
                                    .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "jspecify-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.reactivestreams.Publisher", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono ignoreElement(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono thenEmpty(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxThenEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxThenEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxThenEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxThenEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid vacuous invocations of `Flux#ignoreElements()`.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4968");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.ignoreElements().thenEmpty(#{publisher:any(org.reactivestreams.Publisher<java.lang.Void>)})")
                                .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.thenEmpty(#{publisher:any(org.reactivestreams.Publisher<java.lang.Void>)})")
                                    .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "jspecify-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.reactivestreams.Publisher", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Flux ignoreElements(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono thenEmpty(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoThenMany}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoThenManyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoThenManyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoThenMany`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid vacuous operations prior to invocation of `Mono#thenMany(Publisher)`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.ignoreElement().thenMany(#{publisher:any(org.reactivestreams.Publisher<S>)})")
                                .bindType("reactor.core.publisher.Flux<S>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.thenMany(#{publisher:any(org.reactivestreams.Publisher<S>)})")
                                    .bindType("reactor.core.publisher.Flux<S>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.flux().thenMany(#{publisher:any(org.reactivestreams.Publisher<S>)})")
                                .bindType("reactor.core.publisher.Flux<S>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.thenMany(#{publisher:any(org.reactivestreams.Publisher<S>)})")
                                    .bindType("reactor.core.publisher.Flux<S>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.reactivestreams.Publisher", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Flux thenMany(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono flux(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Mono ignoreElement(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono thenMany(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoThenMonoFlux}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoThenMonoFluxRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoThenMonoFluxRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoThenMonoFlux`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer explicit invocation of `Mono#flux()` over implicit conversions from `Mono` to `Flux`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono1:any(reactor.core.publisher.Mono<T>)}.thenMany(#{mono2:any(reactor.core.publisher.Mono<S>)})")
                                .bindType("reactor.core.publisher.Flux<S>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono1:any(reactor.core.publisher.Mono<T>)}.then(#{mono2:any(reactor.core.publisher.Mono<S>)}).flux()")
                                    .bindType("reactor.core.publisher.Flux<S>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono thenMany(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxThenMany}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxThenManyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxThenManyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxThenMany`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid vacuous invocations of `Flux#ignoreElements()`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.ignoreElements().thenMany(#{publisher:any(org.reactivestreams.Publisher<S>)})")
                                .bindType("reactor.core.publisher.Flux<S>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.thenMany(#{publisher:any(org.reactivestreams.Publisher<S>)})")
                                    .bindType("reactor.core.publisher.Flux<S>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.reactivestreams.Publisher", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux ignoreElements(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono thenMany(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoThenMono}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoThenMonoRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoThenMonoRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoThenMono`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid vacuous operations prior to invocation of `Mono#then(Mono)`.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4968");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{mono1:any(reactor.core.publisher.Mono<T>)}.ignoreElement().then(#{mono2:any(reactor.core.publisher.Mono<S>)})")
                                .bindType("reactor.core.publisher.Mono<S>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono1:any(reactor.core.publisher.Mono<T>)}.then(#{mono2:any(reactor.core.publisher.Mono<S>)})")
                                    .bindType("reactor.core.publisher.Mono<S>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{mono1:any(reactor.core.publisher.Mono<T>)}.flux().then(#{mono2:any(reactor.core.publisher.Mono<S>)})")
                                .bindType("reactor.core.publisher.Mono<S>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono1:any(reactor.core.publisher.Mono<T>)}.then(#{mono2:any(reactor.core.publisher.Mono<S>)})")
                                    .bindType("reactor.core.publisher.Mono<S>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{mono1:any(reactor.core.publisher.Mono<T>)}.thenEmpty(#{mono2:any(reactor.core.publisher.Mono<java.lang.Void>)})")
                                .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono1:any(reactor.core.publisher.Mono<T>)}.then(#{mono2:any(reactor.core.publisher.Mono<S>)})")
                                    .bindType("reactor.core.publisher.Mono<S>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    new UsesMethod<>("reactor.core.publisher.Mono thenEmpty(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Flux then(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono flux(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Mono ignoreElement(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono then(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxThenMono}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxThenMonoRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxThenMonoRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxThenMono`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid vacuous invocations of `Flux#ignoreElements()`.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4968");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.ignoreElements().then(#{mono:any(reactor.core.publisher.Mono<S>)})")
                                .bindType("reactor.core.publisher.Mono<S>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.then(#{mono:any(reactor.core.publisher.Mono<S>)})")
                                    .bindType("reactor.core.publisher.Mono<S>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.thenEmpty(#{mono:any(reactor.core.publisher.Mono<java.lang.Void>)})")
                                .bindType("reactor.core.publisher.Mono<? extends java.lang.Void>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.then(#{mono:any(reactor.core.publisher.Mono<S>)})")
                                    .bindType("reactor.core.publisher.Mono<S>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    new UsesMethod<>("reactor.core.publisher.Flux thenEmpty(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Flux ignoreElements(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono then(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoSingleOptional}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoSingleOptionalRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoSingleOptionalRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoSingleOptional`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#singleOptional()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.flux().collect(com.google.common.collect.MoreCollectors.toOptional())")
                                .bindType("reactor.core.publisher.Mono<java.util.Optional<T>>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.MoreCollectors");
                        maybeRemoveImport("com.google.common.collect.MoreCollectors.toOptional");
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.singleOptional()")
                                    .bindType("reactor.core.publisher.Mono<java.util.Optional<T>>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.map(java.util.Optional::of)")
                                .bindType("reactor.core.publisher.Mono<java.util.Optional<T>>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.singleOptional()")
                                    .bindType("reactor.core.publisher.Mono<java.util.Optional<T>>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.singleOptional().defaultIfEmpty(#{optional:any(java.util.Optional<T>)})")
                                .bindType("reactor.core.publisher.Mono<java.util.Optional<T>>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.singleOptional()")
                                    .bindType("reactor.core.publisher.Mono<java.util.Optional<T>>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.singleOptional().switchIfEmpty(#{alternate:any(reactor.core.publisher.Mono<java.util.Optional<T>>)})")
                                .bindType("reactor.core.publisher.Mono<java.util.Optional<T>>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.singleOptional()")
                                    .bindType("reactor.core.publisher.Mono<java.util.Optional<T>>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$4 == null) {
                        before$4 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.transform(reactor.core.publisher.Mono::singleOptional)")
                                .bindType("reactor.core.publisher.Mono<java.util.Optional<T>>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before$4.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.singleOptional()")
                                    .bindType("reactor.core.publisher.Mono<java.util.Optional<T>>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    new UsesMethod<>("reactor.core.publisher.Mono map(..)", true),
                                    new UsesMethod<>("reactor.core.publisher.Mono transform(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.MoreCollectors toOptional(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Flux collect(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono flux(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Mono defaultIfEmpty(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono singleOptional(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Mono singleOptional(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono switchIfEmpty(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoOfType}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoOfTypeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoOfTypeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoOfType`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#ofType(Class)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.filter(#{clazz:any(java.lang.Class<S>)}::isInstance).cast(#{clazz})")
                                .bindType("reactor.core.publisher.Mono<S>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.ofType(#{clazz:any(java.lang.Class<S>)})")
                                    .bindType("reactor.core.publisher.Mono<S>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono cast(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono filter(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxOfType}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxOfTypeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxOfTypeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxOfType`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#ofType(Class)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.filter(#{clazz:any(java.lang.Class<S>)}::isInstance).cast(#{clazz})")
                                .bindType("reactor.core.publisher.Flux<S>")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.ofType(#{clazz:any(java.lang.Class<S>)})")
                                    .bindType("reactor.core.publisher.Flux<S>")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux cast(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Flux filter(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.ConcatMapIterableIdentity}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ConcatMapIterableIdentityRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ConcatMapIterableIdentityRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.ConcatMapIterableIdentity`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#concatMapIterable(Function)` over alternatives that require an additional subscription.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<? extends java.lang.Iterable<T>>)}.concatMap((list)->reactor.core.publisher.Flux.fromIterable(list))")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<? extends java.lang.Iterable<T>>)}.concatMapIterable(java.util.function.Function.identity())")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<? extends java.lang.Iterable<T>>)}.concatMap(reactor.core.publisher.Flux::fromIterable)")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<? extends java.lang.Iterable<T>>)}.concatMapIterable(java.util.function.Function.identity())")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux concatMap(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.ConcatMapIterableIdentityWithPrefetch}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ConcatMapIterableIdentityWithPrefetchRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ConcatMapIterableIdentityWithPrefetchRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.ConcatMapIterableIdentityWithPrefetch`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#concatMapIterable(Function, int)` over alternatives that require an additional subscription.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<? extends java.lang.Iterable<T>>)}.concatMap((list)->reactor.core.publisher.Flux.fromIterable(list), #{prefetch:any(int)})")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<? extends java.lang.Iterable<T>>)}.concatMapIterable(java.util.function.Function.identity(), #{prefetch:any(int)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<? extends java.lang.Iterable<T>>)}.concatMap(reactor.core.publisher.Flux::fromIterable, #{prefetch:any(int)})")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<? extends java.lang.Iterable<T>>)}.concatMapIterable(java.util.function.Function.identity(), #{prefetch:any(int)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux concatMap(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxFromIterable}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxFromIterableRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxFromIterableRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxFromIterable`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#fromIterable(Iterable)` over less efficient alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitExpression(Expression elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("reactor.core.publisher.Flux.fromStream(#{collection:any(java.util.Collection<T>)}::stream)")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Supplier");
                        maybeRemoveImport("java.util.stream.Stream");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Flux.fromIterable(#{collection:any(java.util.Collection<T>)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("reactor.core.publisher.Flux.fromStream(()->#{collection:any(java.util.Collection<T>)}.stream())")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Supplier");
                        maybeRemoveImport("java.util.stream.Stream");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Flux.fromIterable(#{collection:any(java.util.Collection<T>)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitExpression(elem, ctx);
                }

                @Override
                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("reactor.core.publisher.Flux.fromStream(#{collection:any(java.util.Collection<T>)}::stream)")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Supplier");
                        maybeRemoveImport("java.util.stream.Stream");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Flux.fromIterable(#{collection:any(java.util.Collection<T>)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("reactor.core.publisher.Flux.fromStream(()->#{collection:any(java.util.Collection<T>)}.stream())")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Supplier");
                        maybeRemoveImport("java.util.stream.Stream");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Flux.fromIterable(#{collection:any(java.util.Collection<T>)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitLambda(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Collection", true),
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux fromStream(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoDoOnError}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoDoOnErrorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoDoOnErrorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoDoOnError`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#doOnError(Class, Consumer)` over `Mono#doOnError(Predicate, Consumer)` where possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.doOnError(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{onError:any(java.util.function.Consumer<? super java.lang.Throwable>)})")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.doOnError(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{onError:any(java.util.function.Consumer<? super java.lang.Throwable>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Consumer", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono doOnError(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxDoOnError}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxDoOnErrorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxDoOnErrorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxDoOnError`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#doOnError(Class, Consumer)` over `Flux#doOnError(Predicate, Consumer)` where possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.doOnError(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{onError:any(java.util.function.Consumer<? super java.lang.Throwable>)})")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.doOnError(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{onError:any(java.util.function.Consumer<? super java.lang.Throwable>)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Consumer", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux doOnError(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoOnErrorComplete}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoOnErrorCompleteRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoOnErrorCompleteRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoOnErrorComplete`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#onErrorComplete()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorResume((e)->reactor.core.publisher.Mono.empty())")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorComplete()")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono empty(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono onErrorResume(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxOnErrorComplete}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxOnErrorCompleteRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxOnErrorCompleteRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxOnErrorComplete`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#onErrorComplete()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorResume((e)->reactor.core.publisher.Mono.empty())")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("reactor.core.publisher.Mono");
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorComplete()")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorResume((e)->reactor.core.publisher.Flux.empty())")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorComplete()")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux onErrorResume(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("reactor.core.publisher.Flux empty(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("reactor.core.publisher.Mono", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono empty(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoOnErrorCompleteClass}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoOnErrorCompleteClassRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoOnErrorCompleteClassRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoOnErrorCompleteClass`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#onErrorComplete(Class)`} over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorComplete(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance)")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorComplete(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorResume(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, (e)->reactor.core.publisher.Mono.empty())")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorComplete(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    new UsesMethod<>("reactor.core.publisher.Mono onErrorComplete(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Mono empty(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono onErrorResume(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoOnErrorCompletePredicate}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoOnErrorCompletePredicateRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoOnErrorCompletePredicateRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoOnErrorCompletePredicate`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#onErrorComplete(Predicate)`} over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorResume(#{predicate:any(java.util.function.Predicate<? super java.lang.Throwable>)}, (e)->reactor.core.publisher.Mono.empty())")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorComplete(#{predicate:any(java.util.function.Predicate<? super java.lang.Throwable>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono empty(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono onErrorResume(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxOnErrorCompletePredicate}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxOnErrorCompletePredicateRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxOnErrorCompletePredicateRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxOnErrorCompletePredicate`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#onErrorComplete(Predicate)`} over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorResume(#{predicate:any(java.util.function.Predicate<? super java.lang.Throwable>)}, (e)->reactor.core.publisher.Mono.empty())")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("reactor.core.publisher.Mono");
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorComplete(#{predicate:any(java.util.function.Predicate<? super java.lang.Throwable>)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorResume(#{predicate:any(java.util.function.Predicate<? super java.lang.Throwable>)}, (e)->reactor.core.publisher.Flux.empty())")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorComplete(#{predicate:any(java.util.function.Predicate<? super java.lang.Throwable>)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux onErrorResume(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("reactor.core.publisher.Flux empty(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("reactor.core.publisher.Mono", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono empty(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoOnErrorContinue}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoOnErrorContinueRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoOnErrorContinueRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoOnErrorContinue`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#onErrorContinue(Class, BiConsumer)` over `Mono#onErrorContinue(Predicate, BiConsumer)` where possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorContinue(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{errorConsumer:any(java.util.function.BiConsumer<java.lang.Throwable, java.lang.Object>)})")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorContinue(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{errorConsumer:any(java.util.function.BiConsumer<java.lang.Throwable, java.lang.Object>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.BiConsumer", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono onErrorContinue(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxOnErrorContinue}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxOnErrorContinueRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxOnErrorContinueRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxOnErrorContinue`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#onErrorContinue(Class, BiConsumer)` over `Flux#onErrorContinue(Predicate, BiConsumer)` where possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorContinue(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{errorConsumer:any(java.util.function.BiConsumer<java.lang.Throwable, java.lang.Object>)})")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorContinue(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{errorConsumer:any(java.util.function.BiConsumer<java.lang.Throwable, java.lang.Object>)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.BiConsumer", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux onErrorContinue(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoOnErrorMap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoOnErrorMapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoOnErrorMapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoOnErrorMap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#onErrorMap(Class, Function)` over `Mono#onErrorMap(Predicate, Function)` where possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorMap(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{mapper:any(java.util.function.Function<? super java.lang.Throwable, ? extends java.lang.Throwable>)})")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorMap(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{mapper:any(java.util.function.Function<? super java.lang.Throwable, ? extends java.lang.Throwable>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Function", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono onErrorMap(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxOnErrorMap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxOnErrorMapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxOnErrorMapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxOnErrorMap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#onErrorMap(Class, Function)` over `Flux#onErrorMap(Predicate, Function)` where possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorMap(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{mapper:any(java.util.function.Function<? super java.lang.Throwable, ? extends java.lang.Throwable>)})")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorMap(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{mapper:any(java.util.function.Function<? super java.lang.Throwable, ? extends java.lang.Throwable>)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Function", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux onErrorMap(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoOnErrorResume}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoOnErrorResumeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoOnErrorResumeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoOnErrorResume`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#onErrorResume(Class, Function)` over `Mono#onErrorResume(Predicate, Function)` where possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorResume(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{fallback:any(java.util.function.Function<? super java.lang.Throwable, ? extends reactor.core.publisher.Mono<? extends T>>)})")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorResume(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{fallback:any(java.util.function.Function<? super java.lang.Throwable, ? extends reactor.core.publisher.Mono<? extends T>>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Function", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono onErrorResume(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxOnErrorResume}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxOnErrorResumeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxOnErrorResumeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxOnErrorResume`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#onErrorResume(Class, Function)` over `Flux#onErrorResume(Predicate, Function)` where possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorResume(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{fallback:any(java.util.function.Function<? super java.lang.Throwable, ? extends org.reactivestreams.Publisher<? extends T>>)})")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorResume(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{fallback:any(java.util.function.Function<? super java.lang.Throwable, ? extends org.reactivestreams.Publisher<? extends T>>)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Function", true),
                            new UsesType<>("org.reactivestreams.Publisher", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux onErrorResume(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoOnErrorReturn}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoOnErrorReturnRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoOnErrorReturnRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoOnErrorReturn`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#onErrorReturn(Class, Object)` over `Mono#onErrorReturn(Predicate, Object)` where possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorReturn(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{fallbackValue:any(T)})")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorReturn(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{fallbackValue:any(T)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono onErrorReturn(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxOnErrorReturn}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxOnErrorReturnRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxOnErrorReturnRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxOnErrorReturn`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#onErrorReturn(Class, Object)` over `Flux#onErrorReturn(Predicate, Object)` where possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorReturn(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{fallbackValue:any(T)})")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorReturn(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{fallbackValue:any(T)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux onErrorReturn(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxFilterSort}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxFilterSortRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxFilterSortRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxFilterSort`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Apply `Flux#filter(Predicate)` before `Flux#sort()` to reduce the number of elements to sort.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.sort().filter(#{predicate:any(java.util.function.Predicate<? super T>)})")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)}).sort()")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux filter(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Flux sort(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxFilterSortWithComparator}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxFilterSortWithComparatorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxFilterSortWithComparatorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxFilterSortWithComparator`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Apply `Flux#filter(Predicate)` before `Flux#sort(Comparator)` to reduce the number of elements to sort.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.sort(#{comparator:any(java.util.Comparator<? super T>)}).filter(#{predicate:any(java.util.function.Predicate<? super T>)})")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)}).sort(#{comparator:any(java.util.Comparator<? super T>)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux filter(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Flux sort(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxTakeWhile}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxTakeWhileRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxTakeWhileRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxTakeWhile`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Do not unnecessarily `Flux#filter(Predicate) filter` the result of `Flux#takeWhile(Predicate)` using the same `Predicate`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.takeWhile(#{predicate:any(java.util.function.Predicate<? super T>)}).filter(#{predicate})")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.takeWhile(#{predicate:any(java.util.function.Predicate<? super T>)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux filter(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Flux takeWhile(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxCollectToImmutableList}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxCollectToImmutableListRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxCollectToImmutableListRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxCollectToImmutableList`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#collect(Collector)` with `ImmutableList#toImmutableList()` over alternatives that do not explicitly return an immutable collection.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.collectList()")
                                .bindType("reactor.core.publisher.Mono<java.util.List<T>>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.collect(com.google.common.collect.ImmutableList.toImmutableList())")
                                    .bindType("reactor.core.publisher.Mono<com.google.common.collect.ImmutableList<T>>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.List", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Flux collectList(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxCollectToImmutableSet}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxCollectToImmutableSetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxCollectToImmutableSetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxCollectToImmutableSet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#collect(Collector)` with `ImmutableSet#toImmutableSet()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.collect(com.google.common.collect.ImmutableList.toImmutableList()).map(com.google.common.collect.ImmutableSet::copyOf)")
                                .bindType("reactor.core.publisher.Mono<com.google.common.collect.ImmutableSet<T>>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableList");
                        maybeRemoveImport("com.google.common.collect.ImmutableList.toImmutableList");
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                    .bindType("reactor.core.publisher.Mono<com.google.common.collect.ImmutableSet<T>>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableList toImmutableList(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Flux collect(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono map(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxSort}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxSortRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxSortRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxSort`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#sort()` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.sort(java.util.Comparator.naturalOrder())")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.sort()")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Flux sort(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxTransformMin}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxTransformMinRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxTransformMinRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxTransformMin`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `MathFlux#min(Publisher)` over less efficient alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.sort().next()")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.transform(reactor.math.MathFlux::min).singleOrEmpty()")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-extra-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Flux next(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Flux sort(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxTransformMinWithComparator}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxTransformMinWithComparatorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxTransformMinWithComparatorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxTransformMinWithComparator`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `MathFlux#min(Publisher, Comparator)` over less efficient or more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.sort(#{cmp:any(java.util.Comparator<? super T>)}).next()")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.transform((f)->reactor.math.MathFlux.min(f, #{cmp:any(java.util.Comparator<? super T>)})).singleOrEmpty()")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-extra-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.collect(java.util.stream.Collectors.minBy(#{cmp:any(java.util.Comparator<? super T>)})).flatMap(reactor.core.publisher.Mono::justOrEmpty)")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.stream.Collectors.minBy");
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.transform((f)->reactor.math.MathFlux.min(f, #{cmp:any(java.util.Comparator<? super T>)})).singleOrEmpty()")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-extra-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.stream.Collectors minBy(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Flux collect(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono flatMap(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Flux next(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Flux sort(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxTransformMax}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxTransformMaxRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxTransformMaxRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxTransformMax`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `MathFlux#max(Publisher)` over less efficient alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.sort().last()")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.transform(reactor.math.MathFlux::max).singleOrEmpty()")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-extra-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Flux last(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Flux sort(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxTransformMaxWithComparator}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxTransformMaxWithComparatorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxTransformMaxWithComparatorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxTransformMaxWithComparator`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `MathFlux#max(Publisher, Comparator)` over less efficient or more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.sort(#{cmp:any(java.util.Comparator<? super T>)}).last()")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.transform((f)->reactor.math.MathFlux.max(f, #{cmp:any(java.util.Comparator<? super T>)})).singleOrEmpty()")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-extra-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.collect(java.util.stream.Collectors.maxBy(#{cmp:any(java.util.Comparator<? super T>)})).flatMap(reactor.core.publisher.Mono::justOrEmpty)")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collectors");
                        maybeRemoveImport("java.util.stream.Collectors.maxBy");
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.transform((f)->reactor.math.MathFlux.max(f, #{cmp:any(java.util.Comparator<? super T>)})).singleOrEmpty()")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-extra-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.stream.Collectors maxBy(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Flux collect(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono flatMap(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Flux last(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Flux sort(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MathFluxMin}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MathFluxMinRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MathFluxMinRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MathFluxMin`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `MathFlux#min(Publisher)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("reactor.math.MathFlux.min(#{publisher:any(org.reactivestreams.Publisher<T>)}, java.util.Comparator.naturalOrder())")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactive-streams-1", "reactor-extra-3", "reactor-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.math.MathFlux.min(#{publisher:any(org.reactivestreams.Publisher<T>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactive-streams-1", "reactor-extra-3", "reactor-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("reactor.math.MathFlux.max(#{publisher:any(org.reactivestreams.Publisher<T>)}, java.util.Comparator.reverseOrder())")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactive-streams-1", "reactor-extra-3", "reactor-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.reverseOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.math.MathFlux.min(#{publisher:any(org.reactivestreams.Publisher<T>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactive-streams-1", "reactor-extra-3", "reactor-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.reactivestreams.Publisher", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesType<>("reactor.math.MathFlux", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("reactor.math.MathFlux min(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Comparator reverseOrder(..)", true),
                                            new UsesMethod<>("reactor.math.MathFlux max(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MathFluxMax}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MathFluxMaxRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MathFluxMaxRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MathFluxMax`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `MathFlux#max(Publisher)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("reactor.math.MathFlux.min(#{publisher:any(org.reactivestreams.Publisher<T>)}, java.util.Comparator.reverseOrder())")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactive-streams-1", "reactor-extra-3", "reactor-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.reverseOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.math.MathFlux.max(#{publisher:any(org.reactivestreams.Publisher<T>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactive-streams-1", "reactor-extra-3", "reactor-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("reactor.math.MathFlux.max(#{publisher:any(org.reactivestreams.Publisher<T>)}, java.util.Comparator.naturalOrder())")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactive-streams-1", "reactor-extra-3", "reactor-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.math.MathFlux.max(#{publisher:any(org.reactivestreams.Publisher<T>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactive-streams-1", "reactor-extra-3", "reactor-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.reactivestreams.Publisher", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesType<>("reactor.math.MathFlux", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("reactor.math.MathFlux max(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Comparator reverseOrder(..)", true),
                                            new UsesMethod<>("reactor.math.MathFlux min(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.PublisherProbeEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PublisherProbeEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PublisherProbeEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.PublisherProbeEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `PublisherProbe#empty()`} over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("reactor.test.publisher.PublisherProbe.of(reactor.core.publisher.Mono.empty())")
                                .bindType("reactor.test.publisher.PublisherProbe<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("reactor.core.publisher.Mono");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.test.publisher.PublisherProbe.empty()")
                                    .bindType("reactor.test.publisher.PublisherProbe<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("reactor.test.publisher.PublisherProbe.of(reactor.core.publisher.Flux.empty())")
                                .bindType("reactor.test.publisher.PublisherProbe<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("reactor.core.publisher.Flux");
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.test.publisher.PublisherProbe.empty()")
                                    .bindType("reactor.test.publisher.PublisherProbe<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.test.publisher.PublisherProbe", true),
                            new UsesMethod<>("reactor.test.publisher.PublisherProbe of(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("reactor.core.publisher.Flux", true),
                                            new UsesMethod<>("reactor.core.publisher.Flux empty(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("reactor.core.publisher.Mono", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono empty(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.PublisherProbeAssertWasSubscribed}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PublisherProbeAssertWasSubscribedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PublisherProbeAssertWasSubscribedRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.PublisherProbeAssertWasSubscribed`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `PublisherProbe#assertWasSubscribed()` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.wasSubscribed()).isTrue();")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.Assertions");
                        maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        if (after == null) {
                            after = JavaTemplate.builder("#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasSubscribed();")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.subscribeCount()).isNotNegative();")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.Assertions");
                        maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        if (after == null) {
                            after = JavaTemplate.builder("#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasSubscribed();")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.subscribeCount()).isNotEqualTo(0);")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.Assertions");
                        maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        if (after == null) {
                            after = JavaTemplate.builder("#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasSubscribed();")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.subscribeCount()).isPositive();")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.Assertions");
                        maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        if (after == null) {
                            after = JavaTemplate.builder("#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasSubscribed();")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.test.publisher.PublisherProbe", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true),
                                            new UsesMethod<>("reactor.test.publisher.PublisherProbe wasSubscribed(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isNotEqualTo(..)", true),
                                            new UsesMethod<>("reactor.test.publisher.PublisherProbe subscribeCount(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isNotNegative(..)", true),
                                            new UsesMethod<>("reactor.test.publisher.PublisherProbe subscribeCount(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isPositive(..)", true),
                                            new UsesMethod<>("reactor.test.publisher.PublisherProbe subscribeCount(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.PublisherProbeAssertWasNotSubscribed}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PublisherProbeAssertWasNotSubscribedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PublisherProbeAssertWasNotSubscribedRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.PublisherProbeAssertWasNotSubscribed`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `PublisherProbe#assertWasNotSubscribed()` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.wasSubscribed()).isFalse();")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.Assertions");
                        maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        if (after == null) {
                            after = JavaTemplate.builder("#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasNotSubscribed();")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.subscribeCount()).isEqualTo(0);")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.Assertions");
                        maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        if (after == null) {
                            after = JavaTemplate.builder("#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasNotSubscribed();")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.subscribeCount()).isNotPositive();")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.Assertions");
                        maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        if (after == null) {
                            after = JavaTemplate.builder("#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasNotSubscribed();")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.test.publisher.PublisherProbe", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                                            new UsesMethod<>("reactor.test.publisher.PublisherProbe wasSubscribed(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true),
                                            new UsesMethod<>("reactor.test.publisher.PublisherProbe subscribeCount(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isNotPositive(..)", true),
                                            new UsesMethod<>("reactor.test.publisher.PublisherProbe subscribeCount(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.PublisherProbeAssertWasCancelled}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PublisherProbeAssertWasCancelledRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PublisherProbeAssertWasCancelledRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.PublisherProbeAssertWasCancelled`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `PublisherProbe#assertWasCancelled()` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.wasCancelled()).isTrue();")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.Assertions");
                        maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        if (after == null) {
                            after = JavaTemplate.builder("#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasCancelled();")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.test.publisher.PublisherProbe", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            new UsesMethod<>("reactor.test.publisher.PublisherProbe wasCancelled(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.PublisherProbeAssertWasNotCancelled}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PublisherProbeAssertWasNotCancelledRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PublisherProbeAssertWasNotCancelledRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.PublisherProbeAssertWasNotCancelled`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `PublisherProbe#assertWasNotCancelled()` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.wasCancelled()).isFalse();")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.Assertions");
                        maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        if (after == null) {
                            after = JavaTemplate.builder("#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasNotCancelled();")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.test.publisher.PublisherProbe", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            new UsesMethod<>("reactor.test.publisher.PublisherProbe wasCancelled(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.PublisherProbeAssertWasRequested}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PublisherProbeAssertWasRequestedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PublisherProbeAssertWasRequestedRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.PublisherProbeAssertWasRequested`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `PublisherProbe#assertWasRequested()` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.wasRequested()).isTrue();")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.Assertions");
                        maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        if (after == null) {
                            after = JavaTemplate.builder("#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasRequested();")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.test.publisher.PublisherProbe", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            new UsesMethod<>("reactor.test.publisher.PublisherProbe wasRequested(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.PublisherProbeAssertWasNotRequested}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PublisherProbeAssertWasNotRequestedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PublisherProbeAssertWasNotRequestedRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.PublisherProbeAssertWasNotRequested`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `PublisherProbe#assertWasNotRequested()` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.wasRequested()).isFalse();")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.Assertions");
                        maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        if (after == null) {
                            after = JavaTemplate.builder("#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasNotRequested();")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.test.publisher.PublisherProbe", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            new UsesMethod<>("reactor.test.publisher.PublisherProbe wasRequested(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.StepVerifierFromMono}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StepVerifierFromMonoRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StepVerifierFromMonoRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.StepVerifierFromMono`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#as(Function)` when creating a `StepVerifier`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("reactor.test.StepVerifier.create(#{mono:any(reactor.core.publisher.Mono<T>)})")
                                .bindType("reactor.test.StepVerifier.FirstStep<? extends T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.test.StepVerifier::create)")
                                    .bindType("reactor.test.StepVerifier.FirstStep<? extends T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.flux().as(reactor.test.StepVerifier::create)")
                                .bindType("reactor.test.StepVerifier.FirstStep<? extends T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.test.StepVerifier::create)")
                                    .bindType("reactor.test.StepVerifier.FirstStep<? extends T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesType<>("reactor.test.StepVerifier", true),
                            Preconditions.or(
                                    new UsesMethod<>("reactor.test.StepVerifier create(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.core.publisher.Flux as(..)", true),
                                            new UsesMethod<>("reactor.core.publisher.Mono flux(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.StepVerifierFromFlux}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StepVerifierFromFluxRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StepVerifierFromFluxRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.StepVerifierFromFlux`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#as(Function)` when creating a `StepVerifier`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("reactor.test.StepVerifier.create(#{flux:any(reactor.core.publisher.Flux<T>)})")
                                .bindType("reactor.test.StepVerifier.FirstStep<? extends T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.as(reactor.test.StepVerifier::create)")
                                    .bindType("reactor.test.StepVerifier.FirstStep<? extends T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.test.StepVerifier", true),
                            new UsesMethod<>("reactor.test.StepVerifier create(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.StepVerifierVerify}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StepVerifierVerifyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StepVerifierVerifyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.StepVerifierVerify`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `StepVerifier#verify()` over a dangling `StepVerifier#verifyThenAssertThat()`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stepVerifier:any(reactor.test.StepVerifier)}.verifyThenAssertThat()")
                                .bindType("reactor.test.StepVerifier.Assertions")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stepVerifier:any(reactor.test.StepVerifier)}.verify()")
                                    .bindType("java.time.Duration")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.test.StepVerifier", true),
                            new UsesMethod<>("reactor.test.StepVerifier verifyThenAssertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.StepVerifierVerifyDuration}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StepVerifierVerifyDurationRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StepVerifierVerifyDurationRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.StepVerifierVerifyDuration`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `StepVerifier#verify(Duration)` over a dangling `StepVerifier#verifyThenAssertThat(Duration)`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stepVerifier:any(reactor.test.StepVerifier)}.verifyThenAssertThat(#{duration:any(java.time.Duration)})")
                                .bindType("reactor.test.StepVerifier.Assertions")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stepVerifier:any(reactor.test.StepVerifier)}.verify(#{duration:any(java.time.Duration)})")
                                    .bindType("java.time.Duration")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("reactor.test.StepVerifier", true),
                            new UsesMethod<>("reactor.test.StepVerifier verifyThenAssertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.StepVerifierVerifyLater}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StepVerifierVerifyLaterRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StepVerifierVerifyLaterRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.StepVerifierVerifyLater`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily invoke `StepVerifier#verifyLater()` multiple times.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stepVerifier:any(reactor.test.StepVerifier)}.verifyLater().verifyLater()")
                                .bindType("reactor.test.StepVerifier")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stepVerifier:any(reactor.test.StepVerifier)}.verifyLater()")
                                    .bindType("reactor.test.StepVerifier")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.test.StepVerifier", true),
                            new UsesMethod<>("reactor.test.StepVerifier verifyLater(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.StepVerifierStepExpectNext}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StepVerifierStepExpectNextRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StepVerifierStepExpectNextRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.StepVerifierStepExpectNext`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `StepVerifier.Step#expectNext(Object)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.Step<T>)}.expectNextMatches((e)->e.equals(#{object:any(T)}))")
                                .bindType("reactor.test.StepVerifier.Step<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.Step<T>)}.expectNext(#{object:any(T)})")
                                    .bindType("reactor.test.StepVerifier.Step<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.Step<T>)}.expectNextMatches(#{object:any(T)}::equals)")
                                .bindType("reactor.test.StepVerifier.Step<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.Step<T>)}.expectNext(#{object:any(T)})")
                                    .bindType("reactor.test.StepVerifier.Step<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("reactor.test.StepVerifier.Step expectNextMatches(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxAsStepVerifierExpectNext}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxAsStepVerifierExpectNextRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxAsStepVerifierExpectNextRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxAsStepVerifierExpectNext`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid list collection when verifying that a `Flux` emits exactly one value.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.collect(#{listCollector:any(java.util.stream.Collector<? super T, ?, L>)}).as(reactor.test.StepVerifier::create).assertNext((list)->org.assertj.core.api.Assertions.assertThat(list).containsExactly(#{object:any(T)}))")
                                .bindType("reactor.test.StepVerifier.Step<L>")
                                .genericTypes("T", "L extends java.util.List<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-test-3", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Collector");
                        maybeRemoveImport("org.assertj.core.api.Assertions");
                        maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.as(reactor.test.StepVerifier::create).expectNext(#{object:any(T)})")
                                    .bindType("reactor.test.StepVerifier.Step<T>")
                                    .genericTypes("T", "L extends java.util.List<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1", "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Collector", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.test.StepVerifier", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert containsExactly(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Flux collect(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono as(..)", true),
                            new UsesMethod<>("reactor.test.StepVerifier.Step assertNext(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.StepVerifierLastStepVerifyComplete}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StepVerifierLastStepVerifyCompleteRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StepVerifierLastStepVerifyCompleteRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyComplete`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `StepVerifier.LastStep#verifyComplete()` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.expectComplete().verify()")
                                .bindType("java.time.Duration")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.verifyComplete()")
                                    .bindType("java.time.Duration")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesMethod<>("reactor.test.StepVerifier verify(..)", true),
                            new UsesMethod<>("reactor.test.StepVerifier.LastStep expectComplete(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.StepVerifierLastStepVerifyError}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StepVerifierLastStepVerifyErrorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StepVerifierLastStepVerifyErrorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyError`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `StepVerifier.LastStep#verifyError()` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.expectError().verify()")
                                .bindType("java.time.Duration")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.verifyError()")
                                    .bindType("java.time.Duration")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesMethod<>("reactor.test.StepVerifier verify(..)", true),
                            new UsesMethod<>("reactor.test.StepVerifier.LastStep expectError(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.StepVerifierLastStepVerifyErrorClass}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StepVerifierLastStepVerifyErrorClassRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StepVerifierLastStepVerifyErrorClassRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyErrorClass`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `StepVerifier.LastStep#verifyError(Class)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.expectError(#{clazz:any(java.lang.Class<T>)}).verify()")
                                .bindType("java.time.Duration")
                                .genericTypes("T extends java.lang.Throwable")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.verifyError(#{clazz:any(java.lang.Class<T>)})")
                                    .bindType("java.time.Duration")
                                    .genericTypes("T extends java.lang.Throwable")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorMatches(#{clazz:any(java.lang.Class<T>)}::isInstance)")
                                .bindType("java.time.Duration")
                                .genericTypes("T extends java.lang.Throwable")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.verifyError(#{clazz:any(java.lang.Class<T>)})")
                                    .bindType("java.time.Duration")
                                    .genericTypes("T extends java.lang.Throwable")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorSatisfies((t)->org.assertj.core.api.Assertions.assertThat(t).isInstanceOf(#{clazz:any(java.lang.Class<T>)}))")
                                .bindType("java.time.Duration")
                                .genericTypes("T extends java.lang.Throwable")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.Assertions");
                        maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        if (after == null) {
                            after = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.verifyError(#{clazz:any(java.lang.Class<T>)})")
                                    .bindType("java.time.Duration")
                                    .genericTypes("T extends java.lang.Throwable")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            Preconditions.or(
                                    new UsesMethod<>("reactor.test.StepVerifier.LastStep verifyErrorMatches(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("org.assertj.core.api.AbstractAssert isInstanceOf(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                                            new UsesMethod<>("reactor.test.StepVerifier.LastStep verifyErrorSatisfies(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.test.StepVerifier verify(..)", true),
                                            new UsesMethod<>("reactor.test.StepVerifier.LastStep expectError(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.StepVerifierLastStepVerifyErrorMatches}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StepVerifierLastStepVerifyErrorMatchesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StepVerifierLastStepVerifyErrorMatchesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyErrorMatches`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `StepVerifier.LastStep#verifyErrorMatches(Predicate)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.expectErrorMatches(#{predicate:any(java.util.function.Predicate<java.lang.Throwable>)}).verify()")
                                .bindType("java.time.Duration")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorMatches(#{predicate:any(java.util.function.Predicate<java.lang.Throwable>)})")
                                    .bindType("java.time.Duration")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.expectError().verifyThenAssertThat().hasOperatorErrorMatching(#{predicate:any(java.util.function.Predicate<java.lang.Throwable>)})")
                                .bindType("reactor.test.StepVerifier.Assertions")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorMatches(#{predicate:any(java.util.function.Predicate<java.lang.Throwable>)})")
                                    .bindType("java.time.Duration")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.test.StepVerifier verifyThenAssertThat(..)", true),
                                            new UsesMethod<>("reactor.test.StepVerifier.Assertions hasOperatorErrorMatching(..)", true),
                                            new UsesMethod<>("reactor.test.StepVerifier.LastStep expectError(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.time.Duration", true),
                                            new UsesMethod<>("reactor.test.StepVerifier verify(..)", true),
                                            new UsesMethod<>("reactor.test.StepVerifier.LastStep expectErrorMatches(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.StepVerifierLastStepVerifyErrorSatisfies}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StepVerifierLastStepVerifyErrorSatisfiesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StepVerifierLastStepVerifyErrorSatisfiesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyErrorSatisfies`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `StepVerifier.LastStep#verifyErrorSatisfies(Consumer)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.expectErrorSatisfies(#{consumer:any(java.util.function.Consumer<java.lang.Throwable>)}).verify()")
                                .bindType("java.time.Duration")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorSatisfies(#{consumer:any(java.util.function.Consumer<java.lang.Throwable>)})")
                                    .bindType("java.time.Duration")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("java.util.function.Consumer", true),
                            new UsesMethod<>("reactor.test.StepVerifier verify(..)", true),
                            new UsesMethod<>("reactor.test.StepVerifier.LastStep expectErrorSatisfies(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.StepVerifierLastStepVerifyErrorSatisfiesAssertJ}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StepVerifierLastStepVerifyErrorSatisfiesAssertJRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StepVerifierLastStepVerifyErrorSatisfiesAssertJRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyErrorSatisfiesAssertJ`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `StepVerifier.LastStep#verifyErrorSatisfies(Consumer)` with AssertJ over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.expectError().verifyThenAssertThat().hasOperatorErrorOfType(#{clazz:any(java.lang.Class<T>)}).hasOperatorErrorWithMessage(#{message:any(java.lang.String)})")
                                .bindType("reactor.test.StepVerifier.Assertions")
                                .genericTypes("T extends java.lang.Throwable")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorSatisfies((t)->org.assertj.core.api.Assertions.assertThat(t).isInstanceOf(#{clazz:any(java.lang.Class<T>)}).hasMessage(#{message:any(java.lang.String)}))")
                                    .bindType("java.time.Duration")
                                    .genericTypes("T extends java.lang.Throwable")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.expectError(#{clazz:any(java.lang.Class<T>)}).verifyThenAssertThat().hasOperatorErrorWithMessage(#{message:any(java.lang.String)})")
                                .bindType("reactor.test.StepVerifier.Assertions")
                                .genericTypes("T extends java.lang.Throwable")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorSatisfies((t)->org.assertj.core.api.Assertions.assertThat(t).isInstanceOf(#{clazz:any(java.lang.Class<T>)}).hasMessage(#{message:any(java.lang.String)}))")
                                    .bindType("java.time.Duration")
                                    .genericTypes("T extends java.lang.Throwable")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.expectErrorMessage(#{message:any(java.lang.String)}).verifyThenAssertThat().hasOperatorErrorOfType(#{clazz:any(java.lang.Class<T>)})")
                                .bindType("reactor.test.StepVerifier.Assertions")
                                .genericTypes("T extends java.lang.Throwable")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorSatisfies((t)->org.assertj.core.api.Assertions.assertThat(t).isInstanceOf(#{clazz:any(java.lang.Class<T>)}).hasMessage(#{message:any(java.lang.String)}))")
                                    .bindType("java.time.Duration")
                                    .genericTypes("T extends java.lang.Throwable")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3", "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesMethod<>("reactor.test.StepVerifier verifyThenAssertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.test.StepVerifier.Assertions hasOperatorErrorOfType(..)", true),
                                            new UsesMethod<>("reactor.test.StepVerifier.Assertions hasOperatorErrorWithMessage(..)", true),
                                            new UsesMethod<>("reactor.test.StepVerifier.LastStep expectError(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.test.StepVerifier.Assertions hasOperatorErrorOfType(..)", true),
                                            new UsesMethod<>("reactor.test.StepVerifier.LastStep expectErrorMessage(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("reactor.test.StepVerifier.Assertions hasOperatorErrorWithMessage(..)", true),
                                            new UsesMethod<>("reactor.test.StepVerifier.LastStep expectError(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.StepVerifierLastStepVerifyErrorMessage}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StepVerifierLastStepVerifyErrorMessageRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StepVerifierLastStepVerifyErrorMessageRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyErrorMessage`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `StepVerifier.LastStep#verifyErrorMessage(String)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.expectErrorMessage(#{message:any(java.lang.String)}).verify()")
                                .bindType("java.time.Duration")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorMessage(#{message:any(java.lang.String)})")
                                    .bindType("java.time.Duration")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesMethod<>("reactor.test.StepVerifier verify(..)", true),
                            new UsesMethod<>("reactor.test.StepVerifier.LastStep expectErrorMessage(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.StepVerifierLastStepVerifyTimeout}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StepVerifierLastStepVerifyTimeoutRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StepVerifierLastStepVerifyTimeoutRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyTimeout`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `StepVerifier.LastStep#verifyTimeout(Duration)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.expectTimeout(#{duration:any(java.time.Duration)}).verify()")
                                .bindType("java.time.Duration")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{step:any(reactor.test.StepVerifier.LastStep)}.verifyTimeout(#{duration:any(java.time.Duration)})")
                                    .bindType("java.time.Duration")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-test-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesMethod<>("reactor.test.StepVerifier verify(..)", true),
                            new UsesMethod<>("reactor.test.StepVerifier.LastStep expectTimeout(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoFromFutureSupplier}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoFromFutureSupplierRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoFromFutureSupplierRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoFromFutureSupplier`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#fromFuture(Supplier)` over `Mono#fromFuture(CompletableFuture)`, as the former may defer initiation of the asynchronous computation until subscription.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("reactor.core.publisher.Mono.fromFuture(#{future:any(java.util.concurrent.CompletableFuture<T>)})")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.fromFuture(()->#{future:any(java.util.concurrent.CompletableFuture<T>)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.concurrent.CompletableFuture", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono fromFuture(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoFromFutureSupplierBoolean}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoFromFutureSupplierBooleanRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoFromFutureSupplierBooleanRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoFromFutureSupplierBoolean`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mono#fromFuture(Supplier, boolean)` over `Mono#fromFuture(CompletableFuture, boolean)`, as the former may defer initiation of the asynchronous computation until subscription.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("reactor.core.publisher.Mono.fromFuture(#{future:any(java.util.concurrent.CompletableFuture<T>)}, #{suppressCancel:any(boolean)})")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.fromFuture(()->#{future:any(java.util.concurrent.CompletableFuture<T>)}, #{suppressCancel:any(boolean)})")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.concurrent.CompletableFuture", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono fromFuture(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoFromFutureAsyncLoadingCacheGet}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoFromFutureAsyncLoadingCacheGetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoFromFutureAsyncLoadingCacheGetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoFromFutureAsyncLoadingCacheGet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't propagate `Mono` cancellations to an upstream cache value computation, as completion of such computations may benefit concurrent or subsequent cache usages.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("reactor.core.publisher.Mono.fromFuture(()->#{cache:any(com.github.benmanes.caffeine.cache.AsyncLoadingCache<K, V>)}.get(#{key:any(K)}))")
                                .bindType("reactor.core.publisher.Mono<V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "caffeine-3", "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.fromFuture(()->#{cache:any(com.github.benmanes.caffeine.cache.AsyncLoadingCache<K, V>)}.get(#{key:any(K)}), true)")
                                    .bindType("reactor.core.publisher.Mono<V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "caffeine-3", "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.github.benmanes.caffeine.cache.AsyncLoadingCache", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("com.github.benmanes.caffeine.cache.AsyncLoadingCache get(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono fromFuture(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.MonoFromFutureAsyncLoadingCacheGetAll}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MonoFromFutureAsyncLoadingCacheGetAllRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MonoFromFutureAsyncLoadingCacheGetAllRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.MonoFromFutureAsyncLoadingCacheGetAll`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't propagate `Mono` cancellations to upstream cache value computations, as completion of such computations may benefit concurrent or subsequent cache usages.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("reactor.core.publisher.Mono.fromFuture(()->#{cache:any(com.github.benmanes.caffeine.cache.AsyncLoadingCache<K1, V>)}.getAll(#{keys:any(java.lang.Iterable<K2>)}))")
                                .bindType("reactor.core.publisher.Mono<java.util.Map<K1, V>>")
                                .genericTypes("K1", "K2 extends K1", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "caffeine-3", "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Mono.fromFuture(()->#{cache:any(com.github.benmanes.caffeine.cache.AsyncLoadingCache<K1, V>)}.getAll(#{keys:any(java.lang.Iterable<K2>)}), true)")
                                    .bindType("reactor.core.publisher.Mono<java.util.Map<K1, V>>")
                                    .genericTypes("K1", "K2 extends K1", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "caffeine-3", "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.github.benmanes.caffeine.cache.AsyncLoadingCache", true),
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("com.github.benmanes.caffeine.cache.AsyncLoadingCache getAll(..)", true),
                            new UsesMethod<>("reactor.core.publisher.Mono fromFuture(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxFromStreamSupplier}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxFromStreamSupplierRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxFromStreamSupplierRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxFromStreamSupplier`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Flux#fromStream(Supplier)` over `Flux#fromStream(Stream)`, as the former yields a `Flux` that is more likely to behave as expected when subscribed to more than once.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("reactor.core.publisher.Flux.fromStream(#{stream:any(java.util.stream.Stream<T>)})")
                                .bindType("reactor.core.publisher.Flux<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("reactor.core.publisher.Flux.fromStream(()->#{stream:any(java.util.stream.Stream<T>)})")
                                    .bindType("reactor.core.publisher.Flux<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesMethod<>("reactor.core.publisher.Flux fromStream(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ReactorRules.FluxNext}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FluxNextRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FluxNextRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ReactorRules.FluxNext`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer fluent `Flux#next()` over less explicit alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("reactor.core.publisher.Mono.from(#{flux:any(reactor.core.publisher.Flux<T>)})")
                                .bindType("reactor.core.publisher.Mono<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{flux:any(reactor.core.publisher.Flux<T>)}.next()")
                                    .bindType("reactor.core.publisher.Mono<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "reactor-core-3", "reactive-streams-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("reactor.core.publisher.Flux", true),
                            new UsesType<>("reactor.core.publisher.Mono", true),
                            new UsesMethod<>("reactor.core.publisher.Mono from(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
