package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.PrimitiveRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class PrimitiveRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public PrimitiveRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`PrimitiveRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with primitives.\n[Source](https://error-prone.picnic.tech/refasterrules/PrimitiveRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new LessThanRecipe(),
                new LessThanOrEqualToRecipe(),
                new GreaterThanRecipe(),
                new GreaterThanOrEqualToRecipe(),
                new LongToIntExactRecipe(),
                new CharacterBytesRecipe(),
                new ShortBytesRecipe(),
                new IntegerBytesRecipe(),
                new LongBytesRecipe(),
                new FloatBytesRecipe(),
                new DoubleBytesRecipe(),
                new IntegerSignumIsPositiveRecipe(),
                new IntegerSignumIsNegativeRecipe(),
                new LongSignumIsPositiveRecipe(),
                new LongSignumIsNegativeRecipe(),
                new IntegerCompareUnsignedRecipe(),
                new LongCompareUnsignedRecipe(),
                new IntegerDivideUnsignedRecipe(),
                new LongDivideUnsignedRecipe(),
                new IntegerRemainderUnsignedRecipe(),
                new LongRemainderUnsignedRecipe(),
                new IntegerParseUnsignedIntRecipe(),
                new LongParseUnsignedLongRecipe(),
                new IntegerParseUnsignedIntWithRadixRecipe(),
                new LongParseUnsignedLongWithRadixRecipe(),
                new IntegerToUnsignedStringRecipe(),
                new LongToUnsignedStringRecipe(),
                new IntegerToUnsignedStringWithRadixRecipe(),
                new LongToUnsignedStringWithRadixRecipe(),
                new ArraysCompareUnsignedBytesRecipe(),
                new ArraysCompareUnsignedIntsRecipe(),
                new ArraysCompareUnsignedLongsRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LessThan}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LessThanRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LessThanRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.LessThan`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid contrived ways of expressing the \"less than\" relationship.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S1940");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("!(#{a:any(double)} >= #{b:any(double)})").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(double)} < #{b:any(double)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LessThanOrEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LessThanOrEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LessThanOrEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.LessThanOrEqualTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid contrived ways of expressing the \"less than or equal to\" relationship.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S1940");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("!(#{a:any(double)} > #{b:any(double)})").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(double)} <= #{b:any(double)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.GreaterThan}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class GreaterThanRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public GreaterThanRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.GreaterThan`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid contrived ways of expressing the \"greater than\" relationship.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S1940");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("!(#{a:any(double)} <= #{b:any(double)})").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(double)} > #{b:any(double)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.GreaterThanOrEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class GreaterThanOrEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public GreaterThanOrEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.GreaterThanOrEqualTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid contrived ways of expressing the \"greater than or equal to\" relationship.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S1940");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("!(#{a:any(double)} < #{b:any(double)})").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(double)} >= #{b:any(double)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongToIntExact}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongToIntExactRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongToIntExactRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.LongToIntExact`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Math#toIntExact(long)` over the Guava alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.Ints.checkedCast(#{l:any(long)})")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Ints");
                        if (after == null) {
                            after = JavaTemplate.builder("Math.toIntExact(#{l:any(long)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.primitives.Ints", true),
                            new UsesMethod<>("com.google.common.primitives.Ints checkedCast(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.CharacterBytes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CharacterBytesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CharacterBytesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.CharacterBytes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Character#BYTES` over the Guava alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.Chars.BYTES")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Chars");
                        if (after == null) {
                            after = JavaTemplate.builder("Character.BYTES").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitFieldAccess(elem, ctx);
                }

                @Override
                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.Chars.BYTES")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Chars");
                        if (after == null) {
                            after = JavaTemplate.builder("Character.BYTES").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitIdentifier(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesType<>("com.google.common.primitives.Chars", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.ShortBytes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ShortBytesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ShortBytesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.ShortBytes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Short#BYTES` over the Guava alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.Shorts.BYTES")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Shorts");
                        if (after == null) {
                            after = JavaTemplate.builder("Short.BYTES").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitFieldAccess(elem, ctx);
                }

                @Override
                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.Shorts.BYTES")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Shorts");
                        if (after == null) {
                            after = JavaTemplate.builder("Short.BYTES").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitIdentifier(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesType<>("com.google.common.primitives.Shorts", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerBytes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerBytesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerBytesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.IntegerBytes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Integer#BYTES` over the Guava alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.Ints.BYTES")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Ints");
                        if (after == null) {
                            after = JavaTemplate.builder("Integer.BYTES").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitFieldAccess(elem, ctx);
                }

                @Override
                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.Ints.BYTES")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Ints");
                        if (after == null) {
                            after = JavaTemplate.builder("Integer.BYTES").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitIdentifier(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesType<>("com.google.common.primitives.Ints", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongBytes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongBytesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongBytesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.LongBytes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Long#BYTES` over the Guava alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.Longs.BYTES")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Longs");
                        if (after == null) {
                            after = JavaTemplate.builder("Long.BYTES").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitFieldAccess(elem, ctx);
                }

                @Override
                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.Longs.BYTES")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Longs");
                        if (after == null) {
                            after = JavaTemplate.builder("Long.BYTES").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitIdentifier(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesType<>("com.google.common.primitives.Longs", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.FloatBytes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FloatBytesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FloatBytesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.FloatBytes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Float#BYTES` over the Guava alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.Floats.BYTES")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Floats");
                        if (after == null) {
                            after = JavaTemplate.builder("Float.BYTES").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitFieldAccess(elem, ctx);
                }

                @Override
                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.Floats.BYTES")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Floats");
                        if (after == null) {
                            after = JavaTemplate.builder("Float.BYTES").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitIdentifier(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesType<>("com.google.common.primitives.Floats", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.DoubleBytes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class DoubleBytesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public DoubleBytesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.DoubleBytes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Double#BYTES` over the Guava alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.Doubles.BYTES")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Doubles");
                        if (after == null) {
                            after = JavaTemplate.builder("Double.BYTES").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitFieldAccess(elem, ctx);
                }

                @Override
                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.Doubles.BYTES")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.Doubles");
                        if (after == null) {
                            after = JavaTemplate.builder("Double.BYTES").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitIdentifier(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesType<>("com.google.common.primitives.Doubles", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerSignumIsPositive}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerSignumIsPositiveRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerSignumIsPositiveRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.IntegerSignumIsPositive`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer an `Integer#signum(int)` comparison to 1 over less clear alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("Integer.signum(#{i:any(int)}) > 0").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("Integer.signum(#{i:any(int)}) == 1").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("Integer.signum(#{i:any(int)}) >= 1").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("Integer.signum(#{i:any(int)}) == 1").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("java.lang.Integer signum(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerSignumIsNegative}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerSignumIsNegativeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerSignumIsNegativeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.IntegerSignumIsNegative`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer an `Integer#signum(int)` comparison to -1 over less clear alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("Integer.signum(#{i:any(int)}) < 0").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("Integer.signum(#{i:any(int)}) == -1").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("Integer.signum(#{i:any(int)}) <= -1").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("Integer.signum(#{i:any(int)}) == -1").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("java.lang.Integer signum(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongSignumIsPositive}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongSignumIsPositiveRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongSignumIsPositiveRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.LongSignumIsPositive`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer an `Long#signum(long)` comparison to 1 over less clear alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("Long.signum(#{l:any(long)}) > 0").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("Long.signum(#{l:any(long)}) == 1").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("Long.signum(#{l:any(long)}) >= 1").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("Long.signum(#{l:any(long)}) == 1").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("java.lang.Long signum(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongSignumIsNegative}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongSignumIsNegativeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongSignumIsNegativeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.LongSignumIsNegative`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer an `Long#signum(long)` comparison to -1 over less clear alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("Long.signum(#{l:any(long)}) < 0").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("Long.signum(#{l:any(long)}) == -1").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("Long.signum(#{l:any(long)}) <= -1").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("Long.signum(#{l:any(long)}) == -1").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("java.lang.Long signum(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerCompareUnsigned}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerCompareUnsignedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerCompareUnsignedRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.IntegerCompareUnsigned`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Integer#compareUnsigned(int, int)` over third-party alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.UnsignedInts.compare(#{x:any(int)}, #{y:any(int)})")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        if (after == null) {
                            after = JavaTemplate.builder("Integer.compareUnsigned(#{x:any(int)}, #{y:any(int)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.primitives.UnsignedInts", true),
                            new UsesMethod<>("com.google.common.primitives.UnsignedInts compare(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongCompareUnsigned}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongCompareUnsignedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongCompareUnsignedRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.LongCompareUnsigned`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Long#compareUnsigned(long, long)` over third-party alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.UnsignedLongs.compare(#{x:any(long)}, #{y:any(long)})")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        if (after == null) {
                            after = JavaTemplate.builder("Long.compareUnsigned(#{x:any(long)}, #{y:any(long)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.primitives.UnsignedLongs", true),
                            new UsesMethod<>("com.google.common.primitives.UnsignedLongs compare(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerDivideUnsigned}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerDivideUnsignedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerDivideUnsignedRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.IntegerDivideUnsigned`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Integer#divideUnsigned(int, int)` over third-party alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.UnsignedInts.divide(#{x:any(int)}, #{y:any(int)})")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        if (after == null) {
                            after = JavaTemplate.builder("Integer.divideUnsigned(#{x:any(int)}, #{y:any(int)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.primitives.UnsignedInts", true),
                            new UsesMethod<>("com.google.common.primitives.UnsignedInts divide(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongDivideUnsigned}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongDivideUnsignedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongDivideUnsignedRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.LongDivideUnsigned`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Long#divideUnsigned(long, long)` over third-party alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.UnsignedLongs.divide(#{x:any(long)}, #{y:any(long)})")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        if (after == null) {
                            after = JavaTemplate.builder("Long.divideUnsigned(#{x:any(long)}, #{y:any(long)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.primitives.UnsignedLongs", true),
                            new UsesMethod<>("com.google.common.primitives.UnsignedLongs divide(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerRemainderUnsigned}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerRemainderUnsignedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerRemainderUnsignedRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.IntegerRemainderUnsigned`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Integer#remainderUnsigned(int, int)` over third-party alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.UnsignedInts.remainder(#{x:any(int)}, #{y:any(int)})")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        if (after == null) {
                            after = JavaTemplate.builder("Integer.remainderUnsigned(#{x:any(int)}, #{y:any(int)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.primitives.UnsignedInts", true),
                            new UsesMethod<>("com.google.common.primitives.UnsignedInts remainder(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongRemainderUnsigned}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongRemainderUnsignedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongRemainderUnsignedRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.LongRemainderUnsigned`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Long#remainderUnsigned(long, long)` over third-party alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.UnsignedLongs.remainder(#{x:any(long)}, #{y:any(long)})")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        if (after == null) {
                            after = JavaTemplate.builder("Long.remainderUnsigned(#{x:any(long)}, #{y:any(long)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.primitives.UnsignedLongs", true),
                            new UsesMethod<>("com.google.common.primitives.UnsignedLongs remainder(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerParseUnsignedInt}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerParseUnsignedIntRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerParseUnsignedIntRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.IntegerParseUnsignedInt`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Integer#parseUnsignedInt(String)` over third-party or more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.primitives.UnsignedInts.parseUnsignedInt(#{string:any(java.lang.String)})")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        if (after == null) {
                            after = JavaTemplate.builder("Integer.parseUnsignedInt(#{string:any(java.lang.String)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("Integer.parseUnsignedInt(#{string:any(java.lang.String)}, 10)")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("Integer.parseUnsignedInt(#{string:any(java.lang.String)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            new UsesMethod<>("java.lang.Integer parseUnsignedInt(..)", true),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.primitives.UnsignedInts", true),
                                    new UsesMethod<>("com.google.common.primitives.UnsignedInts parseUnsignedInt(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongParseUnsignedLong}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongParseUnsignedLongRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongParseUnsignedLongRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.LongParseUnsignedLong`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Long#parseUnsignedLong(String)` over third-party or more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.primitives.UnsignedLongs.parseUnsignedLong(#{string:any(java.lang.String)})")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        if (after == null) {
                            after = JavaTemplate.builder("Long.parseUnsignedLong(#{string:any(java.lang.String)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("Long.parseUnsignedLong(#{string:any(java.lang.String)}, 10)")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("Long.parseUnsignedLong(#{string:any(java.lang.String)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            new UsesMethod<>("java.lang.Long parseUnsignedLong(..)", true),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.primitives.UnsignedLongs", true),
                                    new UsesMethod<>("com.google.common.primitives.UnsignedLongs parseUnsignedLong(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerParseUnsignedIntWithRadix}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerParseUnsignedIntWithRadixRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerParseUnsignedIntWithRadixRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.IntegerParseUnsignedIntWithRadix`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Integer#parseUnsignedInt(String, int)` over third-party alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.UnsignedInts.parseUnsignedInt(#{string:any(java.lang.String)}, #{radix:any(int)})")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        if (after == null) {
                            after = JavaTemplate.builder("Integer.parseUnsignedInt(#{string:any(java.lang.String)}, #{radix:any(int)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.primitives.UnsignedInts", true),
                            new UsesMethod<>("com.google.common.primitives.UnsignedInts parseUnsignedInt(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongParseUnsignedLongWithRadix}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongParseUnsignedLongWithRadixRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongParseUnsignedLongWithRadixRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.LongParseUnsignedLongWithRadix`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Long#parseUnsignedLong(String, int)` over third-party alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.UnsignedLongs.parseUnsignedLong(#{string:any(java.lang.String)}, #{radix:any(int)})")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        if (after == null) {
                            after = JavaTemplate.builder("Long.parseUnsignedLong(#{string:any(java.lang.String)}, #{radix:any(int)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.primitives.UnsignedLongs", true),
                            new UsesMethod<>("com.google.common.primitives.UnsignedLongs parseUnsignedLong(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerToUnsignedString}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerToUnsignedStringRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerToUnsignedStringRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.IntegerToUnsignedString`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Integer#toUnsignedString(int)` over third-party or more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.primitives.UnsignedInts.toString(#{i:any(int)})")
                                .bindType("java.lang.String")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        if (after == null) {
                            after = JavaTemplate.builder("Integer.toUnsignedString(#{i:any(int)})")
                                    .bindType("java.lang.String").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("Integer.toUnsignedString(#{i:any(int)}, 10)")
                                .bindType("java.lang.String")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("Integer.toUnsignedString(#{i:any(int)})")
                                    .bindType("java.lang.String").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            new UsesMethod<>("java.lang.Integer toUnsignedString(..)", true),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.primitives.UnsignedInts", true),
                                    new UsesMethod<>("com.google.common.primitives.UnsignedInts toString(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongToUnsignedString}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongToUnsignedStringRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongToUnsignedStringRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.LongToUnsignedString`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Long#toUnsignedString(long)` over third-party or more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.primitives.UnsignedLongs.toString(#{i:any(long)})")
                                .bindType("java.lang.String")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        if (after == null) {
                            after = JavaTemplate.builder("Long.toUnsignedString(#{i:any(long)})")
                                    .bindType("java.lang.String").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("Long.toUnsignedString(#{i:any(long)}, 10)")
                                .bindType("java.lang.String")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("Long.toUnsignedString(#{i:any(long)})")
                                    .bindType("java.lang.String").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            new UsesMethod<>("java.lang.Long toUnsignedString(..)", true),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.primitives.UnsignedLongs", true),
                                    new UsesMethod<>("com.google.common.primitives.UnsignedLongs toString(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.IntegerToUnsignedStringWithRadix}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IntegerToUnsignedStringWithRadixRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IntegerToUnsignedStringWithRadixRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.IntegerToUnsignedStringWithRadix`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Integer#toUnsignedString(int,int)` over third-party alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.UnsignedInts.toString(#{i:any(int)}, #{radix:any(int)})")
                                .bindType("java.lang.String")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        if (after == null) {
                            after = JavaTemplate.builder("Integer.toUnsignedString(#{i:any(int)}, #{radix:any(int)})")
                                    .bindType("java.lang.String").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.primitives.UnsignedInts", true),
                            new UsesMethod<>("com.google.common.primitives.UnsignedInts toString(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.LongToUnsignedStringWithRadix}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LongToUnsignedStringWithRadixRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LongToUnsignedStringWithRadixRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.LongToUnsignedStringWithRadix`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Long#toUnsignedString(long,int)` over third-party alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.UnsignedLongs.toString(#{i:any(long)}, #{radix:any(int)})")
                                .bindType("java.lang.String")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        if (after == null) {
                            after = JavaTemplate.builder("Long.toUnsignedString(#{i:any(long)}, #{radix:any(int)})")
                                    .bindType("java.lang.String").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.primitives.UnsignedLongs", true),
                            new UsesMethod<>("com.google.common.primitives.UnsignedLongs toString(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.ArraysCompareUnsignedBytes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ArraysCompareUnsignedBytesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ArraysCompareUnsignedBytesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.ArraysCompareUnsignedBytes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Arrays#compareUnsigned(byte[], byte[])` over third-party alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.UnsignedBytes.lexicographicalComparator()")
                                .bindType("java.util.Comparator<byte[]>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedBytes");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Arrays::compareUnsigned")
                                    .bindType("java.util.Comparator<byte[]>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.primitives.UnsignedBytes", true),
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("com.google.common.primitives.UnsignedBytes lexicographicalComparator(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.ArraysCompareUnsignedInts}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ArraysCompareUnsignedIntsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ArraysCompareUnsignedIntsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.ArraysCompareUnsignedInts`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Arrays#compareUnsigned(int[], int[])` over third-party alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.UnsignedInts.lexicographicalComparator()")
                                .bindType("java.util.Comparator<int[]>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedInts");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Arrays::compareUnsigned")
                                    .bindType("java.util.Comparator<int[]>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.primitives.UnsignedInts", true),
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("com.google.common.primitives.UnsignedInts lexicographicalComparator(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PrimitiveRules.ArraysCompareUnsignedLongs}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ArraysCompareUnsignedLongsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ArraysCompareUnsignedLongsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PrimitiveRules.ArraysCompareUnsignedLongs`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer JDK's `Arrays#compareUnsigned(long[], long[])` over third-party alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.primitives.UnsignedLongs.lexicographicalComparator()")
                                .bindType("java.util.Comparator<long[]>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.primitives.UnsignedLongs");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Arrays::compareUnsigned")
                                    .bindType("java.util.Comparator<long[]>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.primitives.UnsignedLongs", true),
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("com.google.common.primitives.UnsignedLongs lexicographicalComparator(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
