package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.PatternRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class PatternRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public PatternRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`PatternRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to code dealing with regular expressions.\n[Source](https://error-prone.picnic.tech/refasterrules/PatternRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new PatternAsPredicateRecipe(),
                new PatternCompileAsPredicateRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PatternRules.PatternAsPredicate}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PatternAsPredicateRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PatternAsPredicateRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PatternRules.PatternAsPredicate`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Pattern#asPredicate()` over non-JDK alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.base.Predicates.contains(#{pattern:any(java.util.regex.Pattern)})")
                                .bindType("java.util.function.Predicate<java.lang.CharSequence>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.base.Predicates");
                        if (after == null) {
                            after = JavaTemplate.builder("#{pattern:any(java.util.regex.Pattern)}.asPredicate()")
                                    .bindType("java.util.function.Predicate<java.lang.String>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.base.Predicates", true),
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesType<>("java.util.regex.Pattern", true),
                            new UsesMethod<>("com.google.common.base.Predicates contains(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code PatternRules.PatternCompileAsPredicate}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PatternCompileAsPredicateRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PatternCompileAsPredicateRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `PatternRules.PatternCompileAsPredicate`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Pattern#asPredicate()` over non-JDK alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.base.Predicates.containsPattern(#{pattern:any(java.lang.String)})")
                                .bindType("java.util.function.Predicate<java.lang.CharSequence>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.base.Predicates");
                        maybeRemoveImport("com.google.common.base.Predicates.containsPattern");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.regex.Pattern.compile(#{pattern:any(java.lang.String)}).asPredicate()")
                                    .bindType("java.util.function.Predicate<java.lang.String>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesMethod<>("com.google.common.base.Predicates containsPattern(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
