package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.OptionalRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class OptionalRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public OptionalRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`OptionalRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `Optional`s.\n[Source](https://error-prone.picnic.tech/refasterrules/OptionalRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new OptionalEmptyRecipe(),
                new OptionalOfNullableRecipe(),
                new OptionalIsEmptyRecipe(),
                new OptionalIsPresentRecipe(),
                new OptionalOrElseThrowRecipe(),
                new OptionalOrElseThrowMethodReferenceRecipe(),
                new OptionalEqualsOptionalRecipe(),
                new OptionalFirstIteratorElementRecipe(),
                new MapOptionalToBooleanRecipe(),
                new OrOrElseThrowRecipe(),
                new StreamFlatMapOptionalRecipe(),
                new OptionalOrOtherOptionalRecipe(),
                new OptionalFilterRecipe(),
                new OptionalMapRecipe(),
                new OptionalStreamRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code OptionalRules.OptionalEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OptionalEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OptionalEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `OptionalRules.OptionalEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Optional#empty()` over the more contrived alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.Optional.ofNullable(null)")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Optional.empty()")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesMethod<>("java.util.Optional ofNullable(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code OptionalRules.OptionalOfNullable}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OptionalOfNullableRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OptionalOfNullableRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `OptionalRules.OptionalOfNullable`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OptionalOfNullable<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"TernaryOperatorOptionalNegativeFiltering\")\n    Optional<T> before(@Nullable\n    T object) {\n        return object == null ? Optional.empty() : Optional.of(object);\n    }\n    \n    @AfterTemplate\n    Optional<T> after(T object) {\n        return Optional.ofNullable(object);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitTernary(J.Ternary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{object:any(T)} == null ? java.util.Optional.empty() : java.util.Optional.of(#{object})")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Optional.ofNullable(#{object:any(T)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitTernary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesMethod<>("java.util.Optional empty(..)", true),
                            new UsesMethod<>("java.util.Optional of(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code OptionalRules.OptionalIsEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OptionalIsEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OptionalIsEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `OptionalRules.OptionalIsEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Optional#isEmpty()` over the more verbose alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("!#{optional:any(java.util.Optional<T>)}.isPresent()")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.isEmpty()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesMethod<>("java.util.Optional isPresent(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code OptionalRules.OptionalIsPresent}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OptionalIsPresentRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OptionalIsPresentRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `OptionalRules.OptionalIsPresent`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Optional#isPresent()` over the inverted alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("!#{optional:any(java.util.Optional<T>)}.isEmpty()")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.isPresent()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesMethod<>("java.util.Optional isEmpty(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code OptionalRules.OptionalOrElseThrow}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OptionalOrElseThrowRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OptionalOrElseThrowRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `OptionalRules.OptionalOrElseThrow`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Optional#orElseThrow()` over the less explicit `Optional#get()`.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S3655");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.get()")
                                .bindType("T")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.orElseThrow()")
                                    .bindType("T")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesMethod<>("java.util.Optional get(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code OptionalRules.OptionalOrElseThrowMethodReference}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OptionalOrElseThrowMethodReferenceRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OptionalOrElseThrowMethodReferenceRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `OptionalRules.OptionalOrElseThrowMethodReference`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Optional#orElseThrow()` over the less explicit `Optional#get()`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitExpression(Expression elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.Optional::get")
                                .bindType("java.util.function.Function<java.util.Optional<T>, T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Optional::orElseThrow")
                                    .bindType("java.util.function.Function<java.util.Optional<T>, T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitExpression(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("java.util.function.Function", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code OptionalRules.OptionalEqualsOptional}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OptionalEqualsOptionalRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OptionalEqualsOptionalRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `OptionalRules.OptionalEqualsOptional`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Optional#equals(Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.filter(#{value:any(S)}::equals).isPresent()")
                                .genericTypes("T", "S").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.equals(java.util.Optional.of(#{value:any(S)}))")
                                    .genericTypes("T", "S").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.stream().anyMatch(#{value:any(S)}::equals)")
                                .genericTypes("T", "S").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.equals(java.util.Optional.of(#{value:any(S)}))")
                                    .genericTypes("T", "S").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Optional filter(..)", true),
                                            new UsesMethod<>("java.util.Optional isPresent(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Optional stream(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream anyMatch(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code OptionalRules.OptionalFirstIteratorElement}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OptionalFirstIteratorElementRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OptionalFirstIteratorElementRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `OptionalRules.OptionalFirstIteratorElement`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't use the ternary operator to extract the first element of a possibly-empty `Iterator` as an `Optional`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitTernary(J.Ternary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{it:any(java.util.Iterator<T>)}.hasNext() ? java.util.Optional.of(#{it}.next()) : java.util.Optional.empty()")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{it:any(java.util.Iterator<T>)}).findFirst()")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitTernary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Iterator", true),
                            new UsesType<>("java.util.Optional", true),
                            new UsesMethod<>("java.util.Iterator hasNext(..)", true),
                            new UsesMethod<>("java.util.Iterator next(..)", true),
                            new UsesMethod<>("java.util.Optional empty(..)", true),
                            new UsesMethod<>("java.util.Optional of(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code OptionalRules.MapOptionalToBoolean}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MapOptionalToBooleanRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MapOptionalToBooleanRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `OptionalRules.MapOptionalToBoolean`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Optional#filter(Predicate)` over `Optional#map(Function)` when converting an `Optional` to a boolean.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.map(#{predicate:any(java.util.function.Function<? super T, java.lang.Boolean>)}).orElse(false)")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Function");
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)}).isPresent()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("java.util.function.Function", true),
                            new UsesMethod<>("java.util.Optional map(..)", true),
                            new UsesMethod<>("java.util.Optional orElse(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code OptionalRules.OrOrElseThrow}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OrOrElseThrowRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OrOrElseThrowRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `OptionalRules.OrOrElseThrow`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OrOrElseThrow<T> {\n    \n    @BeforeTemplate\n    T before(Optional<T> o1, Optional<T> o2) {\n        return o1.orElseGet(()->o2.orElseThrow());\n    }\n    \n    @AfterTemplate\n    T after(Optional<T> o1, Optional<T> o2) {\n        return o1.or(()->o2).orElseThrow();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{o1:any(java.util.Optional<T>)}.orElseGet(()->#{o2:any(java.util.Optional<T>)}.orElseThrow())")
                                .bindType("T")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{o1:any(java.util.Optional<T>)}.or(()->#{o2:any(java.util.Optional<T>)}).orElseThrow()")
                                    .bindType("T")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesMethod<>("java.util.Optional orElseGet(..)", true),
                            new UsesMethod<>("java.util.Optional orElseThrow(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code OptionalRules.StreamFlatMapOptional}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamFlatMapOptionalRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamFlatMapOptionalRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `OptionalRules.StreamFlatMapOptional`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Flatten a stream of `Optional`s using `Optional#stream()`, rather than using one of the more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<java.util.Optional<T>>)}.filter(java.util.Optional::isPresent).map(java.util.Optional::orElseThrow)")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<java.util.Optional<T>>)}.flatMap(java.util.Optional::stream)")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<java.util.Optional<T>>)}.flatMap(com.google.common.collect.Streams::stream)")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<java.util.Optional<T>>)}.flatMap(java.util.Optional::stream)")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.stream.Stream filter(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream map(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Streams", true),
                                            new UsesMethod<>("java.util.stream.Stream flatMap(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code OptionalRules.OptionalOrOtherOptional}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OptionalOrOtherOptionalRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OptionalOrOtherOptionalRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `OptionalRules.OptionalOrOtherOptional`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Optional#or(Supplier)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{optional1:any(java.util.Optional<T>)}.map(java.util.Optional::of).orElse(#{optional2:any(java.util.Optional<T>)})")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional1:any(java.util.Optional<T>)}.or(()->#{optional2:any(java.util.Optional<T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{optional1:any(java.util.Optional<T>)}.map(java.util.Optional::of).orElseGet(()->#{optional2:any(java.util.Optional<T>)})")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional1:any(java.util.Optional<T>)}.or(()->#{optional2:any(java.util.Optional<T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.util.stream.Stream.of(#{optional1:any(java.util.Optional<T>)}, #{optional2:any(java.util.Optional<T>)}).flatMap(java.util.Optional::stream).findFirst()")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Stream");
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional1:any(java.util.Optional<T>)}.or(()->#{optional2:any(java.util.Optional<T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{optional1:any(java.util.Optional<T>)}.isPresent() ? #{optional1} : #{optional2:any(java.util.Optional<T>)}")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional1:any(java.util.Optional<T>)}.or(()->#{optional2:any(java.util.Optional<T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

                @Override
                public J visitTernary(J.Ternary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{optional1:any(java.util.Optional<T>)}.map(java.util.Optional::of).orElse(#{optional2:any(java.util.Optional<T>)})")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional1:any(java.util.Optional<T>)}.or(()->#{optional2:any(java.util.Optional<T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{optional1:any(java.util.Optional<T>)}.map(java.util.Optional::of).orElseGet(()->#{optional2:any(java.util.Optional<T>)})")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional1:any(java.util.Optional<T>)}.or(()->#{optional2:any(java.util.Optional<T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.util.stream.Stream.of(#{optional1:any(java.util.Optional<T>)}, #{optional2:any(java.util.Optional<T>)}).flatMap(java.util.Optional::stream).findFirst()")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Stream");
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional1:any(java.util.Optional<T>)}.or(()->#{optional2:any(java.util.Optional<T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{optional1:any(java.util.Optional<T>)}.isPresent() ? #{optional1} : #{optional2:any(java.util.Optional<T>)}")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional1:any(java.util.Optional<T>)}.or(()->#{optional2:any(java.util.Optional<T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitTernary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Optional isPresent(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Optional map(..)", true),
                                            new UsesMethod<>("java.util.Optional orElse(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Optional map(..)", true),
                                            new UsesMethod<>("java.util.Optional orElseGet(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.stream.Stream", true),
                                            new UsesMethod<>("java.util.stream.Stream findFirst(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream flatMap(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code OptionalRules.OptionalFilter}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OptionalFilterRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OptionalFilterRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `OptionalRules.OptionalFilter`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid unnecessary `Optional` to `Stream` conversion when filtering a value of the former type.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.stream().filter(#{predicate:any(java.util.function.Predicate<? super T>)}).findFirst()")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.stream().filter(#{predicate:any(java.util.function.Predicate<? super T>)}).findAny()")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)})")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesMethod<>("java.util.Optional stream(..)", true),
                            new UsesMethod<>("java.util.stream.Stream filter(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.stream.Stream findAny(..)", true),
                                    new UsesMethod<>("java.util.stream.Stream findFirst(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code OptionalRules.OptionalMap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OptionalMapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OptionalMapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `OptionalRules.OptionalMap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid unnecessary `Optional` to `Stream` conversion when mapping a value of the former type.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{optional:any(java.util.Optional<S>)}.stream().map(#{function:any(java.util.function.Function<? super S, ? extends T>)}).findAny()")
                                .bindType("java.util.Optional<? extends T>")
                                .genericTypes("S", "T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional:any(java.util.Optional<S>)}.map(#{function:any(java.util.function.Function<? super S, ? extends T>)})")
                                    .bindType("java.util.Optional<? extends T>")
                                    .genericTypes("S", "T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("java.util.function.Function", true),
                            new UsesMethod<>("java.util.Optional stream(..)", true),
                            new UsesMethod<>("java.util.stream.Stream findAny(..)", true),
                            new UsesMethod<>("java.util.stream.Stream map(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code OptionalRules.OptionalStream}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OptionalStreamRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OptionalStreamRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `OptionalRules.OptionalStream`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Optional#stream()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.map(java.util.stream.Stream::of).orElseGet(java.util.stream.Stream::empty)")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{optional:any(java.util.Optional<T>)}.stream()")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.Optional map(..)", true),
                            new UsesMethod<>("java.util.Optional orElseGet(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
