package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.NullRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class NullRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public NullRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`NullRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with (possibly) null values.\n[Source](https://error-prone.picnic.tech/refasterrules/NullRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new IsNullRecipe(),
                new IsNotNullRecipe(),
                new RequireNonNullElseRecipe(),
                new RequireNonNullElseGetRecipe(),
                new IsNullFunctionRecipe(),
                new NonNullFunctionRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code NullRules.IsNull}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IsNullRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IsNullRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `NullRules.IsNull`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer the `==` operator (with `null` as the second operand) over `Objects#isNull(Object)`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("null == #{object:any(java.lang.Object)}")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{object:any(java.lang.Object)} == null")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Objects.isNull(#{object:any(java.lang.Object)})")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Objects");
                        if (after == null) {
                            after = JavaTemplate.builder("#{object:any(java.lang.Object)} == null")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("null == #{object:any(java.lang.Object)}")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{object:any(java.lang.Object)} == null")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Objects.isNull(#{object:any(java.lang.Object)})")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Objects");
                        if (after == null) {
                            after = JavaTemplate.builder("#{object:any(java.lang.Object)} == null")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code NullRules.IsNotNull}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IsNotNullRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IsNotNullRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `NullRules.IsNotNull`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer the `!=` operator (with `null` as the second operand) over `Objects#nonNull(Object)`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("null != #{object:any(java.lang.Object)}")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{object:any(java.lang.Object)} != null")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Objects.nonNull(#{object:any(java.lang.Object)})")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Objects");
                        if (after == null) {
                            after = JavaTemplate.builder("#{object:any(java.lang.Object)} != null")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("null != #{object:any(java.lang.Object)}")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{object:any(java.lang.Object)} != null")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Objects.nonNull(#{object:any(java.lang.Object)})")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Objects");
                        if (after == null) {
                            after = JavaTemplate.builder("#{object:any(java.lang.Object)} != null")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "jspecify-1"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code NullRules.RequireNonNullElse}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class RequireNonNullElseRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public RequireNonNullElseRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `NullRules.RequireNonNullElse`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Objects#requireNonNullElse(Object, Object)` over non-JDK or more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.base.MoreObjects.firstNonNull(#{first:any(T)}, #{second:any(T)})")
                                .bindType("T")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.base.MoreObjects");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Objects.requireNonNullElse(#{first:any(T)}, #{second:any(T)})")
                                    .bindType("T")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Optional.ofNullable(#{first:any(T)}).orElse(#{second:any(T)})")
                                .bindType("T")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Optional");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Objects.requireNonNullElse(#{first:any(T)}, #{second:any(T)})")
                                    .bindType("T")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            Preconditions.and(
                                    new UsesType<>("com.google.common.base.MoreObjects", true),
                                    new UsesMethod<>("com.google.common.base.MoreObjects firstNonNull(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("java.util.Optional", true),
                                    new UsesMethod<>("java.util.Optional ofNullable(..)", true),
                                    new UsesMethod<>("java.util.Optional orElse(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code NullRules.RequireNonNullElseGet}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class RequireNonNullElseGetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public RequireNonNullElseGetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `NullRules.RequireNonNullElseGet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Objects#requireNonNullElseGet(Object, Supplier)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.Optional.ofNullable(#{object:any(T)}).orElseGet(#{supplier:any(java.util.function.Supplier<S>)})")
                                .bindType("T")
                                .genericTypes("T", "S extends T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Optional");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Objects.requireNonNullElseGet(#{object:any(T)}, #{supplier:any(java.util.function.Supplier<S>)})")
                                    .bindType("T")
                                    .genericTypes("T", "S extends T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("java.util.function.Supplier", true),
                            new UsesMethod<>("java.util.Optional ofNullable(..)", true),
                            new UsesMethod<>("java.util.Optional orElseGet(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code NullRules.IsNullFunction}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IsNullFunctionRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IsNullFunctionRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `NullRules.IsNullFunction`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Objects#isNull(Object)` over the equivalent lambda function or more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("(o)->o == null")
                                .bindType("java.util.function.Predicate<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Objects::isNull")
                                    .bindType("java.util.function.Predicate<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.function.Predicate.not(java.util.Objects::nonNull)")
                                .bindType("java.util.function.Predicate<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Predicate");
                        maybeRemoveImport("java.util.function.Predicate.not");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Objects::isNull")
                                    .bindType("java.util.function.Predicate<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitLambda(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("(o)->o == null")
                                .bindType("java.util.function.Predicate<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Objects::isNull")
                                    .bindType("java.util.function.Predicate<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.function.Predicate.not(java.util.Objects::nonNull)")
                                .bindType("java.util.function.Predicate<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Predicate");
                        maybeRemoveImport("java.util.function.Predicate.not");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Objects::isNull")
                                    .bindType("java.util.function.Predicate<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesType<>("java.util.function.Predicate", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code NullRules.NonNullFunction}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class NonNullFunctionRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public NonNullFunctionRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `NullRules.NonNullFunction`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Objects#nonNull(Object)` over the equivalent lambda function or more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("(o)->o != null")
                                .bindType("java.util.function.Predicate<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Objects::nonNull")
                                    .bindType("java.util.function.Predicate<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.function.Predicate.not(java.util.Objects::isNull)")
                                .bindType("java.util.function.Predicate<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Predicate");
                        maybeRemoveImport("java.util.function.Predicate.not");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Objects::nonNull")
                                    .bindType("java.util.function.Predicate<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitLambda(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("(o)->o != null")
                                .bindType("java.util.function.Predicate<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Objects::nonNull")
                                    .bindType("java.util.function.Predicate<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.function.Predicate.not(java.util.Objects::isNull)")
                                .bindType("java.util.function.Predicate<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Predicate");
                        maybeRemoveImport("java.util.function.Predicate.not");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Objects::nonNull")
                                    .bindType("java.util.function.Predicate<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesType<>("java.util.function.Predicate", true),
                    javaVisitor
            );
        }
    }

}
