package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.MultimapRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class MultimapRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public MultimapRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`MultimapRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `Multimap`s.\n[Source](https://error-prone.picnic.tech/refasterrules/MultimapRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new MultimapKeySetRecipe(),
                new MultimapIsEmptyRecipe(),
                new MultimapSizeRecipe(),
                new MultimapContainsKeyRecipe(),
                new MultimapContainsValueRecipe(),
                new MultimapGetRecipe(),
                new MultimapKeysStreamRecipe(),
                new MultimapValuesStreamRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MultimapRules.MultimapKeySet}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MultimapKeySetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MultimapKeySetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MultimapRules.MultimapKeySet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Multimap#keySet()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.asMap().keySet()")
                                .bindType("java.util.Set<K>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.keySet()")
                                    .bindType("java.util.Set<K>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Multimap", true),
                            new UsesType<>("java.util.Set", true),
                            new UsesMethod<>("com.google.common.collect.Multimap asMap(..)", true),
                            new UsesMethod<>("java.util.Map keySet(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MultimapRules.MultimapIsEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MultimapIsEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MultimapIsEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MultimapRules.MultimapIsEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Multimap#isEmpty()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.keySet().isEmpty()")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.isEmpty()")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.keys().isEmpty()")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.isEmpty()")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.values().isEmpty()")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.isEmpty()")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.entries().isEmpty()")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.isEmpty()")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Multimap", true),
                            new UsesMethod<>("java.util.Collection isEmpty(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("com.google.common.collect.Multimap entries(..)", true),
                                    new UsesMethod<>("com.google.common.collect.Multimap keySet(..)", true),
                                    new UsesMethod<>("com.google.common.collect.Multimap keys(..)", true),
                                    new UsesMethod<>("com.google.common.collect.Multimap values(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MultimapRules.MultimapSize}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MultimapSizeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MultimapSizeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MultimapRules.MultimapSize`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Multimap#size()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.values().size()")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.size()")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Multimap", true),
                            new UsesMethod<>("com.google.common.collect.Multimap values(..)", true),
                            new UsesMethod<>("java.util.Collection size(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MultimapRules.MultimapContainsKey}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MultimapContainsKeyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MultimapContainsKeyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MultimapRules.MultimapContainsKey`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Multimap#containsKey(Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.keySet().contains(#{key:any(T)})")
                                .genericTypes("K", "V", "T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.containsKey(#{key:any(T)})")
                                    .genericTypes("K", "V", "T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.keys().contains(#{key:any(T)})")
                                .genericTypes("K", "V", "T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.containsKey(#{key:any(T)})")
                                    .genericTypes("K", "V", "T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Multimap", true),
                            new UsesMethod<>("java.util.Collection contains(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("com.google.common.collect.Multimap keySet(..)", true),
                                    new UsesMethod<>("com.google.common.collect.Multimap keys(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MultimapRules.MultimapContainsValue}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MultimapContainsValueRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MultimapContainsValueRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MultimapRules.MultimapContainsValue`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Multimap#containsValue(Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.values().contains(#{value:any(T)})")
                                .genericTypes("K", "V", "T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.containsValue(#{value:any(T)})")
                                    .genericTypes("K", "V", "T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Multimap", true),
                            new UsesMethod<>("com.google.common.collect.Multimap values(..)", true),
                            new UsesMethod<>("java.util.Collection contains(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MultimapRules.MultimapGet}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MultimapGetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MultimapGetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Prefer `Multimap#get(Object)` over more contrived alternatives";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "<strong>Warning:</strong> this rewrite rule is not completely behavior preserving: the\n original code will yield `null` for unknown keys, while the replacement code will return\n an empty collection for unknown keys.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.asMap().get(#{key:any(K)})")
                                .bindType("java.util.Collection<V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.get(#{key:any(K)})")
                                    .bindType("java.util.Collection<V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.Multimaps.asMap(#{multimap:any(com.google.common.collect.Multimap<K, V>)}).get(#{key:any(K)})")
                                .bindType("java.util.Collection<V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Multimaps");
                        if (after == null) {
                            after = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.get(#{key:any(K)})")
                                    .bindType("java.util.Collection<V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Multimap", true),
                            new UsesType<>("java.util.Collection", true),
                            new UsesMethod<>("java.util.Map get(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("com.google.common.collect.Multimap asMap(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Multimaps", true),
                                            new UsesMethod<>("com.google.common.collect.Multimaps asMap(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MultimapRules.MultimapKeysStream}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MultimapKeysStreamRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MultimapKeysStreamRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MultimapRules.MultimapKeysStream`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily use `Multimap#entries()`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.entries().stream().map(java.util.Map.Entry::getKey)")
                                .bindType("java.util.stream.Stream<K>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.keys().stream()")
                                    .bindType("java.util.stream.Stream<K>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Multimap", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.Multimap entries(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.stream.Stream map(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MultimapRules.MultimapValuesStream}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class MultimapValuesStreamRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public MultimapValuesStreamRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MultimapRules.MultimapValuesStream`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily use `Multimap#entries()`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.entries().stream().map(java.util.Map.Entry::getValue)")
                                .bindType("java.util.stream.Stream<V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V>)}.values().stream()")
                                    .bindType("java.util.stream.Stream<V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Multimap", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.Multimap entries(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.stream.Stream map(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
