package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.MockitoRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class MockitoRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public MockitoRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`MockitoRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to Mockito expressions and statements.\n[Source](https://error-prone.picnic.tech/refasterrules/MockitoRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new NeverRecipe(),
                new VerifyOnceRecipe(),
                new InvocationOnMockGetArgumentsRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MockitoRules.Never}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class NeverRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public NeverRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MockitoRules.Never`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mockito#never()`} over explicitly specifying that the associated invocation must happen precisely zero times.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.mockito.Mockito.times(0)")
                                .bindType("org.mockito.verification.VerificationMode")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "mockito-core-5"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.mockito.Mockito");
                        maybeRemoveImport("org.mockito.Mockito.times");
                        if (after == null) {
                            after = JavaTemplate.builder("org.mockito.Mockito.never()")
                                    .bindType("org.mockito.verification.VerificationMode")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "mockito-core-5"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.mockito.verification.VerificationMode", true),
                            new UsesMethod<>("org.mockito.Mockito times(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MockitoRules.VerifyOnce}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class VerifyOnceRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public VerifyOnceRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MockitoRules.VerifyOnce`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Mockito#verify(Object)` over explicitly specifying that the associated invocation must happen precisely once; this is the default behavior.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.mockito.Mockito.verify(#{mock:any(T)}, org.mockito.Mockito.times(1))")
                                .bindType("T")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "mockito-core-5"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.mockito.Mockito");
                        maybeRemoveImport("org.mockito.Mockito.times");
                        if (after == null) {
                            after = JavaTemplate.builder("org.mockito.Mockito.verify(#{mock:any(T)})")
                                    .bindType("T")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "mockito-core-5"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesMethod<>("org.mockito.Mockito times(..)", true),
                            new UsesMethod<>("org.mockito.Mockito verify(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code MockitoRules.InvocationOnMockGetArguments}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class InvocationOnMockGetArgumentsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public InvocationOnMockGetArgumentsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `MockitoRules.InvocationOnMockGetArguments`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class InvocationOnMockGetArguments {\n    \n    @BeforeTemplate\n    Object before(InvocationOnMock invocation, int i) {\n        return invocation.getArguments()[i];\n    }\n    \n    @AfterTemplate\n    Object after(InvocationOnMock invocation, int i) {\n        return invocation.getArgument(i);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitExpression(Expression elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{invocation:any(org.mockito.invocation.InvocationOnMock)}.getArguments()[#{i:any(int)}]")
                                .bindType("java.lang.Object")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "mockito-core-5"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{invocation:any(org.mockito.invocation.InvocationOnMock)}.getArgument(#{i:any(int)})")
                                    .bindType("java.lang.Object")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "mockito-core-5"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitExpression(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.mockito.invocation.InvocationOnMock", true),
                            new UsesMethod<>("org.mockito.invocation.InvocationOnMock getArguments(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
