package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.ImmutableTableRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class ImmutableTableRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public ImmutableTableRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`ImmutableTableRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `ImmutableTable`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableTableRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new ImmutableTableBuilderRecipe(),
                new ImmutableTableBuilderBuildOrThrowRecipe(),
                new CellToImmutableTableRecipe(),
                new ImmutableTableOfRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableTableRules.ImmutableTableBuilder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableTableBuilderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableTableBuilderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableTableRules.ImmutableTableBuilder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableTable#builder()` over the associated constructor.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("new com.google.common.collect.ImmutableTable.Builder<>()")
                                .bindType("com.google.common.collect.ImmutableTable.Builder<R, C, V>")
                                .genericTypes("R", "C", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableTable.builder()")
                                    .bindType("com.google.common.collect.ImmutableTable.Builder<R, C, V>")
                                    .genericTypes("R", "C", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("com.google.common.collect.ImmutableTable.Builder <init>(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableTableRules.ImmutableTableBuilderBuildOrThrow}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableTableBuilderBuildOrThrowRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableTableBuilderBuildOrThrowRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableTableRules.ImmutableTableBuilderBuildOrThrow`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableTable.Builder#buildOrThrow()` over the less explicit `ImmutableTable.Builder#build()`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{builder:any(com.google.common.collect.ImmutableTable.Builder<R, C, V>)}.build()")
                                .bindType("com.google.common.collect.ImmutableTable<R, C, V>")
                                .genericTypes("R", "C", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{builder:any(com.google.common.collect.ImmutableTable.Builder<R, C, V>)}.buildOrThrow()")
                                    .bindType("com.google.common.collect.ImmutableTable<R, C, V>")
                                    .genericTypes("R", "C", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableTable", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableTable.Builder build(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableTableRules.CellToImmutableTable}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CellToImmutableTableRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CellToImmutableTableRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableTableRules.CellToImmutableTable`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableTable#of(Object, Object, Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableTable.<R, C, V>builder().put(#{cell:any(com.google.common.collect.Table.Cell<? extends R, ? extends C, ? extends V>)}).buildOrThrow()")
                                .bindType("com.google.common.collect.ImmutableTable<R, C, V>")
                                .genericTypes("R", "C", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableTable.of(#{cell:any(com.google.common.collect.Table.Cell<? extends R, ? extends C, ? extends V>)}.getRowKey(), #{cell}.getColumnKey(), #{cell}.getValue())")
                                    .bindType("com.google.common.collect.ImmutableTable<R, C, V>")
                                    .genericTypes("R", "C", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.stream.Stream.of(#{cell:any(com.google.common.collect.Table.Cell<? extends R, ? extends C, ? extends V>)}).collect(com.google.common.collect.ImmutableTable.toImmutableTable(com.google.common.collect.Table.Cell::getRowKey, com.google.common.collect.Table.Cell::getColumnKey, com.google.common.collect.Table.Cell::getValue))")
                                .bindType("com.google.common.collect.ImmutableTable<R, C, V>")
                                .genericTypes("R", "C", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Stream");
                        maybeRemoveImport("com.google.common.collect.ImmutableTable");
                        maybeRemoveImport("com.google.common.collect.ImmutableTable.toImmutableTable");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableTable.of(#{cell:any(com.google.common.collect.Table.Cell<? extends R, ? extends C, ? extends V>)}.getRowKey(), #{cell}.getColumnKey(), #{cell}.getValue())")
                                    .bindType("com.google.common.collect.ImmutableTable<R, C, V>")
                                    .genericTypes("R", "C", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableTable", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableTable builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableTable.Builder buildOrThrow(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableTable.Builder put(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.stream.Stream", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableTable toImmutableTable(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableTableRules.ImmutableTableOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableTableOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableTableOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableTableRules.ImmutableTableOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableTable#of()` over more contrived alternatives .";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableTable.<R, C, V>builder().buildOrThrow()")
                                .bindType("com.google.common.collect.ImmutableTable<R, C, V>")
                                .genericTypes("R", "C", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableTable.of()")
                                    .bindType("com.google.common.collect.ImmutableTable<R, C, V>")
                                    .genericTypes("R", "C", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableTable", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableTable builder(..)", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableTable.Builder buildOrThrow(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
