package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.ImmutableSortedSetRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class ImmutableSortedSetRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public ImmutableSortedSetRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`ImmutableSortedSetRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `ImmutableSortedSet`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableSortedSetRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new ImmutableSortedSetBuilderRecipe(),
                new ImmutableSortedSetNaturalOrderBuilderRecipe(),
                new ImmutableSortedSetReverseOrderBuilderRecipe(),
                new EmptyImmutableSortedSetRecipe(),
                new IterableToImmutableSortedSetRecipe(),
                new StreamToImmutableSortedSetRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedSetRules.ImmutableSortedSetBuilder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSortedSetBuilderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSortedSetBuilderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedSetRules.ImmutableSortedSetBuilder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedSet#orderedBy(Comparator)` over the associated constructor.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("new com.google.common.collect.ImmutableSortedSet.Builder<>(#{cmp:any(java.util.Comparator<T>)})")
                                .bindType("com.google.common.collect.ImmutableSortedSet.Builder<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.orderedBy(#{cmp:any(java.util.Comparator<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedSet.Builder<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet.Builder <init>(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedSetRules.ImmutableSortedSetNaturalOrderBuilder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSortedSetNaturalOrderBuilderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSortedSetNaturalOrderBuilderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedSetRules.ImmutableSortedSetNaturalOrderBuilder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedSet#naturalOrder()` over the alternative that requires explicitly providing the `Comparator`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.orderedBy(java.util.Comparator.<T>naturalOrder())")
                                .bindType("com.google.common.collect.ImmutableSortedSet.Builder<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.naturalOrder()")
                                    .bindType("com.google.common.collect.ImmutableSortedSet.Builder<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSortedSet", true),
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet orderedBy(..)", true),
                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedSetRules.ImmutableSortedSetReverseOrderBuilder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSortedSetReverseOrderBuilderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSortedSetReverseOrderBuilderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedSetRules.ImmutableSortedSetReverseOrderBuilder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedSet#reverseOrder()` over the alternative that requires explicitly providing the `Comparator`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.orderedBy(java.util.Comparator.<T>reverseOrder())")
                                .bindType("com.google.common.collect.ImmutableSortedSet.Builder<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.reverseOrder()")
                                    .bindType("com.google.common.collect.ImmutableSortedSet.Builder<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSortedSet", true),
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet orderedBy(..)", true),
                            new UsesMethod<>("java.util.Comparator reverseOrder(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedSetRules.EmptyImmutableSortedSet}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EmptyImmutableSortedSetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EmptyImmutableSortedSetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedSetRules.EmptyImmutableSortedSet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedSet#of()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.<T>naturalOrder().build()")
                                .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.of()")
                                    .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.stream.Stream.<T>empty().collect(com.google.common.collect.ImmutableSortedSet.toImmutableSortedSet(java.util.Comparator.naturalOrder()))")
                                .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Stream");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedSet");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedSet.toImmutableSortedSet");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.of()")
                                    .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSortedSet", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet naturalOrder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet.Builder build(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.stream.Stream", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet toImmutableSortedSet(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream empty(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedSetRules.IterableToImmutableSortedSet}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IterableToImmutableSortedSetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IterableToImmutableSortedSetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedSetRules.IterableToImmutableSortedSet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedSet#copyOf(Iterable)` and variants over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before0$2;
                JavaTemplate before1$0;
                JavaTemplate before1$1;
                JavaTemplate before1$2;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.<T>naturalOrder().add(#{iterable:any(T[])}).build()")
                                .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Arrays.stream(#{iterable:any(T[])}).collect(com.google.common.collect.ImmutableSortedSet.toImmutableSortedSet(java.util.Comparator.naturalOrder()))")
                                .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Arrays");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedSet");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedSet.toImmutableSortedSet");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$0 == null) {
                        before0$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.copyOf(java.util.Comparator.naturalOrder(), #{iterable:any(java.util.Iterator<T>)})")
                                .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Iterator");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$1 == null) {
                        before0$1 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.<T>naturalOrder().addAll(#{iterable:any(java.util.Iterator<T>)}).build()")
                                .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Iterator");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$2 == null) {
                        before0$2 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterable:any(java.util.Iterator<T>)}).collect(com.google.common.collect.ImmutableSortedSet.toImmutableSortedSet(java.util.Comparator.naturalOrder()))")
                                .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Iterator");
                        maybeRemoveImport("com.google.common.collect.Streams");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedSet");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedSet.toImmutableSortedSet");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1$0 == null) {
                        before1$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.copyOf(java.util.Comparator.naturalOrder(), #{iterable:any(java.lang.Iterable<T>)})")
                                .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before1$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1$1 == null) {
                        before1$1 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.<T>naturalOrder().addAll(#{iterable:any(java.lang.Iterable<T>)}).build()")
                                .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before1$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1$2 == null) {
                        before1$2 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterable:any(java.lang.Iterable<T>)}).collect(com.google.common.collect.ImmutableSortedSet.toImmutableSortedSet(java.util.Comparator.naturalOrder()))")
                                .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before1$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedSet");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedSet.toImmutableSortedSet");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{iterable:any(java.util.Collection<T>)}.stream().collect(com.google.common.collect.ImmutableSortedSet.toImmutableSortedSet(java.util.Comparator.naturalOrder()))")
                                .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collection");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedSet");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedSet.toImmutableSortedSet");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSortedSet", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet copyOf(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet naturalOrder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet.Builder add(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet.Builder build(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet naturalOrder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet.Builder addAll(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet.Builder build(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Streams", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet toImmutableSortedSet(..)", true),
                                            new UsesMethod<>("com.google.common.collect.Streams stream(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Streams", true),
                                            new UsesType<>("java.util.Iterator", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet toImmutableSortedSet(..)", true),
                                            new UsesMethod<>("com.google.common.collect.Streams stream(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Arrays", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet toImmutableSortedSet(..)", true),
                                            new UsesMethod<>("java.util.Arrays stream(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Collection", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet toImmutableSortedSet(..)", true),
                                            new UsesMethod<>("java.util.Collection stream(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Iterator", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet copyOf(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Iterator", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet naturalOrder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet.Builder addAll(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet.Builder build(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedSetRules.StreamToImmutableSortedSet}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamToImmutableSortedSetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamToImmutableSortedSetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedSetRules.StreamToImmutableSortedSet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedSet#toImmutableSortedSet(Comparator)` over less idiomatic alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableSortedSet.copyOf(#{stream:any(java.util.stream.Stream<T>)}.iterator())")
                                .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(com.google.common.collect.ImmutableSortedSet.toImmutableSortedSet(java.util.Comparator.naturalOrder()))")
                                    .bindType("com.google.common.collect.ImmutableSortedSet<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSortedSet", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSortedSet copyOf(..)", true),
                            new UsesMethod<>("java.util.stream.BaseStream iterator(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
