package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.ImmutableSortedMultisetRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class ImmutableSortedMultisetRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public ImmutableSortedMultisetRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`ImmutableSortedMultisetRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `ImmutableSortedMultiset`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableSortedMultisetRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new ImmutableSortedMultisetBuilderRecipe(),
                new ImmutableSortedMultisetNaturalOrderBuilderRecipe(),
                new ImmutableSortedMultisetReverseOrderBuilderRecipe(),
                new EmptyImmutableSortedMultisetRecipe(),
                new IterableToImmutableSortedMultisetRecipe(),
                new StreamToImmutableSortedMultisetRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedMultisetRules.ImmutableSortedMultisetBuilder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSortedMultisetBuilderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSortedMultisetBuilderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedMultisetRules.ImmutableSortedMultisetBuilder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedMultiset#orderedBy(Comparator)` over the associated constructor.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("new com.google.common.collect.ImmutableSortedMultiset.Builder<>(#{cmp:any(java.util.Comparator<T>)})")
                                .bindType("com.google.common.collect.ImmutableSortedMultiset.Builder<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.orderedBy(#{cmp:any(java.util.Comparator<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMultiset.Builder<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset.Builder <init>(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedMultisetRules.ImmutableSortedMultisetNaturalOrderBuilder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSortedMultisetNaturalOrderBuilderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSortedMultisetNaturalOrderBuilderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedMultisetRules.ImmutableSortedMultisetNaturalOrderBuilder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedMultiset#naturalOrder()` over the alternative that requires explicitly providing the `Comparator`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.orderedBy(java.util.Comparator.<T>naturalOrder())")
                                .bindType("com.google.common.collect.ImmutableSortedMultiset.Builder<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.naturalOrder()")
                                    .bindType("com.google.common.collect.ImmutableSortedMultiset.Builder<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSortedMultiset", true),
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset orderedBy(..)", true),
                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedMultisetRules.ImmutableSortedMultisetReverseOrderBuilder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSortedMultisetReverseOrderBuilderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSortedMultisetReverseOrderBuilderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedMultisetRules.ImmutableSortedMultisetReverseOrderBuilder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedMultiset#reverseOrder()` over the alternative that requires explicitly providing the `Comparator`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.orderedBy(java.util.Comparator.<T>reverseOrder())")
                                .bindType("com.google.common.collect.ImmutableSortedMultiset.Builder<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.reverseOrder()")
                                    .bindType("com.google.common.collect.ImmutableSortedMultiset.Builder<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSortedMultiset", true),
                            new UsesType<>("java.util.Comparator", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset orderedBy(..)", true),
                            new UsesMethod<>("java.util.Comparator reverseOrder(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedMultisetRules.EmptyImmutableSortedMultiset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EmptyImmutableSortedMultisetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EmptyImmutableSortedMultisetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedMultisetRules.EmptyImmutableSortedMultiset`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedMultiset#of()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.<T>naturalOrder().build()")
                                .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.of()")
                                    .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.stream.Stream.<T>empty().collect(com.google.common.collect.ImmutableSortedMultiset.toImmutableSortedMultiset(java.util.Comparator.naturalOrder()))")
                                .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Stream");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedMultiset");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedMultiset.toImmutableSortedMultiset");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.of()")
                                    .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSortedMultiset", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset naturalOrder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset.Builder build(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.stream.Stream", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset toImmutableSortedMultiset(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream empty(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedMultisetRules.IterableToImmutableSortedMultiset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IterableToImmutableSortedMultisetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IterableToImmutableSortedMultisetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedMultisetRules.IterableToImmutableSortedMultiset`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedMultiset#copyOf(Iterable)` and variants over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before0$2;
                JavaTemplate before1$0;
                JavaTemplate before1$1;
                JavaTemplate before1$2;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.<T>naturalOrder().add(#{iterable:any(T[])}).build()")
                                .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Arrays.stream(#{iterable:any(T[])}).collect(com.google.common.collect.ImmutableSortedMultiset.toImmutableSortedMultiset(java.util.Comparator.naturalOrder()))")
                                .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Arrays");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedMultiset");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedMultiset.toImmutableSortedMultiset");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$0 == null) {
                        before0$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.copyOf(java.util.Comparator.naturalOrder(), #{iterable:any(java.util.Iterator<T>)})")
                                .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Iterator");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$1 == null) {
                        before0$1 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.<T>naturalOrder().addAll(#{iterable:any(java.util.Iterator<T>)}).build()")
                                .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Iterator");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$2 == null) {
                        before0$2 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterable:any(java.util.Iterator<T>)}).collect(com.google.common.collect.ImmutableSortedMultiset.toImmutableSortedMultiset(java.util.Comparator.naturalOrder()))")
                                .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Iterator");
                        maybeRemoveImport("com.google.common.collect.Streams");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedMultiset");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedMultiset.toImmutableSortedMultiset");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1$0 == null) {
                        before1$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.copyOf(java.util.Comparator.naturalOrder(), #{iterable:any(java.lang.Iterable<T>)})")
                                .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before1$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1$1 == null) {
                        before1$1 = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.<T>naturalOrder().addAll(#{iterable:any(java.lang.Iterable<T>)}).build()")
                                .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before1$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1$2 == null) {
                        before1$2 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterable:any(java.lang.Iterable<T>)}).collect(com.google.common.collect.ImmutableSortedMultiset.toImmutableSortedMultiset(java.util.Comparator.naturalOrder()))")
                                .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before1$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedMultiset");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedMultiset.toImmutableSortedMultiset");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{iterable:any(java.util.Collection<T>)}.stream().collect(com.google.common.collect.ImmutableSortedMultiset.toImmutableSortedMultiset(java.util.Comparator.naturalOrder()))")
                                .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collection");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedMultiset");
                        maybeRemoveImport("java.util.Comparator");
                        maybeRemoveImport("com.google.common.collect.ImmutableSortedMultiset.toImmutableSortedMultiset");
                        maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSortedMultiset", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset copyOf(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset naturalOrder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset.Builder add(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset.Builder build(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset naturalOrder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset.Builder addAll(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset.Builder build(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Streams", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset toImmutableSortedMultiset(..)", true),
                                            new UsesMethod<>("com.google.common.collect.Streams stream(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Streams", true),
                                            new UsesType<>("java.util.Iterator", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset toImmutableSortedMultiset(..)", true),
                                            new UsesMethod<>("com.google.common.collect.Streams stream(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Arrays", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset toImmutableSortedMultiset(..)", true),
                                            new UsesMethod<>("java.util.Arrays stream(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Collection", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset toImmutableSortedMultiset(..)", true),
                                            new UsesMethod<>("java.util.Collection stream(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Iterator", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset copyOf(..)", true),
                                            new UsesMethod<>("java.util.Comparator naturalOrder(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Iterator", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset naturalOrder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset.Builder addAll(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset.Builder build(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSortedMultisetRules.StreamToImmutableSortedMultiset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamToImmutableSortedMultisetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamToImmutableSortedMultisetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSortedMultisetRules.StreamToImmutableSortedMultiset`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSortedMultiset#toImmutableSortedMultiset(Comparator)` over less idiomatic alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableSortedMultiset.copyOf(#{stream:any(java.util.stream.Stream<T>)}.iterator())")
                                .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                .genericTypes("T extends java.lang.Comparable<? super T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(com.google.common.collect.ImmutableSortedMultiset.toImmutableSortedMultiset(java.util.Comparator.naturalOrder()))")
                                    .bindType("com.google.common.collect.ImmutableSortedMultiset<T>")
                                    .genericTypes("T extends java.lang.Comparable<? super T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSortedMultiset", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSortedMultiset copyOf(..)", true),
                            new UsesMethod<>("java.util.stream.BaseStream iterator(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
