package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.ImmutableSetMultimapRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class ImmutableSetMultimapRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public ImmutableSetMultimapRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`ImmutableSetMultimapRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `ImmutableSetMultimap`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableSetMultimapRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new ImmutableSetMultimapBuilderRecipe(),
                new EmptyImmutableSetMultimapRecipe(),
                new PairToImmutableSetMultimapRecipe(),
                new EntryToImmutableSetMultimapRecipe(),
                new IterableToImmutableSetMultimapRecipe(),
                new TransformMultimapValuesToImmutableSetMultimap2Recipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetMultimapRules.ImmutableSetMultimapBuilder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableSetMultimapBuilderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableSetMultimapBuilderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetMultimapRules.ImmutableSetMultimapBuilder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSetMultimap#builder()` over the associated constructor.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("new com.google.common.collect.ImmutableSetMultimap.Builder<>()")
                                .bindType("com.google.common.collect.ImmutableSetMultimap.Builder<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.builder()")
                                    .bindType("com.google.common.collect.ImmutableSetMultimap.Builder<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap.Builder <init>(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetMultimapRules.EmptyImmutableSetMultimap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EmptyImmutableSetMultimapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EmptyImmutableSetMultimapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetMultimapRules.EmptyImmutableSetMultimap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSetMultimap#of()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.<K, V>builder().build()")
                                .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.of()")
                                    .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSetMultimap", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap builder(..)", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap.Builder build(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetMultimapRules.PairToImmutableSetMultimap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PairToImmutableSetMultimapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PairToImmutableSetMultimapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetMultimapRules.PairToImmutableSetMultimap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSetMultimap#of(Object, Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.<K, V>builder().put(#{key:any(K)}, #{value:any(V)}).build()")
                                .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.of(#{key:any(K)}, #{value:any(V)})")
                                    .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSetMultimap", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap builder(..)", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap.Builder build(..)", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap.Builder put(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetMultimapRules.EntryToImmutableSetMultimap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EntryToImmutableSetMultimapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EntryToImmutableSetMultimapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetMultimapRules.EntryToImmutableSetMultimap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSetMultimap#of(Object, Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.<K, V>builder().put(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}).build()")
                                .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}.getKey(), #{entry}.getValue())")
                                    .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.stream.Stream.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}).collect(com.google.common.collect.ImmutableSetMultimap.toImmutableSetMultimap(java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))")
                                .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Stream");
                        maybeRemoveImport("com.google.common.collect.ImmutableSetMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableSetMultimap.toImmutableSetMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}.getKey(), #{entry}.getValue())")
                                    .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSetMultimap", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap.Builder build(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap.Builder put(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.stream.Stream", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap toImmutableSetMultimap(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetMultimapRules.IterableToImmutableSetMultimap}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IterableToImmutableSetMultimapRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IterableToImmutableSetMultimapRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetMultimapRules.IterableToImmutableSetMultimap`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableSetMultimap#copyOf(Iterable)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.copyOf(#{iterable:any(com.google.common.collect.Multimap<? extends K, ? extends V>)}.entries())")
                                .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Multimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.<K, V>builder().putAll(#{iterable:any(com.google.common.collect.Multimap<? extends K, ? extends V>)}).build()")
                                .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Multimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$0 == null) {
                        before0$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.<K, V>builder().putAll(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)}).build()")
                                .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$1 == null) {
                        before0$1 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)}).collect(com.google.common.collect.ImmutableSetMultimap.toImmutableSetMultimap(java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))")
                                .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        maybeRemoveImport("com.google.common.collect.ImmutableSetMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableSetMultimap.toImmutableSetMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1 == null) {
                        before1 = JavaTemplate.builder("#{iterable:any(java.util.Collection<? extends java.util.Map.Entry<? extends K, ? extends V>>)}.stream().collect(com.google.common.collect.ImmutableSetMultimap.toImmutableSetMultimap(java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))")
                                .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collection");
                        maybeRemoveImport("com.google.common.collect.ImmutableSetMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableSetMultimap.toImmutableSetMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})")
                                    .bindType("com.google.common.collect.ImmutableSetMultimap<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSetMultimap", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap.Builder build(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap.Builder putAll(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Multimap", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap.Builder build(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap.Builder putAll(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Multimap", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap copyOf(..)", true),
                                            new UsesMethod<>("com.google.common.collect.Multimap entries(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Streams", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap toImmutableSetMultimap(..)", true),
                                            new UsesMethod<>("com.google.common.collect.Streams stream(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Collection", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap toImmutableSetMultimap(..)", true),
                                            new UsesMethod<>("java.util.Collection stream(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableSetMultimapRules.TransformMultimapValuesToImmutableSetMultimap2}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class TransformMultimapValuesToImmutableSetMultimap2Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public TransformMultimapValuesToImmutableSetMultimap2Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableSetMultimapRules.TransformMultimapValuesToImmutableSetMultimap2`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer creating an immutable copy of the result of `Multimaps#transformValues(Multimap, com.google.common.base.Function)` over creating and directly collecting a stream.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{multimap:any(com.google.common.collect.Multimap<K, V1>)}.asMap().entrySet().stream().collect(com.google.common.collect.ImmutableSetMultimap.flatteningToImmutableSetMultimap(java.util.Map.Entry::getKey, (e)->e.getValue().stream().map(#{transformation:any(java.util.function.Function<? super V1, ? extends V2>)})))")
                                .bindType("com.google.common.collect.ImmutableSetMultimap<K, V2>")
                                .genericTypes("K", "V1", "V2")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Function");
                        maybeRemoveImport("java.util.Map.Entry");
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("java.util.Collection");
                        maybeRemoveImport("com.google.common.collect.ImmutableSetMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableSetMultimap.flatteningToImmutableSetMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.copyOf(com.google.common.collect.Multimaps.transformValues(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}, #{transformation:any(com.google.common.base.Function<? super V1, ? extends V2>)}))")
                                    .bindType("com.google.common.collect.ImmutableSetMultimap<K, V2>")
                                    .genericTypes("K", "V1", "V2")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.Multimaps.asMap(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}).entrySet().stream().collect(com.google.common.collect.ImmutableSetMultimap.flatteningToImmutableSetMultimap(java.util.Map.Entry::getKey, (e)->e.getValue().stream().map(#{transformation:any(java.util.function.Function<? super V1, ? extends V2>)})))")
                                .bindType("com.google.common.collect.ImmutableSetMultimap<K, V2>")
                                .genericTypes("K", "V1", "V2")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Function");
                        maybeRemoveImport("java.util.Map.Entry");
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("java.util.Collection");
                        maybeRemoveImport("com.google.common.collect.ImmutableSetMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableSetMultimap.flatteningToImmutableSetMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.copyOf(com.google.common.collect.Multimaps.transformValues(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}, #{transformation:any(com.google.common.base.Function<? super V1, ? extends V2>)}))")
                                    .bindType("com.google.common.collect.ImmutableSetMultimap<K, V2>")
                                    .genericTypes("K", "V1", "V2")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("com.google.common.collect.Multimaps.asMap(#{multimap:any(com.google.common.collect.ListMultimap<K, V1>)}).entrySet().stream().collect(com.google.common.collect.ImmutableSetMultimap.flatteningToImmutableSetMultimap(java.util.Map.Entry::getKey, (e)->e.getValue().stream().map(#{transformation:any(java.util.function.Function<? super V1, ? extends V2>)})))")
                                .bindType("com.google.common.collect.ImmutableSetMultimap<K, V2>")
                                .genericTypes("K", "V1", "V2")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ListMultimap");
                        maybeRemoveImport("java.util.function.Function");
                        maybeRemoveImport("java.util.Map.Entry");
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("java.util.List");
                        maybeRemoveImport("com.google.common.collect.ImmutableSetMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableSetMultimap.flatteningToImmutableSetMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.copyOf(com.google.common.collect.Multimaps.transformValues(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}, #{transformation:any(com.google.common.base.Function<? super V1, ? extends V2>)}))")
                                    .bindType("com.google.common.collect.ImmutableSetMultimap<K, V2>")
                                    .genericTypes("K", "V1", "V2")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1 == null) {
                        before1 = JavaTemplate.builder("com.google.common.collect.Multimaps.asMap(#{multimap:any(com.google.common.collect.SetMultimap<K, V1>)}).entrySet().stream().collect(com.google.common.collect.ImmutableSetMultimap.flatteningToImmutableSetMultimap(java.util.Map.Entry::getKey, (e)->e.getValue().stream().map(#{transformation:any(java.util.function.Function<? super V1, ? extends V2>)})))")
                                .bindType("com.google.common.collect.ImmutableSetMultimap<K, V2>")
                                .genericTypes("K", "V1", "V2")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.SetMultimap");
                        maybeRemoveImport("java.util.function.Function");
                        maybeRemoveImport("java.util.Map.Entry");
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("java.util.Set");
                        maybeRemoveImport("com.google.common.collect.ImmutableSetMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableSetMultimap.flatteningToImmutableSetMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.copyOf(com.google.common.collect.Multimaps.transformValues(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}, #{transformation:any(com.google.common.base.Function<? super V1, ? extends V2>)}))")
                                    .bindType("com.google.common.collect.ImmutableSetMultimap<K, V2>")
                                    .genericTypes("K", "V1", "V2")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("com.google.common.collect.Multimaps.asMap(#{multimap:any(com.google.common.collect.SortedSetMultimap<K, V1>)}).entrySet().stream().collect(com.google.common.collect.ImmutableSetMultimap.flatteningToImmutableSetMultimap(java.util.Map.Entry::getKey, (e)->e.getValue().stream().map(#{transformation:any(java.util.function.Function<? super V1, ? extends V2>)})))")
                                .bindType("com.google.common.collect.ImmutableSetMultimap<K, V2>")
                                .genericTypes("K", "V1", "V2")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.SortedSetMultimap");
                        maybeRemoveImport("java.util.function.Function");
                        maybeRemoveImport("java.util.Map.Entry");
                        maybeRemoveImport("java.util.Map");
                        maybeRemoveImport("java.util.SortedSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSetMultimap");
                        maybeRemoveImport("com.google.common.collect.ImmutableSetMultimap.flatteningToImmutableSetMultimap");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableSetMultimap.copyOf(com.google.common.collect.Multimaps.transformValues(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}, #{transformation:any(com.google.common.base.Function<? super V1, ? extends V2>)}))")
                                    .bindType("com.google.common.collect.ImmutableSetMultimap<K, V2>")
                                    .genericTypes("K", "V1", "V2")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSetMultimap", true),
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("java.util.Map.Entry", true),
                            new UsesType<>("java.util.function.Function", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSetMultimap flatteningToImmutableSetMultimap(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.Map entrySet(..)", true),
                            new UsesMethod<>("java.util.Map.Entry getValue(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                            new UsesMethod<>("java.util.stream.Stream map(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ListMultimap", true),
                                            new UsesType<>("com.google.common.collect.Multimaps", true),
                                            new UsesType<>("java.util.List", true),
                                            new UsesMethod<>("com.google.common.collect.Multimaps asMap(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Multimap", true),
                                            new UsesType<>("com.google.common.collect.Multimaps", true),
                                            new UsesType<>("java.util.Collection", true),
                                            new UsesMethod<>("com.google.common.collect.Multimaps asMap(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Multimap", true),
                                            new UsesType<>("java.util.Collection", true),
                                            new UsesMethod<>("com.google.common.collect.Multimap asMap(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Multimaps", true),
                                            new UsesType<>("com.google.common.collect.SetMultimap", true),
                                            new UsesType<>("java.util.Set", true),
                                            new UsesMethod<>("com.google.common.collect.Multimaps asMap(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Multimaps", true),
                                            new UsesType<>("com.google.common.collect.SortedSetMultimap", true),
                                            new UsesType<>("java.util.SortedSet", true),
                                            new UsesMethod<>("com.google.common.collect.Multimaps asMap(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

}
