package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.ImmutableMultisetRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class ImmutableMultisetRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public ImmutableMultisetRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`ImmutableMultisetRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `ImmutableMultiset`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableMultisetRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new ImmutableMultisetBuilderRecipe(),
                new EmptyImmutableMultisetRecipe(),
                new IterableToImmutableMultisetRecipe(),
                new StreamToImmutableMultisetRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableMultisetRules.ImmutableMultisetBuilder}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableMultisetBuilderRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableMultisetBuilderRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableMultisetRules.ImmutableMultisetBuilder`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableMultiset#builder()` over the associated constructor.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("new com.google.common.collect.ImmutableMultiset.Builder<>()")
                                .bindType("com.google.common.collect.ImmutableMultiset.Builder<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMultiset.builder()")
                                    .bindType("com.google.common.collect.ImmutableMultiset.Builder<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("com.google.common.collect.ImmutableMultiset.Builder <init>(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableMultisetRules.EmptyImmutableMultiset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EmptyImmutableMultisetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EmptyImmutableMultisetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableMultisetRules.EmptyImmutableMultiset`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableMultiset#of()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableMultiset.<T>builder().build()")
                                .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMultiset.of()")
                                    .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.stream.Stream.<T>empty().collect(com.google.common.collect.ImmutableMultiset.toImmutableMultiset())")
                                .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.stream.Stream");
                        maybeRemoveImport("com.google.common.collect.ImmutableMultiset");
                        maybeRemoveImport("com.google.common.collect.ImmutableMultiset.toImmutableMultiset");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMultiset.of()")
                                    .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableMultiset", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset.Builder build(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.stream.Stream", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset toImmutableMultiset(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream empty(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableMultisetRules.IterableToImmutableMultiset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IterableToImmutableMultisetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IterableToImmutableMultisetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableMultisetRules.IterableToImmutableMultiset`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableMultiset#copyOf(Iterable)` and variants over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before1$0;
                JavaTemplate before1$1;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableMultiset.<T>builder().add(#{iterable:any(T[])}).build()")
                                .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Arrays.stream(#{iterable:any(T[])}).collect(com.google.common.collect.ImmutableMultiset.toImmutableMultiset())")
                                .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Arrays");
                        maybeRemoveImport("com.google.common.collect.ImmutableMultiset");
                        maybeRemoveImport("com.google.common.collect.ImmutableMultiset.toImmutableMultiset");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$0 == null) {
                        before0$0 = JavaTemplate.builder("com.google.common.collect.ImmutableMultiset.<T>builder().addAll(#{iterable:any(java.util.Iterator<T>)}).build()")
                                .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Iterator");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$1 == null) {
                        before0$1 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterable:any(java.util.Iterator<T>)}).collect(com.google.common.collect.ImmutableMultiset.toImmutableMultiset())")
                                .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Iterator");
                        maybeRemoveImport("com.google.common.collect.Streams");
                        maybeRemoveImport("com.google.common.collect.ImmutableMultiset");
                        maybeRemoveImport("com.google.common.collect.ImmutableMultiset.toImmutableMultiset");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1$0 == null) {
                        before1$0 = JavaTemplate.builder("com.google.common.collect.ImmutableMultiset.<T>builder().addAll(#{iterable:any(java.lang.Iterable<T>)}).build()")
                                .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before1$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1$1 == null) {
                        before1$1 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterable:any(java.lang.Iterable<T>)}).collect(com.google.common.collect.ImmutableMultiset.toImmutableMultiset())")
                                .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before1$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        maybeRemoveImport("com.google.common.collect.ImmutableMultiset");
                        maybeRemoveImport("com.google.common.collect.ImmutableMultiset.toImmutableMultiset");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{iterable:any(java.util.Collection<T>)}.stream().collect(com.google.common.collect.ImmutableMultiset.toImmutableMultiset())")
                                .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collection");
                        maybeRemoveImport("com.google.common.collect.ImmutableMultiset");
                        maybeRemoveImport("com.google.common.collect.ImmutableMultiset.toImmutableMultiset");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.ImmutableMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableMultiset", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset.Builder add(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset.Builder build(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset.Builder addAll(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset.Builder build(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Streams", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset toImmutableMultiset(..)", true),
                                            new UsesMethod<>("com.google.common.collect.Streams stream(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Streams", true),
                                            new UsesType<>("java.util.Iterator", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset toImmutableMultiset(..)", true),
                                            new UsesMethod<>("com.google.common.collect.Streams stream(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Arrays", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset toImmutableMultiset(..)", true),
                                            new UsesMethod<>("java.util.Arrays stream(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Collection", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset toImmutableMultiset(..)", true),
                                            new UsesMethod<>("java.util.Collection stream(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Iterator", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset builder(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset.Builder addAll(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset.Builder build(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableMultisetRules.StreamToImmutableMultiset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamToImmutableMultisetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamToImmutableMultisetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableMultisetRules.StreamToImmutableMultiset`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableMultiset#toImmutableMultiset()` over less idiomatic alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableMultiset.copyOf(#{stream:any(java.util.stream.Stream<T>)}.iterator())")
                                .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(com.google.common.collect.ImmutableMultiset.toImmutableMultiset())")
                                    .bindType("com.google.common.collect.ImmutableMultiset<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableMultiset", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableMultiset copyOf(..)", true),
                            new UsesMethod<>("java.util.stream.BaseStream iterator(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
