package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.ImmutableEnumSetRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class ImmutableEnumSetRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public ImmutableEnumSetRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`ImmutableEnumSetRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `com.google.common.collect.ImmutableEnumSet`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableEnumSetRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new SetsImmutableEnumSetIterableRecipe(),
                new SetsImmutableEnumSetArraysAsListRecipe(),
                new SetsImmutableEnumSet1Recipe(),
                new SetsImmutableEnumSet2Recipe(),
                new SetsImmutableEnumSet3Recipe(),
                new SetsImmutableEnumSet4Recipe(),
                new SetsImmutableEnumSet5Recipe(),
                new SetsImmutableEnumSet6Recipe(),
                new StreamToImmutableEnumSetRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableEnumSetRules.SetsImmutableEnumSetIterable}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SetsImmutableEnumSetIterableRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SetsImmutableEnumSetIterableRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Prefer `Sets#immutableEnumSet(Iterable)` for enum collections to take advantage of the internally used `EnumSet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "<strong>Warning:</strong> this rule is not completely behavior preserving: while the\n original code produces a set that iterates over its elements in the same order as the input\n `Iterable`, the replacement code iterates over the elements in enum definition order.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(#{elements:any(java.lang.Iterable<T>)})")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T extends java.lang.Enum<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.immutableEnumSet(#{elements:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T extends java.lang.Enum<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(#{elements:any(java.util.Collection<T>)})")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T extends java.lang.Enum<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collection");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.immutableEnumSet(#{elements:any(java.lang.Iterable<T>)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T extends java.lang.Enum<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSet copyOf(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableEnumSetRules.SetsImmutableEnumSetArraysAsList}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SetsImmutableEnumSetArraysAsListRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SetsImmutableEnumSetArraysAsListRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Prefer `Sets#immutableEnumSet(Iterable)` for enum collections to take advantage of the internally used `EnumSet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "<strong>Warning:</strong> this rule is not completely behavior preserving: while the\n original code produces a set that iterates over its elements in the same order as defined in\n the array, the replacement code iterates over the elements in enum definition order.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(#{elements:any(T[])})")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T extends java.lang.Enum<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.immutableEnumSet(java.util.Arrays.asList(#{elements:any(T[])}))")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T extends java.lang.Enum<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSet copyOf(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableEnumSetRules.SetsImmutableEnumSet1}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SetsImmutableEnumSet1Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SetsImmutableEnumSet1Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `ImmutableEnumSetRules.SetsImmutableEnumSet1`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Sets#immutableEnumSet(Enum, Enum[])` for enum collections to take advantage of the internally used `EnumSet`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{e1:any(T)})")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T extends java.lang.Enum<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.immutableEnumSet(#{e1:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T extends java.lang.Enum<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(java.util.EnumSet.of(#{e1:any(T)}))")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T extends java.lang.Enum<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.EnumSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.immutableEnumSet(#{e1:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T extends java.lang.Enum<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            Preconditions.or(
                                    new UsesMethod<>("com.google.common.collect.ImmutableSet of(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.EnumSet", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet copyOf(..)", true),
                                            new UsesMethod<>("java.util.EnumSet of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableEnumSetRules.SetsImmutableEnumSet2}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SetsImmutableEnumSet2Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SetsImmutableEnumSet2Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Prefer `Sets#immutableEnumSet(Enum, Enum[])` for enum collections to take advantage of the internally used `EnumSet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "<strong>Warning:</strong> this rule is not completely behavior preserving: while the `ImmutableSet#of` expression produces a set that iterates over its elements in the listed order,\n the replacement code iterates over the elements in enum definition order.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{e1:any(T)}, #{e2:any(T)})")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T extends java.lang.Enum<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.immutableEnumSet(#{e1:any(T)}, #{e2:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T extends java.lang.Enum<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(java.util.EnumSet.of(#{e1:any(T)}, #{e2:any(T)}))")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T extends java.lang.Enum<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.EnumSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.immutableEnumSet(#{e1:any(T)}, #{e2:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T extends java.lang.Enum<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            Preconditions.or(
                                    new UsesMethod<>("com.google.common.collect.ImmutableSet of(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.EnumSet", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet copyOf(..)", true),
                                            new UsesMethod<>("java.util.EnumSet of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableEnumSetRules.SetsImmutableEnumSet3}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SetsImmutableEnumSet3Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SetsImmutableEnumSet3Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Prefer `Sets#immutableEnumSet(Enum, Enum[])` for enum collections to take advantage of the internally used `EnumSet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "<strong>Warning:</strong> this rule is not completely behavior preserving: while the `ImmutableSet#of` expression produces a set that iterates over its elements in the listed order,\n the replacement code iterates over the elements in enum definition order.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)})")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T extends java.lang.Enum<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.immutableEnumSet(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T extends java.lang.Enum<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(java.util.EnumSet.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}))")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T extends java.lang.Enum<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.EnumSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.immutableEnumSet(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T extends java.lang.Enum<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            Preconditions.or(
                                    new UsesMethod<>("com.google.common.collect.ImmutableSet of(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.EnumSet", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet copyOf(..)", true),
                                            new UsesMethod<>("java.util.EnumSet of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableEnumSetRules.SetsImmutableEnumSet4}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SetsImmutableEnumSet4Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SetsImmutableEnumSet4Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Prefer `Sets#immutableEnumSet(Enum, Enum[])` for enum collections to take advantage of the internally used `EnumSet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "<strong>Warning:</strong> this rule is not completely behavior preserving: while the `ImmutableSet#of` expression produces a set that iterates over its elements in the listed order,\n the replacement code iterates over the elements in enum definition order.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)})")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T extends java.lang.Enum<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.immutableEnumSet(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T extends java.lang.Enum<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(java.util.EnumSet.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}))")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T extends java.lang.Enum<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.EnumSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.immutableEnumSet(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T extends java.lang.Enum<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            Preconditions.or(
                                    new UsesMethod<>("com.google.common.collect.ImmutableSet of(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.EnumSet", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet copyOf(..)", true),
                                            new UsesMethod<>("java.util.EnumSet of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableEnumSetRules.SetsImmutableEnumSet5}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SetsImmutableEnumSet5Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SetsImmutableEnumSet5Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Prefer `Sets#immutableEnumSet(Enum, Enum[])` for enum collections to take advantage of the internally used `EnumSet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "<strong>Warning:</strong> this rule is not completely behavior preserving: while the `ImmutableSet#of` expression produces a set that iterates over its elements in the listed order,\n the replacement code iterates over the elements in enum definition order.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}, #{e5:any(T)})")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T extends java.lang.Enum<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.immutableEnumSet(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}, #{e5:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T extends java.lang.Enum<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.ImmutableSet.copyOf(java.util.EnumSet.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}, #{e5:any(T)}))")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T extends java.lang.Enum<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.EnumSet");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.immutableEnumSet(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}, #{e5:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T extends java.lang.Enum<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            Preconditions.or(
                                    new UsesMethod<>("com.google.common.collect.ImmutableSet of(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.EnumSet", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet copyOf(..)", true),
                                            new UsesMethod<>("java.util.EnumSet of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableEnumSetRules.SetsImmutableEnumSet6}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SetsImmutableEnumSet6Recipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SetsImmutableEnumSet6Recipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Prefer `Sets#immutableEnumSet(Enum, Enum[])` for enum collections to take advantage of the internally used `EnumSet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "<strong>Warning:</strong> this rule is not completely behavior preserving: while the\n original code produces a set that iterates over its elements in the listed order, the\n replacement code iterates over the elements in enum definition order.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableSet.of(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}, #{e5:any(T)}, #{e6:any(T)})")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T extends java.lang.Enum<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Sets.immutableEnumSet(#{e1:any(T)}, #{e2:any(T)}, #{e3:any(T)}, #{e4:any(T)}, #{e5:any(T)}, #{e6:any(T)})")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T extends java.lang.Enum<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3), matcher.parameter(4), matcher.parameter(5)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSet of(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code ImmutableEnumSetRules.StreamToImmutableEnumSet}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class StreamToImmutableEnumSetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public StreamToImmutableEnumSetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Use `Sets#toImmutableEnumSet()` when possible, as it is more efficient than `ImmutableSet#toImmutableSet()` and produces a more compact object";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "<strong>Warning:</strong> this rule is not completely behavior preserving: while the\n original code produces a set that iterates over its elements in encounter order, the\n replacement code iterates over the elements in enum definition order.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(com.google.common.collect.ImmutableSet.toImmutableSet())")
                                .bindType("com.google.common.collect.ImmutableSet<T>")
                                .genericTypes("T extends java.lang.Enum<T>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        maybeRemoveImport("com.google.common.collect.ImmutableSet.toImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("#{stream:any(java.util.stream.Stream<T>)}.collect(com.google.common.collect.Sets.toImmutableEnumSet())")
                                    .bindType("com.google.common.collect.ImmutableSet<T>")
                                    .genericTypes("T extends java.lang.Enum<T>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableSet toImmutableSet(..)", true),
                            new UsesMethod<>("java.util.stream.Stream collect(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
