package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.FileRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class FileRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public FileRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`FileRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with files.\n[Source](https://error-prone.picnic.tech/refasterrules/FileRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new PathOfUriRecipe(),
                new PathInstanceRecipe(),
                new FilesReadStringWithCharsetRecipe(),
                new FilesReadStringRecipe(),
                new FilesCreateTempFileToFileRecipe(),
                new FilesCreateTempFileInCustomDirectoryToFileRecipe(),
                new PathToFileMkDirsFilesExistsRecipe(),
                new FileMkDirsFileExistsRecipe(),
                new FilesNewBufferedReaderPathOfRecipe(),
                new FilesNewBufferedReaderToPathRecipe(),
                new FilesNewBufferedReaderPathOfWithCharsetRecipe(),
                new FilesNewBufferedReaderToPathWithCharsetRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.PathOfUri}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PathOfUriRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PathOfUriRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `FileRules.PathOfUri`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer the more idiomatic `Path#of(URI)` over `Paths#get(URI)`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.nio.file.Paths.get(#{uri:any(java.net.URI)})")
                                .bindType("java.nio.file.Path").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.nio.file.Paths");
                        if (after == null) {
                            after = JavaTemplate.builder("java.nio.file.Path.of(#{uri:any(java.net.URI)})")
                                    .bindType("java.nio.file.Path").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.net.URI", true),
                            new UsesType<>("java.nio.file.Path", true),
                            new UsesType<>("java.nio.file.Paths", true),
                            new UsesMethod<>("java.nio.file.Paths get(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.PathInstance}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PathInstanceRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PathInstanceRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `FileRules.PathInstance`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid redundant conversions from `Path` to `File`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{path:any(java.nio.file.Path)}.toFile().toPath()")
                                .bindType("java.nio.file.Path").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{path:any(java.nio.file.Path)}")
                                    .bindType("java.nio.file.Path").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.nio.file.Path", true),
                            new UsesMethod<>("java.io.File toPath(..)", true),
                            new UsesMethod<>("java.nio.file.Path toFile(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.FilesReadStringWithCharset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FilesReadStringWithCharsetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FilesReadStringWithCharsetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `FileRules.FilesReadStringWithCharset`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Files#readString(Path, Charset)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("new String(java.nio.file.Files.readAllBytes(#{path:any(java.nio.file.Path)}), #{charset:any(java.nio.charset.Charset)})")
                                .bindType("java.lang.String").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.nio.file.Files.readString(#{path:any(java.nio.file.Path)}, #{charset:any(java.nio.charset.Charset)})")
                                    .bindType("java.lang.String").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.nio.charset.Charset", true),
                            new UsesType<>("java.nio.file.Files", true),
                            new UsesType<>("java.nio.file.Path", true),
                            new UsesMethod<>("java.lang.String <init>(..)", true),
                            new UsesMethod<>("java.nio.file.Files readAllBytes(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.FilesReadString}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FilesReadStringRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FilesReadStringRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `FileRules.FilesReadString`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Files#readString(Path)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.nio.file.Files.readString(#{path:any(java.nio.file.Path)}, java.nio.charset.StandardCharsets.UTF_8)")
                                .bindType("java.lang.String").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.nio.charset.StandardCharsets");
                        maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        if (after == null) {
                            after = JavaTemplate.builder("java.nio.file.Files.readString(#{path:any(java.nio.file.Path)})")
                                    .bindType("java.lang.String").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.nio.file.Files", true),
                            new UsesType<>("java.nio.file.Path", true),
                            new UsesMethod<>("java.nio.file.Files readString(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.FilesCreateTempFileToFile}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FilesCreateTempFileToFileRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FilesCreateTempFileToFileRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Prefer `Files#createTempFile(String, String, FileAttribute[])` over alternatives that create files with more liberal permissions";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Note that `File#createTempFile` treats the given prefix as a path, and ignores all but\n its file name. That is, the actual prefix used is derived from all characters following the\n final file separator (if any). This is not the case with `Files#createTempFile`, which\n will instead throw an `IllegalArgumentException` if the prefix contains any file\n separators.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S5443");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.io.File.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)})")
                                .bindType("java.io.File").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.nio.file.Files.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}).toFile()")
                                    .bindType("java.io.File").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.io.File.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}, null)")
                                .bindType("java.io.File").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.nio.file.Files.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}).toFile()")
                                    .bindType("java.io.File").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.io.File", true),
                            new UsesMethod<>("java.io.File createTempFile(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.FilesCreateTempFileInCustomDirectoryToFile}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FilesCreateTempFileInCustomDirectoryToFileRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FilesCreateTempFileInCustomDirectoryToFileRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Prefer `Files#createTempFile(Path, String, String, FileAttribute[])` over alternatives that create files with more liberal permissions";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Note that `File#createTempFile` treats the given prefix as a path, and ignores all but\n its file name. That is, the actual prefix used is derived from all characters following the\n final file separator (if any). This is not the case with `Files#createTempFile`, which\n will instead throw an `IllegalArgumentException` if the prefix contains any file\n separators.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.io.File.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}, #{directory:any(java.io.File)})")
                                .bindType("java.io.File").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.nio.file.Files.createTempFile(#{directory:any(java.io.File)}.toPath(), #{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}).toFile()")
                                    .bindType("java.io.File").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(2), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.io.File", true),
                            new UsesMethod<>("java.io.File createTempFile(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.PathToFileMkDirsFilesExists}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class PathToFileMkDirsFilesExistsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public PathToFileMkDirsFilesExistsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `FileRules.PathToFileMkDirsFilesExists`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Invoke `File#mkdirs()` before `Files#exists(Path, LinkOption...)` to avoid concurrency issues.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.nio.file.Files.exists(#{path:any(java.nio.file.Path)}) || #{path}.toFile().mkdirs()").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{path:any(java.nio.file.Path)}.toFile().mkdirs() || java.nio.file.Files.exists(#{path})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.nio.file.Files", true),
                            new UsesType<>("java.nio.file.Path", true),
                            new UsesMethod<>("java.io.File mkdirs(..)", true),
                            new UsesMethod<>("java.nio.file.Files exists(..)", true),
                            new UsesMethod<>("java.nio.file.Path toFile(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.FileMkDirsFileExists}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FileMkDirsFileExistsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FileMkDirsFileExistsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `FileRules.FileMkDirsFileExists`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Invoke `File#mkdirs()` before `File#exists()` to avoid concurrency issues.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{file:any(java.io.File)}.exists() || #{file}.mkdirs()").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{file:any(java.io.File)}.mkdirs() || #{file}.exists()").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.io.File", true),
                            new UsesMethod<>("java.io.File exists(..)", true),
                            new UsesMethod<>("java.io.File mkdirs(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.FilesNewBufferedReaderPathOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FilesNewBufferedReaderPathOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FilesNewBufferedReaderPathOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `FileRules.FilesNewBufferedReaderPathOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Files#newBufferedReader(Path)` over more verbose or contrived alternatives.";
        }

        @Override
        public Set<String> getTags() {
            return new HashSet<>(Arrays.asList("RSPEC-S1943", "RSPEC-S2095"));
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.nio.file.Files.newBufferedReader(java.nio.file.Path.of(#{path:any(java.lang.String)}), java.nio.charset.StandardCharsets.UTF_8)")
                                .bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.nio.charset.StandardCharsets");
                        maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        if (after == null) {
                            after = JavaTemplate.builder("java.nio.file.Files.newBufferedReader(java.nio.file.Path.of(#{path:any(java.lang.String)}))")
                                    .bindType("java.io.BufferedReader").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(#{path:any(java.lang.String)})))")
                                .bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.io.InputStreamReader");
                        maybeRemoveImport("java.io.FileInputStream");
                        if (after == null) {
                            after = JavaTemplate.builder("java.nio.file.Files.newBufferedReader(java.nio.file.Path.of(#{path:any(java.lang.String)}))")
                                    .bindType("java.io.BufferedReader").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.nio.file.Files.newBufferedReader(java.nio.file.Path.of(#{path:any(java.lang.String)}), java.nio.charset.StandardCharsets.UTF_8)")
                                .bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.nio.charset.StandardCharsets");
                        maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        if (after == null) {
                            after = JavaTemplate.builder("java.nio.file.Files.newBufferedReader(java.nio.file.Path.of(#{path:any(java.lang.String)}))")
                                    .bindType("java.io.BufferedReader").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(#{path:any(java.lang.String)})))")
                                .bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.io.InputStreamReader");
                        maybeRemoveImport("java.io.FileInputStream");
                        if (after == null) {
                            after = JavaTemplate.builder("java.nio.file.Files.newBufferedReader(java.nio.file.Path.of(#{path:any(java.lang.String)}))")
                                    .bindType("java.io.BufferedReader").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.io.BufferedReader", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("java.io.FileInputStream", true),
                                            new UsesType<>("java.io.InputStreamReader", true),
                                            new UsesMethod<>("java.io.BufferedReader <init>(..)", true),
                                            new UsesMethod<>("java.io.FileInputStream <init>(..)", true),
                                            new UsesMethod<>("java.io.InputStreamReader <init>(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.nio.file.Files", true),
                                            new UsesType<>("java.nio.file.Path", true),
                                            new UsesMethod<>("java.nio.file.Files newBufferedReader(..)", true),
                                            new UsesMethod<>("java.nio.file.Path of(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.FilesNewBufferedReaderToPath}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FilesNewBufferedReaderToPathRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FilesNewBufferedReaderToPathRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `FileRules.FilesNewBufferedReaderToPath`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Files#newBufferedReader(Path)` over more verbose or contrived alternatives.";
        }

        @Override
        public Set<String> getTags() {
            return new HashSet<>(Arrays.asList("RSPEC-S1943", "RSPEC-S2095"));
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.nio.file.Files.newBufferedReader(#{file:any(java.io.File)}.toPath(), java.nio.charset.StandardCharsets.UTF_8)")
                                .bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.nio.charset.StandardCharsets");
                        maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        if (after == null) {
                            after = JavaTemplate.builder("java.nio.file.Files.newBufferedReader(#{file:any(java.io.File)}.toPath())")
                                    .bindType("java.io.BufferedReader").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(#{file:any(java.io.File)})))")
                                .bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.io.InputStreamReader");
                        maybeRemoveImport("java.io.FileInputStream");
                        if (after == null) {
                            after = JavaTemplate.builder("java.nio.file.Files.newBufferedReader(#{file:any(java.io.File)}.toPath())")
                                    .bindType("java.io.BufferedReader").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.nio.file.Files.newBufferedReader(#{file:any(java.io.File)}.toPath(), java.nio.charset.StandardCharsets.UTF_8)")
                                .bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.nio.charset.StandardCharsets");
                        maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        if (after == null) {
                            after = JavaTemplate.builder("java.nio.file.Files.newBufferedReader(#{file:any(java.io.File)}.toPath())")
                                    .bindType("java.io.BufferedReader").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(#{file:any(java.io.File)})))")
                                .bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.io.InputStreamReader");
                        maybeRemoveImport("java.io.FileInputStream");
                        if (after == null) {
                            after = JavaTemplate.builder("java.nio.file.Files.newBufferedReader(#{file:any(java.io.File)}.toPath())")
                                    .bindType("java.io.BufferedReader").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.io.BufferedReader", true),
                            new UsesType<>("java.io.File", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("java.io.FileInputStream", true),
                                            new UsesType<>("java.io.InputStreamReader", true),
                                            new UsesMethod<>("java.io.BufferedReader <init>(..)", true),
                                            new UsesMethod<>("java.io.FileInputStream <init>(..)", true),
                                            new UsesMethod<>("java.io.InputStreamReader <init>(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.nio.file.Files", true),
                                            new UsesMethod<>("java.io.File toPath(..)", true),
                                            new UsesMethod<>("java.nio.file.Files newBufferedReader(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.FilesNewBufferedReaderPathOfWithCharset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FilesNewBufferedReaderPathOfWithCharsetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FilesNewBufferedReaderPathOfWithCharsetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `FileRules.FilesNewBufferedReaderPathOfWithCharset`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Files#newBufferedReader(Path, Charset)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(#{path:any(java.lang.String)}), #{charset:any(java.nio.charset.Charset)}))")
                                .bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.io.InputStreamReader");
                        maybeRemoveImport("java.io.FileInputStream");
                        if (after == null) {
                            after = JavaTemplate.builder("java.nio.file.Files.newBufferedReader(java.nio.file.Path.of(#{path:any(java.lang.String)}), #{charset:any(java.nio.charset.Charset)})")
                                    .bindType("java.io.BufferedReader").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.io.BufferedReader", true),
                            new UsesType<>("java.io.FileInputStream", true),
                            new UsesType<>("java.io.InputStreamReader", true),
                            new UsesType<>("java.nio.charset.Charset", true),
                            new UsesMethod<>("java.io.BufferedReader <init>(..)", true),
                            new UsesMethod<>("java.io.FileInputStream <init>(..)", true),
                            new UsesMethod<>("java.io.InputStreamReader <init>(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code FileRules.FilesNewBufferedReaderToPathWithCharset}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class FilesNewBufferedReaderToPathWithCharsetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public FilesNewBufferedReaderToPathWithCharsetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `FileRules.FilesNewBufferedReaderToPathWithCharset`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Files#newBufferedReader(Path, Charset)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(#{file:any(java.io.File)}), #{charset:any(java.nio.charset.Charset)}))")
                                .bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.io.InputStreamReader");
                        maybeRemoveImport("java.io.FileInputStream");
                        if (after == null) {
                            after = JavaTemplate.builder("java.nio.file.Files.newBufferedReader(#{file:any(java.io.File)}.toPath(), #{charset:any(java.nio.charset.Charset)})")
                                    .bindType("java.io.BufferedReader").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.io.BufferedReader", true),
                            new UsesType<>("java.io.File", true),
                            new UsesType<>("java.io.FileInputStream", true),
                            new UsesType<>("java.io.InputStreamReader", true),
                            new UsesType<>("java.nio.charset.Charset", true),
                            new UsesMethod<>("java.io.BufferedReader <init>(..)", true),
                            new UsesMethod<>("java.io.FileInputStream <init>(..)", true),
                            new UsesMethod<>("java.io.InputStreamReader <init>(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
