package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.EqualityRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class EqualityRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public EqualityRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`EqualityRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with (in)equalities.\n[Source](https://error-prone.picnic.tech/refasterrules/EqualityRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new EnumReferenceEqualityRecipe(),
                new EnumReferenceEqualityLambdaRecipe(),
                new EqualsPredicateRecipe(),
                new DoubleNegationRecipe(),
                new NegationRecipe(),
                new IndirectDoubleNegationRecipe(),
                new EqualsRecipe(),
                new ObjectsEqualsRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code EqualityRules.EnumReferenceEquality}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EnumReferenceEqualityRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EnumReferenceEqualityRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `EqualityRules.EnumReferenceEquality`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer reference-based equality for enums.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{a:any(T)}.equals(#{b:any(T)})")
                                .genericTypes("T extends java.lang.Enum<T>").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(T)} == #{b:any(T)}")
                                    .genericTypes("T extends java.lang.Enum<T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Objects.equals(#{a:any(T)}, #{b:any(T)})")
                                .genericTypes("T extends java.lang.Enum<T>").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Objects");
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(T)} == #{b:any(T)}")
                                    .genericTypes("T extends java.lang.Enum<T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{a:any(T)}.ordinal() == #{b:any(T)}.ordinal()")
                                .genericTypes("T extends java.lang.Enum<T>").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(T)} == #{b:any(T)}")
                                    .genericTypes("T extends java.lang.Enum<T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{a:any(T)}.equals(#{b:any(T)})")
                                .genericTypes("T extends java.lang.Enum<T>").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(T)} == #{b:any(T)}")
                                    .genericTypes("T extends java.lang.Enum<T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Objects.equals(#{a:any(T)}, #{b:any(T)})")
                                .genericTypes("T extends java.lang.Enum<T>").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Objects");
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(T)} == #{b:any(T)}")
                                    .genericTypes("T extends java.lang.Enum<T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{a:any(T)}.ordinal() == #{b:any(T)}.ordinal()")
                                .genericTypes("T extends java.lang.Enum<T>").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(T)} == #{b:any(T)}")
                                    .genericTypes("T extends java.lang.Enum<T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            new UsesMethod<>("java.lang.Enum equals(..)", true),
                            new UsesMethod<>("java.lang.Enum ordinal(..)", true),
                            Preconditions.and(
                                    new UsesType<>("java.util.Objects", true),
                                    new UsesMethod<>("java.util.Objects equals(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code EqualityRules.EnumReferenceEqualityLambda}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EnumReferenceEqualityLambdaRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EnumReferenceEqualityLambdaRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `EqualityRules.EnumReferenceEqualityLambda`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer reference-based equality for enums.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitExpression(Expression elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.util.function.Predicate.isEqual(#{e:any(T)})")
                                .bindType("java.util.function.Predicate<T>")
                                .genericTypes("T extends java.lang.Enum<T>").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Predicate");
                        maybeRemoveImport("java.util.function.Predicate.isEqual");
                        if (after == null) {
                            after = JavaTemplate.builder("(v)->v == #{e:any(T)}")
                                    .bindType("java.util.function.Predicate<T>")
                                    .genericTypes("T extends java.lang.Enum<T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{e:any(T)}::equals")
                                .bindType("java.util.function.Predicate<T>")
                                .genericTypes("T extends java.lang.Enum<T>").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("(v)->v == #{e:any(T)}")
                                    .bindType("java.util.function.Predicate<T>")
                                    .genericTypes("T extends java.lang.Enum<T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitExpression(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.util.function.Predicate.isEqual(#{e:any(T)})")
                                .bindType("java.util.function.Predicate<T>")
                                .genericTypes("T extends java.lang.Enum<T>").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.function.Predicate");
                        maybeRemoveImport("java.util.function.Predicate.isEqual");
                        if (after == null) {
                            after = JavaTemplate.builder("(v)->v == #{e:any(T)}")
                                    .bindType("java.util.function.Predicate<T>")
                                    .genericTypes("T extends java.lang.Enum<T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{e:any(T)}::equals")
                                .bindType("java.util.function.Predicate<T>")
                                .genericTypes("T extends java.lang.Enum<T>").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("(v)->v == #{e:any(T)}")
                                    .bindType("java.util.function.Predicate<T>")
                                    .genericTypes("T extends java.lang.Enum<T>").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesType<>("java.util.function.Predicate", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code EqualityRules.EqualsPredicate}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EqualsPredicateRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EqualsPredicateRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `EqualityRules.EqualsPredicate`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Object#equals(Object)` over the equivalent lambda function.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("(e)->#{v:any(T)}.equals(e)")
                                .bindType("java.util.function.Predicate<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{v:any(T)}::equals")
                                    .bindType("java.util.function.Predicate<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitLambda(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesMethod<>("java.lang.Object equals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code EqualityRules.DoubleNegation}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class DoubleNegationRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public DoubleNegationRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `EqualityRules.DoubleNegation`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid double negations; this is not Javascript.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S2761");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("!!#{b:any(boolean)}").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{b:any(boolean)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code EqualityRules.Negation}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class NegationRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public NegationRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `EqualityRules.Negation`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't negate an equality test or use the ternary operator to compare two booleans; directly test for inequality instead.";
        }

        @Override
        public Set<String> getTags() {
            return new HashSet<>(Arrays.asList("RSPEC-S1940", "RSPEC-S1244"));
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate after;

                @Override
                public J visitTernary(J.Ternary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("!(#{a:any(boolean)} == #{b:any(boolean)})").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(boolean)} != #{b:any(boolean)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{a:any(boolean)} ? !#{b:any(boolean)} : #{b}").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(boolean)} != #{b:any(boolean)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitTernary(elem, ctx);
                }

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("!(#{a:any(boolean)} == #{b:any(boolean)})").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(boolean)} != #{b:any(boolean)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{a:any(boolean)} ? !#{b:any(boolean)} : #{b}").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(boolean)} != #{b:any(boolean)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("!(#{a:any(double)} == #{b:any(double)})").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(boolean)} != #{b:any(boolean)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before1 == null) {
                        before1 = JavaTemplate.builder("!(#{a:any(java.lang.Object)} == #{b:any(java.lang.Object)})").build();
                    }
                    if ((matcher = before1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(boolean)} != #{b:any(boolean)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code EqualityRules.IndirectDoubleNegation}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IndirectDoubleNegationRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IndirectDoubleNegationRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `EqualityRules.IndirectDoubleNegation`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't negate an inequality test or use the ternary operator to compare two booleans; directly test for equality instead.";
        }

        @Override
        public Set<String> getTags() {
            return new HashSet<>(Arrays.asList("RSPEC-S1940", "RSPEC-S1244"));
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate after;

                @Override
                public J visitTernary(J.Ternary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("!(#{a:any(boolean)} != #{b:any(boolean)})").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(boolean)} == #{b:any(boolean)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{a:any(boolean)} ? #{b:any(boolean)} : !#{b}").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(boolean)} == #{b:any(boolean)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitTernary(elem, ctx);
                }

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("!(#{a:any(boolean)} != #{b:any(boolean)})").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(boolean)} == #{b:any(boolean)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{a:any(boolean)} ? #{b:any(boolean)} : !#{b}").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(boolean)} == #{b:any(boolean)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("!(#{a:any(double)} != #{b:any(double)})").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(boolean)} == #{b:any(boolean)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before1 == null) {
                        before1 = JavaTemplate.builder("!(#{a:any(java.lang.Object)} != #{b:any(java.lang.Object)})").build();
                    }
                    if ((matcher = before1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{a:any(boolean)} == #{b:any(boolean)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code EqualityRules.Equals}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EqualsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EqualsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `EqualityRules.Equals`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid contrived ways of handling `null` values during equality testing.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.util.Optional.of(#{value1:any(T)}).equals(java.util.Optional.of(#{value2:any(S)}))")
                                .genericTypes("T", "S").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Optional");
                        if (after == null) {
                            after = JavaTemplate.builder("#{value1:any(T)}.equals(#{value2:any(S)})")
                                    .genericTypes("T", "S").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Optional.of(#{value1:any(T)}).equals(java.util.Optional.ofNullable(#{value2:any(S)}))")
                                .genericTypes("T", "S").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Optional");
                        if (after == null) {
                            after = JavaTemplate.builder("#{value1:any(T)}.equals(#{value2:any(S)})")
                                    .genericTypes("T", "S").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.util.Optional.ofNullable(#{value2:any(S)}).equals(java.util.Optional.of(#{value1:any(T)}))")
                                .genericTypes("T", "S").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Optional");
                        if (after == null) {
                            after = JavaTemplate.builder("#{value1:any(T)}.equals(#{value2:any(S)})")
                                    .genericTypes("T", "S").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(1), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesMethod<>("java.util.Optional equals(..)", true),
                            new UsesMethod<>("java.util.Optional of(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code EqualityRules.ObjectsEquals}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ObjectsEqualsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ObjectsEqualsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `EqualityRules.ObjectsEquals`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid contrived ways of handling `null` values during equality testing.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("java.util.Optional.ofNullable(#{value1:any(T)}).equals(java.util.Optional.ofNullable(#{value2:any(S)}))")
                                .genericTypes("T", "S").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Optional");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Objects.equals(#{value1:any(T)}, #{value2:any(S)})")
                                    .genericTypes("T", "S").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesMethod<>("java.util.Optional equals(..)", true),
                            new UsesMethod<>("java.util.Optional ofNullable(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
