package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.CollectionRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class CollectionRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public CollectionRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`CollectionRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with (arbitrary) collections.\n[Source](https://error-prone.picnic.tech/refasterrules/CollectionRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new CollectionIsEmptyRecipe(),
                new CollectionSizeRecipe(),
                new CollectionContainsRecipe(),
                new CollectionAddAllToCollectionExpressionRecipe(),
                new CollectionRemoveAllFromCollectionExpressionRecipe(),
                new SetStreamRecipe(),
                new NewArrayListFromCollectionRecipe(),
                new ImmutableCollectionAsListRecipe(),
                new ImmutableCollectionStreamRecipe(),
                new ImmutableCollectionContainsRecipe(),
                new ImmutableCollectionParallelStreamRecipe(),
                new ImmutableCollectionToStringRecipe(),
                new CollectionToArrayRecipe(),
                new ImmutableCollectionToArrayWithArrayRecipe(),
                new ImmutableCollectionToArrayWithGeneratorRecipe(),
                new CollectionIteratorRecipe(),
                new OptionalFirstCollectionElementRecipe(),
                new RemoveOptionalFirstNavigableSetElementRecipe(),
                new CollectionForEachRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.CollectionIsEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CollectionIsEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CollectionIsEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.CollectionIsEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Collection#isEmpty()` over alternatives that consult the collection's size or are otherwise more contrived.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S1155");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate before$5;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.size() == 0")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.isEmpty()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.size() <= 0")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.isEmpty()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.size() < 1")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.isEmpty()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("com.google.common.collect.Iterables.isEmpty(#{collection:any(java.util.Collection<T>)})")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Iterables");
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.isEmpty()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$4 == null) {
                        before$4 = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().findAny().isEmpty()")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$4.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.isEmpty()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$5 == null) {
                        before$5 = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().findFirst().isEmpty()")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$5.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.isEmpty()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.size() == 0")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.isEmpty()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.size() <= 0")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.isEmpty()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.size() < 1")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.isEmpty()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("com.google.common.collect.Iterables.isEmpty(#{collection:any(java.util.Collection<T>)})")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Iterables");
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.isEmpty()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$4 == null) {
                        before$4 = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().findAny().isEmpty()")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$4.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.isEmpty()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$5 == null) {
                        before$5 = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().findFirst().isEmpty()")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$5.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.isEmpty()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().isEmpty()")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.isEmpty()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableCollection asList(..)", true),
                                    new UsesMethod<>("java.util.AbstractCollection isEmpty(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.Iterables", true),
                                    new UsesType<>("java.util.Collection", true),
                                    new UsesMethod<>("com.google.common.collect.Iterables isEmpty(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("java.util.Collection", true),
                                    new UsesMethod<>("java.util.Collection size(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("java.util.Collection", true),
                                    new UsesMethod<>("java.util.Collection stream(..)", true),
                                    new UsesMethod<>("java.util.Optional isEmpty(..)", true),
                                    new UsesMethod<>("java.util.stream.Stream findAny(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("java.util.Collection", true),
                                    new UsesMethod<>("java.util.Collection stream(..)", true),
                                    new UsesMethod<>("java.util.Optional isEmpty(..)", true),
                                    new UsesMethod<>("java.util.stream.Stream findFirst(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.CollectionSize}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CollectionSizeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CollectionSizeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.CollectionSize`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Collection#size()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.Iterables.size(#{collection:any(java.util.Collection<T>)})")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Iterables");
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.size()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().size()")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.size()")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableCollection asList(..)", true),
                                    new UsesMethod<>("java.util.List size(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.Iterables", true),
                                    new UsesType<>("java.util.Collection", true),
                                    new UsesMethod<>("com.google.common.collect.Iterables size(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.CollectionContains}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CollectionContainsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CollectionContainsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.CollectionContains`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Collection#contains(Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().anyMatch(#{value:any(S)}::equals)")
                                .genericTypes("T", "S").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.contains(#{value:any(S)})")
                                    .genericTypes("T", "S").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Collection", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.stream.Stream anyMatch(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.CollectionAddAllToCollectionExpression}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CollectionAddAllToCollectionExpressionRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CollectionAddAllToCollectionExpressionRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.CollectionAddAllToCollectionExpression`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't call `Iterables#addAll(Collection, Iterable)` when the elements to be added are already part of a `Collection`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.Iterables.addAll(#{addTo:any(java.util.Collection<T>)}, #{elementsToAdd:any(java.util.Collection<S>)})")
                                .genericTypes("T", "S extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Iterables");
                        if (after == null) {
                            after = JavaTemplate.builder("#{addTo:any(java.util.Collection<T>)}.addAll(#{elementsToAdd:any(java.util.Collection<S>)})")
                                    .genericTypes("T", "S extends T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Iterables", true),
                            new UsesType<>("java.util.Collection", true),
                            new UsesMethod<>("com.google.common.collect.Iterables addAll(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.CollectionRemoveAllFromCollectionExpression}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CollectionRemoveAllFromCollectionExpressionRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CollectionRemoveAllFromCollectionExpressionRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.CollectionRemoveAllFromCollectionExpression`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't call `Iterables#removeAll(Iterable, Collection)` when the elements to be removed are already part of a `Collection`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.Iterables.removeAll(#{removeTo:any(java.util.Collection<T>)}, #{elementsToRemove:any(java.util.Collection<S>)})")
                                .genericTypes("T", "S extends T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Iterables");
                        if (after == null) {
                            after = JavaTemplate.builder("#{removeTo:any(java.util.Collection<T>)}.removeAll(#{elementsToRemove:any(java.util.Collection<S>)})")
                                    .genericTypes("T", "S extends T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Iterables", true),
                            new UsesType<>("java.util.Collection", true),
                            new UsesMethod<>("com.google.common.collect.Iterables removeAll(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.SetStream}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SetStreamRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SetStreamRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.SetStream`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily call `Stream#distinct()` on an already-unique stream of elements.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{set:any(java.util.Set<T>)}.stream().distinct()")
                                .bindType("java.util.stream.Stream<?>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{set:any(java.util.Set<T>)}.stream()")
                                    .bindType("java.util.stream.Stream<?>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Set", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.stream.Stream distinct(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.NewArrayListFromCollection}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class NewArrayListFromCollectionRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public NewArrayListFromCollectionRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.NewArrayListFromCollection`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ArrayList#ArrayList(Collection)` over the Guava alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.Lists.newArrayList(#{collection:any(java.util.Collection<T>)})")
                                .bindType("java.util.ArrayList<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Lists");
                        if (after == null) {
                            after = JavaTemplate.builder("new java.util.ArrayList<>(#{collection:any(java.util.Collection<T>)})")
                                    .bindType("java.util.ArrayList<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Lists", true),
                            new UsesType<>("java.util.ArrayList", true),
                            new UsesType<>("java.util.Collection", true),
                            new UsesMethod<>("com.google.common.collect.Lists newArrayList(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.ImmutableCollectionAsList}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableCollectionAsListRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableCollectionAsListRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.ImmutableCollectionAsList`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `ImmutableCollection#asList()` over the more verbose alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.ImmutableList.copyOf(#{collection:any(com.google.common.collect.ImmutableCollection<T>)})")
                                .bindType("com.google.common.collect.ImmutableList<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList()")
                                    .bindType("com.google.common.collect.ImmutableList<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                            new UsesType<>("com.google.common.collect.ImmutableList", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableList copyOf(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.ImmutableCollectionStream}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableCollectionStreamRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableCollectionStreamRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.ImmutableCollectionStream`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't call `ImmutableCollection#asList()` if the result is going to be streamed; stream directly.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().stream()")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.stream()")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableCollection asList(..)", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.ImmutableCollectionContains}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableCollectionContainsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableCollectionContainsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.ImmutableCollectionContains`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't call `ImmutableCollection#asList()` if `Collection#contains(Object)` is called on the result; call it directly.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().contains(#{elem:any(S)})")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.contains(#{elem:any(S)})")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableCollection asList(..)", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableList contains(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.ImmutableCollectionParallelStream}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableCollectionParallelStreamRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableCollectionParallelStreamRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.ImmutableCollectionParallelStream`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't call `ImmutableCollection#asList()` if `ImmutableCollection#parallelStream()` is called on the result; call it directly.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().parallelStream()")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.parallelStream()")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableCollection asList(..)", true),
                            new UsesMethod<>("java.util.Collection parallelStream(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.ImmutableCollectionToString}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableCollectionToStringRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableCollectionToStringRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.ImmutableCollectionToString`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't call `ImmutableCollection#asList()` if `ImmutableCollection#toString()` is called on the result; call it directly.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().toString()")
                                .bindType("java.lang.String")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.toString()")
                                    .bindType("java.lang.String")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableCollection asList(..)", true),
                            new UsesMethod<>("java.util.AbstractCollection toString(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.CollectionToArray}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CollectionToArrayRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CollectionToArrayRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.CollectionToArray`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer calling `Collection#toArray()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.toArray(new Object[#{size:any(int)}])")
                                .bindType("java.lang.Object[]")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.toArray()")
                                    .bindType("java.lang.Object[]")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.toArray(Object[]::new)")
                                .bindType("java.lang.Object[]")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.toArray()")
                                    .bindType("java.lang.Object[]")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().toArray()")
                                .bindType("java.lang.Object[]")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.toArray()")
                                    .bindType("java.lang.Object[]")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableCollection asList(..)", true),
                                    new UsesMethod<>("com.google.common.collect.ImmutableCollection toArray(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("java.util.Collection", true),
                                    new UsesMethod<>("java.util.Collection toArray(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.ImmutableCollectionToArrayWithArray}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableCollectionToArrayWithArrayRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableCollectionToArrayWithArrayRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.ImmutableCollectionToArrayWithArray`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't call `ImmutableCollection#asList()` if `ImmutableCollection#toArray(Object[])`` is called on the result; call it directly.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().toArray(#{array:any(S[])})")
                                .bindType("java.lang.Object[]")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.toArray(#{array:any(S[])})")
                                    .bindType("java.lang.Object[]")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableCollection asList(..)", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableCollection toArray(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.ImmutableCollectionToArrayWithGenerator}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class ImmutableCollectionToArrayWithGeneratorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public ImmutableCollectionToArrayWithGeneratorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.ImmutableCollectionToArrayWithGenerator`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't call `ImmutableCollection#asList()` if `ImmutableCollection#toArray(IntFunction)`} is called on the result; call it directly.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().toArray(#{generator:any(java.util.function.IntFunction<S[]>)})")
                                .bindType("S[]")
                                .genericTypes("T", "S")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.toArray(#{generator:any(java.util.function.IntFunction<S[]>)})")
                                    .bindType("S[]")
                                    .genericTypes("T", "S")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                            new UsesType<>("java.util.function.IntFunction", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableCollection asList(..)", true),
                            new UsesMethod<>("java.util.Collection toArray(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.CollectionIterator}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CollectionIteratorRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CollectionIteratorRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.CollectionIterator`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Collection#iterator()` over more contrived or less efficient alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().iterator()")
                                .bindType("java.util.Iterator<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.iterator()")
                                    .bindType("java.util.Iterator<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().iterator()")
                                .bindType("java.util.Iterator<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.iterator()")
                                    .bindType("java.util.Iterator<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Iterator", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableCollection", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableCollection asList(..)", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableList iterator(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Collection", true),
                                            new UsesMethod<>("java.util.Collection stream(..)", true),
                                            new UsesMethod<>("java.util.stream.BaseStream iterator(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.OptionalFirstCollectionElement}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class OptionalFirstCollectionElementRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public OptionalFirstCollectionElementRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.OptionalFirstCollectionElement`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't use the ternary operator to extract the first element of a possibly-empty `Collection` as an `Optional`, and (when applicable) prefer `Stream#findFirst()` over `Stream#findAny()` to communicate that the collection's first element (if any, according to iteration order) will be returned.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().findAny()")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().findFirst()")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.isEmpty() ? java.util.Optional.empty() : java.util.Optional.of(#{collection}.iterator().next())")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().findFirst()")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

                @Override
                public J visitTernary(J.Ternary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().findAny()")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().findFirst()")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.isEmpty() ? java.util.Optional.empty() : java.util.Optional.of(#{collection}.iterator().next())")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().findFirst()")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{collection:any(java.util.List<T>)}.isEmpty() ? java.util.Optional.empty() : java.util.Optional.of(#{collection}.get(0))")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.List");
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().findFirst()")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1 == null) {
                        before1 = JavaTemplate.builder("#{collection:any(java.util.SortedSet<T>)}.isEmpty() ? java.util.Optional.empty() : java.util.Optional.of(#{collection}.first())")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.SortedSet");
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().findFirst()")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitTernary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("java.util.Collection", true),
                                            new UsesMethod<>("java.util.Collection isEmpty(..)", true),
                                            new UsesMethod<>("java.util.Collection iterator(..)", true),
                                            new UsesMethod<>("java.util.Iterator next(..)", true),
                                            new UsesMethod<>("java.util.Optional empty(..)", true),
                                            new UsesMethod<>("java.util.Optional of(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Collection", true),
                                            new UsesMethod<>("java.util.Collection stream(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream findAny(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.List", true),
                                            new UsesMethod<>("java.util.List get(..)", true),
                                            new UsesMethod<>("java.util.List isEmpty(..)", true),
                                            new UsesMethod<>("java.util.Optional empty(..)", true),
                                            new UsesMethod<>("java.util.Optional of(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.SortedSet", true),
                                            new UsesMethod<>("java.util.Optional empty(..)", true),
                                            new UsesMethod<>("java.util.Optional of(..)", true),
                                            new UsesMethod<>("java.util.Set isEmpty(..)", true),
                                            new UsesMethod<>("java.util.SortedSet first(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.RemoveOptionalFirstNavigableSetElement}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class RemoveOptionalFirstNavigableSetElementRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public RemoveOptionalFirstNavigableSetElementRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.RemoveOptionalFirstNavigableSetElement`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid contrived constructions when extracting the first element from a possibly empty `NavigableSet`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{set:any(java.util.NavigableSet<T>)}.isEmpty() ? java.util.Optional.empty() : java.util.Optional.of(#{set}.pollFirst())")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Optional.ofNullable(#{set:any(java.util.NavigableSet<T>)}.pollFirst())")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{set:any(java.util.NavigableSet<T>)}.isEmpty() ? java.util.Optional.empty() : java.util.Optional.ofNullable(#{set}.pollFirst())")
                                .bindType("java.util.Optional<T>")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Optional.ofNullable(#{set:any(java.util.NavigableSet<T>)}.pollFirst())")
                                    .bindType("java.util.Optional<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.NavigableSet", true),
                            new UsesType<>("java.util.Optional", true),
                            new UsesMethod<>("java.util.NavigableSet pollFirst(..)", true),
                            new UsesMethod<>("java.util.Optional empty(..)", true),
                            new UsesMethod<>("java.util.Set isEmpty(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.util.Optional of(..)", true),
                                    new UsesMethod<>("java.util.Optional ofNullable(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code CollectionRules.CollectionForEach}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CollectionForEachRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CollectionForEachRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `CollectionRules.CollectionForEach`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Collection#forEach(Consumer)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.stream().forEach(#{consumer:any(java.util.function.Consumer<? super T>)});")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{collection:any(java.util.Collection<T>)}.forEach(#{consumer:any(java.util.function.Consumer<? super T>)});")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Collection", true),
                            new UsesType<>("java.util.function.Consumer", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("java.util.stream.Stream forEach(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
