package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.BugCheckerRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class BugCheckerRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public BugCheckerRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`BugCheckerRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to `com.google.errorprone.bugpatterns.BugChecker` classes.\n[Source](https://error-prone.picnic.tech/refasterrules/BugCheckerRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new BugCheckerRefactoringTestHelperIdentityRecipe(),
                new BugCheckerRefactoringTestHelperAddInputLinesExpectUnchangedRecipe(),
                new NameContentEqualsRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code BugCheckerRules.BugCheckerRefactoringTestHelperIdentity}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class BugCheckerRefactoringTestHelperIdentityRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public BugCheckerRefactoringTestHelperIdentityRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `BugCheckerRules.BugCheckerRefactoringTestHelperIdentity`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Avoid calling `BugCheckerRefactoringTestHelper#setFixChooser(FixChooser)` or `BugCheckerRefactoringTestHelper#setImportOrder(String)` with their respective default values.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.setFixChooser(com.google.errorprone.BugCheckerRefactoringTestHelper.FixChoosers.FIRST)")
                                .bindType("com.google.errorprone.BugCheckerRefactoringTestHelper")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_test_helpers-2"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.errorprone.BugCheckerRefactoringTestHelper.FixChoosers");
                        if (after == null) {
                            after = JavaTemplate.builder("#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}")
                                    .bindType("com.google.errorprone.BugCheckerRefactoringTestHelper")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_test_helpers-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.setImportOrder(\"static-first\")")
                                .bindType("com.google.errorprone.BugCheckerRefactoringTestHelper")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_test_helpers-2"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}")
                                    .bindType("com.google.errorprone.BugCheckerRefactoringTestHelper")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_test_helpers-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.errorprone.BugCheckerRefactoringTestHelper", true),
                            Preconditions.or(
                                    new UsesMethod<>("com.google.errorprone.BugCheckerRefactoringTestHelper setImportOrder(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("com.google.errorprone.BugCheckerRefactoringTestHelper.FixChoosers", true),
                                            new UsesMethod<>("com.google.errorprone.BugCheckerRefactoringTestHelper setFixChooser(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code BugCheckerRules.BugCheckerRefactoringTestHelperAddInputLinesExpectUnchanged}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class BugCheckerRefactoringTestHelperAddInputLinesExpectUnchangedRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public BugCheckerRefactoringTestHelperAddInputLinesExpectUnchangedRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `BugCheckerRules.BugCheckerRefactoringTestHelperAddInputLinesExpectUnchanged`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `BugCheckerRefactoringTestHelper.ExpectOutput#expectUnchanged()` over repeating the input.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.addInputLines(#{path:any(java.lang.String)}, #{source:any(java.lang.String)}).addOutputLines(#{path}, #{source})")
                                .bindType("com.google.errorprone.BugCheckerRefactoringTestHelper")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_test_helpers-2"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.addInputLines(#{path:any(java.lang.String)}, #{source:any(java.lang.String)}).expectUnchanged()")
                                    .bindType("com.google.errorprone.BugCheckerRefactoringTestHelper")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "error_prone_test_helpers-2"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.errorprone.BugCheckerRefactoringTestHelper", true),
                            new UsesMethod<>("com.google.errorprone.BugCheckerRefactoringTestHelper addInputLines(..)", true),
                            new UsesMethod<>("com.google.errorprone.BugCheckerRefactoringTestHelper.ExpectOutput addOutputLines(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code BugCheckerRules.NameContentEquals}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class NameContentEqualsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public NameContentEqualsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `BugCheckerRules.NameContentEquals`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Name#contentEquals(CharSequence)` over more verbose alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{name:any(javax.lang.model.element.Name)}.toString().equals(#{string:any(java.lang.CharSequence)}.toString())").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{name:any(javax.lang.model.element.Name)}.contentEquals(#{string:any(java.lang.CharSequence)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{name:any(javax.lang.model.element.Name)}.toString().equals(#{string:any(java.lang.String)})").build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{name:any(javax.lang.model.element.Name)}.contentEquals(#{string:any(java.lang.CharSequence)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("javax.lang.model.element.Name", true),
                            new UsesMethod<>("java.lang.CharSequence toString(..)", true),
                            new UsesMethod<>("java.lang.String equals(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
