package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.BigDecimalRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class BigDecimalRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public BigDecimalRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`BigDecimalRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `BigDecimal`s.\n[Source](https://error-prone.picnic.tech/refasterrules/BigDecimalRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new BigDecimalZeroRecipe(),
                new BigDecimalOneRecipe(),
                new BigDecimalTenRecipe(),
                new BigDecimalValueOfRecipe(),
                new BigDecimalSignumIsZeroRecipe(),
                new BigDecimalSignumIsPositiveRecipe(),
                new BigDecimalSignumIsNegativeRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code BigDecimalRules.BigDecimalZero}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class BigDecimalZeroRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public BigDecimalZeroRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `BigDecimalRules.BigDecimalZero`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer using the constant `BigDecimal#ZERO` when possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.math.BigDecimal.valueOf(0)")
                                .bindType("java.math.BigDecimal").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.math.BigDecimal.ZERO")
                                    .bindType("java.math.BigDecimal").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("new java.math.BigDecimal(\"0\")")
                                .bindType("java.math.BigDecimal").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.math.BigDecimal.ZERO")
                                    .bindType("java.math.BigDecimal").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.math.BigDecimal.valueOf(0)")
                                .bindType("java.math.BigDecimal").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.math.BigDecimal.ZERO")
                                    .bindType("java.math.BigDecimal").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("new java.math.BigDecimal(\"0\")")
                                .bindType("java.math.BigDecimal").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.math.BigDecimal.ZERO")
                                    .bindType("java.math.BigDecimal").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.math.BigDecimal", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.math.BigDecimal <init>(..)", true),
                                    new UsesMethod<>("java.math.BigDecimal valueOf(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code BigDecimalRules.BigDecimalOne}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class BigDecimalOneRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public BigDecimalOneRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `BigDecimalRules.BigDecimalOne`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer using the constant `BigDecimal#ONE` when possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.math.BigDecimal.valueOf(1)")
                                .bindType("java.math.BigDecimal").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.math.BigDecimal.ONE")
                                    .bindType("java.math.BigDecimal").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("new java.math.BigDecimal(\"1\")")
                                .bindType("java.math.BigDecimal").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.math.BigDecimal.ONE")
                                    .bindType("java.math.BigDecimal").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.math.BigDecimal.valueOf(1)")
                                .bindType("java.math.BigDecimal").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.math.BigDecimal.ONE")
                                    .bindType("java.math.BigDecimal").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("new java.math.BigDecimal(\"1\")")
                                .bindType("java.math.BigDecimal").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.math.BigDecimal.ONE")
                                    .bindType("java.math.BigDecimal").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.math.BigDecimal", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.math.BigDecimal <init>(..)", true),
                                    new UsesMethod<>("java.math.BigDecimal valueOf(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code BigDecimalRules.BigDecimalTen}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class BigDecimalTenRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public BigDecimalTenRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `BigDecimalRules.BigDecimalTen`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer using the constant `BigDecimal#TEN` when possible.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.math.BigDecimal.valueOf(10)")
                                .bindType("java.math.BigDecimal").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.math.BigDecimal.TEN")
                                    .bindType("java.math.BigDecimal").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("new java.math.BigDecimal(\"10\")")
                                .bindType("java.math.BigDecimal").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.math.BigDecimal.TEN")
                                    .bindType("java.math.BigDecimal").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.math.BigDecimal.valueOf(10)")
                                .bindType("java.math.BigDecimal").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.math.BigDecimal.TEN")
                                    .bindType("java.math.BigDecimal").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("new java.math.BigDecimal(\"10\")")
                                .bindType("java.math.BigDecimal").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.math.BigDecimal.TEN")
                                    .bindType("java.math.BigDecimal").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace()),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.math.BigDecimal", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.math.BigDecimal <init>(..)", true),
                                    new UsesMethod<>("java.math.BigDecimal valueOf(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code BigDecimalRules.BigDecimalValueOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class BigDecimalValueOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public BigDecimalValueOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `BigDecimalRules.BigDecimalValueOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `BigDecimal#valueOf(double)` over the associated constructor.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S2111");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("new java.math.BigDecimal(#{value:any(double)})")
                                .bindType("java.math.BigDecimal").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.math.BigDecimal.valueOf(#{value:any(double)})")
                                    .bindType("java.math.BigDecimal").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitNewClass(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.math.BigDecimal", true),
                            new UsesMethod<>("java.math.BigDecimal <init>(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code BigDecimalRules.BigDecimalSignumIsZero}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class BigDecimalSignumIsZeroRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public BigDecimalSignumIsZeroRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `BigDecimalRules.BigDecimalSignumIsZero`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer using `BigDecimal#signum()` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.compareTo(java.math.BigDecimal.ZERO) == 0").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.signum() == 0").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.math.BigDecimal.ZERO.compareTo(#{value:any(java.math.BigDecimal)}) == 0").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.signum() == 0").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.math.BigDecimal", true),
                            new UsesMethod<>("java.math.BigDecimal compareTo(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code BigDecimalRules.BigDecimalSignumIsPositive}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class BigDecimalSignumIsPositiveRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public BigDecimalSignumIsPositiveRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `BigDecimalRules.BigDecimalSignumIsPositive`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer a `BigDecimal#signum()` comparison to 1 over more contrived or less clear alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.compareTo(java.math.BigDecimal.ZERO) > 0").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.signum() == 1").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.math.BigDecimal.ZERO.compareTo(#{value:any(java.math.BigDecimal)}) < 0").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.signum() == 1").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.signum() > 0").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.signum() == 1").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.signum() >= 1").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.signum() == 1").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.math.BigDecimal", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.math.BigDecimal compareTo(..)", true),
                                    new UsesMethod<>("java.math.BigDecimal signum(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code BigDecimalRules.BigDecimalSignumIsNegative}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class BigDecimalSignumIsNegativeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public BigDecimalSignumIsNegativeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `BigDecimalRules.BigDecimalSignumIsNegative`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer a `BigDecimal#signum()` comparison to -1 over more contrived or less clear alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.compareTo(java.math.BigDecimal.ZERO) < 0").build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.signum() == -1").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.math.BigDecimal.ZERO.compareTo(#{value:any(java.math.BigDecimal)}) > 0").build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.signum() == -1").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.signum() < 0").build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.signum() == -1").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.signum() <= -1").build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{value:any(java.math.BigDecimal)}.signum() == -1").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.math.BigDecimal", true),
                            Preconditions.or(
                                    new UsesMethod<>("java.math.BigDecimal compareTo(..)", true),
                                    new UsesMethod<>("java.math.BigDecimal signum(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

}
