package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssortedRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssortedRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssortedRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`AssortedRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Assorted Refaster rules that do not (yet) belong in one of the other classes with more topical Refaster rules.\n[Source](https://error-prone.picnic.tech/refasterrules/AssortedRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new CheckIndexRecipe(),
                new IteratorGetNextOrDefaultRecipe(),
                new LogicalImplicationRecipe(),
                new UnboundedSingleElementStreamRecipe(),
                new DisjointSetsRecipe(),
                new DisjointCollectionsRecipe(),
                new IterableIsEmptyRecipe(),
                new SplitToStreamRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssortedRules.CheckIndex}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class CheckIndexRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public CheckIndexRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssortedRules.CheckIndex`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Objects#checkIndex(int, int)` over the Guava alternative.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.base.Preconditions.checkElementIndex(#{index:any(int)}, #{size:any(int)})")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.base.Preconditions");
                        maybeRemoveImport("com.google.common.base.Preconditions.checkElementIndex");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Objects.checkIndex(#{index:any(int)}, #{size:any(int)})").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    new UsesMethod<>("com.google.common.base.Preconditions checkElementIndex(..)", true),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssortedRules.IteratorGetNextOrDefault}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IteratorGetNextOrDefaultRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IteratorGetNextOrDefaultRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssortedRules.IteratorGetNextOrDefault`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Iterators#getNext(Iterator, Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{iterator:any(java.util.Iterator<T>)}.hasNext() ? #{iterator}.next() : #{defaultValue:any(T)}")
                                .bindType("T")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Iterators.getNext(#{iterator:any(java.util.Iterator<T>)}, #{defaultValue:any(T)})")
                                    .bindType("T")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterator:any(java.util.Iterator<T>)}).findFirst().orElse(#{defaultValue:any(T)})")
                                .bindType("T")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Iterators.getNext(#{iterator:any(java.util.Iterator<T>)}, #{defaultValue:any(T)})")
                                    .bindType("T")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterator:any(java.util.Iterator<T>)}).findAny().orElse(#{defaultValue:any(T)})")
                                .bindType("T")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Iterators.getNext(#{iterator:any(java.util.Iterator<T>)}, #{defaultValue:any(T)})")
                                    .bindType("T")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

                @Override
                public J visitTernary(J.Ternary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{iterator:any(java.util.Iterator<T>)}.hasNext() ? #{iterator}.next() : #{defaultValue:any(T)}")
                                .bindType("T")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Iterators.getNext(#{iterator:any(java.util.Iterator<T>)}, #{defaultValue:any(T)})")
                                    .bindType("T")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterator:any(java.util.Iterator<T>)}).findFirst().orElse(#{defaultValue:any(T)})")
                                .bindType("T")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Iterators.getNext(#{iterator:any(java.util.Iterator<T>)}, #{defaultValue:any(T)})")
                                    .bindType("T")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{iterator:any(java.util.Iterator<T>)}).findAny().orElse(#{defaultValue:any(T)})")
                                .bindType("T")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Iterators.getNext(#{iterator:any(java.util.Iterator<T>)}, #{defaultValue:any(T)})")
                                    .bindType("T")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitTernary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Iterator", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Iterator hasNext(..)", true),
                                            new UsesMethod<>("java.util.Iterator next(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Streams", true),
                                            new UsesMethod<>("com.google.common.collect.Streams stream(..)", true),
                                            new UsesMethod<>("java.util.Optional orElse(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream findAny(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Streams", true),
                                            new UsesMethod<>("com.google.common.collect.Streams stream(..)", true),
                                            new UsesMethod<>("java.util.Optional orElse(..)", true),
                                            new UsesMethod<>("java.util.stream.Stream findFirst(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssortedRules.LogicalImplication}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class LogicalImplicationRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public LogicalImplicationRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssortedRules.LogicalImplication`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily repeat boolean expressions.";
        }

        @Override
        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S2589");
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{firstTest:any(boolean)} || (!#{firstTest} && #{secondTest:any(boolean)})").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{firstTest:any(boolean)} || #{secondTest:any(boolean)}").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitBinary(elem, ctx);
                }

            };
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssortedRules.UnboundedSingleElementStream}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class UnboundedSingleElementStreamRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public UnboundedSingleElementStreamRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssortedRules.UnboundedSingleElementStream`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Stream#generate(java.util.function.Supplier)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.Streams.stream(com.google.common.collect.Iterables.cycle(#{object:any(T)}))")
                                .bindType("java.util.stream.Stream<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        maybeRemoveImport("com.google.common.collect.Iterables");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.stream.Stream.generate(()->#{object:any(T)})")
                                    .bindType("java.util.stream.Stream<T>")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.Iterables", true),
                            new UsesType<>("com.google.common.collect.Streams", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("com.google.common.collect.Iterables cycle(..)", true),
                            new UsesMethod<>("com.google.common.collect.Streams stream(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssortedRules.DisjointSets}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class DisjointSetsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public DisjointSetsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssortedRules.DisjointSets`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Collections#disjoint(Collection, Collection)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("com.google.common.collect.Sets.intersection(#{collection1:any(java.util.Set<T>)}, #{collection2:any(java.util.Set<T>)}).isEmpty()")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Set");
                        maybeRemoveImport("com.google.common.collect.Sets");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Collections.disjoint(#{collection1:any(java.util.Collection<T>)}, #{collection2:any(java.util.Collection<T>)})")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{collection1:any(java.util.Collection<T>)}.stream().noneMatch(#{collection2:any(java.util.Collection<T>)}::contains)")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Collections.disjoint(#{collection1:any(java.util.Collection<T>)}, #{collection2:any(java.util.Collection<T>)})")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            Preconditions.and(
                                    new UsesType<>("com.google.common.collect.Sets", true),
                                    new UsesType<>("java.util.Set", true),
                                    new UsesMethod<>("com.google.common.collect.Sets intersection(..)", true),
                                    new UsesMethod<>("java.util.AbstractCollection isEmpty(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("java.util.Collection", true),
                                    new UsesMethod<>("java.util.Collection stream(..)", true),
                                    new UsesMethod<>("java.util.stream.Stream noneMatch(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssortedRules.DisjointCollections}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class DisjointCollectionsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public DisjointCollectionsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssortedRules.DisjointCollections`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Don't unnecessarily copy collections before passing them to `Collections#disjoint(Collection, Collection)`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("java.util.Collections.disjoint(com.google.common.collect.ImmutableSet.copyOf(#{collection1:any(java.util.Collection<T>)}), #{collection2:any(java.util.Collection<T>)})")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Collections.disjoint(#{collection1:any(java.util.Collection<T>)}, #{collection2:any(java.util.Collection<T>)})")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("java.util.Collections.disjoint(new java.util.HashSet<>(#{collection1:any(java.util.Collection<T>)}), #{collection2:any(java.util.Collection<T>)})")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.HashSet");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Collections.disjoint(#{collection1:any(java.util.Collection<T>)}, #{collection2:any(java.util.Collection<T>)})")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("java.util.Collections.disjoint(#{collection1:any(java.util.Collection<T>)}, com.google.common.collect.ImmutableSet.copyOf(#{collection2:any(java.util.Collection<T>)}))")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Collections.disjoint(#{collection1:any(java.util.Collection<T>)}, #{collection2:any(java.util.Collection<T>)})")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("java.util.Collections.disjoint(#{collection1:any(java.util.Collection<T>)}, new java.util.HashSet<>(#{collection2:any(java.util.Collection<T>)}))")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.HashSet");
                        if (after == null) {
                            after = JavaTemplate.builder("java.util.Collections.disjoint(#{collection1:any(java.util.Collection<T>)}, #{collection2:any(java.util.Collection<T>)})")
                                    .genericTypes("T").build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Collection", true),
                            new UsesMethod<>("java.util.Collections disjoint(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.ImmutableSet", true),
                                            new UsesMethod<>("com.google.common.collect.ImmutableSet copyOf(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.HashSet", true),
                                            new UsesMethod<>("java.util.HashSet <init>(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssortedRules.IterableIsEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class IterableIsEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public IterableIsEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssortedRules.IterableIsEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Iterables#isEmpty(Iterable)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("!#{iterable:any(java.lang.Iterable<T>)}.iterator().hasNext()")
                                .genericTypes("T").build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("com.google.common.collect.Iterables.isEmpty(#{iterable:any(java.lang.Iterable<T>)})")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, SIMPLIFY_BOOLEANS
                        );
                    }
                    return super.visitUnary(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesMethod<>("java.lang.Iterable iterator(..)", true),
                            new UsesMethod<>("java.util.Iterator hasNext(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssortedRules.SplitToStream}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class SplitToStreamRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public SplitToStreamRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssortedRules.SplitToStream`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `Splitter#splitToStream(CharSequence)` over less efficient alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("com.google.common.collect.Streams.stream(#{splitter:any(com.google.common.base.Splitter)}.split(#{charSequence:any(java.lang.CharSequence)}))")
                                .bindType("java.util.stream.Stream<java.lang.String>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Streams");
                        if (after == null) {
                            after = JavaTemplate.builder("#{splitter:any(com.google.common.base.Splitter)}.splitToStream(#{charSequence:any(java.lang.CharSequence)})")
                                    .bindType("java.util.stream.Stream<java.lang.String>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{splitter:any(com.google.common.base.Splitter)}.splitToList(#{charSequence:any(java.lang.CharSequence)}).stream()")
                                .bindType("java.util.stream.Stream<java.lang.String>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{splitter:any(com.google.common.base.Splitter)}.splitToStream(#{charSequence:any(java.lang.CharSequence)})")
                                    .bindType("java.util.stream.Stream<java.lang.String>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.base.Splitter", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("com.google.common.base.Splitter splitToList(..)", true),
                                            new UsesMethod<>("java.util.Collection stream(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("com.google.common.collect.Streams", true),
                                            new UsesMethod<>("com.google.common.base.Splitter split(..)", true),
                                            new UsesMethod<>("com.google.common.collect.Streams stream(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

}
