package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJStreamRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJStreamRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJStreamRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`AssertJStreamRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJStreamRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJStreamRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AssertThatFilteredOnRecipe(),
                new AssertThatNoneMatchRecipe(),
                new AssertThatAnyMatchRecipe(),
                new AssertThatCollectionRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJStreamRules.AssertThatFilteredOn}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatFilteredOnRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatFilteredOnRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJStreamRules.AssertThatFilteredOn`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatFilteredOn<T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<T> stream, Predicate<? super T> predicate) {\n        return assertThat(stream.filter(predicate));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<T> after(Stream<T> stream, Predicate<? super T> predicate) {\n        return assertThat(stream).filteredOn(predicate);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)}))")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).filteredOn(#{predicate:any(java.util.function.Predicate<? super T>)})")
                                    .bindType("org.assertj.core.api.ListAssert<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesType<>("org.assertj.core.api.ListAssert", true),
                            new UsesMethod<>("java.util.stream.Stream filter(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJStreamRules.AssertThatNoneMatch}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatNoneMatchRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatNoneMatchRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJStreamRules.AssertThatNoneMatch`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatNoneMatch<T> {\n    \n    @BeforeTemplate\n    void before(Stream<T> stream, Predicate<? super T> predicate) {\n        assertThat(stream).filteredOn(predicate).isEmpty();\n    }\n    \n    @BeforeTemplate\n    void before2(Stream<T> stream, Predicate<? super T> predicate) {\n        Refaster.anyOf(assertThat(stream.anyMatch(predicate)).isFalse(), assertThat(stream.noneMatch(predicate)).isTrue());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Stream<T> stream, Predicate<? super T> predicate) {\n        assertThat(stream).noneMatch(predicate);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2$0;
                JavaTemplate before2$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).filteredOn(#{predicate:any(java.util.function.Predicate<? super T>)}).isEmpty();")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).noneMatch(#{predicate:any(java.util.function.Predicate<? super T>)});")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2$0 == null) {
                        before2$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}.anyMatch(#{predicate:any(java.util.function.Predicate<? super T>)})).isFalse();")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).noneMatch(#{predicate:any(java.util.function.Predicate<? super T>)});")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2$1 == null) {
                        before2$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}.noneMatch(#{predicate:any(java.util.function.Predicate<? super T>)})).isTrue();")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).noneMatch(#{predicate:any(java.util.function.Predicate<? super T>)});")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.stream.Stream anyMatch(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.stream.Stream noneMatch(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert filteredOn(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert isEmpty(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJStreamRules.AssertThatAnyMatch}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatAnyMatchRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatAnyMatchRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJStreamRules.AssertThatAnyMatch`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatAnyMatch<T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<T> stream, Predicate<? super T> predicate) {\n        return assertThat(stream).filteredOn(predicate).isNotEmpty();\n    }\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before2(Stream<T> stream, Predicate<? super T> predicate) {\n        return Refaster.anyOf(assertThat(stream.anyMatch(predicate)).isTrue(), assertThat(stream.noneMatch(predicate)).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<T> after(Stream<T> stream, Predicate<? super T> predicate) {\n        return assertThat(stream).anyMatch(predicate);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2$0;
                JavaTemplate before2$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).filteredOn(#{predicate:any(java.util.function.Predicate<? super T>)}).isNotEmpty()")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).anyMatch(#{predicate:any(java.util.function.Predicate<? super T>)})")
                                    .bindType("org.assertj.core.api.ListAssert<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2$0 == null) {
                        before2$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}.anyMatch(#{predicate:any(java.util.function.Predicate<? super T>)})).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).anyMatch(#{predicate:any(java.util.function.Predicate<? super T>)})")
                                    .bindType("org.assertj.core.api.ListAssert<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2$1 == null) {
                        before2$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}.noneMatch(#{predicate:any(java.util.function.Predicate<? super T>)})).isFalse()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).anyMatch(#{predicate:any(java.util.function.Predicate<? super T>)})")
                                    .bindType("org.assertj.core.api.ListAssert<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesType<>("java.util.stream.Stream", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                                            new UsesMethod<>("java.util.stream.Stream anyMatch(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                                            new UsesMethod<>("java.util.stream.Stream noneMatch(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("org.assertj.core.api.ListAssert", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert filteredOn(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert isNotEmpty(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJStreamRules.AssertThatCollection}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatCollectionRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatCollectionRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJStreamRules.AssertThatCollection`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCollection<T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Collection<T> collection) {\n        return assertThat(collection.stream());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractCollectionAssert<?, ?, T, ?> after(Collection<T> collection) {\n        return assertThat(collection);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{collection:any(java.util.Collection<T>)}.stream())")
                                .bindType("org.assertj.core.api.ListAssert<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.ListAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{collection:any(java.util.Collection<T>)})")
                                    .bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, T, ?>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Collection", true),
                            new UsesType<>("org.assertj.core.api.ListAssert", true),
                            new UsesMethod<>("java.util.Collection stream(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
