package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJOptionalRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJOptionalRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJOptionalRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`AssertJOptionalRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJOptionalRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJOptionalRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AssertThatOptionalRecipe(),
                new AbstractOptionalAssertIsPresentRecipe(),
                new AssertThatOptionalIsPresentRecipe(),
                new AbstractOptionalAssertIsEmptyRecipe(),
                new AssertThatOptionalIsEmptyRecipe(),
                new AbstractOptionalAssertHasValueRecipe(),
                new AbstractOptionalAssertContainsSameRecipe(),
                new AssertThatOptionalHasValueMatchingRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJOptionalRules.AssertThatOptional}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatOptionalRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatOptionalRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJOptionalRules.AssertThatOptional`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptional<T> {\n    \n    @BeforeTemplate\n    ObjectAssert<T> before(Optional<T> optional) {\n        return assertThat(optional.orElseThrow());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, T> after(Optional<T> optional) {\n        return assertThat(optional).get();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}.orElseThrow())")
                                .bindType("org.assertj.core.api.ObjectAssert<T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.ObjectAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}).get()")
                                    .bindType("org.assertj.core.api.AbstractObjectAssert<?, T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("org.assertj.core.api.ObjectAssert", true),
                            new UsesMethod<>("java.util.Optional orElseThrow(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJOptionalRules.AbstractOptionalAssertIsPresent}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractOptionalAssertIsPresentRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractOptionalAssertIsPresentRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJOptionalRules.AbstractOptionalAssertIsPresent`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractOptionalAssertIsPresent<T> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(AbstractOptionalAssert<?, T> optionalAssert) {\n        return Refaster.anyOf(optionalAssert.isNotEmpty(), optionalAssert.isNotEqualTo(Optional.empty()));\n    }\n    \n    @AfterTemplate\n    AbstractOptionalAssert<?, T> after(AbstractOptionalAssert<?, T> optionalAssert) {\n        return optionalAssert.isPresent();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isNotEmpty()")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isPresent()")
                                    .bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isNotEqualTo(java.util.Optional.empty())")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Optional");
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isPresent()")
                                    .bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractAssert", true),
                            new UsesType<>("org.assertj.core.api.AbstractOptionalAssert", true),
                            Preconditions.or(
                                    new UsesMethod<>("org.assertj.core.api.AbstractOptionalAssert isNotEmpty(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Optional", true),
                                            new UsesMethod<>("java.util.Optional empty(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractAssert isNotEqualTo(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJOptionalRules.AssertThatOptionalIsPresent}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatOptionalIsPresentRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatOptionalIsPresentRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJOptionalRules.AssertThatOptionalIsPresent`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalIsPresent<T> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(Optional<T> optional) {\n        return Refaster.anyOf(assertThat(optional.isPresent()).isTrue(), assertThat(optional.isEmpty()).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    OptionalAssert<T> after(Optional<T> optional) {\n        return assertThat(optional).isPresent();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}.isPresent()).isTrue()")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}).isPresent()")
                                    .bindType("org.assertj.core.api.OptionalAssert<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}.isEmpty()).isFalse()")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}).isPresent()")
                                    .bindType("org.assertj.core.api.OptionalAssert<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("org.assertj.core.api.AbstractAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Optional isEmpty(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Optional isPresent(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJOptionalRules.AbstractOptionalAssertIsEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractOptionalAssertIsEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractOptionalAssertIsEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJOptionalRules.AbstractOptionalAssertIsEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractOptionalAssertIsEmpty<T> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(AbstractOptionalAssert<?, T> optionalAssert) {\n        return Refaster.anyOf(optionalAssert.isNotPresent(), optionalAssert.isEqualTo(Optional.empty()));\n    }\n    \n    @AfterTemplate\n    AbstractOptionalAssert<?, T> after(AbstractOptionalAssert<?, T> optionalAssert) {\n        return optionalAssert.isEmpty();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isNotPresent()")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isEmpty()")
                                    .bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isEqualTo(java.util.Optional.empty())")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Optional");
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isEmpty()")
                                    .bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractAssert", true),
                            new UsesType<>("org.assertj.core.api.AbstractOptionalAssert", true),
                            Preconditions.or(
                                    new UsesMethod<>("org.assertj.core.api.AbstractOptionalAssert isNotPresent(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Optional", true),
                                            new UsesMethod<>("java.util.Optional empty(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractAssert isEqualTo(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJOptionalRules.AssertThatOptionalIsEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatOptionalIsEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatOptionalIsEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJOptionalRules.AssertThatOptionalIsEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalIsEmpty<T> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(Optional<T> optional) {\n        return Refaster.anyOf(assertThat(optional.isEmpty()).isTrue(), assertThat(optional.isPresent()).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    OptionalAssert<T> after(Optional<T> optional) {\n        return assertThat(optional).isEmpty();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}.isEmpty()).isTrue()")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}).isEmpty()")
                                    .bindType("org.assertj.core.api.OptionalAssert<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}.isPresent()).isFalse()")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}).isEmpty()")
                                    .bindType("org.assertj.core.api.OptionalAssert<T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("org.assertj.core.api.AbstractAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Optional isEmpty(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Optional isPresent(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJOptionalRules.AbstractOptionalAssertHasValue}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractOptionalAssertHasValueRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractOptionalAssertHasValueRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJOptionalRules.AbstractOptionalAssertHasValue`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractOptionalAssertHasValue<T> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(AbstractOptionalAssert<?, T> optionalAssert, T value) {\n        return Refaster.anyOf(optionalAssert.get().isEqualTo(value), optionalAssert.isEqualTo(Optional.of(value)), optionalAssert.contains(value), optionalAssert.isPresent().hasValue(value));\n    }\n    \n    @AfterTemplate\n    AbstractOptionalAssert<?, T> after(AbstractOptionalAssert<?, T> optionalAssert, T value) {\n        return optionalAssert.hasValue(value);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.get().isEqualTo(#{value:any(T)})")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.hasValue(#{value:any(T)})")
                                    .bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isEqualTo(java.util.Optional.of(#{value:any(T)}))")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Optional");
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.hasValue(#{value:any(T)})")
                                    .bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.contains(#{value:any(T)})")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.hasValue(#{value:any(T)})")
                                    .bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isPresent().hasValue(#{value:any(T)})")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.hasValue(#{value:any(T)})")
                                    .bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractAssert", true),
                            new UsesType<>("org.assertj.core.api.AbstractOptionalAssert", true),
                            Preconditions.or(
                                    new UsesMethod<>("org.assertj.core.api.AbstractOptionalAssert contains(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("org.assertj.core.api.AbstractAssert isEqualTo(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractOptionalAssert get(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("org.assertj.core.api.AbstractOptionalAssert hasValue(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractOptionalAssert isPresent(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("java.util.Optional", true),
                                            new UsesMethod<>("java.util.Optional of(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractAssert isEqualTo(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJOptionalRules.AbstractOptionalAssertContainsSame}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractOptionalAssertContainsSameRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractOptionalAssertContainsSameRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJOptionalRules.AbstractOptionalAssertContainsSame`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractOptionalAssertContainsSame<T> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(AbstractOptionalAssert<?, T> optionalAssert, T value) {\n        return Refaster.anyOf(optionalAssert.get().isSameAs(value), optionalAssert.isPresent().isSameAs(value));\n    }\n    \n    @AfterTemplate\n    AbstractOptionalAssert<?, T> after(AbstractOptionalAssert<?, T> optionalAssert, T value) {\n        return optionalAssert.containsSame(value);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.get().isSameAs(#{value:any(T)})")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.containsSame(#{value:any(T)})")
                                    .bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isPresent().isSameAs(#{value:any(T)})")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.containsSame(#{value:any(T)})")
                                    .bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractAssert", true),
                            new UsesType<>("org.assertj.core.api.AbstractOptionalAssert", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractAssert isSameAs(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("org.assertj.core.api.AbstractOptionalAssert get(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractOptionalAssert isPresent(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJOptionalRules.AssertThatOptionalHasValueMatching}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatOptionalHasValueMatchingRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatOptionalHasValueMatchingRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJOptionalRules.AssertThatOptionalHasValueMatching`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalHasValueMatching<T> {\n    \n    @BeforeTemplate\n    AbstractOptionalAssert<?, T> before(Optional<T> optional, Predicate<? super T> predicate) {\n        return assertThat(optional.filter(predicate)).isPresent();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, T> after(Optional<T> optional, Predicate<? super T> predicate) {\n        return assertThat(optional).get().matches(predicate);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)})).isPresent()")
                                .bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractOptionalAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}).get().matches(#{predicate:any(java.util.function.Predicate<? super T>)})")
                                    .bindType("org.assertj.core.api.AbstractObjectAssert<?, T>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Optional", true),
                            new UsesType<>("java.util.function.Predicate", true),
                            new UsesType<>("org.assertj.core.api.AbstractOptionalAssert", true),
                            new UsesMethod<>("java.util.Optional filter(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractOptionalAssert isPresent(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
