package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJMapRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJMapRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJMapRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`AssertJMapRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJMapRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJMapRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AssertThatMapIsEmptyRecipe(),
                new AbstractMapAssertContainsExactlyInAnyOrderEntriesOfRecipe(),
                new AbstractMapAssertContainsExactlyEntriesOfRecipe(),
                new AbstractMapAssertHasSameSizeAsRecipe(),
                new AssertThatMapContainsKeyRecipe(),
                new AssertThatMapDoesNotContainKeyRecipe(),
                new AssertThatMapContainsOnlyKeyRecipe(),
                new AssertThatMapContainsOnlyKeysRecipe(),
                new AssertThatMapContainsValueRecipe(),
                new AssertThatMapDoesNotContainValueRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJMapRules.AssertThatMapIsEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatMapIsEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatMapIsEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJMapRules.AssertThatMapIsEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatMapIsEmpty<K, V> {\n    \n    @BeforeTemplate\n    void before(Map<K, V> map) {\n        Refaster.anyOf(assertThat(map).hasSize(0), assertThat(map.isEmpty()).isTrue(), assertThat(map.size()).isEqualTo(0L), assertThat(map.size()).isNotPositive());\n    }\n    \n    @BeforeTemplate\n    void before2(Map<K, V> map) {\n        assertThat(Refaster.anyOf(map.keySet(), map.values(), map.entrySet())).isEmpty();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Map<K, V> map) {\n        assertThat(map).isEmpty();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before2$0;
                JavaTemplate before2$1;
                JavaTemplate before2$2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).hasSize(0);")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).isEmpty();")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.isEmpty()).isTrue();")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).isEmpty();")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$2 == null) {
                        before$2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.size()).isEqualTo(0L);")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).isEmpty();")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$3 == null) {
                        before$3 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.size()).isNotPositive();")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$3.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).isEmpty();")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2$0 == null) {
                        before2$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.keySet()).isEmpty();")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).isEmpty();")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2$1 == null) {
                        before2$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.values()).isEmpty();")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).isEmpty();")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before2$2 == null) {
                        before2$2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.entrySet()).isEmpty();")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2$2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).isEmpty();")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("org.assertj.core.api.AbstractMapAssert hasSize(..)", true),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Map entrySet(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert isEmpty(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Map isEmpty(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Map keySet(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert isEmpty(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Map size(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isEqualTo(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Map size(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isNotPositive(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Map values(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert isEmpty(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJMapRules.AbstractMapAssertContainsExactlyInAnyOrderEntriesOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractMapAssertContainsExactlyInAnyOrderEntriesOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractMapAssertContainsExactlyInAnyOrderEntriesOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJMapRules.AbstractMapAssertContainsExactlyInAnyOrderEntriesOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractMapAssertContainsExactlyInAnyOrderEntriesOf<K, V> {\n    \n    @BeforeTemplate\n    AbstractMapAssert<?, ?, K, V> before(AbstractMapAssert<?, ?, K, V> mapAssert, Map<? extends K, ? extends V> map) {\n        return mapAssert.isEqualTo(map);\n    }\n    \n    @AfterTemplate\n    AbstractMapAssert<?, ?, K, V> after(AbstractMapAssert<?, ?, K, V> mapAssert, Map<? extends K, ? extends V> map) {\n        return mapAssert.containsExactlyInAnyOrderEntriesOf(map);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mapAssert:any(org.assertj.core.api.AbstractMapAssert<?, ?, K, V>)}.isEqualTo(#{map:any(java.util.Map<? extends K, ? extends V>)})")
                                .bindType("org.assertj.core.api.AbstractMapAssert<?, ?, K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mapAssert:any(org.assertj.core.api.AbstractMapAssert<?, ?, K, V>)}.containsExactlyInAnyOrderEntriesOf(#{map:any(java.util.Map<? extends K, ? extends V>)})")
                                    .bindType("org.assertj.core.api.AbstractMapAssert<?, ?, K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("org.assertj.core.api.AbstractMapAssert", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractMapAssert isEqualTo(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJMapRules.AbstractMapAssertContainsExactlyEntriesOf}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractMapAssertContainsExactlyEntriesOfRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractMapAssertContainsExactlyEntriesOfRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJMapRules.AbstractMapAssertContainsExactlyEntriesOf`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractMapAssertContainsExactlyEntriesOf<K, V> {\n    \n    @BeforeTemplate\n    AbstractMapAssert<?, ?, K, V> before(AbstractMapAssert<?, ?, K, V> mapAssert, K key, V value) {\n        return mapAssert.containsExactlyInAnyOrderEntriesOf(ImmutableMap.of(key, value));\n    }\n    \n    @AfterTemplate\n    AbstractMapAssert<?, ?, K, V> after(AbstractMapAssert<?, ?, K, V> mapAssert, K key, V value) {\n        return mapAssert.containsExactlyEntriesOf(ImmutableMap.of(key, value));\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mapAssert:any(org.assertj.core.api.AbstractMapAssert<?, ?, K, V>)}.containsExactlyInAnyOrderEntriesOf(com.google.common.collect.ImmutableMap.of(#{key:any(K)}, #{value:any(V)}))")
                                .bindType("org.assertj.core.api.AbstractMapAssert<?, ?, K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3", "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mapAssert:any(org.assertj.core.api.AbstractMapAssert<?, ?, K, V>)}.containsExactlyEntriesOf(com.google.common.collect.ImmutableMap.of(#{key:any(K)}, #{value:any(V)}))")
                                    .bindType("org.assertj.core.api.AbstractMapAssert<?, ?, K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3", "guava-33"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("com.google.common.collect.ImmutableMap", true),
                            new UsesType<>("org.assertj.core.api.AbstractMapAssert", true),
                            new UsesMethod<>("com.google.common.collect.ImmutableMap of(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractMapAssert containsExactlyInAnyOrderEntriesOf(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJMapRules.AbstractMapAssertHasSameSizeAs}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AbstractMapAssertHasSameSizeAsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AbstractMapAssertHasSameSizeAsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJMapRules.AbstractMapAssertHasSameSizeAs`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractMapAssertHasSameSizeAs<K, V> {\n    \n    @BeforeTemplate\n    AbstractMapAssert<?, ?, K, V> before(AbstractMapAssert<?, ?, K, V> mapAssert, Map<?, ?> map) {\n        return mapAssert.hasSize(map.size());\n    }\n    \n    @AfterTemplate\n    AbstractMapAssert<?, ?, K, V> after(AbstractMapAssert<?, ?, K, V> mapAssert, Map<?, ?> map) {\n        return mapAssert.hasSameSizeAs(map);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{mapAssert:any(org.assertj.core.api.AbstractMapAssert<?, ?, K, V>)}.hasSize(#{map:any(java.util.Map<?, ?>)}.size())")
                                .bindType("org.assertj.core.api.AbstractMapAssert<?, ?, K, V>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{mapAssert:any(org.assertj.core.api.AbstractMapAssert<?, ?, K, V>)}.hasSameSizeAs(#{map:any(java.util.Map<?, ?>)})")
                                    .bindType("org.assertj.core.api.AbstractMapAssert<?, ?, K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("org.assertj.core.api.AbstractMapAssert", true),
                            new UsesMethod<>("java.util.Map size(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractMapAssert hasSize(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJMapRules.AssertThatMapContainsKey}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatMapContainsKeyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatMapContainsKeyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJMapRules.AssertThatMapContainsKey`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatMapContainsKey<K, V> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(Map<K, V> map, K key) {\n        return Refaster.anyOf(assertThat(map.containsKey(key)).isTrue(), assertThat(map.keySet()).contains(key));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    MapAssert<K, V> after(Map<K, V> map, K key) {\n        return assertThat(map).containsKey(key);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.containsKey(#{key:any(K)})).isTrue()")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).containsKey(#{key:any(K)})")
                                    .bindType("org.assertj.core.api.MapAssert<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.keySet()).contains(#{key:any(K)})")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).containsKey(#{key:any(K)})")
                                    .bindType("org.assertj.core.api.MapAssert<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("org.assertj.core.api.AbstractAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Map containsKey(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Map keySet(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert contains(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJMapRules.AssertThatMapDoesNotContainKey}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatMapDoesNotContainKeyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatMapDoesNotContainKeyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJMapRules.AssertThatMapDoesNotContainKey`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatMapDoesNotContainKey<K, V> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(Map<K, V> map, K key) {\n        return Refaster.anyOf(assertThat(map.containsKey(key)).isFalse(), assertThat(map.keySet()).doesNotContain(key));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    MapAssert<K, V> after(Map<K, V> map, K key) {\n        return assertThat(map).doesNotContainKey(key);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.containsKey(#{key:any(K)})).isFalse()")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).doesNotContainKey(#{key:any(K)})")
                                    .bindType("org.assertj.core.api.MapAssert<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.keySet()).doesNotContain(#{key:any(K)})")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).doesNotContainKey(#{key:any(K)})")
                                    .bindType("org.assertj.core.api.MapAssert<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("org.assertj.core.api.AbstractAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Map containsKey(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Map keySet(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert doesNotContain(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJMapRules.AssertThatMapContainsOnlyKey}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatMapContainsOnlyKeyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatMapContainsOnlyKeyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJMapRules.AssertThatMapContainsOnlyKey`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatMapContainsOnlyKey<K, V> {\n    \n    @BeforeTemplate\n    AbstractCollectionAssert<?, Collection<? extends K>, K, ?> before(Map<K, V> map, K key) {\n        return assertThat(map.keySet()).containsExactly(key);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    MapAssert<K, V> after(Map<K, V> map, K key) {\n        return assertThat(map).containsOnlyKeys(key);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.keySet()).containsExactly(#{key:any(K)})")
                                .bindType("org.assertj.core.api.AbstractCollectionAssert<?, java.util.Collection<? extends K>, K, ?>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractCollectionAssert");
                        maybeRemoveImport("java.util.Collection");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).containsOnlyKeys(#{key:any(K)})")
                                    .bindType("org.assertj.core.api.MapAssert<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Collection", true),
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("org.assertj.core.api.AbstractCollectionAssert", true),
                            new UsesMethod<>("java.util.Map keySet(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert containsExactly(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJMapRules.AssertThatMapContainsOnlyKeys}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatMapContainsOnlyKeysRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatMapContainsOnlyKeysRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJMapRules.AssertThatMapContainsOnlyKeys`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatMapContainsOnlyKeys<K, V> {\n    \n    @BeforeTemplate\n    AbstractCollectionAssert<?, Collection<? extends K>, K, ?> before(Map<K, V> map, Iterable<? extends K> keys) {\n        return assertThat(map.keySet()).hasSameElementsAs(keys);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    MapAssert<K, V> after(Map<K, V> map, Iterable<? extends K> keys) {\n        return assertThat(map).containsOnlyKeys(keys);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.keySet()).hasSameElementsAs(#{keys:any(java.lang.Iterable<? extends K>)})")
                                .bindType("org.assertj.core.api.AbstractCollectionAssert<?, java.util.Collection<? extends K>, K, ?>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractCollectionAssert");
                        maybeRemoveImport("java.util.Collection");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).containsOnlyKeys(#{keys:any(java.lang.Iterable<? extends K>)})")
                                    .bindType("org.assertj.core.api.MapAssert<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Collection", true),
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("org.assertj.core.api.AbstractCollectionAssert", true),
                            new UsesMethod<>("java.util.Map keySet(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert hasSameElementsAs(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJMapRules.AssertThatMapContainsValue}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatMapContainsValueRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatMapContainsValueRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJMapRules.AssertThatMapContainsValue`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatMapContainsValue<K, V> {\n    \n    @BeforeTemplate\n    AbstractAssert<? extends AbstractAssert<?, ?>, ? extends Object> before(Map<K, V> map, V value) {\n        return Refaster.anyOf(assertThat(map.containsValue(value)).isTrue(), assertThat(map.values()).contains(value));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    MapAssert<K, V> after(Map<K, V> map, V value) {\n        return assertThat(map).containsValue(value);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.containsValue(#{value:any(V)})).isTrue()")
                                .bindType("org.assertj.core.api.AbstractAssert<? extends org.assertj.core.api.AbstractAssert<?, ?>, ? extends java.lang.Object>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).containsValue(#{value:any(V)})")
                                    .bindType("org.assertj.core.api.MapAssert<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.values()).contains(#{value:any(V)})")
                                .bindType("org.assertj.core.api.AbstractAssert<? extends org.assertj.core.api.AbstractAssert<?, ?>, ? extends java.lang.Object>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).containsValue(#{value:any(V)})")
                                    .bindType("org.assertj.core.api.MapAssert<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("org.assertj.core.api.AbstractAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Map containsValue(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Map values(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert contains(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJMapRules.AssertThatMapDoesNotContainValue}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatMapDoesNotContainValueRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatMapDoesNotContainValueRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJMapRules.AssertThatMapDoesNotContainValue`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatMapDoesNotContainValue<K, V> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(Map<K, V> map, V value) {\n        return Refaster.anyOf(assertThat(map.containsValue(value)).isFalse(), assertThat(map.values()).doesNotContain(value));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    MapAssert<K, V> after(Map<K, V> map, V value) {\n        return assertThat(map).doesNotContainValue(value);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.containsValue(#{value:any(V)})).isFalse()")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).doesNotContainValue(#{value:any(V)})")
                                    .bindType("org.assertj.core.api.MapAssert<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.values()).doesNotContain(#{value:any(V)})")
                                .bindType("org.assertj.core.api.AbstractAssert<?, ?>")
                                .genericTypes("K", "V")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).doesNotContainValue(#{value:any(V)})")
                                    .bindType("org.assertj.core.api.MapAssert<K, V>")
                                    .genericTypes("K", "V")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES, STATIC_IMPORT_ALWAYS
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.util.Map", true),
                            new UsesType<>("org.assertj.core.api.AbstractAssert", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Map containsValue(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesMethod<>("java.util.Map values(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert doesNotContain(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

}
