package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJEnumerableRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJEnumerableRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJEnumerableRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`AssertJEnumerableRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJEnumerableRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJEnumerableRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new EnumerableAssertIsNotEmptyRecipe(),
                new EnumerableAssertHasSizeRecipe(),
                new EnumerableAssertHasSizeLessThanRecipe(),
                new EnumerableAssertHasSizeLessThanOrEqualToRecipe(),
                new EnumerableAssertHasSizeGreaterThanRecipe(),
                new EnumerableAssertHasSizeGreaterThanOrEqualToRecipe(),
                new EnumerableAssertHasSizeBetweenRecipe(),
                new EnumerableAssertHasSameSizeAsRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJEnumerableRules.EnumerableAssertIsNotEmpty}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EnumerableAssertIsNotEmptyRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EnumerableAssertIsNotEmptyRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertIsNotEmpty`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertIsNotEmpty<E> {\n    \n    @BeforeTemplate\n    EnumerableAssert<?, E> before(EnumerableAssert<?, E> enumAssert) {\n        return Refaster.anyOf(enumAssert.hasSizeGreaterThan(0), enumAssert.hasSizeGreaterThanOrEqualTo(1));\n    }\n    \n    @BeforeTemplate\n    AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert) {\n        return Refaster.anyOf(enumAssert.size().isNotEqualTo(0).returnToIterable(), enumAssert.size().isPositive().returnToIterable());\n    }\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert) {\n        return Refaster.anyOf(enumAssert.size().isNotEqualTo(0), enumAssert.size().isPositive());\n    }\n    \n    @AfterTemplate\n    EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert) {\n        return enumAssert.isNotEmpty();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before2$0;
                JavaTemplate before2$1;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before$0 == null) {
                        before$0 = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeGreaterThan(0)")
                                .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$0.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.isNotEmpty()")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before$1 == null) {
                        before$1 = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeGreaterThanOrEqualTo(1)")
                                .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before$1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.isNotEmpty()")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$0 == null) {
                        before0$0 = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isNotEqualTo(0).returnToIterable()")
                                .bindType("org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before0$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.isNotEmpty()")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0$1 == null) {
                        before0$1 = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isPositive().returnToIterable()")
                                .bindType("org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before0$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.isNotEmpty()")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2$0 == null) {
                        before2$0 = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isNotEqualTo(0)")
                                .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2$0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.isNotEmpty()")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2$1 == null) {
                        before2$1 = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isPositive()")
                                .bindType("org.assertj.core.api.AbstractIntegerAssert<?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2$1.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.isNotEmpty()")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            Preconditions.and(
                                    new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                                    new UsesType<>("org.assertj.core.api.AbstractIterableAssert", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isNotEqualTo(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert size(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("org.assertj.core.api.AbstractIntegerAssert", true),
                                    new UsesType<>("org.assertj.core.api.AbstractIterableAssert", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isPositive(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert size(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("org.assertj.core.api.AbstractIterableAssert", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isNotEqualTo(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert size(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIterableSizeAssert returnToIterable(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("org.assertj.core.api.AbstractIterableAssert", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isPositive(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert size(..)", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIterableSizeAssert returnToIterable(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("org.assertj.core.api.EnumerableAssert", true),
                                    new UsesMethod<>("org.assertj.core.api.EnumerableAssert hasSizeGreaterThan(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("org.assertj.core.api.EnumerableAssert", true),
                                    new UsesMethod<>("org.assertj.core.api.EnumerableAssert hasSizeGreaterThanOrEqualTo(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJEnumerableRules.EnumerableAssertHasSize}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EnumerableAssertHasSizeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EnumerableAssertHasSizeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertHasSize`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertHasSize<E> {\n    \n    @BeforeTemplate\n    AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isEqualTo(size).returnToIterable();\n    }\n    \n    @BeforeTemplate\n    AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isEqualTo(size);\n    }\n    \n    @AfterTemplate\n    EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int size) {\n        return enumAssert.hasSize(size);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isEqualTo(#{size:any(int)}).returnToIterable()")
                                .bindType("org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSize(#{size:any(int)})")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isEqualTo(#{size:any(int)})")
                                .bindType("org.assertj.core.api.AbstractIterableSizeAssert<?, ?, E, ?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableSizeAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSize(#{size:any(int)})")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractIterableAssert", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert size(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.AbstractIterableSizeAssert", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIterableSizeAssert returnToIterable(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJEnumerableRules.EnumerableAssertHasSizeLessThan}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EnumerableAssertHasSizeLessThanRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EnumerableAssertHasSizeLessThanRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertHasSizeLessThan`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertHasSizeLessThan<E> {\n    \n    @BeforeTemplate\n    AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isLessThan(size).returnToIterable();\n    }\n    \n    @BeforeTemplate\n    AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isLessThan(size);\n    }\n    \n    @AfterTemplate\n    EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int size) {\n        return enumAssert.hasSizeLessThan(size);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isLessThan(#{size:any(int)}).returnToIterable()")
                                .bindType("org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeLessThan(#{size:any(int)})")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isLessThan(#{size:any(int)})")
                                .bindType("org.assertj.core.api.AbstractIterableSizeAssert<?, ?, E, ?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableSizeAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeLessThan(#{size:any(int)})")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractIterableAssert", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isLessThan(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert size(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.AbstractIterableSizeAssert", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIterableSizeAssert returnToIterable(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJEnumerableRules.EnumerableAssertHasSizeLessThanOrEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EnumerableAssertHasSizeLessThanOrEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EnumerableAssertHasSizeLessThanOrEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertHasSizeLessThanOrEqualTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertHasSizeLessThanOrEqualTo<E> {\n    \n    @BeforeTemplate\n    AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isLessThanOrEqualTo(size).returnToIterable();\n    }\n    \n    @BeforeTemplate\n    AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isLessThanOrEqualTo(size);\n    }\n    \n    @AfterTemplate\n    EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int size) {\n        return enumAssert.hasSizeLessThanOrEqualTo(size);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isLessThanOrEqualTo(#{size:any(int)}).returnToIterable()")
                                .bindType("org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeLessThanOrEqualTo(#{size:any(int)})")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isLessThanOrEqualTo(#{size:any(int)})")
                                .bindType("org.assertj.core.api.AbstractIterableSizeAssert<?, ?, E, ?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableSizeAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeLessThanOrEqualTo(#{size:any(int)})")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractIterableAssert", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isLessThanOrEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert size(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.AbstractIterableSizeAssert", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIterableSizeAssert returnToIterable(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJEnumerableRules.EnumerableAssertHasSizeGreaterThan}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EnumerableAssertHasSizeGreaterThanRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EnumerableAssertHasSizeGreaterThanRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertHasSizeGreaterThan`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertHasSizeGreaterThan<E> {\n    \n    @BeforeTemplate\n    AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isGreaterThan(size).returnToIterable();\n    }\n    \n    @BeforeTemplate\n    AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isGreaterThan(size);\n    }\n    \n    @AfterTemplate\n    EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int size) {\n        return enumAssert.hasSizeGreaterThan(size);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isGreaterThan(#{size:any(int)}).returnToIterable()")
                                .bindType("org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeGreaterThan(#{size:any(int)})")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isGreaterThan(#{size:any(int)})")
                                .bindType("org.assertj.core.api.AbstractIterableSizeAssert<?, ?, E, ?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableSizeAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeGreaterThan(#{size:any(int)})")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractIterableAssert", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isGreaterThan(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert size(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.AbstractIterableSizeAssert", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIterableSizeAssert returnToIterable(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJEnumerableRules.EnumerableAssertHasSizeGreaterThanOrEqualTo}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EnumerableAssertHasSizeGreaterThanOrEqualToRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EnumerableAssertHasSizeGreaterThanOrEqualToRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertHasSizeGreaterThanOrEqualTo`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertHasSizeGreaterThanOrEqualTo<E> {\n    \n    @BeforeTemplate\n    AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isGreaterThanOrEqualTo(size).returnToIterable();\n    }\n    \n    @BeforeTemplate\n    AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isGreaterThanOrEqualTo(size);\n    }\n    \n    @AfterTemplate\n    EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int size) {\n        return enumAssert.hasSizeGreaterThanOrEqualTo(size);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isGreaterThanOrEqualTo(#{size:any(int)}).returnToIterable()")
                                .bindType("org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeGreaterThanOrEqualTo(#{size:any(int)})")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isGreaterThanOrEqualTo(#{size:any(int)})")
                                .bindType("org.assertj.core.api.AbstractIterableSizeAssert<?, ?, E, ?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableSizeAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeGreaterThanOrEqualTo(#{size:any(int)})")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractIterableAssert", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isGreaterThanOrEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert size(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.AbstractIterableSizeAssert", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIterableSizeAssert returnToIterable(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJEnumerableRules.EnumerableAssertHasSizeBetween}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EnumerableAssertHasSizeBetweenRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EnumerableAssertHasSizeBetweenRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertHasSizeBetween`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertHasSizeBetween<E> {\n    \n    @BeforeTemplate\n    AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int lower, int upper) {\n        return enumAssert.size().isBetween(lower, upper).returnToIterable();\n    }\n    \n    @BeforeTemplate\n    AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int lower, int upper) {\n        return enumAssert.size().isBetween(lower, upper);\n    }\n    \n    @AfterTemplate\n    EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int lower, int upper) {\n        return enumAssert.hasSizeBetween(lower, upper);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isBetween(#{lower:any(int)}, #{upper:any(int)}).returnToIterable()")
                                .bindType("org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeBetween(#{lower:any(int)}, #{upper:any(int)})")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isBetween(#{lower:any(int)}, #{upper:any(int)})")
                                .bindType("org.assertj.core.api.AbstractIterableSizeAssert<?, ?, E, ?>")
                                .genericTypes("E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        maybeRemoveImport("org.assertj.core.api.AbstractIterableSizeAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeBetween(#{lower:any(int)}, #{upper:any(int)})")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, E>")
                                    .genericTypes("E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.AbstractIterableAssert", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIntegerAssert isBetween(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractIterableAssert size(..)", true),
                            Preconditions.or(
                                    new UsesType<>("org.assertj.core.api.AbstractIterableSizeAssert", true),
                                    new UsesMethod<>("org.assertj.core.api.AbstractIterableSizeAssert returnToIterable(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJEnumerableRules.EnumerableAssertHasSameSizeAs}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class EnumerableAssertHasSameSizeAsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public EnumerableAssertHasSameSizeAsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertHasSameSizeAs`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertHasSameSizeAs<S, E> {\n    \n    @BeforeTemplate\n    EnumerableAssert<?, S> before(EnumerableAssert<?, S> enumAssert, Iterable<E> iterable) {\n        return enumAssert.hasSize(Iterables.size(iterable));\n    }\n    \n    @BeforeTemplate\n    EnumerableAssert<?, S> before(EnumerableAssert<?, S> enumAssert, Collection<E> iterable) {\n        return enumAssert.hasSize(iterable.size());\n    }\n    \n    @BeforeTemplate\n    EnumerableAssert<?, S> before(EnumerableAssert<?, S> enumAssert, E[] iterable) {\n        return enumAssert.hasSize(iterable.length);\n    }\n    \n    @BeforeTemplate\n    EnumerableAssert<?, S> before(EnumerableAssert<?, S> enumAssert, CharSequence iterable) {\n        return enumAssert.hasSize(iterable.length());\n    }\n    \n    @AfterTemplate\n    EnumerableAssert<?, S> after(EnumerableAssert<?, S> enumAssert, Iterable<E> iterable) {\n        return enumAssert.hasSameSizeAs(iterable);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, S>)}.hasSize(com.google.common.collect.Iterables.size(#{iterable:any(java.lang.Iterable<E>)}))")
                                .bindType("org.assertj.core.api.EnumerableAssert<?, S>")
                                .genericTypes("S", "E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3", "guava-33"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("com.google.common.collect.Iterables");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, S>)}.hasSameSizeAs(#{iterable:any(java.lang.Iterable<E>)})")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, S>")
                                    .genericTypes("S", "E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, S>)}.hasSize(#{iterable:any(java.util.Collection<E>)}.size())")
                                .bindType("org.assertj.core.api.EnumerableAssert<?, S>")
                                .genericTypes("S", "E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("java.util.Collection");
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, S>)}.hasSameSizeAs(#{iterable:any(java.lang.Iterable<E>)})")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, S>")
                                    .genericTypes("S", "E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before1 == null) {
                        before1 = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, S>)}.hasSize(#{iterable:any(E[])}.length)")
                                .bindType("org.assertj.core.api.EnumerableAssert<?, S>")
                                .genericTypes("S", "E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before1.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, S>)}.hasSameSizeAs(#{iterable:any(java.lang.Iterable<E>)})")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, S>")
                                    .genericTypes("S", "E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, S>)}.hasSize(#{iterable:any(java.lang.CharSequence)}.length())")
                                .bindType("org.assertj.core.api.EnumerableAssert<?, S>")
                                .genericTypes("S", "E")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, S>)}.hasSameSizeAs(#{iterable:any(java.lang.Iterable<E>)})")
                                    .bindType("org.assertj.core.api.EnumerableAssert<?, S>")
                                    .genericTypes("S", "E")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("org.assertj.core.api.EnumerableAssert", true),
                            new UsesMethod<>("org.assertj.core.api.EnumerableAssert hasSize(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

}
