package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.AssertJDurationRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class AssertJDurationRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public AssertJDurationRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "Refaster rules related to AssertJ assertions over `Duration`s";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "These rules simplify and improve the readability of tests by using `Duration`-specific\n AssertJ assertion methods instead of generic assertions.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJDurationRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new AssertThatHasNanosRecipe(),
                new AssertThatHasMillisRecipe(),
                new AssertThatHasSecondsRecipe(),
                new AssertThatHasMinutesRecipe(),
                new AssertThatHasHoursRecipe(),
                new AssertThatHasDaysRecipe(),
                new AssertThatIsZeroRecipe(),
                new AssertThatIsPositiveRecipe(),
                new AssertThatIsNegativeRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJDurationRules.AssertThatHasNanos}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatHasNanosRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatHasNanosRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJDurationRules.AssertThatHasNanos`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatHasNanos {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(Duration duration, long nanos) {\n        return assertThat(duration.toNanos()).isEqualTo(nanos);\n    }\n    \n    @AfterTemplate\n    AbstractDurationAssert<?> after(Duration duration, long nanos) {\n        return assertThat(duration).hasNanos(nanos);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}.toNanos()).isEqualTo(#{nanos:any(long)})")
                                .bindType("org.assertj.core.api.AbstractLongAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}).hasNanos(#{nanos:any(long)})")
                                    .bindType("org.assertj.core.api.AbstractDurationAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("org.assertj.core.api.AbstractLongAssert", true),
                            new UsesMethod<>("java.time.Duration toNanos(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJDurationRules.AssertThatHasMillis}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatHasMillisRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatHasMillisRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJDurationRules.AssertThatHasMillis`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatHasMillis {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(Duration duration, long millis) {\n        return assertThat(duration.toMillis()).isEqualTo(millis);\n    }\n    \n    @AfterTemplate\n    AbstractDurationAssert<?> after(Duration duration, long millis) {\n        return assertThat(duration).hasMillis(millis);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}.toMillis()).isEqualTo(#{millis:any(long)})")
                                .bindType("org.assertj.core.api.AbstractLongAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}).hasMillis(#{millis:any(long)})")
                                    .bindType("org.assertj.core.api.AbstractDurationAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("org.assertj.core.api.AbstractLongAssert", true),
                            new UsesMethod<>("java.time.Duration toMillis(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJDurationRules.AssertThatHasSeconds}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatHasSecondsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatHasSecondsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJDurationRules.AssertThatHasSeconds`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatHasSeconds {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(Duration duration, long seconds) {\n        return assertThat(duration.toSeconds()).isEqualTo(seconds);\n    }\n    \n    @AfterTemplate\n    AbstractDurationAssert<?> after(Duration duration, long seconds) {\n        return assertThat(duration).hasSeconds(seconds);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}.toSeconds()).isEqualTo(#{seconds:any(long)})")
                                .bindType("org.assertj.core.api.AbstractLongAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}).hasSeconds(#{seconds:any(long)})")
                                    .bindType("org.assertj.core.api.AbstractDurationAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("org.assertj.core.api.AbstractLongAssert", true),
                            new UsesMethod<>("java.time.Duration toSeconds(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJDurationRules.AssertThatHasMinutes}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatHasMinutesRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatHasMinutesRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJDurationRules.AssertThatHasMinutes`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatHasMinutes {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(Duration duration, long minutes) {\n        return assertThat(duration.toMinutes()).isEqualTo(minutes);\n    }\n    \n    @AfterTemplate\n    AbstractDurationAssert<?> after(Duration duration, long minutes) {\n        return assertThat(duration).hasMinutes(minutes);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}.toMinutes()).isEqualTo(#{minutes:any(long)})")
                                .bindType("org.assertj.core.api.AbstractLongAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}).hasMinutes(#{minutes:any(long)})")
                                    .bindType("org.assertj.core.api.AbstractDurationAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("org.assertj.core.api.AbstractLongAssert", true),
                            new UsesMethod<>("java.time.Duration toMinutes(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJDurationRules.AssertThatHasHours}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatHasHoursRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatHasHoursRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJDurationRules.AssertThatHasHours`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatHasHours {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(Duration duration, long hours) {\n        return assertThat(duration.toHours()).isEqualTo(hours);\n    }\n    \n    @AfterTemplate\n    AbstractDurationAssert<?> after(Duration duration, long hours) {\n        return assertThat(duration).hasHours(hours);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}.toHours()).isEqualTo(#{hours:any(long)})")
                                .bindType("org.assertj.core.api.AbstractLongAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}).hasHours(#{hours:any(long)})")
                                    .bindType("org.assertj.core.api.AbstractDurationAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("org.assertj.core.api.AbstractLongAssert", true),
                            new UsesMethod<>("java.time.Duration toHours(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJDurationRules.AssertThatHasDays}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatHasDaysRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatHasDaysRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJDurationRules.AssertThatHasDays`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatHasDays {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(Duration duration, long days) {\n        return assertThat(duration.toDays()).isEqualTo(days);\n    }\n    \n    @AfterTemplate\n    AbstractDurationAssert<?> after(Duration duration, long days) {\n        return assertThat(duration).hasDays(days);\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}.toDays()).isEqualTo(#{days:any(long)})")
                                .bindType("org.assertj.core.api.AbstractLongAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}).hasDays(#{days:any(long)})")
                                    .bindType("org.assertj.core.api.AbstractDurationAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("org.assertj.core.api.AbstractLongAssert", true),
                            new UsesMethod<>("java.time.Duration toDays(..)", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJDurationRules.AssertThatIsZero}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsZeroRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsZeroRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJDurationRules.AssertThatIsZero`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsZero {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(Duration duration) {\n        return assertThat(duration.isZero()).isTrue();\n    }\n    \n    @BeforeTemplate\n    AbstractDurationAssert<?> before2(Duration duration) {\n        return assertThat(duration).isEqualTo(Duration.ZERO);\n    }\n    \n    @AfterTemplate\n    AbstractDurationAssert<?> after(Duration duration) {\n        return assertThat(duration).isZero();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}.isZero()).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}).isZero()")
                                    .bindType("org.assertj.core.api.AbstractDurationAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}).isEqualTo(java.time.Duration.ZERO)")
                                .bindType("org.assertj.core.api.AbstractDurationAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}).isZero()")
                                    .bindType("org.assertj.core.api.AbstractDurationAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                                            new UsesMethod<>("java.time.Duration isZero(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("org.assertj.core.api.AbstractDurationAssert", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractAssert isEqualTo(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJDurationRules.AssertThatIsPositive}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsPositiveRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsPositiveRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJDurationRules.AssertThatIsPositive`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsPositive {\n    \n    @BeforeTemplate\n    AbstractDurationAssert<?> before(Duration duration) {\n        return assertThat(duration).isGreaterThan(Duration.ZERO);\n    }\n    \n    @AfterTemplate\n    AbstractDurationAssert<?> after(Duration duration) {\n        return assertThat(duration).isPositive();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}).isGreaterThan(java.time.Duration.ZERO)")
                                .bindType("org.assertj.core.api.AbstractDurationAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}).isPositive()")
                                    .bindType("org.assertj.core.api.AbstractDurationAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesType<>("org.assertj.core.api.AbstractDurationAssert", true),
                            new UsesMethod<>("org.assertj.core.api.AbstractComparableAssert isGreaterThan(..)", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true)
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code AssertJDurationRules.AssertThatIsNegative}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class AssertThatIsNegativeRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public AssertThatIsNegativeRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `AssertJDurationRules.AssertThatIsNegative`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsNegative {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(Duration duration) {\n        return assertThat(duration.isNegative()).isTrue();\n    }\n    \n    @BeforeTemplate\n    AbstractDurationAssert<?> before2(Duration duration) {\n        return assertThat(duration).isLessThan(Duration.ZERO);\n    }\n    \n    @AfterTemplate\n    AbstractDurationAssert<?> after(Duration duration) {\n        return assertThat(duration).isNegative();\n    }\n}\n```\n.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}.isNegative()).isTrue()")
                                .bindType("org.assertj.core.api.AbstractBooleanAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}).isNegative()")
                                    .bindType("org.assertj.core.api.AbstractDurationAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before2 == null) {
                        before2 = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}).isLessThan(java.time.Duration.ZERO)")
                                .bindType("org.assertj.core.api.AbstractDurationAssert<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                .build();
                    }
                    if ((matcher = before2.matcher(getCursor())).find()) {
                        if (after == null) {
                            after = JavaTemplate.builder("org.assertj.core.api.Assertions.assertThat(#{duration:any(java.time.Duration)}).isNegative()")
                                    .bindType("org.assertj.core.api.AbstractDurationAssert<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "assertj-core-3"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesType<>("java.time.Duration", true),
                            new UsesMethod<>("org.assertj.core.api.Assertions assertThat(..)", true),
                            Preconditions.or(
                                    Preconditions.and(
                                            new UsesType<>("org.assertj.core.api.AbstractBooleanAssert", true),
                                            new UsesMethod<>("java.time.Duration isNegative(..)", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)
                                    ),
                                    Preconditions.and(
                                            new UsesType<>("org.assertj.core.api.AbstractDurationAssert", true),
                                            new UsesMethod<>("org.assertj.core.api.AbstractComparableAssert isLessThan(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

}
