/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class TestNGToAssertJRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules that replace TestNG assertions with equivalent AssertJ assertions";
    }

    public String getDescription() {
        return "Some of the classes below have TestNG `@BeforeTemplate`s that reference wildcard type\n bounds (`<?>`), while the associated AssertJ `@AfterTemplate`s reference stricter\n type bounds. This introduces the risk of producing invalid code. We do this anyway, because\n TestNG's wildcard types can cause javac to infer less specific types than AssertJ requires, while\n the appropriate (more specific) types _will_ be inferred properly when plugged into AssertJ's\n API.\n\n The following is an example of a TestNG statement, which would not be rewritten if it weren't\n for the wildcard matching (note that the type parameters of the map on the right-hand side will\n be inferred to be `<Object, Object>` rather than `<String, Object>`).\n\n ```java\n List<Map<String, Object>> myMaps = new ArrayList<>();\n assertEquals(myMaps, ImmutableList.of(ImmutableMap.of()));\n ```\n.\n[Source](https://error-prone.picnic.tech/refasterrules/TestNGToAssertJRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new FailRecipe(), new FailWithMessageRecipe(), new FailWithMessageAndThrowableRecipe(), new AssertTrueRecipe(), new AssertTrueWithMessageRecipe(), new AssertFalseRecipe(), new AssertFalseWithMessageRecipe(), new AssertNullRecipe(), new AssertNullWithMessageRecipe(), new AssertNotNullRecipe(), new AssertNotNullWithMessageRecipe(), new AssertSameRecipe(), new AssertSameWithMessageRecipe(), new AssertNotSameRecipe(), new AssertNotSameWithMessageRecipe(), new AssertEqualRecipe(), new AssertEqualWithMessageRecipe(), new AssertEqualFloatsWithDeltaRecipe(), new AssertEqualFloatsWithDeltaWithMessageRecipe(), new AssertEqualDoublesWithDeltaRecipe(), new AssertEqualDoublesWithDeltaWithMessageRecipe(), new AssertEqualArrayIterationOrderRecipe(), new AssertEqualArrayIterationOrderWithMessageRecipe(), new AssertEqualFloatArraysWithDeltaRecipe(), new AssertEqualFloatArraysWithDeltaWithMessageRecipe(), new AssertEqualDoubleArraysWithDeltaRecipe(), new AssertEqualDoubleArraysWithDeltaWithMessageRecipe(), new AssertEqualArraysIrrespectiveOfOrderRecipe(), new AssertEqualArraysIrrespectiveOfOrderWithMessageRecipe(), new AssertEqualIteratorIterationOrderRecipe(), new AssertEqualIteratorIterationOrderWithMessageRecipe(), new AssertEqualIterableIterationOrderRecipe(), new AssertEqualIterableIterationOrderWithMessageRecipe(), new AssertEqualSetsRecipe(), new AssertEqualSetsWithMessageRecipe(), new AssertUnequalRecipe(), new AssertUnequalWithMessageRecipe(), new AssertUnequalFloatsWithDeltaRecipe(), new AssertUnequalFloatsWithDeltaWithMessageRecipe(), new AssertUnequalDoublesWithDeltaRecipe(), new AssertUnequalDoublesWithDeltaWithMessageRecipe(), new AssertThrowsRecipe(), new AssertThrowsWithTypeRecipe()});
    }

    @NullMarked
    public static class FailRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.Fail`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class Fail {\n    \n    @BeforeTemplate\n    void before() {\n        Assert.fail();\n    }\n    \n    @AfterTemplate\n    @DoNotCall\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after() {\n        fail();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.fail();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.fail();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.testng.Assert", Boolean.valueOf(true)), new UsesMethod("org.testng.Assert fail(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FailWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.FailWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FailWithMessage {\n    \n    @BeforeTemplate\n    void before(String message) {\n        Assert.fail(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(String message) {\n        fail(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.fail(#{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.fail(#{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.testng.Assert", Boolean.valueOf(true)), new UsesMethod("org.testng.Assert fail(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FailWithMessageAndThrowableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.FailWithMessageAndThrowable`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FailWithMessageAndThrowable {\n    \n    @BeforeTemplate\n    void before(String message, Throwable throwable) {\n        Assert.fail(message, throwable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(String message, Throwable throwable) {\n        fail(message, throwable);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.fail(#{message:any(java.lang.String)}, #{throwable:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.fail(#{message:any(java.lang.String)}, #{throwable:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.testng.Assert", Boolean.valueOf(true)), new UsesMethod("org.testng.Assert fail(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertTrueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertTrue`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertTrue {\n    \n    @BeforeTemplate\n    void before(boolean condition) {\n        assertTrue(condition);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean condition) {\n        assertThat(condition).isTrue();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertTrue(#{condition:any(boolean)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertTrue");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{condition:any(boolean)}).isTrue();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertTrue(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertTrueWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertTrueWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertTrueWithMessage {\n    \n    @BeforeTemplate\n    void before(boolean condition, String message) {\n        assertTrue(condition, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean condition, String message) {\n        assertThat(condition).withFailMessage(message).isTrue();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertTrue(#{condition:any(boolean)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertTrue");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{condition:any(boolean)}).withFailMessage(#{message:any(java.lang.String)}).isTrue();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertTrue(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertFalseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertFalse`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertFalse {\n    \n    @BeforeTemplate\n    void before(boolean condition) {\n        assertFalse(condition);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean condition) {\n        assertThat(condition).isFalse();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertFalse(#{condition:any(boolean)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertFalse");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{condition:any(boolean)}).isFalse();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertFalse(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertFalseWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertFalseWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertFalseWithMessage {\n    \n    @BeforeTemplate\n    void before(boolean condition, String message) {\n        assertFalse(condition, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(boolean condition, String message) {\n        assertThat(condition).withFailMessage(message).isFalse();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertFalse(#{condition:any(boolean)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertFalse");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{condition:any(boolean)}).withFailMessage(#{message:any(java.lang.String)}).isFalse();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertFalse(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNull {\n    \n    @BeforeTemplate\n    void before(Object object) {\n        assertNull(object);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object object) {\n        assertThat(object).isNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertNull(#{object:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNull");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object:any(java.lang.Object)}).isNull();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNull(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertNullWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertNullWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNullWithMessage {\n    \n    @BeforeTemplate\n    void before(Object object, String message) {\n        assertNull(object, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object object, String message) {\n        assertThat(object).withFailMessage(message).isNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertNull(#{object:any(java.lang.Object)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNull");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNull();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNull(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertNotNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertNotNull`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNotNull {\n    \n    @BeforeTemplate\n    void before(Object object) {\n        assertNotNull(object);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object object) {\n        assertThat(object).isNotNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertNotNull(#{object:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotNull");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object:any(java.lang.Object)}).isNotNull();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotNull(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertNotNullWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertNotNullWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNotNullWithMessage {\n    \n    @BeforeTemplate\n    void before(Object object, String message) {\n        assertNotNull(object, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object object, String message) {\n        assertThat(object).withFailMessage(message).isNotNull();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertNotNull(#{object:any(java.lang.Object)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotNull");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{object:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotNull();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotNull(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertSameRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertSame`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertSame {\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertSame(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertSame(#{actual:any(java.lang.Object)}, #{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertSame");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isSameAs(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertSame(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertSameWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertSameWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertSameWithMessage {\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertSame(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertSame(#{actual:any(java.lang.Object)}, #{expected:any(java.lang.Object)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertSame");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isSameAs(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertSame(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertNotSameRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertNotSame`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNotSame {\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertNotSame(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isNotSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertNotSame(#{actual:any(java.lang.Object)}, #{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotSame");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotSameAs(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotSame(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertNotSameWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertNotSameWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertNotSameWithMessage {\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertNotSame(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isNotSameAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertNotSame(#{actual:any(java.lang.Object)}, #{expected:any(java.lang.Object)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotSame");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotSameAs(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotSame(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqual`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\n@SuppressWarnings(value = \"java:S1448\")\nstatic final class AssertEqual {\n    \n    @BeforeTemplate\n    void before(boolean actual, boolean expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(boolean actual, Boolean expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Boolean actual, boolean expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Boolean actual, Boolean expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(byte actual, byte expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(byte actual, Byte expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Byte actual, byte expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Byte actual, Byte expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(char actual, char expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(char actual, Character expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Character actual, char expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Character actual, Character expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(short actual, short expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(short actual, Short expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Short actual, short expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Short actual, Short expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(int actual, int expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(int actual, Integer expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Integer actual, int expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Integer actual, Integer expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(long actual, long expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(long actual, Long expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Long actual, long expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Long actual, Long expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(float actual, float expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(float actual, Float expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Float actual, float expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Float actual, Float expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(double actual, double expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(double actual, Double expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Double actual, double expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Double actual, Double expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(String actual, String expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Map<?, ?> actual, Map<?, ?> expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isEqualTo(expected);\n    }\n}\n```\n.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S1448");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate before2;
                JavaTemplate before3;
                JavaTemplate before4;
                JavaTemplate before5;
                JavaTemplate before6;
                JavaTemplate before7;
                JavaTemplate before8;
                JavaTemplate before9;
                JavaTemplate before10;
                JavaTemplate before11;
                JavaTemplate before12;
                JavaTemplate before13;
                JavaTemplate before14;
                JavaTemplate before15;
                JavaTemplate before16;
                JavaTemplate before17;
                JavaTemplate before18;
                JavaTemplate before19;
                JavaTemplate before20;
                JavaTemplate before21;
                JavaTemplate before22;
                JavaTemplate before23;
                JavaTemplate before24;
                JavaTemplate before25;
                JavaTemplate before26;
                JavaTemplate before27;
                JavaTemplate before28;
                JavaTemplate before29;
                JavaTemplate before30;
                JavaTemplate before31;
                JavaTemplate before32;
                JavaTemplate before33;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(boolean)}, #{expected:any(boolean)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(boolean)}, #{expected:any(java.lang.Boolean)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before1 == null) {
                        this.before1 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Boolean)}, #{expected:any(boolean)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before10 == null) {
                        this.before10 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Character)}, #{expected:any(java.lang.Character)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before10.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before11 == null) {
                        this.before11 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(short)}, #{expected:any(short)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before11.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before12 == null) {
                        this.before12 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(short)}, #{expected:any(java.lang.Short)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before12.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before13 == null) {
                        this.before13 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Short)}, #{expected:any(short)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before13.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before14 == null) {
                        this.before14 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Short)}, #{expected:any(java.lang.Short)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before14.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before15 == null) {
                        this.before15 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(int)}, #{expected:any(int)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before15.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before16 == null) {
                        this.before16 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(int)}, #{expected:any(java.lang.Integer)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before16.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before17 == null) {
                        this.before17 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Integer)}, #{expected:any(int)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before17.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before18 == null) {
                        this.before18 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Integer)}, #{expected:any(java.lang.Integer)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before18.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before19 == null) {
                        this.before19 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(long)}, #{expected:any(long)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before19.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Boolean)}, #{expected:any(java.lang.Boolean)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before20 == null) {
                        this.before20 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(long)}, #{expected:any(java.lang.Long)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before20.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before21 == null) {
                        this.before21 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Long)}, #{expected:any(long)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before21.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before22 == null) {
                        this.before22 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Long)}, #{expected:any(java.lang.Long)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before22.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before23 == null) {
                        this.before23 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(float)}, #{expected:any(float)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before23.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before24 == null) {
                        this.before24 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(float)}, #{expected:any(java.lang.Float)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before24.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before25 == null) {
                        this.before25 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Float)}, #{expected:any(float)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before25.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before26 == null) {
                        this.before26 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Float)}, #{expected:any(java.lang.Float)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before26.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before27 == null) {
                        this.before27 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(double)}, #{expected:any(double)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before27.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before28 == null) {
                        this.before28 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(double)}, #{expected:any(java.lang.Double)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before28.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before29 == null) {
                        this.before29 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Double)}, #{expected:any(double)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before29.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before3 == null) {
                        this.before3 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(byte)}, #{expected:any(byte)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before30 == null) {
                        this.before30 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Double)}, #{expected:any(java.lang.Double)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before30.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before31 == null) {
                        this.before31 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Object)}, #{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before31.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before32 == null) {
                        this.before32 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.String)}, #{expected:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before32.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before33 == null) {
                        this.before33 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.util.Map<?, ?>)}, #{expected:any(java.util.Map<?, ?>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before33.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before4 == null) {
                        this.before4 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(byte)}, #{expected:any(java.lang.Byte)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before4.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before5 == null) {
                        this.before5 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Byte)}, #{expected:any(byte)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before5.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before6 == null) {
                        this.before6 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Byte)}, #{expected:any(java.lang.Byte)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before6.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before7 == null) {
                        this.before7 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(char)}, #{expected:any(char)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before7.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before8 == null) {
                        this.before8 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(char)}, #{expected:any(java.lang.Character)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before8.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before9 == null) {
                        this.before9 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Character)}, #{expected:any(char)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before9.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\n@SuppressWarnings(value = \"java:S1448\")\nstatic final class AssertEqualWithMessage {\n    \n    @BeforeTemplate\n    void before(boolean actual, String message, boolean expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(boolean actual, String message, Boolean expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Boolean actual, String message, boolean expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Boolean actual, String message, Boolean expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(byte actual, String message, byte expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(byte actual, String message, Byte expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Byte actual, String message, byte expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Byte actual, String message, Byte expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(char actual, String message, char expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(char actual, String message, Character expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Character actual, String message, char expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Character actual, String message, Character expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(short actual, String message, short expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(short actual, String message, Short expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Short actual, String message, short expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Short actual, String message, Short expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(int actual, String message, int expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(int actual, String message, Integer expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Integer actual, String message, int expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Integer actual, String message, Integer expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(long actual, String message, long expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(long actual, String message, Long expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Long actual, String message, long expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Long actual, String message, Long expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(float actual, String message, float expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(float actual, String message, Float expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Float actual, String message, float expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Float actual, String message, Float expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(double actual, String message, double expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(double actual, String message, Double expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Double actual, String message, double expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Double actual, String message, Double expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(String actual, String message, String expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Map<?, ?> actual, String message, Map<?, ?> expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isEqualTo(expected);\n    }\n}\n```\n.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S1448");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate before2;
                JavaTemplate before3;
                JavaTemplate before4;
                JavaTemplate before5;
                JavaTemplate before6;
                JavaTemplate before7;
                JavaTemplate before8;
                JavaTemplate before9;
                JavaTemplate before10;
                JavaTemplate before11;
                JavaTemplate before12;
                JavaTemplate before13;
                JavaTemplate before14;
                JavaTemplate before15;
                JavaTemplate before16;
                JavaTemplate before17;
                JavaTemplate before18;
                JavaTemplate before19;
                JavaTemplate before20;
                JavaTemplate before21;
                JavaTemplate before22;
                JavaTemplate before23;
                JavaTemplate before24;
                JavaTemplate before25;
                JavaTemplate before26;
                JavaTemplate before27;
                JavaTemplate before28;
                JavaTemplate before29;
                JavaTemplate before30;
                JavaTemplate before31;
                JavaTemplate before32;
                JavaTemplate before33;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(boolean)}, #{expected:any(boolean)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(boolean)}, #{expected:any(java.lang.Boolean)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before1 == null) {
                        this.before1 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Boolean)}, #{expected:any(boolean)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before10 == null) {
                        this.before10 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Character)}, #{expected:any(java.lang.Character)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before10.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before11 == null) {
                        this.before11 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(short)}, #{expected:any(short)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before11.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before12 == null) {
                        this.before12 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(short)}, #{expected:any(java.lang.Short)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before12.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before13 == null) {
                        this.before13 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Short)}, #{expected:any(short)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before13.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before14 == null) {
                        this.before14 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Short)}, #{expected:any(java.lang.Short)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before14.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before15 == null) {
                        this.before15 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(int)}, #{expected:any(int)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before15.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before16 == null) {
                        this.before16 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(int)}, #{expected:any(java.lang.Integer)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before16.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before17 == null) {
                        this.before17 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Integer)}, #{expected:any(int)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before17.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before18 == null) {
                        this.before18 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Integer)}, #{expected:any(java.lang.Integer)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before18.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before19 == null) {
                        this.before19 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(long)}, #{expected:any(long)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before19.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Boolean)}, #{expected:any(java.lang.Boolean)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before20 == null) {
                        this.before20 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(long)}, #{expected:any(java.lang.Long)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before20.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before21 == null) {
                        this.before21 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Long)}, #{expected:any(long)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before21.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before22 == null) {
                        this.before22 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Long)}, #{expected:any(java.lang.Long)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before22.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before23 == null) {
                        this.before23 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(float)}, #{expected:any(float)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before23.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before24 == null) {
                        this.before24 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(float)}, #{expected:any(java.lang.Float)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before24.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before25 == null) {
                        this.before25 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Float)}, #{expected:any(float)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before25.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before26 == null) {
                        this.before26 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Float)}, #{expected:any(java.lang.Float)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before26.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before27 == null) {
                        this.before27 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(double)}, #{expected:any(double)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before27.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before28 == null) {
                        this.before28 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(double)}, #{expected:any(java.lang.Double)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before28.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before29 == null) {
                        this.before29 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Double)}, #{expected:any(double)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before29.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before3 == null) {
                        this.before3 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(byte)}, #{expected:any(byte)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before30 == null) {
                        this.before30 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Double)}, #{expected:any(java.lang.Double)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before30.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before31 == null) {
                        this.before31 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Object)}, #{expected:any(java.lang.Object)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before31.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before32 == null) {
                        this.before32 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.String)}, #{expected:any(java.lang.String)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before32.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before33 == null) {
                        this.before33 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.util.Map<?, ?>)}, #{expected:any(java.util.Map<?, ?>)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before33.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before4 == null) {
                        this.before4 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(byte)}, #{expected:any(java.lang.Byte)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before4.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before5 == null) {
                        this.before5 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Byte)}, #{expected:any(byte)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before5.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before6 == null) {
                        this.before6 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Byte)}, #{expected:any(java.lang.Byte)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before6.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before7 == null) {
                        this.before7 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(char)}, #{expected:any(char)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before7.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before8 == null) {
                        this.before8 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(char)}, #{expected:any(java.lang.Character)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before8.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before9 == null) {
                        this.before9 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Character)}, #{expected:any(char)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before9.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualFloatsWithDeltaRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualFloatsWithDelta`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualFloatsWithDelta {\n    \n    @BeforeTemplate\n    void before(float actual, float expected, float delta) {\n        assertEquals(actual, expected, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Float actual, float expected, float delta) {\n        assertThat(actual).isCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(float)}, #{expected:any(float)}, #{delta:any(float)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Float)}).isCloseTo(#{expected:any(float)}, org.assertj.core.data.Offset.offset(#{delta:any(float)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualFloatsWithDeltaWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualFloatsWithDeltaWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualFloatsWithDeltaWithMessage {\n    \n    @BeforeTemplate\n    void before(float actual, String message, float expected, float delta) {\n        assertEquals(actual, expected, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float actual, String message, float expected, float delta) {\n        assertThat(actual).withFailMessage(message).isCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(float)}, #{expected:any(float)}, #{delta:any(float)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(float)}).withFailMessage(#{message:any(java.lang.String)}).isCloseTo(#{expected:any(float)}, org.assertj.core.data.Offset.offset(#{delta:any(float)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(3), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualDoublesWithDeltaRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualDoublesWithDelta`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualDoublesWithDelta {\n    \n    @BeforeTemplate\n    void before(double actual, double expected, double delta) {\n        assertEquals(actual, expected, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double actual, double expected, double delta) {\n        assertThat(actual).isCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(double)}, #{expected:any(double)}, #{delta:any(double)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isCloseTo(#{expected:any(double)}, org.assertj.core.data.Offset.offset(#{delta:any(double)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualDoublesWithDeltaWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualDoublesWithDeltaWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualDoublesWithDeltaWithMessage {\n    \n    @BeforeTemplate\n    void before(double actual, String message, double expected, double delta) {\n        assertEquals(actual, expected, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double actual, String message, double expected, double delta) {\n        assertThat(actual).withFailMessage(message).isCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(double)}, #{expected:any(double)}, #{delta:any(double)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).withFailMessage(#{message:any(java.lang.String)}).isCloseTo(#{expected:any(double)}, org.assertj.core.data.Offset.offset(#{delta:any(double)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(3), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualArrayIterationOrderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualArrayIterationOrder`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualArrayIterationOrder {\n    \n    @BeforeTemplate\n    void before(boolean[] actual, boolean[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(byte[] actual, byte[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(char[] actual, char[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(short[] actual, short[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(int[] actual, int[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(long[] actual, long[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(float[] actual, float[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(double[] actual, double[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Object[] actual, Object[] expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, Object[] expected) {\n        assertThat(actual).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate before2;
                JavaTemplate before3;
                JavaTemplate before4;
                JavaTemplate before5;
                JavaTemplate before6;
                JavaTemplate before7;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(boolean[])}, #{expected:any(boolean[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(byte[])}, #{expected:any(byte[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before1 == null) {
                        this.before1 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(char[])}, #{expected:any(char[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(short[])}, #{expected:any(short[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before3 == null) {
                        this.before3 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(int[])}, #{expected:any(int[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before4 == null) {
                        this.before4 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(long[])}, #{expected:any(long[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before4.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before5 == null) {
                        this.before5 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(float[])}, #{expected:any(float[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before5.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before6 == null) {
                        this.before6 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(double[])}, #{expected:any(double[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before6.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before7 == null) {
                        this.before7 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Object[])}, #{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before7.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualArrayIterationOrderWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualArrayIterationOrderWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualArrayIterationOrderWithMessage {\n    \n    @BeforeTemplate\n    void before(boolean[] actual, String message, boolean[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(byte[] actual, String message, byte[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(char[] actual, String message, char[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(short[] actual, String message, short[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(int[] actual, String message, int[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(long[] actual, String message, long[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(float[] actual, String message, float[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(double[] actual, String message, double[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Object[] actual, String message, Object[] expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, String message, Object[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate before2;
                JavaTemplate before3;
                JavaTemplate before4;
                JavaTemplate before5;
                JavaTemplate before6;
                JavaTemplate before7;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(boolean[])}, #{expected:any(boolean[])}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(byte[])}, #{expected:any(byte[])}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before1 == null) {
                        this.before1 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(char[])}, #{expected:any(char[])}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(short[])}, #{expected:any(short[])}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before3 == null) {
                        this.before3 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(int[])}, #{expected:any(int[])}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before4 == null) {
                        this.before4 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(long[])}, #{expected:any(long[])}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before4.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before5 == null) {
                        this.before5 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(float[])}, #{expected:any(float[])}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before5.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before6 == null) {
                        this.before6 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(double[])}, #{expected:any(double[])}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before6.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before7 == null) {
                        this.before7 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Object[])}, #{expected:any(java.lang.Object[])}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before7.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualFloatArraysWithDeltaRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualFloatArraysWithDelta`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualFloatArraysWithDelta {\n    \n    @BeforeTemplate\n    void before(float[] actual, float[] expected, float delta) {\n        assertEquals(actual, expected, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float[] actual, float[] expected, float delta) {\n        assertThat(actual).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(float[])}, #{expected:any(float[])}, #{delta:any(float)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(float[])}).containsExactly(#{expected:any(float[])}, org.assertj.core.data.Offset.offset(#{delta:any(float)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualFloatArraysWithDeltaWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualFloatArraysWithDeltaWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualFloatArraysWithDeltaWithMessage {\n    \n    @BeforeTemplate\n    void before(float[] actual, String message, float[] expected, float delta) {\n        assertEquals(actual, expected, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float[] actual, String message, float[] expected, float delta) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(float[])}, #{expected:any(float[])}, #{delta:any(float)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(float[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(float[])}, org.assertj.core.data.Offset.offset(#{delta:any(float)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(3), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualDoubleArraysWithDeltaRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualDoubleArraysWithDelta`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualDoubleArraysWithDelta {\n    \n    @BeforeTemplate\n    void before(double[] actual, double[] expected, double delta) {\n        assertEquals(actual, expected, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double[] actual, double[] expected, double delta) {\n        assertThat(actual).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(double[])}, #{expected:any(double[])}, #{delta:any(double)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(double[])}).containsExactly(#{expected:any(double[])}, org.assertj.core.data.Offset.offset(#{delta:any(double)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualDoubleArraysWithDeltaWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualDoubleArraysWithDeltaWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualDoubleArraysWithDeltaWithMessage {\n    \n    @BeforeTemplate\n    void before(double[] actual, String message, double[] expected, double delta) {\n        assertEquals(actual, expected, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double[] actual, String message, double[] expected, double delta) {\n        assertThat(actual).withFailMessage(message).containsExactly(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(double[])}, #{expected:any(double[])}, #{delta:any(double)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(double[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactly(#{expected:any(double[])}, org.assertj.core.data.Offset.offset(#{delta:any(double)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(3), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualArraysIrrespectiveOfOrderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualArraysIrrespectiveOfOrder`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualArraysIrrespectiveOfOrder {\n    \n    @BeforeTemplate\n    void before(Object[] actual, Object[] expected) {\n        assertEqualsNoOrder(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, Object[] expected) {\n        assertThat(actual).containsExactlyInAnyOrder(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEqualsNoOrder(#{actual:any(java.lang.Object[])}, #{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEqualsNoOrder");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).containsExactlyInAnyOrder(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEqualsNoOrder(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualArraysIrrespectiveOfOrderWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualArraysIrrespectiveOfOrderWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualArraysIrrespectiveOfOrderWithMessage {\n    \n    @BeforeTemplate\n    void before(Object[] actual, String message, Object[] expected) {\n        assertEqualsNoOrder(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object[] actual, String message, Object[] expected) {\n        assertThat(actual).withFailMessage(message).containsExactlyInAnyOrder(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEqualsNoOrder(#{actual:any(java.lang.Object[])}, #{expected:any(java.lang.Object[])}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEqualsNoOrder");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object[])}).withFailMessage(#{message:any(java.lang.String)}).containsExactlyInAnyOrder(#{expected:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEqualsNoOrder(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualIteratorIterationOrderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualIteratorIterationOrder`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualIteratorIterationOrder<S, T extends S> {\n    \n    @BeforeTemplate\n    void before(Iterator<S> actual, Iterator<T> expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Iterator<S> actual, Iterator<T> expected) {\n        assertThat(actual).toIterable().containsExactlyElementsOf(ImmutableList.copyOf(expected));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.util.Iterator<S>)}, #{expected:any(java.util.Iterator<T>)});").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.util.Iterator<S>)}).toIterable().containsExactlyElementsOf(com.google.common.collect.ImmutableList.copyOf(#{expected:any(java.util.Iterator<T>)}));").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Iterator", Boolean.valueOf(true)), new UsesMethod("org.testng.Assert assertEquals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualIteratorIterationOrderWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualIteratorIterationOrderWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualIteratorIterationOrderWithMessage<S, T extends S> {\n    \n    @BeforeTemplate\n    void before(Iterator<S> actual, String message, Iterator<T> expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Iterator<S> actual, String message, Iterator<T> expected) {\n        assertThat(actual).toIterable().withFailMessage(message).containsExactlyElementsOf(ImmutableList.copyOf(expected));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.util.Iterator<S>)}, #{expected:any(java.util.Iterator<T>)}, #{message:any(java.lang.String)});").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.util.Iterator<S>)}).toIterable().withFailMessage(#{message:any(java.lang.String)}).containsExactlyElementsOf(com.google.common.collect.ImmutableList.copyOf(#{expected:any(java.util.Iterator<T>)}));").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Iterator", Boolean.valueOf(true)), new UsesMethod("org.testng.Assert assertEquals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualIterableIterationOrderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualIterableIterationOrder`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualIterableIterationOrder<S, T extends S> {\n    \n    @BeforeTemplate\n    void before(Iterable<S> actual, Iterable<T> expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Collection<S> actual, Collection<T> expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Iterable<S> actual, Iterable<T> expected) {\n        assertThat(actual).containsExactlyElementsOf(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Iterable<S>)}, #{expected:any(java.lang.Iterable<T>)});").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Iterable<S>)}).containsExactlyElementsOf(#{expected:any(java.lang.Iterable<T>)});").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.util.Collection<S>)}, #{expected:any(java.util.Collection<T>)});").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Collection");
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Iterable<S>)}).containsExactlyElementsOf(#{expected:any(java.lang.Iterable<T>)});").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualIterableIterationOrderWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualIterableIterationOrderWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualIterableIterationOrderWithMessage<S, T extends S> {\n    \n    @BeforeTemplate\n    void before(Iterable<S> actual, String message, Iterable<T> expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Collection<S> actual, String message, Collection<T> expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Iterable<S> actual, String message, Iterable<T> expected) {\n        assertThat(actual).withFailMessage(message).containsExactlyElementsOf(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.lang.Iterable<S>)}, #{expected:any(java.lang.Iterable<T>)}, #{message:any(java.lang.String)});").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Iterable<S>)}).withFailMessage(#{message:any(java.lang.String)}).containsExactlyElementsOf(#{expected:any(java.lang.Iterable<T>)});").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.util.Collection<S>)}, #{expected:any(java.util.Collection<T>)}, #{message:any(java.lang.String)});").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Collection");
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Iterable<S>)}).withFailMessage(#{message:any(java.lang.String)}).containsExactlyElementsOf(#{expected:any(java.lang.Iterable<T>)});").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualSetsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualSets`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualSets<S, T extends S> {\n    \n    @BeforeTemplate\n    void before(Set<S> actual, Set<T> expected) {\n        assertEquals(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Set<S> actual, Set<T> expected) {\n        assertThat(actual).hasSameElementsAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.util.Set<S>)}, #{expected:any(java.util.Set<T>)});").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.util.Set<S>)}).hasSameElementsAs(#{expected:any(java.util.Set<T>)});").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesMethod("org.testng.Assert assertEquals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertEqualSetsWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertEqualSetsWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertEqualSetsWithMessage<S, T extends S> {\n    \n    @BeforeTemplate\n    void before(Set<S> actual, String message, Set<T> expected) {\n        assertEquals(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Set<S> actual, String message, Set<T> expected) {\n        assertThat(actual).withFailMessage(message).hasSameElementsAs(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertEquals(#{actual:any(java.util.Set<S>)}, #{expected:any(java.util.Set<T>)}, #{message:any(java.lang.String)});").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.util.Set<S>)}).withFailMessage(#{message:any(java.lang.String)}).hasSameElementsAs(#{expected:any(java.util.Set<T>)});").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesMethod("org.testng.Assert assertEquals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertUnequalRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertUnequal`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequal {\n    \n    @BeforeTemplate\n    void before(boolean actual, boolean expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(byte actual, byte expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(char actual, char expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(short actual, short expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(int actual, int expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(long actual, long expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(float actual, float expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(double actual, double expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Object actual, Object expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(String actual, String expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Set<?> actual, Set<?> expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @BeforeTemplate\n    void before(Map<?, ?> actual, Map<?, ?> expected) {\n        assertNotEquals(actual, expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, Object expected) {\n        assertThat(actual).isNotEqualTo(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate before2;
                JavaTemplate before3;
                JavaTemplate before4;
                JavaTemplate before5;
                JavaTemplate before6;
                JavaTemplate before7;
                JavaTemplate before8;
                JavaTemplate before9;
                JavaTemplate before10;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(boolean)}, #{expected:any(boolean)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(byte)}, #{expected:any(byte)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before1 == null) {
                        this.before1 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(char)}, #{expected:any(char)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before10 == null) {
                        this.before10 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(java.util.Map<?, ?>)}, #{expected:any(java.util.Map<?, ?>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before10.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(short)}, #{expected:any(short)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before3 == null) {
                        this.before3 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(int)}, #{expected:any(int)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before4 == null) {
                        this.before4 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(long)}, #{expected:any(long)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before4.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before5 == null) {
                        this.before5 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(float)}, #{expected:any(float)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before5.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before6 == null) {
                        this.before6 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(double)}, #{expected:any(double)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before6.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before7 == null) {
                        this.before7 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(java.lang.Object)}, #{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before7.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before8 == null) {
                        this.before8 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(java.lang.String)}, #{expected:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before8.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before9 == null) {
                        this.before9 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(java.util.Set<?>)}, #{expected:any(java.util.Set<?>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before9.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Set");
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertUnequalWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertUnequalWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequalWithMessage {\n    \n    @BeforeTemplate\n    void before(boolean actual, String message, boolean expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(byte actual, String message, byte expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(char actual, String message, char expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(short actual, String message, short expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(int actual, String message, int expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(long actual, String message, long expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(float actual, String message, float expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(double actual, String message, double expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Object actual, String message, Object expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(String actual, String message, String expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Set<?> actual, String message, Set<?> expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @BeforeTemplate\n    void before(Map<?, ?> actual, String message, Map<?, ?> expected) {\n        assertNotEquals(actual, expected, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Object actual, String message, Object expected) {\n        assertThat(actual).withFailMessage(message).isNotEqualTo(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate before2;
                JavaTemplate before3;
                JavaTemplate before4;
                JavaTemplate before5;
                JavaTemplate before6;
                JavaTemplate before7;
                JavaTemplate before8;
                JavaTemplate before9;
                JavaTemplate before10;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(boolean)}, #{expected:any(boolean)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(byte)}, #{expected:any(byte)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before1 == null) {
                        this.before1 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(char)}, #{expected:any(char)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before10 == null) {
                        this.before10 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(java.util.Map<?, ?>)}, #{expected:any(java.util.Map<?, ?>)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before10.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map");
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(short)}, #{expected:any(short)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before3 == null) {
                        this.before3 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(int)}, #{expected:any(int)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before4 == null) {
                        this.before4 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(long)}, #{expected:any(long)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before4.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before5 == null) {
                        this.before5 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(float)}, #{expected:any(float)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before5.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before6 == null) {
                        this.before6 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(double)}, #{expected:any(double)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before6.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before7 == null) {
                        this.before7 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(java.lang.Object)}, #{expected:any(java.lang.Object)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before7.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before8 == null) {
                        this.before8 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(java.lang.String)}, #{expected:any(java.lang.String)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before8.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before9 == null) {
                        this.before9 = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(java.util.Set<?>)}, #{expected:any(java.util.Set<?>)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before9.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Set");
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.lang.Object)}).withFailMessage(#{message:any(java.lang.String)}).isNotEqualTo(#{expected:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertUnequalFloatsWithDeltaRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertUnequalFloatsWithDelta`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequalFloatsWithDelta {\n    \n    @BeforeTemplate\n    void before(float actual, float expected, float delta) {\n        assertNotEquals(actual, expected, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float actual, float expected, float delta) {\n        assertThat(actual).isNotCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(float)}, #{expected:any(float)}, #{delta:any(float)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(float)}).isNotCloseTo(#{expected:any(float)}, org.assertj.core.data.Offset.offset(#{delta:any(float)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertUnequalFloatsWithDeltaWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertUnequalFloatsWithDeltaWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequalFloatsWithDeltaWithMessage {\n    \n    @BeforeTemplate\n    void before(float actual, String message, float expected, float delta) {\n        assertNotEquals(actual, expected, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(float actual, String message, float expected, float delta) {\n        assertThat(actual).withFailMessage(message).isNotCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(float)}, #{expected:any(float)}, #{delta:any(float)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(float)}).withFailMessage(#{message:any(java.lang.String)}).isNotCloseTo(#{expected:any(float)}, org.assertj.core.data.Offset.offset(#{delta:any(float)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(3), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertUnequalDoublesWithDeltaRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertUnequalDoublesWithDelta`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequalDoublesWithDelta {\n    \n    @BeforeTemplate\n    void before(double actual, double expected, double delta) {\n        assertNotEquals(actual, expected, delta);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double actual, double expected, double delta) {\n        assertThat(actual).isNotCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(double)}, #{expected:any(double)}, #{delta:any(double)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).isNotCloseTo(#{expected:any(double)}, org.assertj.core.data.Offset.offset(#{delta:any(double)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertUnequalDoublesWithDeltaWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertUnequalDoublesWithDeltaWithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertUnequalDoublesWithDeltaWithMessage {\n    \n    @BeforeTemplate\n    void before(double actual, String message, double expected, double delta) {\n        assertNotEquals(actual, expected, delta, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(double actual, String message, double expected, double delta) {\n        assertThat(actual).withFailMessage(message).isNotCloseTo(expected, offset(delta));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertNotEquals(#{actual:any(double)}, #{expected:any(double)}, #{delta:any(double)}, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertNotEquals");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(double)}).withFailMessage(#{message:any(java.lang.String)}).isNotCloseTo(#{expected:any(double)}, org.assertj.core.data.Offset.offset(#{delta:any(double)}));").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(3), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("org.testng.Assert assertNotEquals(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThrowsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertThrows`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThrows {\n    \n    @BeforeTemplate\n    void before(ThrowingRunnable runnable) {\n        assertThrows(runnable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable runnable) {\n        assertThatThrownBy(runnable);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertThrows(#{runnable:any(org.testng.Assert.ThrowingRunnable)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert.ThrowingRunnable");
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertThrows");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{runnable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.testng.Assert.ThrowingRunnable", Boolean.valueOf(true)), new UsesMethod("org.testng.Assert assertThrows(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThrowsWithTypeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `TestNGToAssertJRules.AssertThrowsWithType`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThrowsWithType<T extends Throwable> {\n    \n    @BeforeTemplate\n    void before(ThrowingRunnable runnable, Class<T> clazz) {\n        assertThrows(clazz, runnable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(ThrowingCallable runnable, Class<T> clazz) {\n        assertThatThrownBy(runnable).isInstanceOf(clazz);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.testng.Assert.assertThrows(#{clazz:any(java.lang.Class<T>)}, #{runnable:any(org.testng.Assert.ThrowingRunnable)});").genericTypes(new String[]{"T extends java.lang.Throwable"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.testng.Assert.ThrowingRunnable");
                        this.maybeRemoveImport("org.testng.Assert");
                        this.maybeRemoveImport("org.testng.Assert.assertThrows");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThatThrownBy(#{runnable:any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)}).isInstanceOf(#{clazz:any(java.lang.Class<T>)});").genericTypes(new String[]{"T extends java.lang.Throwable"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.testng.Assert.ThrowingRunnable", Boolean.valueOf(true)), new UsesMethod("org.testng.Assert assertThrows(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

