/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class PreconditionsRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`PreconditionsRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster templates related to statements dealing with `Preconditions`.\n[Source](https://error-prone.picnic.tech/refasterrules/PreconditionsRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new RequireNonNullRecipe(), new RequireNonNullWithMessageRecipe()});
    }

    @NullMarked
    public static class RequireNonNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PreconditionsRules.RequireNonNull`";
        }

        public String getDescription() {
            return "Prefer `Objects#requireNonNull(Object)` over non-JDK alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.base.Preconditions.checkNotNull(#{object:any(T)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.base.Preconditions");
                        this.maybeRemoveImport("com.google.common.base.Preconditions.checkNotNull");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects.requireNonNull(#{object:any(T)})").bindType("T").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("com.google.common.base.Preconditions checkNotNull(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class RequireNonNullWithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `PreconditionsRules.RequireNonNullWithMessage`";
        }

        public String getDescription() {
            return "Prefer `Objects#requireNonNull(Object, String)` over non-JDK alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.base.Preconditions.checkNotNull(#{object:any(T)}, #{message:any(java.lang.String)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.base.Preconditions");
                        this.maybeRemoveImport("com.google.common.base.Preconditions.checkNotNull");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects.requireNonNull(#{object:any(T)}, #{message:any(java.lang.String)})").bindType("T").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("com.google.common.base.Preconditions checkNotNull(..)", true), (TreeVisitor)javaVisitor);
        }
    }
}

