/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class OptionalRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`OptionalRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `Optional`s.\n[Source](https://error-prone.picnic.tech/refasterrules/OptionalRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new OptionalEmptyRecipe(), new OptionalOfNullableRecipe(), new OptionalIsEmptyRecipe(), new OptionalIsPresentRecipe(), new OptionalOrElseThrowRecipe(), new OptionalOrElseThrowMethodReferenceRecipe(), new OptionalEqualsOptionalRecipe(), new OptionalFirstIteratorElementRecipe(), new MapOptionalToBooleanRecipe(), new OrOrElseThrowRecipe(), new StreamFlatMapOptionalRecipe(), new OptionalOrOtherOptionalRecipe(), new OptionalFilterRecipe(), new OptionalMapRecipe(), new OptionalStreamRecipe()});
    }

    @NullMarked
    public static class OptionalEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `OptionalRules.OptionalEmpty`";
        }

        public String getDescription() {
            return "Prefer `Optional#empty()` over the more contrived alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.Optional.ofNullable(null)").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Optional.empty()").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("java.util.Optional ofNullable(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OptionalOfNullableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `OptionalRules.OptionalOfNullable`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OptionalOfNullable<T> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"TernaryOperatorOptionalNegativeFiltering\")\n    Optional<T> before(@Nullable\n    T object) {\n        return object == null ? Optional.empty() : Optional.of(object);\n    }\n    \n    @AfterTemplate\n    Optional<T> after(T object) {\n        return Optional.ofNullable(object);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitTernary(J.Ternary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{object:any(T)} == null ? java.util.Optional.empty() : java.util.Optional.of(#{object})").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Optional.ofNullable(#{object:any(T)})").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitTernary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("java.util.Optional empty(..)", true), new UsesMethod("java.util.Optional of(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OptionalIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `OptionalRules.OptionalIsEmpty`";
        }

        public String getDescription() {
            return "Prefer `Optional#isEmpty()` over the more verbose alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"!#{optional:any(java.util.Optional<T>)}.isPresent()").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.isEmpty()").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitUnary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("java.util.Optional isPresent(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OptionalIsPresentRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `OptionalRules.OptionalIsPresent`";
        }

        public String getDescription() {
            return "Prefer `Optional#isPresent()` over the inverted alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"!#{optional:any(java.util.Optional<T>)}.isEmpty()").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.isPresent()").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitUnary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("java.util.Optional isEmpty(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OptionalOrElseThrowRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `OptionalRules.OptionalOrElseThrow`";
        }

        public String getDescription() {
            return "Prefer `Optional#orElseThrow()` over the less explicit `Optional#get()`.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S3655");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.get()").bindType("T").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.orElseThrow()").bindType("T").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("java.util.Optional get(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OptionalOrElseThrowMethodReferenceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `OptionalRules.OptionalOrElseThrowMethodReference`";
        }

        public String getDescription() {
            return "Prefer `Optional#orElseThrow()` over the less explicit `Optional#get()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitExpression(Expression elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.Optional::get").bindType("java.util.function.Function<java.util.Optional<T>, T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Optional::orElseThrow").bindType("java.util.function.Function<java.util.Optional<T>, T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitExpression(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true))}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OptionalEqualsOptionalRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `OptionalRules.OptionalEqualsOptional`";
        }

        public String getDescription() {
            return "Prefer `Optional#equals(Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.filter(#{value:any(S)}::equals).isPresent()").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.equals(java.util.Optional.of(#{value:any(S)}))").genericTypes(new String[]{"T", "S"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.stream().anyMatch(#{value:any(S)}::equals)").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.equals(java.util.Optional.of(#{value:any(S)}))").genericTypes(new String[]{"T", "S"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Optional filter(..)", true), new UsesMethod("java.util.Optional isPresent(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Optional stream(..)", true), new UsesMethod("java.util.stream.Stream anyMatch(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OptionalFirstIteratorElementRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `OptionalRules.OptionalFirstIteratorElement`";
        }

        public String getDescription() {
            return "Don't use the ternary operator to extract the first element of a possibly-empty `Iterator` as an `Optional`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitTernary(J.Ternary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{it:any(java.util.Iterator<T>)}.hasNext() ? java.util.Optional.of(#{it}.next()) : java.util.Optional.empty()").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Streams.stream(#{it:any(java.util.Iterator<T>)}).findFirst()").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitTernary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Iterator", Boolean.valueOf(true)), new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("java.util.Iterator hasNext(..)", true), new UsesMethod("java.util.Iterator next(..)", true), new UsesMethod("java.util.Optional empty(..)", true), new UsesMethod("java.util.Optional of(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MapOptionalToBooleanRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `OptionalRules.MapOptionalToBoolean`";
        }

        public String getDescription() {
            return "Prefer `Optional#filter(Predicate)` over `Optional#map(Function)` when converting an `Optional` to a boolean.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.map(#{predicate:any(java.util.function.Function<? super T, java.lang.Boolean>)}).orElse(false)").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)}).isPresent()").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("java.util.Optional map(..)", true), new UsesMethod("java.util.Optional orElse(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OrOrElseThrowRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `OptionalRules.OrOrElseThrow`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OrOrElseThrow<T> {\n    \n    @BeforeTemplate\n    T before(Optional<T> o1, Optional<T> o2) {\n        return o1.orElseGet(()->o2.orElseThrow());\n    }\n    \n    @AfterTemplate\n    T after(Optional<T> o1, Optional<T> o2) {\n        return o1.or(()->o2).orElseThrow();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{o1:any(java.util.Optional<T>)}.orElseGet(()->#{o2:any(java.util.Optional<T>)}.orElseThrow())").bindType("T").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{o1:any(java.util.Optional<T>)}.or(()->#{o2:any(java.util.Optional<T>)}).orElseThrow()").bindType("T").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("java.util.Optional orElseGet(..)", true), new UsesMethod("java.util.Optional orElseThrow(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamFlatMapOptionalRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `OptionalRules.StreamFlatMapOptional`";
        }

        public String getDescription() {
            return "Flatten a stream of `Optional`s using `Optional#stream()`, rather than using one of the more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<java.util.Optional<T>>)}.filter(java.util.Optional::isPresent).map(java.util.Optional::orElseThrow)").bindType("java.util.stream.Stream<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<java.util.Optional<T>>)}.flatMap(java.util.Optional::stream)").bindType("java.util.stream.Stream<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<java.util.Optional<T>>)}.flatMap(com.google.common.collect.Streams::stream)").bindType("java.util.stream.Stream<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<java.util.Optional<T>>)}.flatMap(java.util.Optional::stream)").bindType("java.util.stream.Stream<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.Stream filter(..)", true), new UsesMethod("java.util.stream.Stream map(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream flatMap(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OptionalOrOtherOptionalRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `OptionalRules.OptionalOrOtherOptional`";
        }

        public String getDescription() {
            return "Prefer `Optional#or(Supplier)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{optional1:any(java.util.Optional<T>)}.map(java.util.Optional::of).orElse(#{optional2:any(java.util.Optional<T>)})").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional1:any(java.util.Optional<T>)}.or(()->#{optional2:any(java.util.Optional<T>)})").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{optional1:any(java.util.Optional<T>)}.map(java.util.Optional::of).orElseGet(()->#{optional2:any(java.util.Optional<T>)})").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional1:any(java.util.Optional<T>)}.or(()->#{optional2:any(java.util.Optional<T>)})").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.util.stream.Stream.of(#{optional1:any(java.util.Optional<T>)}, #{optional2:any(java.util.Optional<T>)}).flatMap(java.util.Optional::stream).findFirst()").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Stream");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional1:any(java.util.Optional<T>)}.or(()->#{optional2:any(java.util.Optional<T>)})").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"#{optional1:any(java.util.Optional<T>)}.isPresent() ? #{optional1} : #{optional2:any(java.util.Optional<T>)}").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional1:any(java.util.Optional<T>)}.or(()->#{optional2:any(java.util.Optional<T>)})").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }

                public J visitTernary(J.Ternary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{optional1:any(java.util.Optional<T>)}.map(java.util.Optional::of).orElse(#{optional2:any(java.util.Optional<T>)})").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional1:any(java.util.Optional<T>)}.or(()->#{optional2:any(java.util.Optional<T>)})").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{optional1:any(java.util.Optional<T>)}.map(java.util.Optional::of).orElseGet(()->#{optional2:any(java.util.Optional<T>)})").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional1:any(java.util.Optional<T>)}.or(()->#{optional2:any(java.util.Optional<T>)})").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.util.stream.Stream.of(#{optional1:any(java.util.Optional<T>)}, #{optional2:any(java.util.Optional<T>)}).flatMap(java.util.Optional::stream).findFirst()").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Stream");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional1:any(java.util.Optional<T>)}.or(()->#{optional2:any(java.util.Optional<T>)})").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"#{optional1:any(java.util.Optional<T>)}.isPresent() ? #{optional1} : #{optional2:any(java.util.Optional<T>)}").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional1:any(java.util.Optional<T>)}.or(()->#{optional2:any(java.util.Optional<T>)})").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitTernary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Optional isPresent(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Optional map(..)", true), new UsesMethod("java.util.Optional orElse(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Optional map(..)", true), new UsesMethod("java.util.Optional orElseGet(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream findFirst(..)", true), new UsesMethod("java.util.stream.Stream flatMap(..)", true), new UsesMethod("java.util.stream.Stream of(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OptionalFilterRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `OptionalRules.OptionalFilter`";
        }

        public String getDescription() {
            return "Avoid unnecessary `Optional` to `Stream` conversion when filtering a value of the former type.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.stream().filter(#{predicate:any(java.util.function.Predicate<? super T>)}).findFirst()").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)})").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.stream().filter(#{predicate:any(java.util.function.Predicate<? super T>)}).findAny()").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)})").bindType("java.util.Optional<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesMethod("java.util.Optional stream(..)", true), new UsesMethod("java.util.stream.Stream filter(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.Stream findAny(..)", true), new UsesMethod("java.util.stream.Stream findFirst(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OptionalMapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `OptionalRules.OptionalMap`";
        }

        public String getDescription() {
            return "Avoid unnecessary `Optional` to `Stream` conversion when mapping a value of the former type.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<S>)}.stream().map(#{function:any(java.util.function.Function<? super S, ? extends T>)}).findAny()").bindType("java.util.Optional<? extends T>").genericTypes(new String[]{"S", "T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<S>)}.map(#{function:any(java.util.function.Function<? super S, ? extends T>)})").bindType("java.util.Optional<? extends T>").genericTypes(new String[]{"S", "T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("java.util.Optional stream(..)", true), new UsesMethod("java.util.stream.Stream findAny(..)", true), new UsesMethod("java.util.stream.Stream map(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OptionalStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `OptionalRules.OptionalStream`";
        }

        public String getDescription() {
            return "Prefer `Optional#stream()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.map(java.util.stream.Stream::of).orElseGet(java.util.stream.Stream::empty)").bindType("java.util.stream.Stream<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.stream()").bindType("java.util.stream.Stream<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.Optional map(..)", true), new UsesMethod("java.util.Optional orElseGet(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

