/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJStreamRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJStreamRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJStreamRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJStreamRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AssertThatFilteredOnRecipe(), new AssertThatNoneMatchRecipe(), new AssertThatAnyMatchRecipe(), new AssertThatCollectionRecipe()});
    }

    @NullMarked
    public static class AssertThatFilteredOnRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStreamRules.AssertThatFilteredOn`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatFilteredOn<T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<T> stream, Predicate<? super T> predicate) {\n        return assertThat(stream.filter(predicate));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<T> after(Stream<T> stream, Predicate<? super T> predicate) {\n        return assertThat(stream).filteredOn(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)}))").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).filteredOn(#{predicate:any(java.util.function.Predicate<? super T>)})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream filter(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatNoneMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStreamRules.AssertThatNoneMatch`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatNoneMatch<T> {\n    \n    @BeforeTemplate\n    void before(Stream<T> stream, Predicate<? super T> predicate) {\n        assertThat(stream).filteredOn(predicate).isEmpty();\n    }\n    \n    @BeforeTemplate\n    void before2(Stream<T> stream, Predicate<? super T> predicate) {\n        Refaster.anyOf(assertThat(stream.anyMatch(predicate)).isFalse(), assertThat(stream.noneMatch(predicate)).isTrue());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Stream<T> stream, Predicate<? super T> predicate) {\n        assertThat(stream).noneMatch(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before2$0;
                JavaTemplate before2$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).filteredOn(#{predicate:any(java.util.function.Predicate<? super T>)}).isEmpty();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).noneMatch(#{predicate:any(java.util.function.Predicate<? super T>)});").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2$0 == null) {
                        this.before2$0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}.anyMatch(#{predicate:any(java.util.function.Predicate<? super T>)})).isFalse();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before2$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).noneMatch(#{predicate:any(java.util.function.Predicate<? super T>)});").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2$1 == null) {
                        this.before2$1 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}.noneMatch(#{predicate:any(java.util.function.Predicate<? super T>)})).isTrue();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before2$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).noneMatch(#{predicate:any(java.util.function.Predicate<? super T>)});").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.Stream anyMatch(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.Stream noneMatch(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractIterableAssert filteredOn(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert isEmpty(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatAnyMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStreamRules.AssertThatAnyMatch`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatAnyMatch<T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<T> stream, Predicate<? super T> predicate) {\n        return assertThat(stream).filteredOn(predicate).isNotEmpty();\n    }\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before2(Stream<T> stream, Predicate<? super T> predicate) {\n        return Refaster.anyOf(assertThat(stream.anyMatch(predicate)).isTrue(), assertThat(stream.noneMatch(predicate)).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<T> after(Stream<T> stream, Predicate<? super T> predicate) {\n        return assertThat(stream).anyMatch(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before2$0;
                JavaTemplate before2$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).filteredOn(#{predicate:any(java.util.function.Predicate<? super T>)}).isNotEmpty()").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).anyMatch(#{predicate:any(java.util.function.Predicate<? super T>)})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2$0 == null) {
                        this.before2$0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}.anyMatch(#{predicate:any(java.util.function.Predicate<? super T>)})).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before2$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).anyMatch(#{predicate:any(java.util.function.Predicate<? super T>)})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2$1 == null) {
                        this.before2$1 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}.noneMatch(#{predicate:any(java.util.function.Predicate<? super T>)})).isFalse()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before2$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).anyMatch(#{predicate:any(java.util.function.Predicate<? super T>)})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream anyMatch(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream noneMatch(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIterableAssert filteredOn(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert isNotEmpty(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatCollectionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStreamRules.AssertThatCollection`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatCollection<T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Collection<T> collection) {\n        return assertThat(collection.stream());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractCollectionAssert<?, ?, T, ?> after(Collection<T> collection) {\n        return assertThat(collection);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{collection:any(java.util.Collection<T>)}.stream())").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.ListAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{collection:any(java.util.Collection<T>)})").bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, T, ?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true)), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

