/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJDoubleRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJDoubleRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJDoubleRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJDoubleRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbstractDoubleAssertIsCloseToWithOffsetRecipe(), new AbstractDoubleAssertIsEqualToRecipe(), new AbstractDoubleAssertIsNotEqualToRecipe(), new AbstractDoubleAssertIsZeroRecipe(), new AbstractDoubleAssertIsNotZeroRecipe(), new AbstractDoubleAssertIsOneRecipe()});
    }

    @NullMarked
    public static class AbstractDoubleAssertIsCloseToWithOffsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJDoubleRules.AbstractDoubleAssertIsCloseToWithOffset`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractDoubleAssertIsCloseToWithOffset {\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert, double n, Offset<Double> offset) {\n        return doubleAssert.isEqualTo(n, offset);\n    }\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert, Double n, Offset<Double> offset) {\n        return doubleAssert.isEqualTo(n, offset);\n    }\n    \n    @AfterTemplate\n    AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert, double n, Offset<Double> offset) {\n        return doubleAssert.isCloseTo(n, offset);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(#{n:any(double)}, #{offset:any(org.assertj.core.data.Offset<java.lang.Double>)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isCloseTo(#{n:any(double)}, #{offset:any(org.assertj.core.data.Offset<java.lang.Double>)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(#{n:any(java.lang.Double)}, #{offset:any(org.assertj.core.data.Offset<java.lang.Double>)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isCloseTo(#{n:any(double)}, #{offset:any(org.assertj.core.data.Offset<java.lang.Double>)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractDoubleAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.data.Offset", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractDoubleAssert isEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractDoubleAssertIsEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJDoubleRules.AbstractDoubleAssertIsEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractDoubleAssertIsEqualTo {\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert, double n) {\n        return Refaster.anyOf(doubleAssert.isCloseTo(n, offset(0.0)), doubleAssert.isCloseTo(n, withPercentage(0.0)));\n    }\n    \n    @AfterTemplate\n    AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert, double n) {\n        return doubleAssert.isEqualTo(n);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isCloseTo(#{n:any(double)}, org.assertj.core.data.Offset.offset(0.0))").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset");
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(#{n:any(double)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isCloseTo(#{n:any(double)}, org.assertj.core.data.Percentage.withPercentage(0.0))").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage");
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(#{n:any(double)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractDoubleAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractDoubleAssert isCloseTo(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.data.Offset offset(..)", true), new UsesMethod("org.assertj.core.data.Percentage withPercentage(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractDoubleAssertIsNotEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJDoubleRules.AbstractDoubleAssertIsNotEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractDoubleAssertIsNotEqualTo {\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert, double n) {\n        return Refaster.anyOf(doubleAssert.isNotCloseTo(n, offset(0.0)), doubleAssert.isNotCloseTo(n, withPercentage(0.0)));\n    }\n    \n    @AfterTemplate\n    AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert, double n) {\n        return doubleAssert.isNotEqualTo(n);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotCloseTo(#{n:any(double)}, org.assertj.core.data.Offset.offset(0.0))").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset");
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotEqualTo(#{n:any(double)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotCloseTo(#{n:any(double)}, org.assertj.core.data.Percentage.withPercentage(0.0))").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage");
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotEqualTo(#{n:any(double)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractDoubleAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractDoubleAssert isNotCloseTo(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.data.Offset offset(..)", true), new UsesMethod("org.assertj.core.data.Percentage withPercentage(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractDoubleAssertIsZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJDoubleRules.AbstractDoubleAssertIsZero`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractDoubleAssertIsZero {\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert) {\n        return doubleAssert.isZero();\n    }\n    \n    @AfterTemplate\n    AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert) {\n        return doubleAssert.isEqualTo(0);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isZero()").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(0)").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractDoubleAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractDoubleAssert isZero(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractDoubleAssertIsNotZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJDoubleRules.AbstractDoubleAssertIsNotZero`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractDoubleAssertIsNotZero {\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert) {\n        return doubleAssert.isNotZero();\n    }\n    \n    @AfterTemplate\n    AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert) {\n        return doubleAssert.isNotEqualTo(0);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotZero()").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotEqualTo(0)").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractDoubleAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractDoubleAssert isNotZero(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractDoubleAssertIsOneRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJDoubleRules.AbstractDoubleAssertIsOne`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractDoubleAssertIsOne {\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert) {\n        return doubleAssert.isOne();\n    }\n    \n    @AfterTemplate\n    AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert) {\n        return doubleAssert.isEqualTo(1);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isOne()").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(1)").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractDoubleAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractDoubleAssert isOne(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

