/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.util.random.RandomGenerator;

final class RandomGeneratorRules {
    private RandomGeneratorRules() {
    }

    static final class RandomGeneratorNextLong {
        RandomGeneratorNextLong() {
        }

        long before(RandomGenerator random, long bound) {
            return (Long)Refaster.anyOf((Object[])new Long[]{(long)random.nextDouble(bound), Math.round(random.nextDouble(bound)), (long)random.nextDouble(bound), Math.round(random.nextDouble(bound))});
        }

        long after(RandomGenerator random, long bound) {
            return random.nextLong(bound);
        }
    }

    static final class RandomGeneratorNextInt {
        RandomGeneratorNextInt() {
        }

        int before(RandomGenerator random, int bound) {
            return (Integer)Refaster.anyOf((Object[])new Integer[]{(int)random.nextDouble(bound), (int)Math.round(random.nextDouble(bound))});
        }

        int after(RandomGenerator random, int bound) {
            return random.nextInt(bound);
        }
    }

    static final class RandomGeneratorNextDouble {
        RandomGeneratorNextDouble() {
        }

        double before(RandomGenerator random, double bound) {
            return (Double)Refaster.anyOf((Object[])new Double[]{random.nextDouble() * bound, bound * random.nextDouble()});
        }

        double after(RandomGenerator random, double bound) {
            return random.nextDouble(bound);
        }
    }
}

