/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.StaticImports;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.refaster.ImportPolicy;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import tech.picnic.errorprone.bugpatterns.NonStaticImport;

@BugPattern(summary="Identifier should be statically imported", link="https://error-prone.picnic.tech/bugpatterns/StaticImport", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Style"})
@AutoService(value={BugChecker.class})
public final class StaticImport
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher {
    private static final long serialVersionUID = 1L;
    @VisibleForTesting
    static final ImmutableSet<String> STATIC_IMPORT_CANDIDATE_TYPES = ImmutableSet.of((Object)BugPattern.LinkType.class.getCanonicalName(), (Object)BugPattern.SeverityLevel.class.getCanonicalName(), (Object)BugPattern.StandardTags.class.getCanonicalName(), (Object)Collections.class.getCanonicalName(), (Object)Collectors.class.getCanonicalName(), (Object)Comparator.class.getCanonicalName(), (Object[])new String[]{ImportPolicy.class.getCanonicalName(), Map.Entry.class.getCanonicalName(), Matchers.class.getCanonicalName(), MoreCollectors.class.getCanonicalName(), Pattern.class.getCanonicalName(), Preconditions.class.getCanonicalName(), Predicates.class.getCanonicalName(), StandardCharsets.class.getCanonicalName(), TypePredicates.class.getCanonicalName(), Verify.class.getCanonicalName(), "com.fasterxml.jackson.annotation.JsonCreator.Mode", "com.fasterxml.jackson.annotation.JsonFormat.Shape", "com.fasterxml.jackson.annotation.JsonInclude.Include", "com.fasterxml.jackson.annotation.JsonProperty.Access", "com.mongodb.client.model.Accumulators", "com.mongodb.client.model.Aggregates", "com.mongodb.client.model.Filters", "com.mongodb.client.model.Indexes", "com.mongodb.client.model.Projections", "com.mongodb.client.model.Sorts", "com.mongodb.client.model.Updates", "org.assertj.core.api.Assertions", "org.assertj.core.api.InstanceOfAssertFactories", "org.assertj.core.api.SoftAssertions", "org.assertj.core.data.Offset", "org.assertj.core.groups.Tuple", "org.hamcrest.Matchers", "org.hamcrest.text.MatchesPattern", "org.hibernate.validator.testutil.ConstraintViolationAssert", "org.junit.jupiter.api.Assertions", "org.mockito.AdditionalAnswers", "org.mockito.Answers", "org.mockito.ArgumentMatchers", "org.mockito.Mockito", "org.springframework.boot.test.context.SpringBootTest.WebEnvironment", "org.springframework.format.annotation.DateTimeFormat.ISO", "org.springframework.http.HttpHeaders", "org.springframework.http.HttpMethod", "org.springframework.http.MediaType", "org.testng.Assert", "reactor.function.TupleUtils", "tech.picnic.errorprone.utils.MoreTypes"});
    static final ImmutableSetMultimap<String, String> STATIC_IMPORT_CANDIDATE_MEMBERS = ImmutableSetMultimap.builder().putAll((Object)Comparators.class.getCanonicalName(), (Object[])new String[]{"emptiesFirst", "emptiesLast"}).put((Object)Function.class.getCanonicalName(), (Object)"identity").put((Object)Functions.class.getCanonicalName(), (Object)"identity").put((Object)ImmutableList.class.getCanonicalName(), (Object)"toImmutableList").putAll((Object)ImmutableListMultimap.class.getCanonicalName(), (Object[])new String[]{"flatteningToImmutableListMultimap", "toImmutableListMultimap"}).put((Object)ImmutableMap.class.getCanonicalName(), (Object)"toImmutableMap").put((Object)ImmutableMultiset.class.getCanonicalName(), (Object)"toImmutableMultiset").put((Object)ImmutableRangeSet.class.getCanonicalName(), (Object)"toImmutableRangeSet").put((Object)ImmutableSet.class.getCanonicalName(), (Object)"toImmutableSet").putAll((Object)ImmutableSetMultimap.class.getCanonicalName(), (Object[])new String[]{"flatteningToImmutableSetMultimap", "toImmutableSetMultimap"}).put((Object)ImmutableSortedMap.class.getCanonicalName(), (Object)"toImmutableSortedMap").put((Object)ImmutableSortedMultiset.class.getCanonicalName(), (Object)"toImmutableSortedMultiset").put((Object)ImmutableSortedSet.class.getCanonicalName(), (Object)"toImmutableSortedSet").put((Object)ImmutableTable.class.getCanonicalName(), (Object)"toImmutableTable").putAll((Object)Objects.class.getCanonicalName(), (Object[])new String[]{"checkIndex", "checkFromIndexSize", "checkFromToIndex", "requireNonNull", "requireNonNullElse", "requireNonNullElseGet"}).put((Object)Predicate.class.getCanonicalName(), (Object)"not").put((Object)Sets.class.getCanonicalName(), (Object)"toImmutableEnumSet").put((Object)UUID.class.getCanonicalName(), (Object)"randomUUID").put((Object)ZoneOffset.class.getCanonicalName(), (Object)"UTC").put((Object)"org.junit.jupiter.params.provider.Arguments", (Object)"arguments").build();

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        if (!StaticImport.isCandidateContext(state) || !StaticImport.isCandidate(tree)) {
            return Description.NO_MATCH;
        }
        StaticImports.StaticImportInfo importInfo = StaticImports.tryCreate((MemberSelectTree)tree, (VisitorState)state);
        if (importInfo == null) {
            return Description.NO_MATCH;
        }
        return StaticImport.getCandidateSimpleName(importInfo).flatMap(n -> StaticImport.tryStaticImport(tree, importInfo.canonicalName() + "." + n, n, state)).map(fix -> this.describeMatch(tree, (Fix)fix)).orElse(Description.NO_MATCH);
    }

    private static boolean isCandidateContext(VisitorState state) {
        boolean bl;
        Tree parentTree = Objects.requireNonNull(state.getPath().getParentPath(), "MemberSelectTree lacks enclosing node").getLeaf();
        if (parentTree instanceof MethodInvocationTree) {
            MethodInvocationTree methodInvocation = (MethodInvocationTree)parentTree;
            bl = methodInvocation.getTypeArguments().isEmpty();
        } else {
            bl = !(parentTree instanceof ImportTree) && !(parentTree instanceof MemberSelectTree);
        }
        return bl;
    }

    private static boolean isCandidate(MemberSelectTree tree) {
        String identifier = tree.getIdentifier().toString();
        if (NonStaticImport.NON_STATIC_IMPORT_CANDIDATE_IDENTIFIERS.contains((Object)identifier)) {
            return false;
        }
        Type type = ASTHelpers.getType((Tree)tree.getExpression());
        return type != null && !NonStaticImport.NON_STATIC_IMPORT_CANDIDATE_MEMBERS.containsEntry((Object)type.toString(), (Object)identifier);
    }

    private static Optional<String> getCandidateSimpleName(StaticImports.StaticImportInfo importInfo) {
        String canonicalName = importInfo.canonicalName();
        return importInfo.simpleName().toJavaUtil().filter(name -> STATIC_IMPORT_CANDIDATE_TYPES.contains((Object)canonicalName) || STATIC_IMPORT_CANDIDATE_MEMBERS.containsEntry((Object)canonicalName, name));
    }

    private static Optional<Fix> tryStaticImport(MemberSelectTree tree, String fullyQualifiedName, String simpleName, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder().replace((Tree)tree, simpleName);
        if (!simpleName.equals(SuggestedFixes.qualifyStaticImport((String)fullyQualifiedName, (SuggestedFix.Builder)fix, (VisitorState)state))) {
            return Optional.empty();
        }
        return Optional.of(fix.build());
    }
}

