/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Visibility;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="Iterable creation can be avoided by using a varargs alternative method", link="https://error-prone.picnic.tech/bugpatterns/ExplicitArgumentEnumeration", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Performance", "Simplification"})
@AutoService(value={BugChecker.class})
public final class ExplicitArgumentEnumeration
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> EXPLICIT_ITERABLE_CREATOR = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClassAny(new String[]{ImmutableList.class.getCanonicalName(), ImmutableMultiset.class.getCanonicalName(), ImmutableSet.class.getCanonicalName(), java.util.List.class.getCanonicalName(), Set.class.getCanonicalName()}).named("of"), Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClassAny(new String[]{ImmutableList.class.getCanonicalName(), ImmutableMultiset.class.getCanonicalName(), ImmutableSet.class.getCanonicalName()}).named("copyOf"), Matchers.symbolMatcher((symbol, state) -> state.getSymtab().arrayClass.equals(((Symbol.MethodSymbol)symbol).params().get((int)0).type.tsym))}), Matchers.staticMethod().onClass(Arrays.class.getCanonicalName()).named("asList")});
    private static final Matcher<ExpressionTree> IMMUTABLE_COLLECTION_BUILDER = Matchers.instanceMethod().onDescendantOf(ImmutableCollection.Builder.class.getCanonicalName());
    private static final Matcher<ExpressionTree> OBJECT_ENUMERABLE_ASSERT = Matchers.instanceMethod().onDescendantOf("org.assertj.core.api.ObjectEnumerableAssert");
    private static final Matcher<ExpressionTree> STEP_VERIFIER_STEP = Matchers.instanceMethod().onDescendantOf("reactor.test.StepVerifier.Step");
    private static final ImmutableTable<Matcher<ExpressionTree>, String, String> ALTERNATIVE_METHODS = ImmutableTable.builder().put(IMMUTABLE_COLLECTION_BUILDER, (Object)"addAll", (Object)"add").put(OBJECT_ENUMERABLE_ASSERT, (Object)"containsAnyElementsOf", (Object)"containsAnyOf").put(OBJECT_ENUMERABLE_ASSERT, (Object)"containsAll", (Object)"contains").put(OBJECT_ENUMERABLE_ASSERT, (Object)"containsExactlyElementsOf", (Object)"containsExactly").put(OBJECT_ENUMERABLE_ASSERT, (Object)"containsExactlyInAnyOrderElementsOf", (Object)"containsExactlyInAnyOrder").put(OBJECT_ENUMERABLE_ASSERT, (Object)"containsOnlyElementsOf", (Object)"containsOnly").put(OBJECT_ENUMERABLE_ASSERT, (Object)"containsOnlyOnceElementsOf", (Object)"containsOnlyOnce").put(OBJECT_ENUMERABLE_ASSERT, (Object)"doesNotContainAnyElementsOf", (Object)"doesNotContain").put(OBJECT_ENUMERABLE_ASSERT, (Object)"hasSameElementsAs", (Object)"containsOnly").put(STEP_VERIFIER_STEP, (Object)"expectNextSequence", (Object)"expectNext").buildOrThrow();

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (tree.getArguments().size() != 1) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (!ExplicitArgumentEnumeration.isUnaryIterableAcceptingMethod(method, state) || ExplicitArgumentEnumeration.isLocalOverload(method, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree argument = tree.getArguments().get(0);
        if (!EXPLICIT_ITERABLE_CREATOR.matches((Tree)argument, state)) {
            return Description.NO_MATCH;
        }
        return ExplicitArgumentEnumeration.trySuggestCallingVarargsOverload(method, (MethodInvocationTree)argument, state).or(() -> ExplicitArgumentEnumeration.trySuggestCallingCustomAlternative(tree, (MethodInvocationTree)argument, state)).map(fix -> this.describeMatch(tree, (Fix)fix)).orElse(Description.NO_MATCH);
    }

    private static boolean isUnaryIterableAcceptingMethod(Symbol.MethodSymbol method, VisitorState state) {
        List<Symbol.VarSymbol> params = method.params();
        return !method.isVarArgs() && params.size() == 1 && ASTHelpers.isSubtype((Type)((Symbol.VarSymbol)params.get((int)0)).type, (Type)state.getSymtab().iterableType, (VisitorState)state);
    }

    private static boolean isLocalOverload(Symbol.MethodSymbol calledMethod, VisitorState state) {
        MethodTree enclosingMethod = (MethodTree)state.findEnclosing(new Class[]{MethodTree.class});
        if (enclosingMethod == null) {
            return false;
        }
        Symbol.MethodSymbol callingMethod = ASTHelpers.getSymbol((MethodTree)enclosingMethod);
        return Objects.equals(callingMethod.getEnclosingElement(), calledMethod.getEnclosingElement()) && ((Object)callingMethod.getSimpleName()).equals(calledMethod.getSimpleName());
    }

    private static Optional<SuggestedFix> trySuggestCallingVarargsOverload(Symbol.MethodSymbol method, MethodInvocationTree argument, VisitorState state) {
        ImmutableList overloads = (ImmutableList)ASTHelpers.matchingMethods((Name)method.getSimpleName(), m -> ExplicitArgumentEnumeration.isAtLeastAsVisible(m, method), (Type)method.enclClass().type, (Types)state.getTypes()).collect(ImmutableList.toImmutableList());
        return ExplicitArgumentEnumeration.hasLikelySuitableVarargsOverload(method, (ImmutableList<Symbol.MethodSymbol>)overloads, state) ? Optional.of(SourceCode.unwrapMethodInvocation((MethodInvocationTree)argument, (VisitorState)state)) : Optional.empty();
    }

    private static boolean hasLikelySuitableVarargsOverload(Symbol.MethodSymbol method, ImmutableList<Symbol.MethodSymbol> overloads, VisitorState state) {
        Types types = state.getTypes();
        Type parameterType = (Type)Iterables.getOnlyElement(((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)method.getParameters())).type.getTypeArguments());
        return overloads.stream().allMatch(m -> m.params().size() == 1) && overloads.stream().filter(Symbol.MethodSymbol::isVarArgs).map(m -> types.elemtype(((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)m.getParameters())).type)).anyMatch(varArgsType -> types.containsType(parameterType, (Type)varArgsType));
    }

    private static Optional<SuggestedFix> trySuggestCallingCustomAlternative(MethodInvocationTree tree, MethodInvocationTree argument, VisitorState state) {
        return ALTERNATIVE_METHODS.rowMap().entrySet().stream().filter(e -> ((Matcher)e.getKey()).matches((Tree)tree, state)).findFirst().flatMap(e -> ExplicitArgumentEnumeration.trySuggestCallingCustomAlternative(tree, argument, state, (Map)e.getValue()));
    }

    private static Optional<SuggestedFix> trySuggestCallingCustomAlternative(MethodInvocationTree tree, MethodInvocationTree argument, VisitorState state, Map<String, String> alternatives) {
        return Optional.ofNullable(alternatives.get(((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).toString())).map(replacement -> SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)replacement, (VisitorState)state).toBuilder().merge(SourceCode.unwrapMethodInvocation((MethodInvocationTree)argument, (VisitorState)state)).build());
    }

    private static boolean isAtLeastAsVisible(Element symbol, Element reference) {
        return Visibility.fromModifiers(symbol.getModifiers()).compareTo((Enum)Visibility.fromModifiers(reference.getModifiers())) >= 0;
    }
}

