/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class ReactorRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ReactorRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to Reactor expressions and statements.\n[Source](https://error-prone.picnic.tech/refasterrules/ReactorRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new MonoEmptyRecipe(), new MonoJustRecipe(), new MonoJustOrEmptyObjectRecipe(), new MonoJustOrEmptyOptionalRecipe(), new MonoDeferMonoJustOrEmptyRecipe(), new OptionalMapMonoJustRecipe(), new MonoFromOptionalSwitchIfEmptyRecipe(), new MonoZipRecipe(), new MonoZipWithCombinatorRecipe(), new FluxZipRecipe(), new FluxZipWithCombinatorRecipe(), new FluxZipWithIterableRecipe(), new FluxZipWithIterableBiFunctionRecipe(), new FluxZipWithIterableMapFunctionRecipe(), new MonoDeferredErrorRecipe(), new FluxDeferredErrorRecipe(), new MonoErrorSupplierRecipe(), new FluxErrorSupplierRecipe(), new MonoThenReturnRecipe(), new FluxTakeRecipe(), new MonoDefaultIfEmptyRecipe(), new FluxDefaultIfEmptyRecipe(), new FluxEmptyRecipe(), new FluxJustRecipe(), new MonoIdentityRecipe(), new MonoSingleRecipe(), new FluxSwitchIfEmptyOfEmptyPublisherRecipe(), new MonoFlatMapIterableIdentityRecipe(), new FluxMapNotNullOrElseRecipe(), new MonoFluxRecipe(), new MonoThenRecipe(), new FluxThenRecipe(), new MonoThenEmptyRecipe(), new FluxThenEmptyRecipe(), new MonoThenManyRecipe(), new MonoThenMonoFluxRecipe(), new FluxThenManyRecipe(), new MonoThenMonoRecipe(), new FluxThenMonoRecipe(), new MonoSingleOptionalRecipe(), new MonoOfTypeRecipe(), new FluxOfTypeRecipe(), new ConcatMapIterableIdentityRecipe(), new ConcatMapIterableIdentityWithPrefetchRecipe(), new FluxFromIterableRecipe(), new MonoDoOnErrorRecipe(), new FluxDoOnErrorRecipe(), new MonoOnErrorCompleteRecipe(), new FluxOnErrorCompleteRecipe(), new MonoOnErrorCompleteClassRecipe(), new MonoOnErrorCompletePredicateRecipe(), new FluxOnErrorCompletePredicateRecipe(), new MonoOnErrorContinueRecipe(), new FluxOnErrorContinueRecipe(), new MonoOnErrorMapRecipe(), new FluxOnErrorMapRecipe(), new MonoOnErrorResumeRecipe(), new FluxOnErrorResumeRecipe(), new MonoOnErrorReturnRecipe(), new FluxOnErrorReturnRecipe(), new FluxFilterSortRecipe(), new FluxFilterSortWithComparatorRecipe(), new FluxTakeWhileRecipe(), new FluxCollectToImmutableListRecipe(), new FluxCollectToImmutableSetRecipe(), new FluxSortRecipe(), new FluxTransformMinRecipe(), new FluxTransformMinWithComparatorRecipe(), new FluxTransformMaxRecipe(), new FluxTransformMaxWithComparatorRecipe(), new MathFluxMinRecipe(), new MathFluxMaxRecipe(), new PublisherProbeEmptyRecipe(), new PublisherProbeAssertWasSubscribedRecipe(), new PublisherProbeAssertWasNotSubscribedRecipe(), new PublisherProbeAssertWasCancelledRecipe(), new PublisherProbeAssertWasNotCancelledRecipe(), new PublisherProbeAssertWasRequestedRecipe(), new PublisherProbeAssertWasNotRequestedRecipe(), new StepVerifierFromMonoRecipe(), new StepVerifierFromFluxRecipe(), new StepVerifierVerifyRecipe(), new StepVerifierVerifyDurationRecipe(), new StepVerifierVerifyLaterRecipe(), new StepVerifierStepExpectNextRecipe(), new FluxAsStepVerifierExpectNextRecipe(), new StepVerifierLastStepVerifyCompleteRecipe(), new StepVerifierLastStepVerifyErrorRecipe(), new StepVerifierLastStepVerifyErrorClassRecipe(), new StepVerifierLastStepVerifyErrorMatchesRecipe(), new StepVerifierLastStepVerifyErrorSatisfiesRecipe(), new StepVerifierLastStepVerifyErrorSatisfiesAssertJRecipe(), new StepVerifierLastStepVerifyErrorMessageRecipe(), new StepVerifierLastStepVerifyTimeoutRecipe(), new MonoFromFutureSupplierRecipe(), new MonoFromFutureSupplierBooleanRecipe(), new MonoFromFutureAsyncLoadingCacheGetRecipe(), new MonoFromFutureAsyncLoadingCacheGetAllRecipe(), new FluxFromStreamSupplierRecipe()});
    }

    @NullMarked
    public static class MonoEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoEmpty`";
        }

        public String getDescription() {
            return "Prefer `Mono#empty()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"reactor.core.publisher.Mono.justOrEmpty(null)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"reactor.core.publisher.Mono.justOrEmpty(java.util.Optional.empty())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Mono.empty()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Optional");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono justOrEmpty(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoJustRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoJust`";
        }

        public String getDescription() {
            return "Prefer `Mono#just(Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"reactor.core.publisher.Mono.justOrEmpty(java.util.Optional.of(#{value:any(T)}))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Mono.just(#{value:any(T)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Optional");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("java.util.Optional of(..)", true), new UsesMethod("reactor.core.publisher.Mono justOrEmpty(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoJustOrEmptyObjectRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoJustOrEmptyObject`";
        }

        public String getDescription() {
            return "Prefer `Mono#justOrEmpty(Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"reactor.core.publisher.Mono.justOrEmpty(java.util.Optional.ofNullable(#{value:any(T)}))").genericTypes(new String[]{"T extends java.lang.Object"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Mono.justOrEmpty(#{value:any(T)})").genericTypes(new String[]{"T extends java.lang.Object"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Optional");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("java.util.Optional ofNullable(..)", true), new UsesMethod("reactor.core.publisher.Mono justOrEmpty(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoJustOrEmptyOptionalRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoJustOrEmptyOptional`";
        }

        public String getDescription() {
            return "Prefer `Mono#justOrEmpty(Optional)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"reactor.core.publisher.Mono.just(#{optional:any(java.util.Optional<T>)}).filter(java.util.Optional::isPresent).map(java.util.Optional::orElseThrow)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Mono.justOrEmpty(#{optional:any(java.util.Optional<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono filter(..)", true), new UsesMethod("reactor.core.publisher.Mono just(..)", true), new UsesMethod("reactor.core.publisher.Mono map(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoDeferMonoJustOrEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoDeferMonoJustOrEmpty`";
        }

        public String getDescription() {
            return "Prefer `Mono#defer(Supplier) deferring` `Mono#justOrEmpty(Optional)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"reactor.core.publisher.Mono.fromCallable(()->#{optional:any(java.util.Optional<T>)}.orElse(null))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"reactor.core.publisher.Mono.fromSupplier(()->#{optional:any(java.util.Optional<T>)}.orElse(null))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Mono.defer(()->reactor.core.publisher.Mono.justOrEmpty(#{optional:any(java.util.Optional<T>)}))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("java.util.Optional orElse(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Mono fromCallable(..)", true), new UsesMethod("reactor.core.publisher.Mono fromSupplier(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OptionalMapMonoJustRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.OptionalMapMonoJust`";
        }

        public String getDescription() {
            return "Try to avoid expressions of type `Optional<Mono<T>>`, but if you must map an `Optional` to this type, prefer using `Mono#just(Object)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.map(reactor.core.publisher.Mono::justOrEmpty)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.map(reactor.core.publisher.Mono::just)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("java.util.Optional map(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoFromOptionalSwitchIfEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer a `Mono#justOrEmpty(Optional)` and `Mono#switchIfEmpty(Mono)` chain over more contrived alternatives";
        }

        public String getDescription() {
            return "In particular, avoid mixing of the `Optional` and `Mono` APIs.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<T>)}.map(reactor.core.publisher.Mono::just).orElse(#{mono:any(reactor.core.publisher.Mono<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Mono.justOrEmpty(#{optional:any(java.util.Optional<T>)}).switchIfEmpty(#{mono:any(reactor.core.publisher.Mono<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("java.util.Optional map(..)", true), new UsesMethod("java.util.Optional orElse(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoZipRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoZip`";
        }

        public String getDescription() {
            return "Prefer `Mono#zip(Mono, Mono)` over a chained `Mono#zipWith(Mono)`, as the former better conveys that the `Mono`s may be subscribed to concurrently, and generalizes to combining three or more reactive streams.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.zipWith(#{other:any(reactor.core.publisher.Mono<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Mono.zip(#{mono:any(reactor.core.publisher.Mono<T>)}, #{other:any(reactor.core.publisher.Mono<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesType("reactor.util.function.Tuple2", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono zipWith(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoZipWithCombinatorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoZipWithCombinator`";
        }

        public String getDescription() {
            return "Prefer `Mono#zip(Mono, Mono)` with a chained combinator over a chained `Mono#zipWith(Mono, BiFunction)`, as the former better conveys that the `Mono`s may be subscribed to concurrently, and generalizes to combining three or more reactive streams.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.zipWith(#{other:any(reactor.core.publisher.Mono<S>)}, #{combinator:any(java.util.function.BiFunction<T, S, R>)})").genericTypes(new String[]{"T", "S", "R"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Mono.zip(#{mono:any(reactor.core.publisher.Mono<T>)}, #{other:any(reactor.core.publisher.Mono<S>)}).map(reactor.function.TupleUtils.function(#{combinator:any(java.util.function.BiFunction<T, S, R>)}))").genericTypes(new String[]{"T", "S", "R"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.BiFunction", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono zipWith(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxZipRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxZip`";
        }

        public String getDescription() {
            return "Prefer `Flux#zip(Publisher, Publisher)` over a chained `Flux#zipWith(Publisher)`, as the former better conveys that the `Publisher`s may be subscribed to concurrently, and generalizes to combining three or more reactive streams.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.zipWith(#{other:any(org.reactivestreams.Publisher<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Flux.zip(#{flux:any(reactor.core.publisher.Flux<T>)}, #{other:any(org.reactivestreams.Publisher<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.reactivestreams.Publisher", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.util.function.Tuple2", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux zipWith(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxZipWithCombinatorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxZipWithCombinator`";
        }

        public String getDescription() {
            return "Prefer `Flux#zip(Publisher, Publisher)` with a chained combinator over a chained `Flux#zipWith(Publisher, BiFunction)`, as the former better conveys that the `Publisher`s may be subscribed to concurrently, and generalizes to combining three or more reactive streams.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.zipWith(#{other:any(org.reactivestreams.Publisher<S>)}, #{combinator:any(java.util.function.BiFunction<T, S, R>)})").genericTypes(new String[]{"T", "S", "R"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Flux.zip(#{flux:any(reactor.core.publisher.Flux<T>)}, #{other:any(org.reactivestreams.Publisher<S>)}).map(reactor.function.TupleUtils.function(#{combinator:any(java.util.function.BiFunction<T, S, R>)}))").genericTypes(new String[]{"T", "S", "R"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.BiFunction", Boolean.valueOf(true)), new UsesType("org.reactivestreams.Publisher", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux zipWith(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxZipWithIterableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxZipWithIterable`";
        }

        public String getDescription() {
            return "Prefer `Flux#zipWithIterable(Iterable)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"reactor.core.publisher.Flux.zip(#{flux:any(reactor.core.publisher.Flux<T>)}, reactor.core.publisher.Flux.fromIterable(#{iterable:any(java.lang.Iterable<S>)}))").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.zipWithIterable(#{iterable:any(java.lang.Iterable<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.util.function.Tuple2", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux fromIterable(..)", true), new UsesMethod("reactor.core.publisher.Flux zip(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxZipWithIterableBiFunctionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxZipWithIterableBiFunction`";
        }

        public String getDescription() {
            return "Prefer `Flux#zipWithIterable(Iterable, BiFunction)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.zipWith(reactor.core.publisher.Flux.fromIterable(#{iterable:any(java.lang.Iterable<S>)}), #{function:any(java.util.function.BiFunction<? super T, ? super S, ? extends R>)})").genericTypes(new String[]{"T", "S", "R"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.zipWithIterable(#{iterable:any(java.lang.Iterable<S>)}, #{function:any(java.util.function.BiFunction<? super T, ? super S, ? extends R>)})").genericTypes(new String[]{"T", "S", "R"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.BiFunction", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux fromIterable(..)", true), new UsesMethod("reactor.core.publisher.Flux zipWith(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxZipWithIterableMapFunctionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxZipWithIterableMapFunction`";
        }

        public String getDescription() {
            return "Prefer `Flux#zipWithIterable(Iterable)` with a chained combinator over `Flux#zipWithIterable(Iterable, BiFunction)`, as the former generally yields more readable code.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.zipWithIterable(#{iterable:any(java.lang.Iterable<S>)}, #{combinator:any(java.util.function.BiFunction<T, S, R>)})").genericTypes(new String[]{"T", "S", "R"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.zipWithIterable(#{iterable:any(java.lang.Iterable<S>)}).map(reactor.function.TupleUtils.function(#{combinator:any(java.util.function.BiFunction<T, S, R>)}))").genericTypes(new String[]{"T", "S", "R"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.BiFunction", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux zipWithIterable(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoDeferredErrorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoDeferredError`";
        }

        public String getDescription() {
            return "Don't unnecessarily defer `Mono#error(Throwable)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"reactor.core.publisher.Mono.defer(()->reactor.core.publisher.Mono.error(#{throwable:any(java.lang.Throwable)}))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Mono.error(()->#{throwable:any(java.lang.Throwable)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono defer(..)", true), new UsesMethod("reactor.core.publisher.Mono error(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxDeferredErrorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxDeferredError`";
        }

        public String getDescription() {
            return "Don't unnecessarily defer `Flux#error(Throwable)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"reactor.core.publisher.Flux.defer(()->reactor.core.publisher.Flux.error(#{throwable:any(java.lang.Throwable)}))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Flux.error(()->#{throwable:any(java.lang.Throwable)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux defer(..)", true), new UsesMethod("reactor.core.publisher.Flux error(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoErrorSupplierRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoErrorSupplier`";
        }

        public String getDescription() {
            return "Don't unnecessarily pass `Mono#error(Supplier)` a method reference or lambda expression.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"reactor.core.publisher.Mono.error(()->#{supplier:any(java.util.function.Supplier<E>)}.get())").genericTypes(new String[]{"T", "E extends java.lang.Throwable"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Mono.error(#{supplier:any(java.util.function.Supplier<E>)})").genericTypes(new String[]{"T", "E extends java.lang.Throwable"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("java.util.function.Supplier get(..)", true), new UsesMethod("reactor.core.publisher.Mono error(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxErrorSupplierRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxErrorSupplier`";
        }

        public String getDescription() {
            return "Don't unnecessarily pass `Flux#error(Supplier)` a method reference or lambda expression.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"reactor.core.publisher.Flux.error(()->#{supplier:any(java.util.function.Supplier<E>)}.get())").genericTypes(new String[]{"T", "E extends java.lang.Throwable"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Flux.error(#{supplier:any(java.util.function.Supplier<E>)})").genericTypes(new String[]{"T", "E extends java.lang.Throwable"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("java.util.function.Supplier get(..)", true), new UsesMethod("reactor.core.publisher.Flux error(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoThenReturnRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoThenReturn`";
        }

        public String getDescription() {
            return "Prefer `Mono#thenReturn(Object)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.ignoreElement().thenReturn(#{object:any(S)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.then().thenReturn(#{object:any(S)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.then(reactor.core.publisher.Mono.just(#{object:any(S)}))").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.thenReturn(#{object:any(S)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Mono ignoreElement(..)", true), new UsesMethod("reactor.core.publisher.Mono thenReturn(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Mono just(..)", true), new UsesMethod("reactor.core.publisher.Mono then(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Mono then(..)", true), new UsesMethod("reactor.core.publisher.Mono thenReturn(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxTakeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Flux#take(long)` over `Flux#take(long, boolean)` where relevant";
        }

        public String getDescription() {
            return "In Reactor versions prior to 3.5.0, `Flux#take(long)` makes an unbounded request\n upstream, and is equivalent to `Flux#take(long, false)`. From version 3.5.0 onwards, the\n behavior of `Flux#take(long)` instead matches `Flux#take(long, true)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.take(#{n:any(long)}, true)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.take(#{n:any(long)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux take(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoDefaultIfEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoDefaultIfEmpty`";
        }

        public String getDescription() {
            return "Prefer `Mono#defaultIfEmpty(Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.switchIfEmpty(reactor.core.publisher.Mono.just(#{object:any(T)}))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.defaultIfEmpty(#{object:any(T)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono just(..)", true), new UsesMethod("reactor.core.publisher.Mono switchIfEmpty(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxDefaultIfEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxDefaultIfEmpty`";
        }

        public String getDescription() {
            return "Prefer `Flux#defaultIfEmpty(Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.switchIfEmpty(reactor.core.publisher.Mono.just(#{object:any(T)}))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.switchIfEmpty(reactor.core.publisher.Flux.just(#{object:any(T)}))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.defaultIfEmpty(#{object:any(T)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("reactor.core.publisher.Mono");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux switchIfEmpty(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux just(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono just(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxEmpty`";
        }

        public String getDescription() {
            return "Prefer `Flux#empty()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.zip(#{combinator:any(java.util.function.Function<? super java.lang.Object[], ? extends T>)})").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.zip(#{combinator:any(java.util.function.Function<? super java.lang.Object[], ? extends T>)}, #{prefetch:any(int)})").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.concat()").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$3 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.concatDelayError()").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$4 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.firstWithSignal()").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$5 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.just()").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$6 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.merge()").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$7 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.merge(#{prefetch:any(int)})").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$8 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.mergeComparing(#{comparator:any(java.util.Comparator<? super T>)})").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$9 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.mergeComparing(#{prefetch:any(int)}, #{comparator:any(java.util.Comparator<? super T>)})").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$10 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.mergeComparingDelayError(#{prefetch:any(int)}, #{comparator:any(java.util.Comparator<? super T>)})").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$11 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.mergeDelayError(#{prefetch:any(int)})").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$12 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.mergePriority(#{comparator:any(java.util.Comparator<? super T>)})").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$13 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.mergePriority(#{prefetch:any(int)}, #{comparator:any(java.util.Comparator<? super T>)})").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$14 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.mergePriorityDelayError(#{prefetch:any(int)}, #{comparator:any(java.util.Comparator<? super T>)})").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$15 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.mergeSequential()").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$16 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.mergeSequential(#{prefetch:any(int)})").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$17 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.mergeSequentialDelayError(#{prefetch:any(int)})").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$0 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.combineLatest(#{combinator:any(java.util.function.Function<java.lang.Object[], T>)})").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$1 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.combineLatest(#{combinator:any(java.util.function.Function<java.lang.Object[], T>)}, #{prefetch:any(int)})").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before1$0 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.mergeComparing()").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before1$1 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.mergePriority()").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.range(#{start:any(int)}, 0)").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Flux.empty()").genericTypes(new String[]{"T", "S extends java.lang.Comparable<? super S>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$4.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$5.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$6.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$7.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$8.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$9.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$10.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$11.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$12.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$13.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$14.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$15.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$16.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$17.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Function");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux mergeComparing(..)", true), new UsesMethod("reactor.core.publisher.Flux mergePriority(..)", true), new UsesMethod("reactor.core.publisher.Flux range(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux concat(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux concatDelayError(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux firstWithSignal(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux just(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux merge(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux mergeComparing(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux mergeComparingDelayError(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux mergeDelayError(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux mergePriority(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux mergePriorityDelayError(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux mergeSequential(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux mergeSequentialDelayError(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux zip(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux combineLatest(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxJustRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxJust`";
        }

        public String getDescription() {
            return "Prefer `Flux#just(Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"reactor.core.publisher.Flux.range(#{value:any(int)}, 1)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$0 = JavaTemplate.builder((String)"reactor.core.publisher.Mono.just(#{value:any(T)}).flux()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$1 = JavaTemplate.builder((String)"reactor.core.publisher.Mono.just(#{value:any(T)}).repeat().take(1)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$2 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.fromIterable(com.google.common.collect.ImmutableList.of(#{value:any(T)}))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$3 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.fromIterable(com.google.common.collect.ImmutableSet.of(#{value:any(T)}))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Flux.just(#{value:any(T)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("reactor.core.publisher.Mono");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("reactor.core.publisher.Mono");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableList");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux range(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableList", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableList of(..)", true), new UsesMethod("reactor.core.publisher.Flux fromIterable(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet of(..)", true), new UsesMethod("reactor.core.publisher.Flux fromIterable(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux take(..)", true), new UsesMethod("reactor.core.publisher.Mono just(..)", true), new UsesMethod("reactor.core.publisher.Mono repeat(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono flux(..)", true), new UsesMethod("reactor.core.publisher.Mono just(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoIdentityRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoIdentity`";
        }

        public String getDescription() {
            return "Don't unnecessarily transform a `Mono` to an equivalent instance.";
        }

        public Set<String> getTags() {
            return new HashSet<String>(Arrays.asList("RSPEC-S2637", "RSPEC-S4968"));
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.switchIfEmpty(reactor.core.publisher.Mono.empty())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.flux().next()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.flux().singleOrEmpty()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2$0 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<java.lang.Void>)}.ignoreElement()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2$1 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<java.lang.Void>)}.then()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before3 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<com.google.common.collect.ImmutableList<T>>)}.map(com.google.common.collect.ImmutableList::copyOf)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableList");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Mono ignoreElement(..)", true), new UsesMethod("reactor.core.publisher.Mono then(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux next(..)", true), new UsesMethod("reactor.core.publisher.Mono flux(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux singleOrEmpty(..)", true), new UsesMethod("reactor.core.publisher.Mono flux(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Mono empty(..)", true), new UsesMethod("reactor.core.publisher.Mono switchIfEmpty(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableList", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono map(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoSingleRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoSingle`";
        }

        public String getDescription() {
            return "Don't unnecessarily transform a `Mono` to a `Flux` to expect exactly one item.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.flux().single()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.single()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux single(..)", true), new UsesMethod("reactor.core.publisher.Mono flux(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxSwitchIfEmptyOfEmptyPublisherRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxSwitchIfEmptyOfEmptyPublisher`";
        }

        public String getDescription() {
            return "Don't unnecessarily pass an empty publisher to `Flux#switchIfEmpty(Publisher)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.switchIfEmpty(reactor.core.publisher.Mono.empty())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.switchIfEmpty(reactor.core.publisher.Flux.empty())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("reactor.core.publisher.Mono");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux switchIfEmpty(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux empty(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono empty(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoFlatMapIterableIdentityRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoFlatMapIterableIdentity`";
        }

        public String getDescription() {
            return "Prefer `Mono#flatMapIterable(Function)` to flatten a `Mono` of some `Iterable` over less efficient alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<S>)}.flatMapMany(reactor.core.publisher.Flux::fromIterable)").genericTypes(new String[]{"T", "S extends java.lang.Iterable<T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<S>)}.flatMapIterable(java.util.function.Function.identity())").genericTypes(new String[]{"T", "S extends java.lang.Iterable<T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono flatMapMany(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxMapNotNullOrElseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxMapNotNullOrElse`";
        }

        public String getDescription() {
            return "Prefer `Flux#mapNotNull(Function)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<java.util.Optional<T>>)}.filter(java.util.Optional::isPresent).map(java.util.Optional::orElseThrow)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<java.util.Optional<T>>)}.mapNotNull((x)->x.orElse(null))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux filter(..)", true), new UsesMethod("reactor.core.publisher.Flux map(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoFluxRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoFlux`";
        }

        public String getDescription() {
            return "Prefer `Mono#flux()`} over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.flatMapMany(reactor.core.publisher.Mono::just)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.flatMapMany(reactor.core.publisher.Flux::just)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.concat(#{mono:any(reactor.core.publisher.Mono<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.flux()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux concat(..)", true), new UsesMethod("reactor.core.publisher.Mono flatMapMany(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoThenRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoThen`";
        }

        public String getDescription() {
            return "Prefer direct invocation of `Mono#then()`} over more contrived alternatives.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4968");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.ignoreElement().then()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.flux().then()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"reactor.core.publisher.Mono.when(#{mono:any(reactor.core.publisher.Mono<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$3 = JavaTemplate.builder((String)"reactor.core.publisher.Mono.whenDelayError(#{mono:any(reactor.core.publisher.Mono<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.then()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Mono when(..)", true), new UsesMethod("reactor.core.publisher.Mono whenDelayError(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux then(..)", true), new UsesMethod("reactor.core.publisher.Mono flux(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Mono ignoreElement(..)", true), new UsesMethod("reactor.core.publisher.Mono then(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxThenRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxThen`";
        }

        public String getDescription() {
            return "Avoid vacuous invocations of `Flux#ignoreElements()`.";
        }

        public Set<String> getTags() {
            return new HashSet<String>(Arrays.asList("RSPEC-S4968", "RSPEC-S2637"));
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.ignoreElements().then()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<java.lang.Void>)}.ignoreElements()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.then()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux ignoreElements(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoThenEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoThenEmpty`";
        }

        public String getDescription() {
            return "Avoid vacuous invocations of `Mono#ignoreElement()`.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4968");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.ignoreElement().thenEmpty(#{publisher:any(org.reactivestreams.Publisher<java.lang.Void>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.thenEmpty(#{publisher:any(org.reactivestreams.Publisher<java.lang.Void>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.reactivestreams.Publisher", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono ignoreElement(..)", true), new UsesMethod("reactor.core.publisher.Mono thenEmpty(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxThenEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxThenEmpty`";
        }

        public String getDescription() {
            return "Avoid vacuous invocations of `Flux#ignoreElements()`.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4968");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.ignoreElements().thenEmpty(#{publisher:any(org.reactivestreams.Publisher<java.lang.Void>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.thenEmpty(#{publisher:any(org.reactivestreams.Publisher<java.lang.Void>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.reactivestreams.Publisher", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux ignoreElements(..)", true), new UsesMethod("reactor.core.publisher.Mono thenEmpty(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoThenManyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoThenMany`";
        }

        public String getDescription() {
            return "Avoid vacuous operations prior to invocation of `Mono#thenMany(Publisher)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.ignoreElement().thenMany(#{publisher:any(org.reactivestreams.Publisher<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.flux().thenMany(#{publisher:any(org.reactivestreams.Publisher<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.thenMany(#{publisher:any(org.reactivestreams.Publisher<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.reactivestreams.Publisher", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux thenMany(..)", true), new UsesMethod("reactor.core.publisher.Mono flux(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Mono ignoreElement(..)", true), new UsesMethod("reactor.core.publisher.Mono thenMany(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoThenMonoFluxRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoThenMonoFlux`";
        }

        public String getDescription() {
            return "Prefer explicit invocation of `Mono#flux()` over implicit conversions from `Mono` to `Flux`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{mono1:any(reactor.core.publisher.Mono<T>)}.thenMany(#{mono2:any(reactor.core.publisher.Mono<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono1:any(reactor.core.publisher.Mono<T>)}.then(#{mono2:any(reactor.core.publisher.Mono<S>)}).flux()").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono thenMany(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxThenManyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxThenMany`";
        }

        public String getDescription() {
            return "Avoid vacuous invocations of `Flux#ignoreElements()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.ignoreElements().thenMany(#{publisher:any(org.reactivestreams.Publisher<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.thenMany(#{publisher:any(org.reactivestreams.Publisher<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.reactivestreams.Publisher", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux ignoreElements(..)", true), new UsesMethod("reactor.core.publisher.Mono thenMany(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoThenMonoRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoThenMono`";
        }

        public String getDescription() {
            return "Avoid vacuous operations prior to invocation of `Mono#then(Mono)`.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4968");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{mono1:any(reactor.core.publisher.Mono<T>)}.ignoreElement().then(#{mono2:any(reactor.core.publisher.Mono<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{mono1:any(reactor.core.publisher.Mono<T>)}.flux().then(#{mono2:any(reactor.core.publisher.Mono<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"#{mono1:any(reactor.core.publisher.Mono<T>)}.thenEmpty(#{mono2:any(reactor.core.publisher.Mono<java.lang.Void>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono1:any(reactor.core.publisher.Mono<T>)}.then(#{mono2:any(reactor.core.publisher.Mono<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Mono thenEmpty(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux then(..)", true), new UsesMethod("reactor.core.publisher.Mono flux(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Mono ignoreElement(..)", true), new UsesMethod("reactor.core.publisher.Mono then(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxThenMonoRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxThenMono`";
        }

        public String getDescription() {
            return "Avoid vacuous invocations of `Flux#ignoreElements()`.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S4968");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.ignoreElements().then(#{mono:any(reactor.core.publisher.Mono<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.thenEmpty(#{mono:any(reactor.core.publisher.Mono<java.lang.Void>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.then(#{mono:any(reactor.core.publisher.Mono<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux thenEmpty(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux ignoreElements(..)", true), new UsesMethod("reactor.core.publisher.Mono then(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoSingleOptionalRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoSingleOptional`";
        }

        public String getDescription() {
            return "Prefer `Mono#singleOptional()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.flux().collect(com.google.common.collect.MoreCollectors.toOptional())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.map(java.util.Optional::of)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.singleOptional().defaultIfEmpty(#{optional:any(java.util.Optional<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$3 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.singleOptional().switchIfEmpty(#{alternate:any(reactor.core.publisher.Mono<java.util.Optional<T>>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$4 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.transform(reactor.core.publisher.Mono::singleOptional)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.singleOptional()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.MoreCollectors.toOptional");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$4.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Mono map(..)", true), new UsesMethod("reactor.core.publisher.Mono transform(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.MoreCollectors toOptional(..)", true), new UsesMethod("reactor.core.publisher.Flux collect(..)", true), new UsesMethod("reactor.core.publisher.Mono flux(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Mono defaultIfEmpty(..)", true), new UsesMethod("reactor.core.publisher.Mono singleOptional(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Mono singleOptional(..)", true), new UsesMethod("reactor.core.publisher.Mono switchIfEmpty(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoOfTypeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoOfType`";
        }

        public String getDescription() {
            return "Prefer `Mono#ofType(Class)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.filter(#{clazz:any(java.lang.Class<S>)}::isInstance).cast(#{clazz})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.ofType(#{clazz:any(java.lang.Class<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono cast(..)", true), new UsesMethod("reactor.core.publisher.Mono filter(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxOfTypeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxOfType`";
        }

        public String getDescription() {
            return "Prefer `Flux#ofType(Class)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.filter(#{clazz:any(java.lang.Class<S>)}::isInstance).cast(#{clazz})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.ofType(#{clazz:any(java.lang.Class<S>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux cast(..)", true), new UsesMethod("reactor.core.publisher.Flux filter(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ConcatMapIterableIdentityRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.ConcatMapIterableIdentity`";
        }

        public String getDescription() {
            return "Prefer `Flux#concatMapIterable(Function)` over alternatives that require an additional subscription.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<? extends java.lang.Iterable<T>>)}.concatMap((list)->reactor.core.publisher.Flux.fromIterable(list))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<? extends java.lang.Iterable<T>>)}.concatMap(reactor.core.publisher.Flux::fromIterable)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<? extends java.lang.Iterable<T>>)}.concatMapIterable(java.util.function.Function.identity())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux concatMap(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ConcatMapIterableIdentityWithPrefetchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.ConcatMapIterableIdentityWithPrefetch`";
        }

        public String getDescription() {
            return "Prefer `Flux#concatMapIterable(Function, int)` over alternatives that require an additional subscription.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<? extends java.lang.Iterable<T>>)}.concatMap((list)->reactor.core.publisher.Flux.fromIterable(list), #{prefetch:any(int)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<? extends java.lang.Iterable<T>>)}.concatMap(reactor.core.publisher.Flux::fromIterable, #{prefetch:any(int)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<? extends java.lang.Iterable<T>>)}.concatMapIterable(java.util.function.Function.identity(), #{prefetch:any(int)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux concatMap(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxFromIterableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxFromIterable`";
        }

        public String getDescription() {
            return "Prefer `Flux#fromIterable(Iterable)` over less efficient alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.fromStream(#{collection:any(java.util.Collection<T>)}::stream)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"reactor.core.publisher.Flux.fromStream(()->#{collection:any(java.util.Collection<T>)}.stream())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Flux.fromIterable(#{collection:any(java.util.Collection<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitExpression(Expression elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Supplier");
                        this.maybeRemoveImport("java.util.stream.Stream");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Supplier");
                        this.maybeRemoveImport("java.util.stream.Stream");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitExpression(elem, (Object)ctx);
                }

                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Supplier");
                        this.maybeRemoveImport("java.util.stream.Stream");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.function.Supplier");
                        this.maybeRemoveImport("java.util.stream.Stream");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitLambda(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux fromStream(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoDoOnErrorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoDoOnError`";
        }

        public String getDescription() {
            return "Prefer `Mono#doOnError(Class, Consumer)` over `Mono#doOnError(Predicate, Consumer)` where possible.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.doOnError(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{onError:any(java.util.function.Consumer<? super java.lang.Throwable>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.doOnError(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{onError:any(java.util.function.Consumer<? super java.lang.Throwable>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Consumer", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono doOnError(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxDoOnErrorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxDoOnError`";
        }

        public String getDescription() {
            return "Prefer `Flux#doOnError(Class, Consumer)` over `Flux#doOnError(Predicate, Consumer)` where possible.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.doOnError(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{onError:any(java.util.function.Consumer<? super java.lang.Throwable>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.doOnError(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{onError:any(java.util.function.Consumer<? super java.lang.Throwable>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Consumer", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux doOnError(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoOnErrorCompleteRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoOnErrorComplete`";
        }

        public String getDescription() {
            return "Prefer `Mono#onErrorComplete()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorResume((e)->reactor.core.publisher.Mono.empty())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorComplete()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono empty(..)", true), new UsesMethod("reactor.core.publisher.Mono onErrorResume(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxOnErrorCompleteRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxOnErrorComplete`";
        }

        public String getDescription() {
            return "Prefer `Flux#onErrorComplete()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorResume((e)->reactor.core.publisher.Mono.empty())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorResume((e)->reactor.core.publisher.Flux.empty())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorComplete()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("reactor.core.publisher.Mono");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux onErrorResume(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux empty(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono empty(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoOnErrorCompleteClassRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoOnErrorCompleteClass`";
        }

        public String getDescription() {
            return "Prefer `Mono#onErrorComplete(Class)`} over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorComplete(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorResume(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, (e)->reactor.core.publisher.Mono.empty())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorComplete(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Mono onErrorComplete(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Mono empty(..)", true), new UsesMethod("reactor.core.publisher.Mono onErrorResume(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoOnErrorCompletePredicateRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoOnErrorCompletePredicate`";
        }

        public String getDescription() {
            return "Prefer `Mono#onErrorComplete(Predicate)`} over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorResume(#{predicate:any(java.util.function.Predicate<? super java.lang.Throwable>)}, (e)->reactor.core.publisher.Mono.empty())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorComplete(#{predicate:any(java.util.function.Predicate<? super java.lang.Throwable>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono empty(..)", true), new UsesMethod("reactor.core.publisher.Mono onErrorResume(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxOnErrorCompletePredicateRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxOnErrorCompletePredicate`";
        }

        public String getDescription() {
            return "Prefer `Flux#onErrorComplete(Predicate)`} over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorResume(#{predicate:any(java.util.function.Predicate<? super java.lang.Throwable>)}, (e)->reactor.core.publisher.Mono.empty())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorResume(#{predicate:any(java.util.function.Predicate<? super java.lang.Throwable>)}, (e)->reactor.core.publisher.Flux.empty())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorComplete(#{predicate:any(java.util.function.Predicate<? super java.lang.Throwable>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("reactor.core.publisher.Mono");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux onErrorResume(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux empty(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono empty(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoOnErrorContinueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoOnErrorContinue`";
        }

        public String getDescription() {
            return "Prefer `Mono#onErrorContinue(Class, BiConsumer)` over `Mono#onErrorContinue(Predicate, BiConsumer)` where possible.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorContinue(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{errorConsumer:any(java.util.function.BiConsumer<java.lang.Throwable, java.lang.Object>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorContinue(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{errorConsumer:any(java.util.function.BiConsumer<java.lang.Throwable, java.lang.Object>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.BiConsumer", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono onErrorContinue(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxOnErrorContinueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxOnErrorContinue`";
        }

        public String getDescription() {
            return "Prefer `Flux#onErrorContinue(Class, BiConsumer)` over `Flux#onErrorContinue(Predicate, BiConsumer)` where possible.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorContinue(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{errorConsumer:any(java.util.function.BiConsumer<java.lang.Throwable, java.lang.Object>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorContinue(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{errorConsumer:any(java.util.function.BiConsumer<java.lang.Throwable, java.lang.Object>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.BiConsumer", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux onErrorContinue(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoOnErrorMapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoOnErrorMap`";
        }

        public String getDescription() {
            return "Prefer `Mono#onErrorMap(Class, Function)` over `Mono#onErrorMap(Predicate, Function)` where possible.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorMap(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{mapper:any(java.util.function.Function<? super java.lang.Throwable, ? extends java.lang.Throwable>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorMap(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{mapper:any(java.util.function.Function<? super java.lang.Throwable, ? extends java.lang.Throwable>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono onErrorMap(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxOnErrorMapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxOnErrorMap`";
        }

        public String getDescription() {
            return "Prefer `Flux#onErrorMap(Class, Function)` over `Flux#onErrorMap(Predicate, Function)` where possible.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorMap(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{mapper:any(java.util.function.Function<? super java.lang.Throwable, ? extends java.lang.Throwable>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorMap(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{mapper:any(java.util.function.Function<? super java.lang.Throwable, ? extends java.lang.Throwable>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux onErrorMap(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoOnErrorResumeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoOnErrorResume`";
        }

        public String getDescription() {
            return "Prefer `Mono#onErrorResume(Class, Function)` over `Mono#onErrorResume(Predicate, Function)` where possible.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorResume(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{fallback:any(java.util.function.Function<? super java.lang.Throwable, ? extends reactor.core.publisher.Mono<? extends T>>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorResume(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{fallback:any(java.util.function.Function<? super java.lang.Throwable, ? extends reactor.core.publisher.Mono<? extends T>>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono onErrorResume(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxOnErrorResumeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxOnErrorResume`";
        }

        public String getDescription() {
            return "Prefer `Flux#onErrorResume(Class, Function)` over `Flux#onErrorResume(Predicate, Function)` where possible.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorResume(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{fallback:any(java.util.function.Function<? super java.lang.Throwable, ? extends org.reactivestreams.Publisher<? extends T>>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorResume(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{fallback:any(java.util.function.Function<? super java.lang.Throwable, ? extends org.reactivestreams.Publisher<? extends T>>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesType("org.reactivestreams.Publisher", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux onErrorResume(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoOnErrorReturnRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoOnErrorReturn`";
        }

        public String getDescription() {
            return "Prefer `Mono#onErrorReturn(Class, Object)` over `Mono#onErrorReturn(Predicate, Object)` where possible.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorReturn(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{fallbackValue:any(T)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.onErrorReturn(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{fallbackValue:any(T)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono onErrorReturn(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxOnErrorReturnRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxOnErrorReturn`";
        }

        public String getDescription() {
            return "Prefer `Flux#onErrorReturn(Class, Object)` over `Flux#onErrorReturn(Predicate, Object)` where possible.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorReturn(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}::isInstance, #{fallbackValue:any(T)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.onErrorReturn(#{clazz:any(java.lang.Class<? extends java.lang.Throwable>)}, #{fallbackValue:any(T)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux onErrorReturn(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxFilterSortRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxFilterSort`";
        }

        public String getDescription() {
            return "Apply `Flux#filter(Predicate)` before `Flux#sort()` to reduce the number of elements to sort.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.sort().filter(#{predicate:any(java.util.function.Predicate<? super T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)}).sort()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux filter(..)", true), new UsesMethod("reactor.core.publisher.Flux sort(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxFilterSortWithComparatorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxFilterSortWithComparator`";
        }

        public String getDescription() {
            return "Apply `Flux#filter(Predicate)` before `Flux#sort(Comparator)` to reduce the number of elements to sort.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.sort(#{comparator:any(java.util.Comparator<? super T>)}).filter(#{predicate:any(java.util.function.Predicate<? super T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)}).sort(#{comparator:any(java.util.Comparator<? super T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux filter(..)", true), new UsesMethod("reactor.core.publisher.Flux sort(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxTakeWhileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxTakeWhile`";
        }

        public String getDescription() {
            return "Do not unnecessarily `Flux#filter(Predicate) filter` the result of `Flux#takeWhile(Predicate)` using the same `Predicate`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.takeWhile(#{predicate:any(java.util.function.Predicate<? super T>)}).filter(#{predicate})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.takeWhile(#{predicate:any(java.util.function.Predicate<? super T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux filter(..)", true), new UsesMethod("reactor.core.publisher.Flux takeWhile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxCollectToImmutableListRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxCollectToImmutableList`";
        }

        public String getDescription() {
            return "Prefer `Flux#collect(Collector)` with `ImmutableList#toImmutableList()` over alternatives that do not explicitly return an immutable collection.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.collectList()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.collect(com.google.common.collect.ImmutableList.toImmutableList())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.List");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux collectList(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxCollectToImmutableSetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxCollectToImmutableSet`";
        }

        public String getDescription() {
            return "Prefer `Flux#collect(Collector)` with `ImmutableSet#toImmutableSet()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.collect(com.google.common.collect.ImmutableList.toImmutableList()).map(com.google.common.collect.ImmutableSet::copyOf)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.collect(com.google.common.collect.ImmutableSet.toImmutableSet())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableList.toImmutableList");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableList toImmutableList(..)", true), new UsesMethod("reactor.core.publisher.Flux collect(..)", true), new UsesMethod("reactor.core.publisher.Mono map(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxSortRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxSort`";
        }

        public String getDescription() {
            return "Prefer `Flux#sort()` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.sort(java.util.Comparator.naturalOrder())").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.sort()").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Comparator.naturalOrder");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("java.util.Comparator naturalOrder(..)", true), new UsesMethod("reactor.core.publisher.Flux sort(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxTransformMinRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxTransformMin`";
        }

        public String getDescription() {
            return "Prefer `MathFlux#min(Publisher)` over less efficient alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.sort().next()").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.transform(reactor.math.MathFlux::min).singleOrEmpty()").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux next(..)", true), new UsesMethod("reactor.core.publisher.Flux sort(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxTransformMinWithComparatorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxTransformMinWithComparator`";
        }

        public String getDescription() {
            return "Prefer `MathFlux#min(Publisher, Comparator)` over less efficient or more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.sort(#{cmp:any(java.util.Comparator<? super T>)}).next()").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.collect(java.util.stream.Collectors.minBy(#{cmp:any(java.util.Comparator<? super T>)})).flatMap(reactor.core.publisher.Mono::justOrEmpty)").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.transform((f)->reactor.math.MathFlux.min(f, #{cmp:any(java.util.Comparator<? super T>)})).singleOrEmpty()").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collectors.minBy");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.Collectors minBy(..)", true), new UsesMethod("reactor.core.publisher.Flux collect(..)", true), new UsesMethod("reactor.core.publisher.Mono flatMap(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux next(..)", true), new UsesMethod("reactor.core.publisher.Flux sort(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxTransformMaxRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxTransformMax`";
        }

        public String getDescription() {
            return "Prefer `MathFlux#max(Publisher)` over less efficient alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.sort().last()").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.transform(reactor.math.MathFlux::max).singleOrEmpty()").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux last(..)", true), new UsesMethod("reactor.core.publisher.Flux sort(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxTransformMaxWithComparatorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxTransformMaxWithComparator`";
        }

        public String getDescription() {
            return "Prefer `MathFlux#max(Publisher, Comparator)` over less efficient or more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.sort(#{cmp:any(java.util.Comparator<? super T>)}).last()").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.collect(java.util.stream.Collectors.maxBy(#{cmp:any(java.util.Comparator<? super T>)})).flatMap(reactor.core.publisher.Mono::justOrEmpty)").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.transform((f)->reactor.math.MathFlux.max(f, #{cmp:any(java.util.Comparator<? super T>)})).singleOrEmpty()").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collectors.maxBy");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.Collectors maxBy(..)", true), new UsesMethod("reactor.core.publisher.Flux collect(..)", true), new UsesMethod("reactor.core.publisher.Mono flatMap(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux last(..)", true), new UsesMethod("reactor.core.publisher.Flux sort(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MathFluxMinRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MathFluxMin`";
        }

        public String getDescription() {
            return "Prefer `MathFlux#min(Publisher)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"reactor.math.MathFlux.min(#{publisher:any(org.reactivestreams.Publisher<T>)}, java.util.Comparator.naturalOrder())").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"reactor.math.MathFlux.max(#{publisher:any(org.reactivestreams.Publisher<T>)}, java.util.Comparator.reverseOrder())").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.math.MathFlux.min(#{publisher:any(org.reactivestreams.Publisher<T>)})").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Comparator.naturalOrder");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Comparator.reverseOrder");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.reactivestreams.Publisher", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesType("reactor.math.MathFlux", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Comparator naturalOrder(..)", true), new UsesMethod("reactor.math.MathFlux min(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Comparator reverseOrder(..)", true), new UsesMethod("reactor.math.MathFlux max(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MathFluxMaxRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MathFluxMax`";
        }

        public String getDescription() {
            return "Prefer `MathFlux#max(Publisher)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"reactor.math.MathFlux.min(#{publisher:any(org.reactivestreams.Publisher<T>)}, java.util.Comparator.reverseOrder())").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"reactor.math.MathFlux.max(#{publisher:any(org.reactivestreams.Publisher<T>)}, java.util.Comparator.naturalOrder())").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.math.MathFlux.max(#{publisher:any(org.reactivestreams.Publisher<T>)})").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Comparator.reverseOrder");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Comparator.naturalOrder");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.reactivestreams.Publisher", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesType("reactor.math.MathFlux", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Comparator naturalOrder(..)", true), new UsesMethod("reactor.math.MathFlux max(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Comparator reverseOrder(..)", true), new UsesMethod("reactor.math.MathFlux min(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PublisherProbeEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.PublisherProbeEmpty`";
        }

        public String getDescription() {
            return "Prefer `PublisherProbe#empty()`} over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"reactor.test.publisher.PublisherProbe.of(reactor.core.publisher.Mono.empty())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"reactor.test.publisher.PublisherProbe.of(reactor.core.publisher.Flux.empty())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.test.publisher.PublisherProbe.empty()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("reactor.core.publisher.Mono");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("reactor.core.publisher.Flux");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.test.publisher.PublisherProbe", Boolean.valueOf(true)), new UsesMethod("reactor.test.publisher.PublisherProbe of(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux empty(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono empty(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PublisherProbeAssertWasSubscribedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.PublisherProbeAssertWasSubscribed`";
        }

        public String getDescription() {
            return "Prefer `PublisherProbe#assertWasSubscribed()` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.wasSubscribed()).isTrue();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.subscribeCount()).isNotNegative();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.subscribeCount()).isNotEqualTo(0);").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$3 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.subscribeCount()).isPositive();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasSubscribed();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.test.publisher.PublisherProbe", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("reactor.test.publisher.PublisherProbe wasSubscribed(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractLongAssert isNotEqualTo(..)", true), new UsesMethod("reactor.test.publisher.PublisherProbe subscribeCount(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractLongAssert isNotNegative(..)", true), new UsesMethod("reactor.test.publisher.PublisherProbe subscribeCount(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractLongAssert isPositive(..)", true), new UsesMethod("reactor.test.publisher.PublisherProbe subscribeCount(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PublisherProbeAssertWasNotSubscribedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.PublisherProbeAssertWasNotSubscribed`";
        }

        public String getDescription() {
            return "Prefer `PublisherProbe#assertWasNotSubscribed()` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.wasSubscribed()).isFalse();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.subscribeCount()).isEqualTo(0);").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.subscribeCount()).isNotPositive();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasNotSubscribed();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.test.publisher.PublisherProbe", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true), new UsesMethod("reactor.test.publisher.PublisherProbe wasSubscribed(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true), new UsesMethod("reactor.test.publisher.PublisherProbe subscribeCount(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractLongAssert isNotPositive(..)", true), new UsesMethod("reactor.test.publisher.PublisherProbe subscribeCount(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PublisherProbeAssertWasCancelledRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.PublisherProbeAssertWasCancelled`";
        }

        public String getDescription() {
            return "Prefer `PublisherProbe#assertWasCancelled()` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.wasCancelled()).isTrue();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasCancelled();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.test.publisher.PublisherProbe", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), new UsesMethod("reactor.test.publisher.PublisherProbe wasCancelled(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PublisherProbeAssertWasNotCancelledRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.PublisherProbeAssertWasNotCancelled`";
        }

        public String getDescription() {
            return "Prefer `PublisherProbe#assertWasNotCancelled()` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.wasCancelled()).isFalse();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasNotCancelled();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.test.publisher.PublisherProbe", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), new UsesMethod("reactor.test.publisher.PublisherProbe wasCancelled(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PublisherProbeAssertWasRequestedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.PublisherProbeAssertWasRequested`";
        }

        public String getDescription() {
            return "Prefer `PublisherProbe#assertWasRequested()` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.wasRequested()).isTrue();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasRequested();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.test.publisher.PublisherProbe", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), new UsesMethod("reactor.test.publisher.PublisherProbe wasRequested(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PublisherProbeAssertWasNotRequestedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.PublisherProbeAssertWasNotRequested`";
        }

        public String getDescription() {
            return "Prefer `PublisherProbe#assertWasNotRequested()` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.wasRequested()).isFalse();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{probe:any(reactor.test.publisher.PublisherProbe<T>)}.assertWasNotRequested();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.test.publisher.PublisherProbe", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), new UsesMethod("reactor.test.publisher.PublisherProbe wasRequested(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierFromMonoRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierFromMono`";
        }

        public String getDescription() {
            return "Prefer `Mono#as(Function)` when creating a `StepVerifier`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"reactor.test.StepVerifier.create(#{mono:any(reactor.core.publisher.Mono<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.flux().as(reactor.test.StepVerifier::create)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{mono:any(reactor.core.publisher.Mono<T>)}.as(reactor.test.StepVerifier::create)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesType("reactor.test.StepVerifier", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.test.StepVerifier create(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.core.publisher.Flux as(..)", true), new UsesMethod("reactor.core.publisher.Mono flux(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierFromFluxRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierFromFlux`";
        }

        public String getDescription() {
            return "Prefer `Flux#as(Function)` when creating a `StepVerifier`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"reactor.test.StepVerifier.create(#{flux:any(reactor.core.publisher.Flux<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.as(reactor.test.StepVerifier::create)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.test.StepVerifier", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier create(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierVerifyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierVerify`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier#verify()` over a dangling `StepVerifier#verifyThenAssertThat()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stepVerifier:any(reactor.test.StepVerifier)}.verifyThenAssertThat()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stepVerifier:any(reactor.test.StepVerifier)}.verify()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.test.StepVerifier", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verifyThenAssertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierVerifyDurationRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierVerifyDuration`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier#verify(Duration)` over a dangling `StepVerifier#verifyThenAssertThat(Duration)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stepVerifier:any(reactor.test.StepVerifier)}.verifyThenAssertThat(#{duration:any(java.time.Duration)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stepVerifier:any(reactor.test.StepVerifier)}.verify(#{duration:any(java.time.Duration)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("reactor.test.StepVerifier", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verifyThenAssertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierVerifyLaterRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierVerifyLater`";
        }

        public String getDescription() {
            return "Don't unnecessarily invoke `StepVerifier#verifyLater()` multiple times.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stepVerifier:any(reactor.test.StepVerifier)}.verifyLater().verifyLater()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stepVerifier:any(reactor.test.StepVerifier)}.verifyLater()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.test.StepVerifier", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verifyLater(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierStepExpectNextRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierStepExpectNext`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier.Step#expectNext(Object)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.Step<T>)}.expectNextMatches((e)->e.equals(#{object:any(T)}))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.Step<T>)}.expectNextMatches(#{object:any(T)}::equals)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.Step<T>)}.expectNext(#{object:any(T)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("reactor.test.StepVerifier.Step expectNextMatches(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxAsStepVerifierExpectNextRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxAsStepVerifierExpectNext`";
        }

        public String getDescription() {
            return "Avoid list collection when verifying that a `Flux` emits exactly one value.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.collect(#{listCollector:any(java.util.stream.Collector<? super T, ?, L>)}).as(reactor.test.StepVerifier::create).assertNext((list)->org.assertj.core.api.Assertions.assertThat(list).containsExactly(#{object:any(T)}))").genericTypes(new String[]{"T", "L extends java.util.List<T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{flux:any(reactor.core.publisher.Flux<T>)}.as(reactor.test.StepVerifier::create).expectNext(#{object:any(T)})").genericTypes(new String[]{"T", "L extends java.util.List<T>"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesType("reactor.test.StepVerifier", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIterableAssert containsExactly(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), new UsesMethod("reactor.core.publisher.Flux collect(..)", true), new UsesMethod("reactor.core.publisher.Mono as(..)", true), new UsesMethod("reactor.test.StepVerifier.Step assertNext(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierLastStepVerifyCompleteRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyComplete`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier.LastStep#verifyComplete()` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectComplete().verify()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.verifyComplete()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectComplete(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierLastStepVerifyErrorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyError`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier.LastStep#verifyError()` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectError().verify()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.verifyError()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectError(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierLastStepVerifyErrorClassRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyErrorClass`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier.LastStep#verifyError(Class)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectError(#{clazz:any(java.lang.Class<T>)}).verify()").genericTypes(new String[]{"T extends java.lang.Throwable"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorMatches(#{clazz:any(java.lang.Class<T>)}::isInstance)").genericTypes(new String[]{"T extends java.lang.Throwable"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorSatisfies((t)->org.assertj.core.api.Assertions.assertThat(t).isInstanceOf(#{clazz:any(java.lang.Class<T>)}))").genericTypes(new String[]{"T extends java.lang.Throwable"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.verifyError(#{clazz:any(java.lang.Class<T>)})").genericTypes(new String[]{"T extends java.lang.Throwable"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThat");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.test.StepVerifier.LastStep verifyErrorMatches(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractAssert isInstanceOf(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep verifyErrorSatisfies(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.test.StepVerifier verify(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectError(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierLastStepVerifyErrorMatchesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyErrorMatches`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier.LastStep#verifyErrorMatches(Predicate)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectErrorMatches(#{predicate:any(java.util.function.Predicate<java.lang.Throwable>)}).verify()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectError().verifyThenAssertThat().hasOperatorErrorMatching(#{predicate:any(java.util.function.Predicate<java.lang.Throwable>)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorMatches(#{predicate:any(java.util.function.Predicate<java.lang.Throwable>)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.test.StepVerifier verifyThenAssertThat(..)", true), new UsesMethod("reactor.test.StepVerifier.Assertions hasOperatorErrorMatching(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectError(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectErrorMatches(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierLastStepVerifyErrorSatisfiesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyErrorSatisfies`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier.LastStep#verifyErrorSatisfies(Consumer)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectErrorSatisfies(#{consumer:any(java.util.function.Consumer<java.lang.Throwable>)}).verify()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorSatisfies(#{consumer:any(java.util.function.Consumer<java.lang.Throwable>)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.util.function.Consumer", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectErrorSatisfies(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierLastStepVerifyErrorSatisfiesAssertJRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyErrorSatisfiesAssertJ`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier.LastStep#verifyErrorSatisfies(Consumer)` with AssertJ over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectError().verifyThenAssertThat().hasOperatorErrorOfType(#{clazz:any(java.lang.Class<T>)}).hasOperatorErrorWithMessage(#{message:any(java.lang.String)})").genericTypes(new String[]{"T extends java.lang.Throwable"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectError(#{clazz:any(java.lang.Class<T>)}).verifyThenAssertThat().hasOperatorErrorWithMessage(#{message:any(java.lang.String)})").genericTypes(new String[]{"T extends java.lang.Throwable"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectErrorMessage(#{message:any(java.lang.String)}).verifyThenAssertThat().hasOperatorErrorOfType(#{clazz:any(java.lang.Class<T>)})").genericTypes(new String[]{"T extends java.lang.Throwable"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorSatisfies((t)->org.assertj.core.api.Assertions.assertThat(t).isInstanceOf(#{clazz:any(java.lang.Class<T>)}).hasMessage(#{message:any(java.lang.String)}))").genericTypes(new String[]{"T extends java.lang.Throwable"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.test.StepVerifier verifyThenAssertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.test.StepVerifier.Assertions hasOperatorErrorOfType(..)", true), new UsesMethod("reactor.test.StepVerifier.Assertions hasOperatorErrorWithMessage(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectError(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.test.StepVerifier.Assertions hasOperatorErrorOfType(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectErrorMessage(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.test.StepVerifier.Assertions hasOperatorErrorWithMessage(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectError(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierLastStepVerifyErrorMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyErrorMessage`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier.LastStep#verifyErrorMessage(String)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectErrorMessage(#{message:any(java.lang.String)}).verify()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.verifyErrorMessage(#{message:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectErrorMessage(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StepVerifierLastStepVerifyTimeoutRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.StepVerifierLastStepVerifyTimeout`";
        }

        public String getDescription() {
            return "Prefer `StepVerifier.LastStep#verifyTimeout(Duration)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.expectTimeout(#{duration:any(java.time.Duration)}).verify()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{step:any(reactor.test.StepVerifier.LastStep)}.verifyTimeout(#{duration:any(java.time.Duration)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)", true), new UsesMethod("reactor.test.StepVerifier.LastStep expectTimeout(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoFromFutureSupplierRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoFromFutureSupplier`";
        }

        public String getDescription() {
            return "Prefer `Mono#fromFuture(Supplier)` over `Mono#fromFuture(CompletableFuture)`, as the former may defer initiation of the asynchronous computation until subscription.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"reactor.core.publisher.Mono.fromFuture(#{future:any(java.util.concurrent.CompletableFuture<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Mono.fromFuture(()->#{future:any(java.util.concurrent.CompletableFuture<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.concurrent.CompletableFuture", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono fromFuture(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoFromFutureSupplierBooleanRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoFromFutureSupplierBoolean`";
        }

        public String getDescription() {
            return "Prefer `Mono#fromFuture(Supplier, boolean)` over `Mono#fromFuture(CompletableFuture, boolean)`, as the former may defer initiation of the asynchronous computation until subscription.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"reactor.core.publisher.Mono.fromFuture(#{future:any(java.util.concurrent.CompletableFuture<T>)}, #{suppressCancel:any(boolean)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Mono.fromFuture(()->#{future:any(java.util.concurrent.CompletableFuture<T>)}, #{suppressCancel:any(boolean)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.concurrent.CompletableFuture", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Mono fromFuture(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoFromFutureAsyncLoadingCacheGetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoFromFutureAsyncLoadingCacheGet`";
        }

        public String getDescription() {
            return "Don't propagate `Mono` cancellations to an upstream cache value computation, as completion of such computations may benefit concurrent or subsequent cache usages.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"reactor.core.publisher.Mono.fromFuture(()->#{cache:any(com.github.benmanes.caffeine.cache.AsyncLoadingCache<K, V>)}.get(#{key:any(K)}))").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Mono.fromFuture(()->#{cache:any(com.github.benmanes.caffeine.cache.AsyncLoadingCache<K, V>)}.get(#{key:any(K)}), true)").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.github.benmanes.caffeine.cache.AsyncLoadingCache", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("com.github.benmanes.caffeine.cache.AsyncLoadingCache get(..)", true), new UsesMethod("reactor.core.publisher.Mono fromFuture(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MonoFromFutureAsyncLoadingCacheGetAllRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.MonoFromFutureAsyncLoadingCacheGetAll`";
        }

        public String getDescription() {
            return "Don't propagate `Mono` cancellations to upstream cache value computations, as completion of such computations may benefit concurrent or subsequent cache usages.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"reactor.core.publisher.Mono.fromFuture(()->#{cache:any(com.github.benmanes.caffeine.cache.AsyncLoadingCache<K1, V>)}.getAll(#{keys:any(java.lang.Iterable<K2>)}))").genericTypes(new String[]{"K1", "K2 extends K1", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Mono.fromFuture(()->#{cache:any(com.github.benmanes.caffeine.cache.AsyncLoadingCache<K1, V>)}.getAll(#{keys:any(java.lang.Iterable<K2>)}), true)").genericTypes(new String[]{"K1", "K2 extends K1", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.github.benmanes.caffeine.cache.AsyncLoadingCache", Boolean.valueOf(true)), new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesMethod("com.github.benmanes.caffeine.cache.AsyncLoadingCache getAll(..)", true), new UsesMethod("reactor.core.publisher.Mono fromFuture(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FluxFromStreamSupplierRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ReactorRules.FluxFromStreamSupplier`";
        }

        public String getDescription() {
            return "Prefer `Flux#fromStream(Supplier)` over `Flux#fromStream(Stream)`, as the former yields a `Flux` that is more likely to behave as expected when subscribed to more than once.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"reactor.core.publisher.Flux.fromStream(#{stream:any(java.util.stream.Stream<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"reactor.core.publisher.Flux.fromStream(()->#{stream:any(java.util.stream.Stream<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux fromStream(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

