/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class ImmutableTableRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ImmutableTableRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `ImmutableTable`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableTableRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ImmutableTableBuilderRecipe(), new ImmutableTableBuilderBuildOrThrowRecipe(), new CellToImmutableTableRecipe(), new ImmutableTableOfRecipe()});
    }

    @NullMarked
    public static class ImmutableTableBuilderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableTableRules.ImmutableTableBuilder`";
        }

        public String getDescription() {
            return "Prefer `ImmutableTable#builder()` over the associated constructor.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"new com.google.common.collect.ImmutableTable.Builder<>()").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableTable.builder()").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("com.google.common.collect.ImmutableTable.Builder <constructor>(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableTableBuilderBuildOrThrowRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableTableRules.ImmutableTableBuilderBuildOrThrow`";
        }

        public String getDescription() {
            return "Prefer `ImmutableTable.Builder#buildOrThrow()` over the less explicit `ImmutableTable.Builder#build()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{builder:any(com.google.common.collect.ImmutableTable.Builder<R, C, V>)}.build()").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{builder:any(com.google.common.collect.ImmutableTable.Builder<R, C, V>)}.buildOrThrow()").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableTable", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableTable.Builder build(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CellToImmutableTableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableTableRules.CellToImmutableTable`";
        }

        public String getDescription() {
            return "Prefer `ImmutableTable#of(Object, Object, Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableTable.<R, C, V>builder().put(#{cell:any(com.google.common.collect.Table.Cell<? extends R, ? extends C, ? extends V>)}).buildOrThrow()").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"java.util.stream.Stream.of(#{cell:any(com.google.common.collect.Table.Cell<? extends R, ? extends C, ? extends V>)}).collect(com.google.common.collect.ImmutableTable.toImmutableTable(com.google.common.collect.Table.Cell::getRowKey, com.google.common.collect.Table.Cell::getColumnKey, com.google.common.collect.Table.Cell::getValue))").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableTable.of(#{cell:any(com.google.common.collect.Table.Cell<? extends R, ? extends C, ? extends V>)}.getRowKey(), #{cell}.getColumnKey(), #{cell}.getValue())").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Stream");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableTable.toImmutableTable");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableTable", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableTable builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableTable.Builder buildOrThrow(..)", true), new UsesMethod("com.google.common.collect.ImmutableTable.Builder put(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableTable toImmutableTable(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.stream.Stream of(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableTableOfRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableTableRules.ImmutableTableOf`";
        }

        public String getDescription() {
            return "Prefer `ImmutableTable#of()` over more contrived alternatives .";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.ImmutableTable.<R, C, V>builder().buildOrThrow()").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableTable.of()").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableTable", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableTable builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableTable.Builder buildOrThrow(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

