/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import tech.picnic.errorprone.utils.AnnotationAttributeMatcher;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="Prefer the conciseness of `@{Get,Put,Post,Delete,Patch}Mapping` over `@RequestMapping`", link="https://error-prone.picnic.tech/bugpatterns/SpringMvcAnnotation", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class SpringMvcAnnotation
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final String ANN_PACKAGE_PREFIX = "org.springframework.web.bind.annotation.";
    private static final AnnotationAttributeMatcher ARGUMENT_SELECTOR = AnnotationAttributeMatcher.create(Optional.of(ImmutableList.of((Object)"org.springframework.web.bind.annotation.RequestMapping#method")), (Iterable)ImmutableList.of());
    private static final ImmutableMap<String, String> REPLACEMENTS = ImmutableMap.builder().put((Object)"DELETE", (Object)"DeleteMapping").put((Object)"GET", (Object)"GetMapping").put((Object)"PATCH", (Object)"PatchMapping").put((Object)"POST", (Object)"PostMapping").put((Object)"PUT", (Object)"PutMapping").buildOrThrow();

    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        return ARGUMENT_SELECTOR.extractMatchingArguments(tree).findFirst().flatMap(arg -> SpringMvcAnnotation.trySimplification(tree, arg, state)).map(fix -> this.describeMatch(tree, (Fix)fix)).orElse(Description.NO_MATCH);
    }

    private static Optional<Fix> trySimplification(AnnotationTree tree, ExpressionTree arg, VisitorState state) {
        return SpringMvcAnnotation.extractUniqueMethod(arg, state).map(arg_0 -> REPLACEMENTS.get(arg_0)).map(newAnnotation -> SpringMvcAnnotation.replaceAnnotation(tree, arg, newAnnotation, state));
    }

    private static Optional<String> extractUniqueMethod(ExpressionTree arg, VisitorState state) {
        Optional<String> optional;
        if (!(arg instanceof AssignmentTree)) {
            throw new VerifyException("Annotation attribute is not an assignment:" + String.valueOf((Object)arg.getKind()));
        }
        AssignmentTree assignment = (AssignmentTree)arg;
        ExpressionTree expr = assignment.getExpression();
        if (expr instanceof NewArrayTree) {
            NewArrayTree newArray = (NewArrayTree)expr;
            optional = Optional.of(newArray.getInitializers()).filter(args -> args.size() == 1).map(args -> SpringMvcAnnotation.extractMethod((ExpressionTree)args.get(0), state));
        } else {
            optional = Optional.of(SpringMvcAnnotation.extractMethod(expr, state));
        }
        return optional;
    }

    private static String extractMethod(ExpressionTree expr, VisitorState state) {
        return switch (expr.getKind()) {
            case Tree.Kind.IDENTIFIER -> SourceCode.treeToString((Tree)expr, (VisitorState)state);
            case Tree.Kind.MEMBER_SELECT -> ((MemberSelectTree)expr).getIdentifier().toString();
            default -> throw new VerifyException("Unexpected type of expression: " + String.valueOf((Object)expr.getKind()));
        };
    }

    private static Fix replaceAnnotation(AnnotationTree tree, ExpressionTree argToRemove, String newAnnotation, VisitorState state) {
        String newArguments = tree.getArguments().stream().filter(Predicate.not((Predicate<ExpressionTree>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lcom/sun/source/tree/ExpressionTree;)Z)((ExpressionTree)argToRemove))).map(arg -> SourceCode.treeToString((Tree)arg, (VisitorState)state)).collect(Collectors.joining(", "));
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String annotation = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)(ANN_PACKAGE_PREFIX + newAnnotation));
        return fix.replace((Tree)tree, String.format("@%s(%s)", annotation, newArguments)).build();
    }
}

