/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.common.primitives.Ints;

final class PrimitiveTemplates {
    private PrimitiveTemplates() {
    }

    static final class LongToIntExact {
        LongToIntExact() {
        }

        int before(long a) {
            return Ints.checkedCast((long)a);
        }

        int after(long a) {
            return Math.toIntExact(a);
        }
    }

    static final class GreaterThanOrEqualTo {
        GreaterThanOrEqualTo() {
        }

        boolean before(long a, long b) {
            return a >= b;
        }

        boolean before(double a, double b) {
            return !(a < b);
        }

        boolean after(long a, long b) {
            return a >= b;
        }
    }

    static final class GreaterThan {
        GreaterThan() {
        }

        boolean before(long a, long b) {
            return a > b;
        }

        boolean before(double a, double b) {
            return !(a <= b);
        }

        boolean after(long a, long b) {
            return a > b;
        }
    }

    static final class LessThanOrEqualTo {
        LessThanOrEqualTo() {
        }

        boolean before(long a, long b) {
            return a <= b;
        }

        boolean before(double a, double b) {
            return !(a > b);
        }

        boolean after(long a, long b) {
            return a <= b;
        }
    }

    static final class LessThan {
        LessThan() {
        }

        boolean before(long a, long b) {
            return a < b;
        }

        boolean before(double a, double b) {
            return !(a >= b);
        }

        boolean after(long a, long b) {
            return a < b;
        }
    }
}

