/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.function.Predicate;

final class NullTemplates {
    private NullTemplates() {
    }

    static final class NonNullFunction<T> {
        NonNullFunction() {
        }

        Predicate<T> before() {
            return o -> o != null;
        }

        Predicate<T> after() {
            return Objects::nonNull;
        }
    }

    static final class IsNullFunction<T> {
        IsNullFunction() {
        }

        Predicate<T> before() {
            return o -> o == null;
        }

        Predicate<T> after() {
            return Objects::isNull;
        }
    }

    static final class RequireNonNullElse<T> {
        RequireNonNullElse() {
        }

        T before(T first, T second) {
            return (T)MoreObjects.firstNonNull(first, second);
        }

        T after(T first, T second) {
            return Objects.requireNonNullElse(first, second);
        }
    }
}

