/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Streams;
import com.google.errorprone.refaster.Refaster;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;

final class ImmutableMultisetTemplates {
    private ImmutableMultisetTemplates() {
    }

    static final class StreamToImmutableMultiset<T> {
        StreamToImmutableMultiset() {
        }

        ImmutableMultiset<T> before(Stream<T> stream) {
            return ImmutableMultiset.copyOf(stream.iterator());
        }

        ImmutableMultiset<T> after(Stream<T> stream) {
            return (ImmutableMultiset)stream.collect(ImmutableMultiset.toImmutableMultiset());
        }
    }

    static final class IterableToImmutableMultiset<T> {
        IterableToImmutableMultiset() {
        }

        ImmutableMultiset<T> before(T[] iterable) {
            return (ImmutableMultiset)Refaster.anyOf((Object[])new ImmutableMultiset[]{ImmutableMultiset.builder().add((Object[])iterable).build(), (ImmutableMultiset)Arrays.stream(iterable).collect(ImmutableMultiset.toImmutableMultiset())});
        }

        ImmutableMultiset<T> before(Iterator<T> iterable) {
            return (ImmutableMultiset)Refaster.anyOf((Object[])new ImmutableMultiset[]{ImmutableMultiset.builder().addAll(iterable).build(), (ImmutableMultiset)Streams.stream(iterable).collect(ImmutableMultiset.toImmutableMultiset())});
        }

        ImmutableMultiset<T> before(Iterable<T> iterable) {
            return (ImmutableMultiset)Refaster.anyOf((Object[])new ImmutableMultiset[]{ImmutableMultiset.builder().addAll(iterable).build(), (ImmutableMultiset)Streams.stream(iterable).collect(ImmutableMultiset.toImmutableMultiset())});
        }

        ImmutableMultiset<T> before(Collection<T> iterable) {
            return (ImmutableMultiset)iterable.stream().collect(ImmutableMultiset.toImmutableMultiset());
        }

        ImmutableMultiset<T> after(Iterable<T> iterable) {
            return ImmutableMultiset.copyOf(iterable);
        }
    }

    static final class EmptyImmutableMultiset<T> {
        EmptyImmutableMultiset() {
        }

        ImmutableMultiset<T> before() {
            return (ImmutableMultiset)Refaster.anyOf((Object[])new ImmutableMultiset[]{ImmutableMultiset.builder().build(), (ImmutableMultiset)Stream.empty().collect(ImmutableMultiset.toImmutableMultiset())});
        }

        ImmutableMultiset<T> after() {
            return ImmutableMultiset.of();
        }
    }

    static final class ImmutableMultisetBuilder<T> {
        ImmutableMultisetBuilder() {
        }

        ImmutableMultiset.Builder<T> before() {
            return new ImmutableMultiset.Builder();
        }

        ImmutableMultiset.Builder<T> after() {
            return ImmutableMultiset.builder();
        }
    }
}

