/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.common.collect.Streams;
import com.google.errorprone.refaster.Refaster;
import java.util.OptionalDouble;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;

final class DoubleStreamTemplates {
    private DoubleStreamTemplates() {
    }

    static abstract class DoubleStreamAllMatch2 {
        DoubleStreamAllMatch2() {
        }

        abstract boolean test(double var1);

        boolean before(DoubleStream stream) {
            return stream.noneMatch(e -> !this.test(e));
        }

        boolean after(DoubleStream stream) {
            return stream.allMatch(e -> this.test(e));
        }
    }

    static final class DoubleStreamAllMatch {
        DoubleStreamAllMatch() {
        }

        boolean before(DoubleStream stream, DoublePredicate predicate) {
            return stream.noneMatch(predicate.negate());
        }

        boolean after(DoubleStream stream, DoublePredicate predicate) {
            return stream.allMatch(predicate);
        }
    }

    static final class DoubleStreamAnyMatch {
        DoubleStreamAnyMatch() {
        }

        boolean before(DoubleStream stream, DoublePredicate predicate) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{!stream.noneMatch(predicate), stream.filter(predicate).findAny().isPresent()});
        }

        boolean after(DoubleStream stream, DoublePredicate predicate) {
            return stream.anyMatch(predicate);
        }
    }

    static abstract class DoubleStreamNoneMatch2 {
        DoubleStreamNoneMatch2() {
        }

        abstract boolean test(double var1);

        boolean before(DoubleStream stream) {
            return stream.allMatch(e -> !this.test(e));
        }

        boolean after(DoubleStream stream) {
            return stream.noneMatch(e -> this.test(e));
        }
    }

    static final class DoubleStreamNoneMatch {
        DoubleStreamNoneMatch() {
        }

        boolean before(DoubleStream stream, DoublePredicate predicate) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{!stream.anyMatch(predicate), stream.allMatch(predicate.negate()), stream.filter(predicate).findAny().isEmpty()});
        }

        boolean after(DoubleStream stream, DoublePredicate predicate) {
            return stream.noneMatch(predicate);
        }
    }

    static final class DoubleStreamMin {
        DoubleStreamMin() {
        }

        OptionalDouble before(DoubleStream stream) {
            return stream.sorted().findFirst();
        }

        OptionalDouble after(DoubleStream stream) {
            return stream.min();
        }
    }

    static final class DoubleStreamIsNotEmpty {
        DoubleStreamIsNotEmpty() {
        }

        boolean before(DoubleStream stream) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{stream.count() != 0L, stream.count() > 0L, stream.count() >= 1L, stream.findFirst().isPresent()});
        }

        boolean after(DoubleStream stream) {
            return stream.findAny().isPresent();
        }
    }

    static final class DoubleStreamIsEmpty {
        DoubleStreamIsEmpty() {
        }

        boolean before(DoubleStream stream) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{stream.count() == 0L, stream.count() <= 0L, stream.count() < 1L, stream.findFirst().isEmpty()});
        }

        boolean after(DoubleStream stream) {
            return stream.findAny().isEmpty();
        }
    }

    static abstract class FlatMapOuterStreamAfterFlatMapToDouble<T> {
        FlatMapOuterStreamAfterFlatMapToDouble() {
        }

        abstract DoubleStream toDoubleStreamFunction(T var1);

        DoubleStream before(Stream<T> stream, DoubleFunction<? extends DoubleStream> function) {
            return stream.flatMapToDouble(v -> this.toDoubleStreamFunction(v).flatMap(function));
        }

        DoubleStream after(Stream<T> stream, DoubleFunction<? extends DoubleStream> function) {
            return stream.flatMapToDouble(v -> this.toDoubleStreamFunction(v)).flatMap(function);
        }
    }

    static abstract class FlatMapOuterDoubleStreamAfterFlatMap {
        FlatMapOuterDoubleStreamAfterFlatMap() {
        }

        abstract DoubleStream toDoubleStreamFunction(double var1);

        DoubleStream before(DoubleStream stream, DoubleFunction<? extends DoubleStream> function) {
            return stream.flatMap(v -> this.toDoubleStreamFunction(v).flatMap(function));
        }

        DoubleStream after(DoubleStream stream, DoubleFunction<? extends DoubleStream> function) {
            return stream.flatMap(v -> this.toDoubleStreamFunction(v)).flatMap(function);
        }
    }

    static abstract class MapOuterStreamAfterFlatMapToDouble<T> {
        MapOuterStreamAfterFlatMapToDouble() {
        }

        abstract DoubleStream toDoubleStreamFunction(T var1);

        DoubleStream before(Stream<T> stream, DoubleUnaryOperator function) {
            return stream.flatMapToDouble(v -> this.toDoubleStreamFunction(v).map(function));
        }

        DoubleStream after(Stream<T> stream, DoubleUnaryOperator function) {
            return stream.flatMapToDouble(v -> this.toDoubleStreamFunction(v)).map(function);
        }
    }

    static abstract class MapOuterDoubleStreamAfterFlatMap {
        MapOuterDoubleStreamAfterFlatMap() {
        }

        abstract DoubleStream toDoubleStreamFunction(double var1);

        DoubleStream before(DoubleStream stream, DoubleUnaryOperator function) {
            return stream.flatMap(v -> this.toDoubleStreamFunction(v).map(function));
        }

        DoubleStream after(DoubleStream stream, DoubleUnaryOperator function) {
            return stream.flatMap(v -> this.toDoubleStreamFunction(v)).map(function);
        }
    }

    static abstract class FilterOuterStreamAfterFlatMapToDouble<T> {
        FilterOuterStreamAfterFlatMapToDouble() {
        }

        abstract DoubleStream toDoubleStreamFunction(T var1);

        DoubleStream before(Stream<T> stream, DoublePredicate predicate) {
            return stream.flatMapToDouble(v -> this.toDoubleStreamFunction(v).filter(predicate));
        }

        DoubleStream after(Stream<T> stream, DoublePredicate predicate) {
            return stream.flatMapToDouble(v -> this.toDoubleStreamFunction(v)).filter(predicate);
        }
    }

    static abstract class FilterOuterDoubleStreamAfterFlatMap {
        FilterOuterDoubleStreamAfterFlatMap() {
        }

        abstract DoubleStream toDoubleStreamFunction(double var1);

        DoubleStream before(DoubleStream stream, DoublePredicate predicate) {
            return stream.flatMap(v -> this.toDoubleStreamFunction(v).filter(predicate));
        }

        DoubleStream after(DoubleStream stream, DoublePredicate predicate) {
            return stream.flatMap(v -> this.toDoubleStreamFunction(v)).filter(predicate);
        }
    }

    static final class ConcatTwoDoubleStreams {
        ConcatTwoDoubleStreams() {
        }

        DoubleStream before(DoubleStream s1, DoubleStream s2) {
            return Streams.concat((DoubleStream[])new DoubleStream[]{s1, s2});
        }

        DoubleStream after(DoubleStream s1, DoubleStream s2) {
            return DoubleStream.concat(s1, s2);
        }
    }

    static final class ConcatOneDoubleStream {
        ConcatOneDoubleStream() {
        }

        DoubleStream before(DoubleStream stream) {
            return Streams.concat((DoubleStream[])new DoubleStream[]{stream});
        }

        DoubleStream after(DoubleStream stream) {
            return stream;
        }
    }
}

