/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.errorprone.refaster.Refaster;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

final class AssortedTemplates {
    private AssortedTemplates() {
    }

    static final class SplitToStream {
        SplitToStream() {
        }

        Stream<String> before(Splitter splitter, CharSequence charSequence) {
            return (Stream)Refaster.anyOf((Object[])new Stream[]{Streams.stream((Iterable)splitter.split(charSequence)), splitter.splitToList(charSequence).stream()});
        }

        Stream<String> after(Splitter splitter, CharSequence charSequence) {
            return splitter.splitToStream(charSequence);
        }
    }

    static final class MapValueStream<K, V> {
        MapValueStream() {
        }

        Stream<V> before(Map<K, V> map) {
            return map.entrySet().stream().map(Map.Entry::getValue);
        }

        Stream<V> after(Map<K, V> map) {
            return map.values().stream();
        }
    }

    static final class MapKeyStream<K, V> {
        MapKeyStream() {
        }

        Stream<K> before(Map<K, V> map) {
            return map.entrySet().stream().map(Map.Entry::getKey);
        }

        Stream<K> after(Map<K, V> map) {
            return map.keySet().stream();
        }
    }

    static final class IterableIsEmpty<T> {
        IterableIsEmpty() {
        }

        boolean before(Iterable<T> iterable) {
            return !iterable.iterator().hasNext();
        }

        boolean after(Iterable<T> iterable) {
            return Iterables.isEmpty(iterable);
        }
    }

    static final class DisjointCollections<T> {
        DisjointCollections() {
        }

        boolean before(Collection<T> collection1, Collection<T> collection2) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{Collections.disjoint(ImmutableSet.copyOf(collection1), collection2), Collections.disjoint(new HashSet<T>(collection1), collection2), Collections.disjoint(collection1, ImmutableSet.copyOf(collection2)), Collections.disjoint(collection1, new HashSet<T>(collection2))});
        }

        boolean after(Collection<T> collection1, Collection<T> collection2) {
            return Collections.disjoint(collection1, collection2);
        }
    }

    static final class DisjointSets<T> {
        DisjointSets() {
        }

        boolean before(Set<T> set1, Set<T> set2) {
            return Sets.intersection(set1, set2).isEmpty();
        }

        boolean before2(Set<T> set1, Set<T> set2) {
            return set1.stream().noneMatch(set2::contains);
        }

        boolean after(Set<T> set1, Set<T> set2) {
            return Collections.disjoint(set1, set2);
        }
    }

    static final class UnboundedSingleElementStream<T> {
        UnboundedSingleElementStream() {
        }

        Stream<T> before(T object) {
            return Streams.stream((Iterable)Iterables.cycle((Object[])new Object[]{object}));
        }

        Stream<T> after(T object) {
            return Stream.generate(() -> object);
        }
    }

    static final class LogicalImplication {
        LogicalImplication() {
        }

        boolean before(boolean firstTest, boolean secondTest) {
            return firstTest || !firstTest && secondTest;
        }

        boolean after(boolean firstTest, boolean secondTest) {
            return firstTest || secondTest;
        }
    }

    static final class IteratorGetNextOrDefault<T> {
        IteratorGetNextOrDefault() {
        }

        T before(Iterator<T> iterator, T defaultValue) {
            return (T)Refaster.anyOf((Object[])new Object[]{iterator.hasNext() ? iterator.next() : defaultValue, Streams.stream(iterator).findFirst().orElse(defaultValue), Streams.stream(iterator).findAny().orElse(defaultValue)});
        }

        @Nullable
        T after(Iterator<T> iterator, T defaultValue) {
            return (T)Iterators.getNext(iterator, defaultValue);
        }
    }

    static final class StreamToImmutableEnumSet<T extends Enum<T>> {
        StreamToImmutableEnumSet() {
        }

        ImmutableSet<T> before(Stream<T> stream) {
            return (ImmutableSet)stream.collect(ImmutableSet.toImmutableSet());
        }

        ImmutableSet<T> after(Stream<T> stream) {
            return (ImmutableSet)stream.collect(Sets.toImmutableEnumSet());
        }
    }

    static final class MapGetOrNull<K, V, L> {
        MapGetOrNull() {
        }

        @Nullable
        V before(Map<K, V> map, L key) {
            return map.getOrDefault(key, null);
        }

        @Nullable
        V after(Map<K, V> map, L key) {
            return map.get(key);
        }
    }

    static final class CreateEnumMap<K extends Enum<K>, V> {
        CreateEnumMap() {
        }

        Map<K, V> before() {
            return new HashMap();
        }

        Map<K, V> after() {
            return new EnumMap(Refaster.clazz());
        }
    }

    static final class CheckIndex {
        CheckIndex() {
        }

        int before(int index, int size) {
            return Preconditions.checkElementIndex((int)index, (int)size);
        }

        int after(int index, int size) {
            return Objects.checkIndex(index, size);
        }
    }
}

