/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

final class AssertJStringTemplates {
    private AssertJStringTemplates() {
    }

    static final class AssertThatDoesNotMatch {
        AssertThatDoesNotMatch() {
        }

        AbstractAssert<?, ?> before(String string, String regex) {
            return Assertions.assertThat((boolean)string.matches(regex)).isFalse();
        }

        AbstractAssert<?, ?> after(String string, String regex) {
            return Assertions.assertThat((String)string).doesNotMatch((CharSequence)regex);
        }
    }

    static final class AssertThatMatches {
        AssertThatMatches() {
        }

        AbstractAssert<?, ?> before(String string, String regex) {
            return Assertions.assertThat((boolean)string.matches(regex)).isTrue();
        }

        AbstractAssert<?, ?> after(String string, String regex) {
            return Assertions.assertThat((String)string).matches((CharSequence)regex);
        }
    }

    static final class AssertThatStringIsNotEmpty {
        AssertThatStringIsNotEmpty() {
        }

        AbstractAssert<?, ?> before(String string) {
            return Assertions.assertThat((boolean)string.isEmpty()).isFalse();
        }

        AbstractAssert<?, ?> after(String string) {
            return Assertions.assertThat((String)string).isNotEmpty();
        }
    }

    static final class AbstractStringAssertStringIsNotEmpty {
        AbstractStringAssertStringIsNotEmpty() {
        }

        AbstractStringAssert<?> before(AbstractStringAssert<?> stringAssert) {
            return (AbstractStringAssert)stringAssert.isNotEqualTo((Object)"");
        }

        AbstractStringAssert<?> after(AbstractStringAssert<?> stringAssert) {
            return (AbstractStringAssert)stringAssert.isNotEmpty();
        }
    }

    static final class AssertThatStringIsEmpty {
        AssertThatStringIsEmpty() {
        }

        void before(String string) {
            Assertions.assertThat((boolean)string.isEmpty()).isTrue();
        }

        void after(String string) {
            Assertions.assertThat((String)string).isEmpty();
        }
    }

    static final class AbstractStringAssertStringIsEmpty {
        AbstractStringAssertStringIsEmpty() {
        }

        void before(AbstractStringAssert<?> stringAssert) {
            stringAssert.isEqualTo("");
        }

        void after(AbstractStringAssert<?> stringAssert) {
            stringAssert.isEmpty();
        }
    }
}

