/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.errorprone.refaster.Refaster;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;

final class AssertJFloatTemplates {
    private AssertJFloatTemplates() {
    }

    static final class AbstractFloatAssertIsOne {
        AbstractFloatAssertIsOne() {
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert) {
            return floatAssert.isOne();
        }

        AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert) {
            return floatAssert.isEqualTo(1.0f);
        }
    }

    static final class AbstractFloatAssertIsNotZero {
        AbstractFloatAssertIsNotZero() {
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert) {
            return floatAssert.isNotZero();
        }

        AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert) {
            return floatAssert.isNotEqualTo(0.0f);
        }
    }

    static final class AbstractFloatAssertIsZero {
        AbstractFloatAssertIsZero() {
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert) {
            return floatAssert.isZero();
        }

        AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert) {
            return floatAssert.isEqualTo(0.0f);
        }
    }

    static final class AbstractFloatAssertIsNotEqualTo {
        AbstractFloatAssertIsNotEqualTo() {
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert, float n) {
            return (AbstractFloatAssert)Refaster.anyOf((Object[])new AbstractFloatAssert[]{floatAssert.isNotCloseTo(n, Offset.offset((Number)Float.valueOf(0.0f))), floatAssert.isNotCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert, float n) {
            return floatAssert.isNotEqualTo(n);
        }
    }

    static final class AbstractFloatAssertIsEqualTo {
        AbstractFloatAssertIsEqualTo() {
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert, float n) {
            return (AbstractFloatAssert)Refaster.anyOf((Object[])new AbstractFloatAssert[]{floatAssert.isCloseTo(n, Offset.offset((Number)Float.valueOf(0.0f))), floatAssert.isCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert, float n) {
            return floatAssert.isEqualTo(n);
        }
    }

    static final class AbstractFloatAssertIsCloseToWithOffset {
        AbstractFloatAssertIsCloseToWithOffset() {
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert, float n, Offset<Float> offset) {
            return floatAssert.isEqualTo(n, offset);
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert, Float n, Offset<Float> offset) {
            return floatAssert.isEqualTo(n, offset);
        }

        AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert, float n, Offset<Float> offset) {
            return floatAssert.isCloseTo(n, offset);
        }
    }
}

